/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.asserts.core;

import com.epam.jdi.light.settings.WebSettings;
import com.jdiai.tools.PrintUtils;
import com.jdiai.tools.Safe;
import com.jdiai.tools.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class SoftAssert {
    private static Safe<List<String>> listOfErrors = new Safe(new ArrayList());
    private static Safe<Boolean> IS_SOFT_ASSERT = new Safe(() -> false);

    public static void setAssertType(String type) {
        IS_SOFT_ASSERT.set((Object)type.equalsIgnoreCase("soft"));
        SoftAssert.clearResults();
    }

    public static void assertSoft() {
        SoftAssert.setAssertType("soft");
    }

    public static void assertStrict() {
        SoftAssert.setAssertType("strict");
    }

    public static <T> void jdiAssert(List<T> actual, Matcher<? super List<T>> matcher) {
        try {
            MatcherAssert.assertThat(actual, matcher);
        }
        catch (Throwable error) {
            if (((Boolean)IS_SOFT_ASSERT.get()).booleanValue()) {
                SoftAssert.addError(error);
            }
            throw new AssertionError((Object)error);
        }
    }

    public static <T> void jdiAssert(T actual, Matcher<? super T> matcher, String errorMsg) {
        try {
            MatcherAssert.assertThat(actual, matcher);
            WebSettings.logger.debug(">>> " + actual, new Object[0]);
        }
        catch (Throwable error) {
            String errorMessage = String.valueOf(Timer.nowTimeShort()) + " " + SoftAssert.getErrorMsg(errorMsg, error);
            AssertionError failError = new AssertionError((Object)errorMessage);
            if (((Boolean)IS_SOFT_ASSERT.get()).booleanValue()) {
                SoftAssert.addError((Throwable)((Object)failError));
            }
            throw failError;
        }
    }

    private static String getErrorMsg(String errorMsg, Throwable error) {
        return errorMsg != null ? errorMsg : error.getMessage();
    }

    public static <T> void jdiAssert(T actual, Matcher<? super T> matcher) {
        SoftAssert.jdiAssert(actual, matcher, null);
    }

    private static void addError(Throwable error) {
        ((List)listOfErrors.get()).add(error.getMessage().replace("java.lang.AssertionError: ", ""));
    }

    public static List<String> getErrors() {
        ArrayList<String> errors = new ArrayList<String>((Collection)listOfErrors.get());
        SoftAssert.clearResults();
        return errors;
    }

    public static void assertResults() {
        ArrayList errors = new ArrayList((Collection)listOfErrors.get());
        SoftAssert.clearResults();
        if (!errors.isEmpty()) {
            throw new AssertionError((Object)PrintUtils.print(errors));
        }
    }

    public static void clearResults() {
        ((List)listOfErrors.get()).clear();
    }
}

