/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.common;

import com.epam.jdi.light.settings.WebSettings;
import com.jdiai.tools.ReflectionUtils;
import com.jdiai.tools.StringUtils;

public class Exceptions {
    public static RuntimeException runtimeException(String msg, Object ... args) {
        String message = args.length == 0 ? msg : StringUtils.format((String)msg, (Object[])args);
        WebSettings.logger.debug("ERROR: " + message, new Object[0]);
        return new RuntimeException(String.valueOf(StringUtils.LINE_BREAK) + message);
    }

    public static RuntimeException exception(Throwable ex, String msg, Object ... args) {
        String message = args.length == 0 ? msg : StringUtils.format((String)msg, (Object[])args);
        String exMsg = ex.getMessage();
        if (exMsg == null) {
            exMsg = ex.getCause().getMessage();
        }
        WebSettings.logger.debug("ERROR: " + message + ". Exception: " + exMsg, new Object[0]);
        Class<?> exceptionClass = ex.getClass();
        message = "\n" + message;
        if (ReflectionUtils.isClass(exceptionClass, AssertionError.class)) {
            throw new AssertionError(message, ex);
        }
        if (ex.getClass().getSimpleName().equals("RuntimeException")) {
            return new RuntimeException(message, ex);
        }
        message = String.valueOf(ex.getClass().getName()) + "\n" + message;
        return new RuntimeException(message, ex);
    }
}

