/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.driver;

import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.driver.get.DownloadDriverManager;
import com.epam.jdi.light.driver.get.DriverInfo;
import com.epam.jdi.light.driver.get.DriverTypes;
import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.light.settings.WebSettings;
import com.jdiai.tools.LinqUtils;
import com.jdiai.tools.Safe;
import com.jdiai.tools.Timer;
import com.jdiai.tools.func.JFunc;
import com.jdiai.tools.func.JFunc2;
import com.jdiai.tools.map.MapArray;
import com.jdiai.tools.pairs.Pair;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class WebDriverFactory {
    public static boolean MULTI_THREAD = false;
    public static MapArray<String, JFunc<WebDriver>> DRIVERS = new MapArray();
    public static final MapArray<String, WebDriver> RUN_DRIVERS = new MapArray();
    private static final Safe<MapArray<String, WebDriver>> THREAD_RUN_DRIVERS = new Safe(MapArray::new);
    public static boolean GETTING_DRIVER = false;
    public static JFunc2<String, WebDriver, Boolean> VALIDATE_DRIVER = (driverName, driver) -> driver.findElement(By.tagName((String)"body")) != null;

    private WebDriverFactory() {
    }

    public static boolean noRunDrivers() {
        return !WebDriverFactory.hasRunDrivers();
    }

    public static boolean hasRunDrivers() {
        return WebDriverFactory.getRunDrivers().any();
    }

    private static MapArray<String, WebDriver> getRunDrivers() {
        MapArray list = MULTI_THREAD ? (MapArray)THREAD_RUN_DRIVERS.get() : RUN_DRIVERS;
        WebSettings.logger.trace("List size: " + list.size(), new Object[0]);
        if (list.isNotEmpty()) {
            WebSettings.logger.trace("Driver:" + list.keys(), new Object[0]);
        }
        return list;
    }

    private static void setRunDrivers(MapArray<String, WebDriver> map) {
        if (MULTI_THREAD) {
            THREAD_RUN_DRIVERS.set(map);
        } else {
            RUN_DRIVERS.clear();
            RUN_DRIVERS.addAll(map);
        }
    }

    private static WebDriver registerNewDriver(String driverName, WebDriver driver, MapArray<String, WebDriver> drivers) {
        WebSettings.logger.trace("registerNewDriver >> " + driver, new Object[0]);
        drivers.update((Object)driverName, (Object)driver);
        return driver;
    }

    private static WebDriver registerNewDriver(String driverName, MapArray<String, WebDriver> drivers) {
        ReentrantLock locker = new ReentrantLock();
        locker.lock();
        try {
            if (!DRIVERS.has((Object)driverName) && JDISettings.DRIVER.types.has((Object)driverName)) {
                WebDriverFactory.useDriver(driverName, (JFunc<WebDriver>)((JFunc)() -> ((DriverInfo)((Object)((Object)JDISettings.DRIVER.types.get((Object)driverName)))).getDriver()));
            }
            if (!DRIVERS.has((Object)driverName)) {
                throw Exceptions.runtimeException("Can't get driver '%s'. Please use drivers from JDISettings.DRIVER.types list. Or add your own driver with WebDriverFactory.useDriver(name,() -> WebDriver) method.", new Object[0]);
            }
            WebDriver driver = WebDriverFactory.getValidDriver(driverName);
            driver = (WebDriver)JDISettings.DRIVER.setup.execute((Object)driver);
            WebDriverFactory.registerNewDriver(driverName, driver, drivers);
            WebDriver webDriver = driver;
            return webDriver;
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't run and register new driver '%s'", driverName);
        }
        finally {
            locker.unlock();
        }
    }

    private static WebDriver getValidDriver(String driverName) {
        boolean goodDriver = false;
        WebDriver driver = null;
        Timer timer = new Timer(10L);
        while (!goodDriver && timer.isRunning()) {
            try {
                if (driver != null) {
                    driver.quit();
                }
                WebSettings.logger.trace("getValidDriver: Getting driver...", new Object[0]);
                driver = (WebDriver)((JFunc)DRIVERS.get((Object)driverName)).execute();
                goodDriver = (Boolean)VALIDATE_DRIVER.execute((Object)driverName, (Object)driver);
                WebSettings.logger.trace("getValidDriver: Get driver success", new Object[0]);
            }
            catch (Throwable throwable) {
                WebSettings.logger.trace("getValidDriver: Get driver failed", new Object[0]);
            }
        }
        if (!goodDriver) {
            throw Exceptions.runtimeException("Failed to get valid driver '%s'", driverName);
        }
        return driver;
    }

    public static WebDriver getDriverByName(String driverName) {
        if (GETTING_DRIVER) {
            WebDriverFactory.waitMultiThread();
            return (WebDriver)JDISettings.DRIVER.getFunc.execute((Object)driverName);
        }
        GETTING_DRIVER = true;
        try {
            WebDriver webDriver = WebDriverFactory.getDriverFromName(driverName, RUN_DRIVERS);
            return webDriver;
        }
        catch (Exception ex) {
            throw WebDriverFactory.getDriverException(driverName, ex);
        }
        finally {
            if (MULTI_THREAD) {
                WebDriverFactory.switchToMultiThread(driverName);
            }
            GETTING_DRIVER = false;
        }
    }

    private static void switchToMultiThread(String driverName) {
        WebSettings.logger.trace("[MultiThread] " + driverName, new Object[0]);
        JDISettings.DRIVER.getFunc = WebDriverFactory::getMultiThreadDriver;
        THREAD_RUN_DRIVERS.set(RUN_DRIVERS);
    }

    private static RuntimeException getDriverException(String driverName, Exception ex) {
        String threadInfo = MULTI_THREAD ? " [" + Thread.currentThread().getId() + "]" : "";
        return DownloadDriverManager.driverDownloaded ? Exceptions.exception(ex, "Failed to run downloaded driver %s%s. Please check that your browser and driver are compatible or use local driver with 'drivers.folder' property in test.properties'." + com.jdiai.tools.StringUtils.LINE_BREAK + "DriverPath: " + DownloadDriverManager.driverPath, DownloadDriverManager.downloadedDriverInfo, threadInfo) : Exceptions.exception(ex, "Failed to Run driver '%s'%s from driverPath = %s", driverName, threadInfo, JDISettings.DRIVER.path);
    }

    public static void waitMultiThread() {
        MULTI_THREAD = true;
        Timer timer = new Timer((long)JDISettings.TIMEOUTS.page.get() * 1000L);
        while (GETTING_DRIVER && timer.isRunning()) {
        }
    }

    public static WebDriver getDriverFromName(String driverName, MapArray<String, WebDriver> drivers) {
        WebDriver driver = ObjectUtils.isNotEmpty(drivers) && drivers.has((Object)driverName) ? (WebDriver)drivers.get((Object)driverName) : WebDriverFactory.registerNewDriver(driverName, drivers);
        WebSettings.logger.trace("DRIVER >> " + (driver == null ? "NULL" : driver.toString()), new Object[0]);
        return driver;
    }

    public static WebDriver getMultiThreadDriver(String driverName) {
        WebSettings.logger.trace("getMultiThreadDriver", new Object[0]);
        MapArray drivers = (MapArray)THREAD_RUN_DRIVERS.get();
        WebDriver driver = null;
        if (ObjectUtils.isNotEmpty((Object)drivers) && drivers.has((Object)driverName)) {
            driver = (WebDriver)drivers.get((Object)driverName);
        } else {
            try {
                driver = WebDriverFactory.registerNewDriver(driverName, (MapArray<String, WebDriver>)drivers);
                THREAD_RUN_DRIVERS.set((Object)drivers);
            }
            catch (Exception ex) {
                WebSettings.logger.trace("!!!!" + Thread.currentThread().getId() + ": " + LinqUtils.safeException((Throwable)ex), new Object[0]);
            }
        }
        WebSettings.logger.trace("DRIVER >> " + (driver == null ? "NULL" : driver.toString()), new Object[0]);
        return driver;
    }

    public static String useDriver(JFunc<WebDriver> driver) {
        return WebDriverFactory.useDriver("Driver" + (DRIVERS.size() + 1), driver);
    }

    public static String useDriver(String driverName) {
        JDISettings.DRIVER.name = driverName;
        return driverName;
    }

    public static String useDriver(DriverTypes driverType) {
        return WebDriverFactory.useDriver(driverType.name);
    }

    public static String useDriver(DriverTypes driverType, JFunc<WebDriver> driver) {
        return WebDriverFactory.useDriver(driverType.name, driver);
    }

    public static String useDriver(String driverName, JFunc<WebDriver> driver) {
        DRIVERS.update((Object)driverName, driver);
        JDISettings.DRIVER.name = driverName;
        return driverName;
    }

    public static <T> T jsExecute(String script, Object ... args) {
        return (T)WebDriverFactory.getJSExecutor().executeScript(script, args);
    }

    public static WebDriver getDriver() {
        String driverName = StringUtils.isNotBlank((CharSequence)JDISettings.DRIVER.name) ? JDISettings.DRIVER.name : DriverTypes.CHROME.name;
        try {
            return WebDriverFactory.getDriver(driverName);
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't get WebDriver: " + driverName, new Object[0]);
        }
    }

    public static WebDriver getDriver(String driverName) {
        try {
            return (WebDriver)JDISettings.DRIVER.getFunc.execute((Object)driverName);
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't get WebDriver: " + driverName, new Object[0]);
        }
    }

    public static JavascriptExecutor getJSExecutor() {
        if (WebDriverFactory.getDriver() instanceof JavascriptExecutor) {
            return (JavascriptExecutor)WebDriverFactory.getDriver();
        }
        throw new ClassCastException("JavaScript Executor doesn't support");
    }

    public static void reopenDriver() {
        WebDriverFactory.reopenDriver(JDISettings.DRIVER.name);
    }

    public static void reopenDriver(String driverName) {
        MapArray<String, WebDriver> rDriver = WebDriverFactory.getRunDrivers();
        if (rDriver.has((Object)driverName)) {
            WebDriverFactory.closeDriver((WebDriver)rDriver.get((Object)driverName));
            rDriver.removeByKey((Object)driverName);
            WebDriverFactory.setRunDrivers(rDriver);
        }
        if (DRIVERS.has((Object)driverName)) {
            WebDriverFactory.getDriver();
        }
    }

    public static void switchToDriver(String driverName) {
        if (!DRIVERS.has((Object)driverName)) {
            throw Exceptions.runtimeException("Can't switch to WebDriver '%s'. This Driver name not registered", driverName);
        }
        JDISettings.DRIVER.name = driverName;
    }

    public static void close() {
        for (Pair pair : WebDriverFactory.getRunDrivers()) {
            WebDriverFactory.closeDriver((WebDriver)pair.value);
        }
        WebDriverFactory.getRunDrivers().clear();
    }

    private static void closeDriver(WebDriver driver) {
        try {
            driver.quit();
        }
        catch (Exception exception) {}
    }

    public static void quit() {
        WebDriverFactory.close();
    }
}

