/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.driver;

import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.common.LinuxProcessUtils;
import com.epam.jdi.light.common.UnixProcessUtils;
import com.epam.jdi.light.driver.get.DriverData;
import com.epam.jdi.light.settings.WebSettings;
import com.jdiai.tools.LinqUtils;
import com.jdiai.tools.StringUtils;
import com.jdiai.tools.func.JAction1;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;

public final class WebDriverUtils {
    private WebDriverUtils() {
    }

    public static void killAllSeleniumDrivers() {
        String os = System.getProperty("os.name");
        try {
            if (os.contains("Mac")) {
                WebDriverUtils.killAllMacOSDriverProcesses();
            } else if (os.contains("Linux")) {
                WebDriverUtils.killAllLinuxOSDriverProcesses();
            } else {
                WebDriverUtils.killAllWindowsDriverProcesses();
            }
        }
        catch (Exception exception) {
            WebSettings.logger.info("Can't kill driver processes", new Object[0]);
        }
    }

    private static void killAllMacOSDriverProcesses() {
        WebDriverUtils.killOSDriverProcesses((JAction1<String>)((JAction1)WebDriverUtils::killAllMacOSDriverProcessesByName), "firefox");
        WebDriverUtils.killOSDriverProcesses((JAction1<String>)((JAction1)WebDriverUtils::killAllMacOSDriverProcessesByName), "chrome");
    }

    private static void killAllLinuxOSDriverProcesses() {
        WebDriverUtils.killOSDriverProcesses((JAction1<String>)((JAction1)WebDriverUtils::killAllLinuxOSDriverProcessesByName), "chrome");
        WebDriverUtils.killOSDriverProcesses((JAction1<String>)((JAction1)WebDriverUtils::killAllLinuxOSDriverProcessesByName), "firefox");
    }

    private static void killAllWindowsDriverProcesses() throws IOException {
        WebDriverUtils.killByName("chromedriver");
        WebDriverUtils.killByName("geckodriver");
        WebDriverUtils.killByName("IEDriverServer");
        WebDriverUtils.killByName("MicrosoftWebDriver");
    }

    private static void killByName(String value) throws IOException {
        Runtime.getRuntime().exec(StringUtils.format((String)"taskkill /F /IM %s.exe /T", (Object[])new Object[]{value}));
    }

    private static void killOSDriverProcesses(JAction1<String> killDriverByProcessName, String browserName) {
        String processName = WebDriverUtils.getDriverProcessName(browserName);
        if (processName != null) {
            killDriverByProcessName.execute((Object)processName);
        }
    }

    private static String getDriverProcessName(String browserName) {
        String name = null;
        switch (browserName.toLowerCase()) {
            case "firefox": {
                name = "geckodriver";
                break;
            }
            case "chrome": {
                name = "chromedriver";
            }
        }
        return name;
    }

    private static void killAllMacOSDriverProcessesByName(String driverName) {
        UnixProcessUtils.killProcessesTree(driverName);
    }

    private static void killAllLinuxOSDriverProcessesByName(String driverName) {
        LinuxProcessUtils.killProcessesTree(driverName);
    }

    public static WebDriver maximizeWindow(WebDriver driver) {
        try {
            switch (DriverData.getOs()) {
                case WIN: 
                case LINUX: {
                    driver.manage().window().maximize();
                    break;
                }
                case MAC: {
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    WebDriverUtils.setBrowserPositionSize(driver, 0, 0, (int)screenSize.getWidth(), (int)screenSize.getHeight());
                }
            }
            return driver;
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Failed to maximize window", new Object[0]);
        }
    }

    public static WebDriver setBrowserPositionSize(WebDriver driver, int x, int y, int width, int height) {
        try {
            driver.manage().window().setPosition(new Point(x, y));
            driver.manage().window().setSize(new org.openqa.selenium.Dimension(width, height));
            return driver;
        }
        catch (Exception ex) {
            WebSettings.logger.error("Failed to Set resolution (%s, %s): %s", width, height, LinqUtils.safeException((Throwable)ex));
            throw ex;
        }
    }
}

