/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.driver.get;

import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.driver.get.DriverInfo;
import com.epam.jdi.light.driver.get.DriverInfos;
import com.epam.jdi.light.driver.get.DriverTypes;
import com.epam.jdi.light.driver.get.DriverVersion;
import com.epam.jdi.light.driver.get.Platform;
import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.light.settings.WebSettings;
import com.jdiai.tools.func.JFunc3;
import io.github.bonigarcia.wdm.WebDriverManager;
import org.apache.commons.lang.StringUtils;

public class DownloadDriverManager {
    static WebDriverManager wdm;
    public static boolean driverDownloaded;
    public static String downloadedDriverInfo;
    public static String driverPath;
    public static JFunc3<DriverTypes, Platform, String, String> DOWNLOAD_DRIVER_FUNC;

    static {
        driverDownloaded = false;
        DOWNLOAD_DRIVER_FUNC = DownloadDriverManager::downloadDriver;
    }

    private static boolean hasVersion(String version) {
        char c = version.charAt(0);
        return c >= '0' && c <= '9';
    }

    public static String downloadDriver(DriverTypes driverType, Platform platform, String version) {
        try {
            String driverName = driverType.toString();
            switch (driverType) {
                case CHROME: {
                    wdm = WebDriverManager.chromedriver();
                    break;
                }
                case FIREFOX: {
                    wdm = WebDriverManager.firefoxdriver();
                    break;
                }
                case IE: {
                    wdm = WebDriverManager.iedriver();
                    break;
                }
                case EDGE: {
                    wdm = WebDriverManager.edgedriver();
                    break;
                }
                case OPERA: {
                    wdm = WebDriverManager.operadriver();
                    break;
                }
                case SAFARI: {
                    return StringUtils.isBlank((String)JDISettings.DRIVER.path) ? (String)DriverInfos.SAFARI_INFO.path.execute() : JDISettings.DRIVER.path;
                }
                default: {
                    throw Exceptions.runtimeException("%s driver not supported for download", new Object[0]);
                }
            }
            switch (platform) {
                case X32: {
                    wdm = wdm.arch32();
                    break;
                }
                case X64: {
                    wdm = wdm.arch64();
                }
            }
            driverName = String.valueOf(driverName) + " " + (Object)((Object)platform);
            if (DownloadDriverManager.hasVersion(version)) {
                wdm = wdm.browserVersion(version);
                driverName = String.valueOf(driverName) + " " + version;
            }
            if (version.equalsIgnoreCase(DriverVersion.PENULT.value)) {
                wdm.setup();
                wdm.browserVersion(DriverInfo.getBelowVersion());
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)JDISettings.DRIVER.gitHubToken)) {
                wdm.gitHubToken(JDISettings.DRIVER.gitHubToken);
            }
            wdm.setup();
            WebSettings.logger.info("Download driver: '" + driverName + "' successfully", new Object[0]);
            driverDownloaded = true;
            downloadedDriverInfo = com.jdiai.tools.StringUtils.format((String)"%s:%s:%s", (Object[])new Object[]{driverType, platform, version});
            driverPath = wdm.getDownloadedDriverPath();
            return driverPath;
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't download latest driver for " + (Object)((Object)driverType), new Object[0]);
        }
    }
}

