/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.driver.get;

import com.epam.jdi.light.driver.WebDriverUtils;
import com.epam.jdi.light.driver.get.OsTypes;
import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.light.settings.WebSettings;
import com.jdiai.tools.LinqUtils;
import com.jdiai.tools.PathUtils;
import com.jdiai.tools.PrintUtils;
import com.jdiai.tools.ReflectionUtils;
import com.jdiai.tools.func.JAction;
import com.jdiai.tools.func.JAction1;
import com.jdiai.tools.switcher.CaseR;
import com.jdiai.tools.switcher.SwitchActions;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.UnexpectedAlertBehaviour;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.opera.OperaOptions;
import org.openqa.selenium.safari.SafariOptions;

public class DriverData {
    public static final String DEFAULT_DRIVER = "chrome";
    public static String ARGUMENTS_PROPERTY = "arguments";
    public static List<String> setupErrors = new ArrayList<String>();
    public static JAction1<ChromeOptions> CHROME_OPTIONS = DriverData::defaultChromeOptions;
    public static JAction1<FirefoxOptions> FIREFOX_OPTIONS = DriverData::defaultFirefoxOptions;
    public static JAction1<InternetExplorerOptions> IE_OPTIONS = DriverData::defaultIEOptions;
    public static JAction1<EdgeOptions> EDGE_OPTIONS = DriverData::defaultEdgeOptions;
    public static JAction1<OperaOptions> OPERA_OPTIONS = DriverData::defaultOperaOptions;
    public static JAction1<SafariOptions> SAFARI_OPTIONS = DriverData::defaultSafariOptions;

    public static String getDriverFolder() {
        return StringUtils.isNotBlank((CharSequence)JDISettings.DRIVER.path) && !JDISettings.DRIVER.path.equalsIgnoreCase("default") ? JDISettings.DRIVER.path : PathUtils.mergePath((String)JDISettings.COMMON.testPath, (String[])new String[]{"resources", "drivers"});
    }

    public static String chromeDriverPath() {
        return PathUtils.mergePath((String)DriverData.getDriverFolder(), (String[])new String[]{DriverData.getOs() == OsTypes.WIN ? "chromedriver.exe" : "chromedriver"});
    }

    public static String ieDriverPath() {
        return PathUtils.mergePath((String)DriverData.getDriverFolder(), (String[])new String[]{"IEDriverServer.exe"});
    }

    public static String edgeDriverPath() {
        return PathUtils.mergePath((String)DriverData.getDriverFolder(), (String[])new String[]{"MicrosoftWebDriver.exe"});
    }

    public static String operaDriverPath() {
        return DriverData.driverPath("operadriver");
    }

    public static String safariDriverPath() {
        return "/usr/bin/safaridriver";
    }

    public static String firefoxDriverPath() {
        return DriverData.driverPath("geckodriver");
    }

    private static String driverPath(String driverName) {
        return PathUtils.mergePath((String)DriverData.getDriverFolder(), (String[])new String[]{DriverData.getOs() == OsTypes.WIN ? String.valueOf(driverName) + ".exe" : driverName});
    }

    public static OsTypes getOs() {
        if (JDISettings.DRIVER.os != null) {
            return JDISettings.DRIVER.os;
        }
        String osName = System.getProperty("os.name").toLowerCase();
        return (OsTypes)((Object)SwitchActions.Switch((Object)osName).get(new CaseR[]{SwitchActions.Case(os -> os.contains("mac"), (Object)((Object)OsTypes.MAC)), SwitchActions.Case(os -> os.contains("win") || os.contains("ms"), (Object)((Object)OsTypes.WIN)), SwitchActions.Default((Object)((Object)OsTypes.LINUX))}));
    }

    public static WebDriver driverSettings(WebDriver driver) {
        if (JDISettings.DRIVER.screenSize.maximize) {
            WebDriverUtils.maximizeWindow(driver);
        } else {
            driver.manage().window().setSize(JDISettings.DRIVER.screenSize.asDimension());
        }
        return driver;
    }

    public static MutableCapabilities getCapabilities(MutableCapabilities caps, JAction1<MutableCapabilities> defaultCapabilities) {
        try {
            setupErrors.clear();
            defaultCapabilities.execute((Object)caps);
        }
        catch (Throwable ex) {
            setupErrors.add("Setup caps exception: " + LinqUtils.safeException((Throwable)ex));
        }
        if (ObjectUtils.isNotEmpty(setupErrors)) {
            WebSettings.logger.info("Failed to set Default Capabilities for Driver:", new Object[0]);
            WebSettings.logger.info("Errors: " + PrintUtils.print(setupErrors, (String)com.jdiai.tools.StringUtils.LINE_BREAK), new Object[0]);
            setupErrors.clear();
        }
        try {
            JDISettings.DRIVER.capabilities.common.forEach((property, value) -> DriverData.setupCapability(caps, property, value));
        }
        catch (Throwable ex) {
            WebSettings.logger.info("Failed to set COMMON_CAPABILITIES Capabilities for Driver: " + LinqUtils.safeException((Throwable)ex), new Object[0]);
        }
        return caps;
    }

    public static void setupCapability(MutableCapabilities cap, String property, String value) {
        if (!property.equals(ARGUMENTS_PROPERTY)) {
            if (property.toLowerCase().contains("version")) {
                cap.setCapability(property, value);
            } else {
                cap.setCapability(property, ReflectionUtils.stringToPrimitive((String)value));
            }
        } else if (ReflectionUtils.isClass(cap.getClass(), ChromeOptions.class)) {
            ((ChromeOptions)cap).addArguments(value.split(" "));
        } else if (ReflectionUtils.isClass(cap.getClass(), FirefoxOptions.class)) {
            ((FirefoxOptions)cap).addArguments(value.split(" "));
        }
    }

    public static void setUp(String name, JAction action) {
        try {
            action.invoke();
        }
        catch (Throwable ex) {
            setupErrors.add(com.jdiai.tools.StringUtils.format((String)"%s: %s", (Object[])new Object[]{name, LinqUtils.safeException((Throwable)ex)}));
        }
    }

    public static void defaultChromeOptions(ChromeOptions cap) {
        HashMap chromePrefs = new HashMap();
        DriverData.setUp("Set Chrome Prefs", () -> {
            chromePrefs.put("credentials_enable_service", false);
            new File(JDISettings.DRIVER.downloadsFolder).mkdirs();
            chromePrefs.put("download.default_directory", JDISettings.DRIVER.downloadsFolder);
            chromePrefs.put("profile.default_content_setting_values.notifications", 0);
            chromePrefs.put("profile.default_content_settings.popups", 0);
            chromePrefs.put("profile.password_manager_enabled", false);
        });
        DriverData.setUp("Chrome: '--disable-web-security', '--disable-extensions', 'test-type'", () -> {
            ChromeOptions chromeOptions2 = cap.addArguments(new String[]{"--disable-web-security", "--disable-extensions", "test-type"});
        });
        DriverData.setUp("Chrome: PageLoadStrategy:" + JDISettings.DRIVER.pageLoadStrategy, () -> {
            ChromeOptions chromeOptions2 = cap.setPageLoadStrategy(JDISettings.DRIVER.pageLoadStrategy);
        });
        DriverData.setUp("Chrome: ACCEPT_SSL_CERTS:true", () -> cap.setCapability("acceptSslCerts", true));
        DriverData.setUp("Chrome: unexpectedAlertBehaviour=" + UnexpectedAlertBehaviour.ACCEPT, () -> cap.setCapability("unexpectedAlertBehaviour", (Object)UnexpectedAlertBehaviour.ACCEPT));
        DriverData.setUp("Chrome: setExperimentalOption: prefs", () -> {
            ChromeOptions chromeOptions2 = cap.setExperimentalOption("prefs", (Object)chromePrefs);
        });
        DriverData.setUp("Chrome: setUpExperimentalOption: prefs", () -> {
            LoggingPreferences logPrefs = new LoggingPreferences();
            logPrefs.enable("performance", Level.ALL);
            cap.setCapability("loggingPrefs", (Object)logPrefs);
            cap.setCapability("goog:loggingPrefs", (Object)logPrefs);
        });
        JDISettings.DRIVER.capabilities.chrome.forEach((property, value) -> DriverData.setupCapability((MutableCapabilities)cap, property, value));
    }

    public static void defaultFirefoxOptions(FirefoxOptions cap) {
        FirefoxProfile firefoxProfile = new FirefoxProfile();
        DriverData.setUp("Set FirefoxProfile", () -> {
            firefoxProfile.setAssumeUntrustedCertificateIssuer(false);
            firefoxProfile.setPreference("browser.download.folderList", 2);
            firefoxProfile.setPreference("browser.download.manager.showWhenStarting", false);
            firefoxProfile.setPreference("browser.helperApps.alwaysAsk.force", false);
            firefoxProfile.setPreference("browser.helperApps.neverAsk.saveToDisk", "application/xls;text/csv;text/plain");
            firefoxProfile.setPreference("browser.download.dir", JDISettings.DRIVER.downloadsFolder);
            firefoxProfile.setPreference("print.always_print_silent", "true");
            firefoxProfile.setPreference("print.show_print_progress", "false");
            firefoxProfile.setPreference("browser.startup.homepage", "about:blank");
            firefoxProfile.setPreference("startup.homepage_welcome_url", "about:blank");
            firefoxProfile.setPreference("startup.homepage_welcome_url.additional", "about:blank");
            firefoxProfile.setPreference("network.http.phishy-userpass-length", 255);
        });
        DriverData.setUp("Firefox: PageLoadStrategy:" + JDISettings.DRIVER.pageLoadStrategy, () -> {
            FirefoxOptions firefoxOptions2 = cap.setPageLoadStrategy(JDISettings.DRIVER.pageLoadStrategy);
        });
        DriverData.setUp("Firefox: ACCEPT_SSL_CERTS: true", () -> cap.setCapability("acceptSslCerts", true));
        DriverData.setUp("Firefox: UNEXPECTED_ALERT_BEHAVIOR, ACCEPT", () -> cap.setCapability("unexpectedAlertBehaviour", (Object)UnexpectedAlertBehaviour.ACCEPT));
        DriverData.setUp("Firefox: Firefox Profile", () -> {
            FirefoxOptions firefoxOptions2 = cap.setProfile(firefoxProfile);
        });
        JDISettings.DRIVER.capabilities.firefox.forEach((property, value) -> DriverData.setupCapability((MutableCapabilities)cap, property, value));
    }

    public static void defaultIEOptions(InternetExplorerOptions cap) {
        DriverData.setUp("IE: introduceFlakinessByIgnoringSecurityDomains", () -> ((InternetExplorerOptions)cap).introduceFlakinessByIgnoringSecurityDomains());
        DriverData.setUp("ignoreZoomSettings", () -> ((InternetExplorerOptions)cap).ignoreZoomSettings());
        DriverData.setUp("IE: requireWindowFocus:true", () -> cap.setCapability("requireWindowFocus", true));
        DriverData.setUp("IE: PageLoadStrategy:" + JDISettings.DRIVER.pageLoadStrategy, () -> {
            InternetExplorerOptions internetExplorerOptions2 = cap.setPageLoadStrategy(JDISettings.DRIVER.pageLoadStrategy);
        });
        DriverData.setUp("IE: takeFullPageScreenshot", () -> ((InternetExplorerOptions)cap).takeFullPageScreenshot());
        DriverData.setUp("IE: ACCEPT_SSL_CERTS: true", () -> cap.setCapability("acceptSslCerts", true));
        DriverData.setUp("IE: destructivelyEnsureCleanSession", () -> ((InternetExplorerOptions)cap).destructivelyEnsureCleanSession());
        DriverData.setUp("IE: UNEXPECTED_ALERT_BEHAVIOR: ACCEPT)", () -> cap.setCapability("unexpectedAlertBehaviour", (Object)UnexpectedAlertBehaviour.ACCEPT));
        DriverData.setUp("IE: SUPPORTS_JAVASCRIPT", () -> {
            boolean bl = cap.is("javascriptEnabled");
        });
        DriverData.setUp("IE: ACCEPT_SSL_CERTS: true", () -> cap.setCapability("acceptSslCerts", true));
        JDISettings.DRIVER.capabilities.ie.forEach((arg_0, arg_1) -> ((InternetExplorerOptions)cap).setCapability(arg_0, arg_1));
    }

    public static void defaultEdgeOptions(EdgeOptions cap) {
        JDISettings.DRIVER.capabilities.ieEdge.forEach((arg_0, arg_1) -> ((EdgeOptions)cap).setCapability(arg_0, arg_1));
    }

    public static void defaultOperaOptions(OperaOptions cap) {
        JDISettings.DRIVER.capabilities.opera.forEach((arg_0, arg_1) -> ((OperaOptions)cap).setCapability(arg_0, arg_1));
    }

    public static void defaultSafariOptions(SafariOptions cap) {
        JDISettings.DRIVER.capabilities.safari.forEach((arg_0, arg_1) -> ((SafariOptions)cap).setCapability(arg_0, arg_1));
    }
}

