/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.driver.get;

import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.settings.JDISettings;
import org.apache.commons.lang3.StringUtils;

public class RemoteDriverInfo {
    public static final String SELENIUM_LOCAL_HOST = "http://localhost:4444/wd/hub";
    public static final String SELENOID_LOCAL = "http://localhost:4444/wd/hub";
    public static String SAUCE_LABS = "http://ondemand.eu-central-1.saucelabs.com/wd/hub";

    public static String browserstack() {
        return RemoteDriverInfo.browserstack(System.getenv("USERNAME"), System.getenv("ACCESS_KEY"));
    }

    public static String browserstack(String userName, String accessKey) {
        return RemoteDriverInfo.getRemoteURL(com.jdiai.tools.StringUtils.format((String)"https://%s:%s@hub-cloud.browserstack.com/", (Object[])new Object[]{userName, accessKey}));
    }

    public static String appium() {
        return RemoteDriverInfo.getRemoteURL("http://0.0.0.0:4723/");
    }

    public static String getRemoteURL() {
        return RemoteDriverInfo.getRemoteURL(JDISettings.DRIVER.remoteUrl);
    }

    public static String getRemoteURL(String remoteUrl) {
        try {
            if (!StringUtils.isBlank((CharSequence)remoteUrl)) {
                String url = remoteUrl.replaceAll("/+$", "/");
                if (!url.contains("wd/hub")) {
                    url = String.valueOf(url) + "wd/hub/";
                }
                return url;
            }
            throw Exceptions.runtimeException("You run tests in Remote mode, please specify 'driver.remote.url' in test.properties", new Object[0]);
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't get remote Url", new Object[0]);
        }
    }
}

