/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.base;

import com.epam.jdi.light.common.UIUtils;
import com.epam.jdi.light.driver.WebDriverFactory;
import com.epam.jdi.light.elements.base.JDIBase;
import com.epam.jdi.light.elements.composite.WebPage;
import com.epam.jdi.light.elements.init.SiteInfo;
import com.epam.jdi.light.elements.init.entities.collection.EntitiesCollection;
import com.epam.jdi.light.elements.interfaces.base.JDIElement;
import com.epam.jdi.light.settings.JDISettings;
import com.jdiai.tools.ReflectionUtils;
import com.jdiai.tools.map.MapArray;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public abstract class DriverBase
implements JDIElement {
    public String driverName;
    public String name;
    public String varName;
    public String typeName;
    public String failElement;
    public Object parent;
    public Object siteName;
    protected String context;
    private String pageName;

    public DriverBase() {
        this.driverName = JDISettings.DRIVER.name;
        this.name = "";
        this.varName = "";
        this.typeName = "";
        this.failElement = "";
    }

    public WebDriver driver() {
        return WebDriverFactory.getDriver(this.driverName);
    }

    public JavascriptExecutor js() {
        return (JavascriptExecutor)this.driver();
    }

    public <T> T asEntity(Class<T> entityClass) {
        return UIUtils.asEntity(this, entityClass);
    }

    public List<Object> parents() {
        ArrayList<Object> parents = new ArrayList<Object>();
        Object p = this.parent;
        while (p != null) {
            parents.add(p);
            Object object = p = ReflectionUtils.isClass(p.getClass(), DriverBase.class) ? ((DriverBase)p).parent : null;
        }
        return parents;
    }

    public DriverBase setParent(Object parent) {
        this.parent = parent;
        return this;
    }

    public void setName(SiteInfo info) {
        if (info.field != null) {
            this.setName(info.field, info.parentName());
        } else {
            this.setName(info.name());
            this.setTypeName(info.type().getSimpleName());
        }
    }

    public DriverBase setName(String name) {
        this.name = name;
        this.varName = name;
        this.failElement = name;
        return this;
    }

    public void setName(Field field, String className) {
        this.failElement = this.name = (String)JDISettings.ELEMENT.name.execute((Object)field);
        this.varName = String.valueOf(className) + "." + field.getName();
        this.typeName = field.getType().getSimpleName();
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Override
    public String getName() {
        return StringUtils.isBlank((CharSequence)this.name) ? this.getClass().getSimpleName() : this.name;
    }

    public String getFullName() {
        return StringUtils.isBlank((CharSequence)this.varName) ? this.getName() : this.varName;
    }

    public void setPage(String page) {
        this.pageName = page;
    }

    public WebPage getPage() {
        if (this.pageName != null) {
            return ((MapArray)EntitiesCollection.PAGES.get()).keys().contains(this.pageName) ? (WebPage)((MapArray)EntitiesCollection.PAGES.get()).get((Object)this.pageName) : null;
        }
        if (this.parent == null) {
            return null;
        }
        if (ReflectionUtils.isClass(this.parent.getClass(), WebPage.class)) {
            return (WebPage)this.parent;
        }
        if (!ReflectionUtils.isClass(this.parent.getClass(), DriverBase.class)) {
            String pageName = com.jdiai.tools.StringUtils.splitCamelCase((String)this.parent.getClass().getSimpleName());
            return ((MapArray)EntitiesCollection.PAGES.get()).keys().contains(pageName) ? (WebPage)((MapArray)EntitiesCollection.PAGES.get()).get((Object)pageName) : null;
        }
        return ((DriverBase)this.parent).getPage();
    }

    public boolean hasParent(String name) {
        if (this.parent == null) {
            return false;
        }
        if (ReflectionUtils.isClass(this.parent.getClass(), WebPage.class)) {
            return ((WebPage)this.parent).getName().equals(name);
        }
        if (ReflectionUtils.isClass(this.parent.getClass(), JDIBase.class)) {
            return ((JDIBase)this.parent).hasParent(name);
        }
        return false;
    }
}

