/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.base;

import com.epam.jdi.light.driver.WebDriverByUtils;
import com.epam.jdi.light.elements.base.JDIBase;
import com.epam.jdi.light.elements.base.JdiSettings;
import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.light.settings.WebSettings;
import com.jdiai.tools.LinqUtils;
import com.jdiai.tools.PrintUtils;
import com.jdiai.tools.Safe;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;

public class JDILocator {
    private By byLocator;
    private List<By> frames;
    public boolean isRoot = false;
    private Safe<JDIBase> element;
    private Object[] args = new Object[0];

    public JDILocator(JDIBase base) {
        this.element = new Safe(() -> base);
    }

    public JDILocator copy() {
        JDIBase base = (JDIBase)this.element.get();
        JDILocator locator = new JDILocator(base);
        locator.byLocator = this.byLocator;
        locator.isRoot = this.isRoot;
        locator.element = new Safe(() -> base);
        locator.frames = this.frames;
        return locator;
    }

    public By getLocator() {
        return this.byLocator;
    }

    public List<By> getFrames() {
        return this.frames;
    }

    public By getLocator(Object ... args) {
        this.args = args;
        if (args.length == 0) {
            return this.byLocator;
        }
        return args.length == 1 ? WebDriverByUtils.fillByTemplate(this.byLocator, args) : WebDriverByUtils.fillByMsgTemplate(this.byLocator, args);
    }

    public boolean isNull() {
        return this.byLocator == null;
    }

    public boolean hasFrame() {
        return this.frames != null && this.frames.size() > 0;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void add(By locator, JDIBase element) {
        this.byLocator = this.setRootLocator(locator) ? this.trimRoot(locator) : locator;
        this.element = new Safe(() -> element);
    }

    public void add(List<By> frames, JDIBase element) {
        this.frames = frames;
        this.element = new Safe(() -> element);
    }

    public boolean isTemplate() {
        return this.byLocator != null && this.byLocator.toString().contains("%s");
    }

    public boolean isXPath() {
        return this.byLocator != null && this.byLocator.toString().contains("xpath");
    }

    public String addIndex(int index) {
        String locator = WebDriverByUtils.getByLocator(this.byLocator);
        return locator.equals("..") ? "../*[" + index + "]" : com.jdiai.tools.StringUtils.format((String)"(%s)[%s]", (Object[])new Object[]{WebDriverByUtils.getByLocator(this.byLocator), index});
    }

    public String addText(String text) {
        return JdiSettings.addTextToXPath(this.byLocator, text);
    }

    public int argsCount() {
        return this.byLocator != null ? StringUtils.countMatches((CharSequence)this.byLocator.toString(), (CharSequence)"%s") : 0;
    }

    private boolean setRootLocator(By locator) {
        if (this.containsRoot(locator)) {
            this.isRoot = true;
        }
        return this.isRoot;
    }

    private boolean containsRoot(By by) {
        return by != null && by.toString().contains(": *root*");
    }

    private By trimRoot(By by) {
        String byLocator = WebDriverByUtils.getByLocator(by).replace("*root*", " ").trim();
        return WebDriverByUtils.getByFunc(by).apply(byLocator);
    }

    public String printLocator() {
        return this.toString().replace("{{VALUE}}", "%s");
    }

    public String toString() {
        String locatorString;
        JDIBase element;
        String hasFrame;
        By locator;
        block7: {
            try {
                locator = this.getLocator(this.args);
                hasFrame = "";
                if (this.hasFrame()) {
                    hasFrame = "Frame: " + PrintUtils.print((Collection)LinqUtils.map(this.frames, WebDriverByUtils::shortBy));
                }
                element = (JDIBase)this.element.get();
                if (locator != null || !StringUtils.isBlank((CharSequence)hasFrame) || element == null) break block7;
                if (element.webElement.hasValue() || element.webElements.hasValue()) {
                    return element.printWebElement();
                }
                if (StringUtils.isNotBlank((CharSequence)JDISettings.ELEMENT.smartTemplate)) {
                    return WebSettings.printSmartLocators(element);
                }
                return "";
            }
            catch (Exception ex) {
                WebSettings.logger.error("Error on get locator value %s", ex);
                return "Can't print locator";
            }
        }
        String string = locatorString = locator != null ? WebDriverByUtils.shortBy(locator, element).replaceAll("%s", "{{VALUE}}") : "";
        if (StringUtils.isBlank((CharSequence)hasFrame)) {
            return locatorString;
        }
        return StringUtils.isBlank((CharSequence)locatorString) ? hasFrame : String.valueOf(hasFrame) + ">" + locatorString;
    }
}

