/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.base;

import com.epam.jdi.light.actions.ActionProcessor;
import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.common.JDebug;
import com.epam.jdi.light.common.TextTypes;
import com.epam.jdi.light.driver.WebDriverByUtils;
import com.epam.jdi.light.elements.base.JDIBase;
import com.epam.jdi.light.elements.base.JDILocator;
import com.epam.jdi.light.elements.base.JdiSettings$AjcClosure1;
import com.epam.jdi.light.elements.base.JdiSettings$AjcClosure3;
import com.epam.jdi.light.elements.base.JdiSettings$AjcClosure5;
import com.epam.jdi.light.elements.common.UIElement;
import com.epam.jdi.light.elements.composite.WebPage;
import com.epam.jdi.light.elements.interfaces.base.IBaseElement;
import com.epam.jdi.light.elements.interfaces.base.JDIElement;
import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.light.settings.WebSettings;
import com.jdiai.tools.EnumUtils;
import com.jdiai.tools.LinqUtils;
import com.jdiai.tools.PrintUtils;
import com.jdiai.tools.ReflectionUtils;
import com.jdiai.tools.func.JAction2;
import com.jdiai.tools.func.JFunc1;
import com.jdiai.tools.func.JFunc2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class JdiSettings {
    public static JAction2<JDIBase, WebElement> VALIDATE_FOUND_ELEMENT;
    public static JFunc2<JDIBase, Object[], WebElement> GET_WITH_ARGS;
    public static JFunc2<JDIBase, Object[], WebElement> GET_AND_VALIDATE;
    public static final String FAILED_TO_FIND_ELEMENT_MESSAGE = "Can't find Element '%s' during %s seconds";
    public static final String FIND_TO_MUCH_ELEMENTS_MESSAGE = "Found %s elements instead of one for Element '%s' during %s seconds";
    public static final String SEARCH_RULE_VALIDATION_FAILED = "Search rules failed for element. Please check base().searchRules() for element or in global settings(JDISettings.ELEMENT.searchRule)";
    public static JFunc1<WebDriver, SearchContext> DEFAULT_CONTEXT;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    static {
        JdiSettings.ajc$preClinit();
        VALIDATE_FOUND_ELEMENT = JdiSettings::validateFoundElement;
        GET_WITH_ARGS = JdiSettings::getWithArgs;
        GET_AND_VALIDATE = (b, args) -> {
            WebElement element = (WebElement)GET_WITH_ARGS.execute(b, args);
            WebSettings.logger.trace("Validate:" + element, new Object[0]);
            VALIDATE_FOUND_ELEMENT.execute(b, (Object)element);
            b.beforeSearch(element);
            return element;
        };
        DEFAULT_CONTEXT = JdiSettings::getDefaultContext;
    }

    private static WebElement getWithArgs(JDIBase b, Object[] args) {
        WebSettings.logger.trace("getWithArgs", new Object[0]);
        if (b.webElement.hasValue()) {
            WebElement webElement = null;
            try {
                webElement = JdiSettings.purify((WebElement)b.webElement.get());
                webElement.getTagName();
            }
            catch (Exception exception) {
            }
            if (webElement != null) {
                return webElement;
            }
        }
        if (b.locator.isNull() && b.parent == null) {
            return b.getSmart();
        }
        if (b.locator.argsCount() != args.length) {
            return JdiSettings.getUIElementFromArgs(b, args);
        }
        List<WebElement> els = JdiSettings.getAllElementsInContext(b, args);
        return JdiSettings.filterWebListToWebElement(b, els);
    }

    public static WebElement filterWebListToWebElement(JDIBase base, List<WebElement> els) {
        if (els.isEmpty()) {
            throw Exceptions.runtimeException(FAILED_TO_FIND_ELEMENT_MESSAGE, base.toString(), base.getTimeout());
        }
        switch (base.searchType) {
            case Smart: {
                return JdiSettings.smartSearch(base, els);
            }
            case Single: {
                return JdiSettings.singleSearch(base, els);
            }
            case First: {
                return JdiSettings.firstSearch(base, els);
            }
        }
        throw Exceptions.runtimeException("Unknown search type", new Object[0]);
    }

    private static WebElement smartSearch(JDIBase base, List<WebElement> els) {
        List<WebElement> filtered = JdiSettings.filterElements(base, els);
        return filtered.size() == 1 ? filtered.get(0) : els.get(0);
    }

    private static WebElement singleSearch(JDIBase base, List<WebElement> els) {
        List<WebElement> filtered = JdiSettings.filterElements(base, els);
        if (ObjectUtils.isEmpty(filtered)) {
            throw Exceptions.runtimeException("Expected one element but found %s (filters: %s)", filtered.size(), PrintUtils.print((Collection)base.searchRules().keys()));
        }
        if (filtered.size() == 1) {
            return filtered.get(0);
        }
        throw Exceptions.runtimeException("Expected one element but found %s (filters: %s)", filtered.size(), PrintUtils.print((Collection)base.searchRules().keys()));
    }

    private static WebElement firstSearch(JDIBase base, List<WebElement> els) {
        List<WebElement> filtered = JdiSettings.filterElements(base, els);
        if (ObjectUtils.isEmpty(filtered)) {
            throw Exceptions.runtimeException("Expected at least one element but found %s (filters: %s)", filtered.size(), PrintUtils.print((Collection)base.searchRules().keys()));
        }
        return filtered.get(0);
    }

    @JDebug
    public static List<WebElement> filterElements(JDIBase base, List<WebElement> elements) {
        JDIBase jDIBase = base;
        List<WebElement> list = elements;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)jDIBase, list);
        Object[] objectArray = new Object[]{jDIBase, list, joinPoint};
        JdiSettings$AjcClosure1 jdiSettings$AjcClosure1 = new JdiSettings$AjcClosure1(objectArray);
        return (List)ActionProcessor.aspectOf().debugAround(jdiSettings$AjcClosure1.linkClosureAndJoinPoint(65536));
    }

    public static WebElement purify(WebElement element) {
        return ReflectionUtils.isInterface(element.getClass(), IBaseElement.class) ? ((IBaseElement)element).base().get() : element;
    }

    private static void validateFoundElement(JDIBase base, WebElement element) {
        for (JFunc1 rule : base.searchRules().values()) {
            if (((Boolean)rule.execute((Object)element)).booleanValue()) continue;
            throw Exceptions.runtimeException(SEARCH_RULE_VALIDATION_FAILED, new Object[0]);
        }
    }

    private static SearchContext getContextByLocator(JDIBase base, By locator) {
        List<WebElement> els = WebDriverByUtils.uiSearch(JdiSettings.getContext(base), JdiSettings.correctLocator(locator));
        return JdiSettings.filterWebListToWebElement(base, els);
    }

    public static JDIBase getBase(Object element) {
        if (ReflectionUtils.isClass(element.getClass(), JDIBase.class)) {
            return (JDIBase)element;
        }
        if (ReflectionUtils.isInterface(element.getClass(), IBaseElement.class)) {
            return ((IBaseElement)element).base();
        }
        return null;
    }

    private static SearchContext getSearchContext(WebDriver driver, Object parent) {
        JDIBase base = JdiSettings.getBase(parent);
        if (base == null) {
            return (SearchContext)DEFAULT_CONTEXT.execute((Object)driver);
        }
        if (base.webElement.hasValue()) {
            return (SearchContext)base.webElement.get();
        }
        if (base.locator.isRoot() && base.locator.isNull()) {
            return (SearchContext)DEFAULT_CONTEXT.execute((Object)driver);
        }
        List<By> frames = base.getFrames();
        if (frames != null) {
            return JdiSettings.getFrameContext(driver, frames);
        }
        By byLocator = base.getLocator(new Object[0]);
        IBaseElement asBaseElement = (IBaseElement)parent;
        return byLocator == null || StringUtils.isBlank((CharSequence)WebDriverByUtils.getByLocator(byLocator)) ? JdiSettings.getSmartSearchContext(asBaseElement) : JdiSettings.getContextByLocator(base, byLocator);
    }

    private static SearchContext getSmartSearchContext(IBaseElement bElement) {
        try {
            WebElement result = JdiSettings.filterWebListToWebElement(bElement.base(), (List)WebSettings.SMART_SEARCH.execute((Object)bElement));
            if (result != null) {
                return result;
            }
        }
        catch (Exception exception) {
        }
        return JdiSettings.getContext(bElement.base());
    }

    private static boolean isRoot(Object parent) {
        return parent == null || ReflectionUtils.isClass(parent.getClass(), WebPage.class) || !ReflectionUtils.isInterface(parent.getClass(), JDIElement.class);
    }

    public static SearchContext getContext(JDIBase base) {
        Object parent = base.parent;
        JDILocator locator = base.locator;
        List<By> frames = base.getFrames();
        WebDriver driver = base.driver();
        if (frames != null) {
            return JdiSettings.getFrameContext(base.driver(), frames);
        }
        return locator.isRoot || JdiSettings.isRoot(parent) ? (SearchContext)DEFAULT_CONTEXT.execute((Object)driver) : JdiSettings.getSearchContext(driver, parent);
    }

    private static SearchContext getFrameContext(WebDriver driver, List<By> frames) {
        WebDriver ctx = driver;
        DEFAULT_CONTEXT.execute((Object)driver);
        for (By frame : frames) {
            List<WebElement> els = WebDriverByUtils.uiSearch((SearchContext)ctx, JdiSettings.getFrameLocator(frame, ctx));
            if (!ObjectUtils.isNotEmpty(els)) {
                throw Exceptions.runtimeException("Can't find frame by locator: '%s'", frame);
            }
            WebElement frameElement = els.get(0);
            try {
                ctx = ctx.switchTo().frame(frameElement);
                WebSettings.logger.debug("Switch to frame: " + WebDriverByUtils.shortBy(frame), new Object[0]);
            }
            catch (Exception ex) {
                throw Exceptions.exception(ex, "Can't switch to frame by locator: '%s'", frame);
            }
        }
        return ctx;
    }

    private static By getFrameLocator(By frame, WebDriver driver) {
        try {
            driver.findElement(frame).getTagName();
            return frame;
        }
        catch (Exception exception) {
            return By.id((String)WebDriverByUtils.getByLocator(frame));
        }
    }

    public static SearchContext getDefaultContext(WebDriver driver) {
        return driver.switchTo().defaultContent();
    }

    private static By correctLocator(By locator) {
        if (locator == null) {
            return null;
        }
        return WebDriverByUtils.correctXPaths(locator);
    }

    @JDebug
    public static List<WebElement> getAllElementsInContext(JDIBase base, Object ... args) {
        JDIBase jDIBase = base;
        Object[] objectArray = args;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)jDIBase, (Object)objectArray);
        Object[] objectArray2 = new Object[]{jDIBase, objectArray, joinPoint};
        JdiSettings$AjcClosure3 jdiSettings$AjcClosure3 = new JdiSettings$AjcClosure3(objectArray2);
        return (List)ActionProcessor.aspectOf().debugAround(jdiSettings$AjcClosure3.linkClosureAndJoinPoint(65536));
    }

    private static WebElement getUIElementFromArgs(JDIBase base, Object ... args) {
        if (base.locator.argsCount() == 0 && args.length == 1) {
            String value = null;
            if (args[0].getClass() == String.class) {
                value = args[0].toString();
            }
            if (ReflectionUtils.isClass(args[0].getClass(), Enum.class)) {
                value = EnumUtils.getEnumValue((Enum)((Enum)args[0]));
            }
            if (value != null) {
                if (base.locator.isXPath()) {
                    return JdiSettings.getWebElementFromContext(base, (By)WebDriverByUtils.NAME_TO_LOCATOR.execute((Object)JdiSettings.addTextToXPath(base.getLocator(new Object[0]), value)));
                }
                SearchContext searchContext = JdiSettings.getContext(base);
                List<WebElement> elements = WebDriverByUtils.uiSearch(searchContext, base.getLocator(new Object[0]));
                for (WebElement element : elements) {
                    UIElement uIElement = new UIElement(base, element);
                    JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, (Object)uIElement);
                    Object[] objectArray = new Object[]{uIElement, joinPoint};
                    JdiSettings$AjcClosure5 jdiSettings$AjcClosure5 = new JdiSettings$AjcClosure5(objectArray);
                    String name = (String)ActionProcessor.aspectOf().jdiAround(jdiSettings$AjcClosure5.linkClosureAndJoinPoint(16));
                    if (!((Boolean)JDISettings.ELEMENT.namesEqual.execute((Object)name, (Object)value)).booleanValue()) continue;
                    return element;
                }
            }
        }
        throw Exceptions.runtimeException("Can't get element with template locator '%s'. Expected %s arguments but found %s", base.getLocator(new Object[0]), base.locator.argsCount(), args.length);
    }

    public static List<WebElement> getWebElementsFromContext(JDIBase base, By locator) {
        SearchContext searchContext = JdiSettings.getContext(base);
        return WebDriverByUtils.uiSearch(searchContext, locator);
    }

    public static WebElement getWebElementFromContext(JDIBase base, By locator) {
        List<WebElement> result = JdiSettings.getWebElementsFromContext(base, locator);
        if (result.size() == 0) {
            throw Exceptions.runtimeException(FAILED_TO_FIND_ELEMENT_MESSAGE, base.getName(), base.getTimeout());
        }
        return result.get(0);
    }

    public static String addTextToXPath(By byLocator, String text) {
        return com.jdiai.tools.StringUtils.format((String)"(%s)[.='%s']", (Object[])new Object[]{WebDriverByUtils.getByLocator(byLocator), text});
    }

    static final /* synthetic */ List filterElements_aroundBody0(JDIBase base, List elements, JoinPoint joinPoint) {
        if (ObjectUtils.isEmpty((Object)elements)) {
            return new ArrayList();
        }
        List result = elements;
        for (JFunc1 rule : base.searchRules().values()) {
            result = LinqUtils.filter((Collection)result, arg_0 -> ((JFunc1)rule).execute(arg_0));
        }
        return ObjectUtils.isEmpty((Object)result) && base.textType == TextTypes.LABEL ? elements : result;
    }

    static final /* synthetic */ List getAllElementsInContext_aroundBody2(JDIBase base, Object[] args, JoinPoint joinPoint) {
        SearchContext searchContext = JdiSettings.getContext(base);
        By locator = base.getLocator(args);
        return locator == null ? base.getSmartList() : WebDriverByUtils.uiSearch(searchContext, JdiSettings.correctLocator(locator));
    }

    static final /* synthetic */ String getText_aroundBody4(UIElement uIElement, JoinPoint joinPoint) {
        return uIElement.getText();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JdiSettings.java", JdiSettings.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "filterElements", "com.epam.jdi.light.elements.base.JdiSettings", "com.epam.jdi.light.elements.base.JDIBase:java.util.List", "base:elements", "", "java.util.List"), 117);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("89", "getAllElementsInContext", "com.epam.jdi.light.elements.base.JdiSettings", "com.epam.jdi.light.elements.base.JDIBase:[Ljava.lang.Object;", "base:args", "", "java.util.List"), 236);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getText", "com.epam.jdi.light.elements.common.UIElement", "", "", "", "java.lang.String"), 256);
    }
}

