/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.common;

import com.jdiai.tools.StringUtils;
import java.util.function.BiFunction;
import org.openqa.selenium.Point;

public class Direction {
    public static BiFunction<Direction, Direction, Boolean> VECTOR_SIMILARITY = (v1, v2) -> v1.angle == v2.angle && v1.length == v2.length;
    private int angle;
    private int length;

    public Direction(int angle, int length) {
        this.angle = angle;
        this.length = length;
    }

    public Direction(Point point1, Point point2) {
        double difX = point2.x - point1.x;
        double difY = point2.y - point1.y;
        this.angle = this.calculateAngle(difX, difY);
        this.length = (int)Math.sqrt(Math.pow(difY, 2.0) + Math.pow(difX, 2.0));
    }

    private int calculateAngle(double difX, double difY) {
        float angle = (float)Math.toDegrees(Math.atan2(-difY, difX));
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return (int)angle;
    }

    public int angle() {
        return this.angle;
    }

    public double length() {
        return this.length;
    }

    public boolean isSimilarTo(Direction vector) {
        return VECTOR_SIMILARITY.apply(this, vector);
    }

    public String toString() {
        return StringUtils.format((String)"(angle:%s, length:%s)", (Object[])new Object[]{this.angle, this.length});
    }
}

