/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.common;

import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.elements.common.Direction;
import com.google.common.collect.Range;
import java.util.function.Function;

public class Directions {
    public static int MAIN_ACCURACY = 90;
    public static int SECOND_ACCURACY = 45;
    public static int LINE_ACCURACY = 5;
    public static int ANGLE_ACCURACY = 5;
    public static Function<Direction, Boolean> LOWER = Directions.DIRECTION(90, MAIN_ACCURACY);
    public static Function<Direction, Boolean> HIGHER = Directions.DIRECTION(270, MAIN_ACCURACY);
    public static Function<Direction, Boolean> RIGHT = Directions.DIRECTION(180, MAIN_ACCURACY);
    public static Function<Direction, Boolean> LEFT = Directions.DIRECTION(0, MAIN_ACCURACY);
    public static Function<Direction, Boolean> TOP_RIGHT = Directions.DIRECTION(45, SECOND_ACCURACY);
    public static Function<Direction, Boolean> TOP_LEFT = Directions.DIRECTION(135, SECOND_ACCURACY);
    public static Function<Direction, Boolean> BOTTOM_LEFT = Directions.DIRECTION(225, SECOND_ACCURACY);
    public static Function<Direction, Boolean> BOTTOM_RIGHT = Directions.DIRECTION(315, SECOND_ACCURACY);
    public static Function<Direction, Boolean> SAME_HORIZONTAL = d -> Range.closed((Comparable)Integer.valueOf(180 - LINE_ACCURACY), (Comparable)Integer.valueOf(180 + LINE_ACCURACY)).contains((Comparable)Integer.valueOf(d.angle())) || Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(LINE_ACCURACY)).contains((Comparable)Integer.valueOf(d.angle())) || Range.closed((Comparable)Integer.valueOf(360 - LINE_ACCURACY), (Comparable)Integer.valueOf(360)).contains((Comparable)Integer.valueOf(d.angle()));
    public static Function<Direction, Boolean> SAME_VERTICAL = d -> Range.closed((Comparable)Integer.valueOf(90 - LINE_ACCURACY), (Comparable)Integer.valueOf(90 + LINE_ACCURACY)).contains((Comparable)Integer.valueOf(d.angle())) || Range.closed((Comparable)Integer.valueOf(270 - LINE_ACCURACY), (Comparable)Integer.valueOf(270 + LINE_ACCURACY)).contains((Comparable)Integer.valueOf(d.angle()));

    public static Function<Direction, Boolean> DIRECTION(int angle, int accuracy) {
        if (angle < 0 || angle > 360 || accuracy < 0 || accuracy > 180) {
            throw Exceptions.runtimeException("Angle should be in range [0, 360]; Accuracy in [0, 180], but Angle=%s; Accuracy=%s", angle, accuracy);
        }
        int lower = angle - accuracy;
        int upper = angle + accuracy;
        if (lower >= 0 && upper <= 360) {
            return d -> d.angle() >= lower && d.angle() <= upper;
        }
        int min = lower < 0 ? 360 + lower : lower;
        int max = upper > 360 ? upper - 360 : upper;
        return d -> d.angle() <= max && d.angle() >= 0 || d.angle() <= 360 && d.angle() >= min;
    }

    public static Function<Direction, Boolean> ANGLE(int angle, int accuracy) {
        return Directions.DIRECTION(angle, accuracy);
    }

    public static Function<Direction, Boolean> ANGLE(int angle) {
        return Directions.ANGLE(angle, ANGLE_ACCURACY);
    }
}

