/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.common;

import com.epam.jdi.light.actions.ActionProcessor;
import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.common.JDIAction;
import com.epam.jdi.light.driver.WebDriverFactory;
import com.epam.jdi.light.elements.common.WindowsManager$AjcClosure1;
import com.epam.jdi.light.elements.common.WindowsManager$AjcClosure11;
import com.epam.jdi.light.elements.common.WindowsManager$AjcClosure13;
import com.epam.jdi.light.elements.common.WindowsManager$AjcClosure15;
import com.epam.jdi.light.elements.common.WindowsManager$AjcClosure17;
import com.epam.jdi.light.elements.common.WindowsManager$AjcClosure19;
import com.epam.jdi.light.elements.common.WindowsManager$AjcClosure21;
import com.epam.jdi.light.elements.common.WindowsManager$AjcClosure23;
import com.epam.jdi.light.elements.common.WindowsManager$AjcClosure25;
import com.epam.jdi.light.elements.common.WindowsManager$AjcClosure27;
import com.epam.jdi.light.elements.common.WindowsManager$AjcClosure29;
import com.epam.jdi.light.elements.common.WindowsManager$AjcClosure3;
import com.epam.jdi.light.elements.common.WindowsManager$AjcClosure31;
import com.epam.jdi.light.elements.common.WindowsManager$AjcClosure33;
import com.epam.jdi.light.elements.common.WindowsManager$AjcClosure35;
import com.epam.jdi.light.elements.common.WindowsManager$AjcClosure37;
import com.epam.jdi.light.elements.common.WindowsManager$AjcClosure5;
import com.epam.jdi.light.elements.common.WindowsManager$AjcClosure7;
import com.epam.jdi.light.elements.common.WindowsManager$AjcClosure9;
import com.epam.jdi.light.elements.pageobjects.annotations.Name;
import com.epam.jdi.light.settings.JDISettings;
import com.jdiai.tools.Safe;
import com.jdiai.tools.map.MapArray;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebDriver;

public class WindowsManager {
    private static Safe<Set<String>> windowHandles;
    private static Safe<MapArray<String, String>> windowHandlesMap;
    private static Safe<Boolean> newWindow;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;

    static {
        WindowsManager.ajc$preClinit();
        windowHandles = new Safe();
        windowHandlesMap = new Safe(MapArray::new);
        newWindow = new Safe(() -> false);
    }

    public static Set<String> getWindows() {
        WebDriver driver = WebDriverFactory.getDriver();
        if (driver == null) {
            throw Exceptions.runtimeException("Can't get WebDriver", new Object[0]);
        }
        Set wHandles = driver.getWindowHandles();
        if (windowHandles.get() != null && ((Set)windowHandles.get()).size() < wHandles.size()) {
            newWindow.set((Object)true);
        }
        windowHandles.set((Object)wHandles);
        return wHandles;
    }

    public static void openSiteTab(Class<?> site) {
        String name;
        String string = name = site.isAnnotationPresent(Name.class) ? site.getAnnotation(Name.class).value() : site.getSimpleName();
        if (ObjectUtils.isEmpty((Object)windowHandlesMap.get())) {
            WindowsManager.setWindowName(name);
            return;
        }
        if (((MapArray)windowHandlesMap.get()).has((Object)name)) {
            String string2 = name;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)string2);
            Object[] objectArray = new Object[]{string2, joinPoint};
            WindowsManager$AjcClosure1 windowsManager$AjcClosure1 = new WindowsManager$AjcClosure1(objectArray);
            ActionProcessor.aspectOf().jdiAround(windowsManager$AjcClosure1.linkClosureAndJoinPoint(0));
        } else {
            String string3 = name;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string3);
            Object[] objectArray = new Object[]{string3, joinPoint};
            WindowsManager$AjcClosure3 windowsManager$AjcClosure3 = new WindowsManager$AjcClosure3(objectArray);
            ActionProcessor.aspectOf().jdiAround(windowsManager$AjcClosure3.linkClosureAndJoinPoint(0));
        }
    }

    public static boolean newWindowIsOpened() {
        WindowsManager.getWindows();
        if (((Boolean)newWindow.get()).booleanValue()) {
            newWindow.set((Object)false);
            return true;
        }
        return false;
    }

    @JDIAction(value="Check that new window is opened")
    public static void checkNewWindowIsOpened() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        WindowsManager$AjcClosure7 windowsManager$AjcClosure7 = new WindowsManager$AjcClosure7(objectArray);
        ActionProcessor.aspectOf().jdiAround(windowsManager$AjcClosure7.linkClosureAndJoinPoint(65536));
    }

    public static void setWindowName(String value) {
        ((MapArray)windowHandlesMap.get()).update((Object)value, (Object)WebDriverFactory.getDriver().getWindowHandle());
    }

    public static List<String> registeredWindows() {
        return ((MapArray)windowHandlesMap.get()).keys();
    }

    @JDIAction(value="Get windows count")
    public static int windowsCount() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        WindowsManager$AjcClosure9 windowsManager$AjcClosure9 = new WindowsManager$AjcClosure9(objectArray);
        return Conversions.intValue((Object)ActionProcessor.aspectOf().jdiAround(windowsManager$AjcClosure9.linkClosureAndJoinPoint(65536)));
    }

    @JDIAction(value="Switch to new window")
    public static void switchToNewWindow() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        WindowsManager$AjcClosure11 windowsManager$AjcClosure11 = new WindowsManager$AjcClosure11(objectArray);
        ActionProcessor.aspectOf().jdiAround(windowsManager$AjcClosure11.linkClosureAndJoinPoint(65536));
    }

    @JDIAction(value="Open new tab")
    public static void openNewTab() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        WindowsManager$AjcClosure15 windowsManager$AjcClosure15 = new WindowsManager$AjcClosure15(objectArray);
        ActionProcessor.aspectOf().jdiAround(windowsManager$AjcClosure15.linkClosureAndJoinPoint(65536));
    }

    @JDIAction(value="Open new tab '{0}'")
    public static void openNewTab(String name) {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, null, null, (Object)string);
        Object[] objectArray = new Object[]{string, joinPoint};
        WindowsManager$AjcClosure19 windowsManager$AjcClosure19 = new WindowsManager$AjcClosure19(objectArray);
        ActionProcessor.aspectOf().jdiAround(windowsManager$AjcClosure19.linkClosureAndJoinPoint(65536));
    }

    @JDIAction(value="Go back to original window")
    public static void originalWindow() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        WindowsManager$AjcClosure21 windowsManager$AjcClosure21 = new WindowsManager$AjcClosure21(objectArray);
        ActionProcessor.aspectOf().jdiAround(windowsManager$AjcClosure21.linkClosureAndJoinPoint(65536));
    }

    @JDIAction(value="Switch to window '{index}'")
    public static void switchToWindow(int index) {
        int n = index;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, null, null, (Object)Conversions.intObject((int)n));
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), joinPoint};
        WindowsManager$AjcClosure23 windowsManager$AjcClosure23 = new WindowsManager$AjcClosure23(objectArray);
        ActionProcessor.aspectOf().jdiAround(windowsManager$AjcClosure23.linkClosureAndJoinPoint(65536));
    }

    @JDIAction(value="Switch to window '{0}'")
    public static void switchToWindow(String value) {
        String string = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, null, null, (Object)string);
        Object[] objectArray = new Object[]{string, joinPoint};
        WindowsManager$AjcClosure25 windowsManager$AjcClosure25 = new WindowsManager$AjcClosure25(objectArray);
        ActionProcessor.aspectOf().jdiAround(windowsManager$AjcClosure25.linkClosureAndJoinPoint(65536));
    }

    @JDIAction(value="Close current window")
    public static void closeWindow() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        WindowsManager$AjcClosure29 windowsManager$AjcClosure29 = new WindowsManager$AjcClosure29(objectArray);
        ActionProcessor.aspectOf().jdiAround(windowsManager$AjcClosure29.linkClosureAndJoinPoint(65536));
    }

    @JDIAction(value="Close window '{0}'")
    public static void closeWindow(String value) {
        String string = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, null, null, (Object)string);
        Object[] objectArray = new Object[]{string, joinPoint};
        WindowsManager$AjcClosure35 windowsManager$AjcClosure35 = new WindowsManager$AjcClosure35(objectArray);
        ActionProcessor.aspectOf().jdiAround(windowsManager$AjcClosure35.linkClosureAndJoinPoint(65536));
    }

    @JDIAction(value="Resize window '{0}'")
    public static void resizeWindow(int width, int height) {
        int n = width;
        int n2 = height;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, null, null, (Object)Conversions.intObject((int)n), (Object)Conversions.intObject((int)n2));
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), Conversions.intObject((int)n2), joinPoint};
        WindowsManager$AjcClosure37 windowsManager$AjcClosure37 = new WindowsManager$AjcClosure37(objectArray);
        ActionProcessor.aspectOf().jdiAround(windowsManager$AjcClosure37.linkClosureAndJoinPoint(65536));
    }

    static final /* synthetic */ void switchToWindow_aroundBody0(String string, JoinPoint joinPoint) {
        WindowsManager.switchToWindow(string);
    }

    static final /* synthetic */ void openNewTab_aroundBody2(String string, JoinPoint joinPoint) {
        WindowsManager.openNewTab(string);
    }

    static final /* synthetic */ void switchToNewWindow_aroundBody4(JoinPoint joinPoint) {
        WindowsManager.switchToNewWindow();
    }

    static final /* synthetic */ void checkNewWindowIsOpened_aroundBody6(JoinPoint joinPoint) {
        boolean isNewWindow = WindowsManager.newWindowIsOpened();
        if (!isNewWindow) {
            throw Exceptions.runtimeException("New window is not opened", new Object[0]);
        }
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null);
        Object[] objectArray = new Object[]{joinPoint2};
        WindowsManager$AjcClosure5 windowsManager$AjcClosure5 = new WindowsManager$AjcClosure5(objectArray);
        ActionProcessor.aspectOf().jdiAround(windowsManager$AjcClosure5.linkClosureAndJoinPoint(0));
    }

    static final /* synthetic */ int windowsCount_aroundBody8(JoinPoint joinPoint) {
        return WindowsManager.getWindows().size();
    }

    static final /* synthetic */ void switchToNewWindow_aroundBody10(JoinPoint joinPoint) {
        String last = "";
        Iterator<String> iterator = WindowsManager.getWindows().iterator();
        while (iterator.hasNext()) {
            String window;
            last = window = iterator.next();
        }
        if (StringUtils.isBlank((CharSequence)last)) {
            throw Exceptions.runtimeException("No windows found", new Object[0]);
        }
        WebDriverFactory.getDriver().switchTo().window(last);
    }

    static final /* synthetic */ void switchToNewWindow_aroundBody12(JoinPoint joinPoint) {
        WindowsManager.switchToNewWindow();
    }

    static final /* synthetic */ void openNewTab_aroundBody14(JoinPoint joinPoint) {
        WebDriverFactory.jsExecute("window.open()", new Object[0]);
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null);
        Object[] objectArray = new Object[]{joinPoint2};
        WindowsManager$AjcClosure13 windowsManager$AjcClosure13 = new WindowsManager$AjcClosure13(objectArray);
        ActionProcessor.aspectOf().jdiAround(windowsManager$AjcClosure13.linkClosureAndJoinPoint(0));
    }

    static final /* synthetic */ void switchToNewWindow_aroundBody16(JoinPoint joinPoint) {
        WindowsManager.switchToNewWindow();
    }

    static final /* synthetic */ void openNewTab_aroundBody18(String name, JoinPoint joinPoint) {
        WebDriverFactory.jsExecute("window.open()", new Object[0]);
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null);
        Object[] objectArray = new Object[]{joinPoint2};
        WindowsManager$AjcClosure17 windowsManager$AjcClosure17 = new WindowsManager$AjcClosure17(objectArray);
        ActionProcessor.aspectOf().jdiAround(windowsManager$AjcClosure17.linkClosureAndJoinPoint(0));
        WindowsManager.setWindowName(name);
    }

    static final /* synthetic */ void originalWindow_aroundBody20(JoinPoint joinPoint) {
        WebDriverFactory.getDriver().switchTo().window(WindowsManager.getWindows().iterator().next());
    }

    static final /* synthetic */ void switchToWindow_aroundBody22(int index, JoinPoint joinPoint) {
        if (index < JDISettings.ELEMENT.startIndex) {
            throw Exceptions.runtimeException("Window's index starts from 1. You try to use '%s' that less than 1.", index);
        }
        int counter = 0;
        if (WindowsManager.getWindows().size() < index - JDISettings.ELEMENT.startIndex + 1) {
            throw Exceptions.runtimeException(String.valueOf(index) + " is too much. Only " + WindowsManager.getWindows().size() + " windows found", new Object[0]);
        }
        for (String window : WindowsManager.getWindows()) {
            if (++counter != index) continue;
            WebDriverFactory.getDriver().switchTo().window(window);
            return;
        }
    }

    static final /* synthetic */ void switchToWindow_aroundBody24(String value, JoinPoint joinPoint) {
        if (!((MapArray)windowHandlesMap.get()).has((Object)value)) {
            throw Exceptions.runtimeException("Window %s not registered. Use setWindowName method to setup window name for current windowHandle", value);
        }
        WebDriverFactory.getDriver().switchTo().window((String)((MapArray)windowHandlesMap.get()).get((Object)value));
    }

    static final /* synthetic */ void originalWindow_aroundBody26(JoinPoint joinPoint) {
        WindowsManager.originalWindow();
    }

    static final /* synthetic */ void closeWindow_aroundBody28(JoinPoint joinPoint) {
        WebDriverFactory.getDriver().close();
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, null, null);
        Object[] objectArray = new Object[]{joinPoint2};
        WindowsManager$AjcClosure27 windowsManager$AjcClosure27 = new WindowsManager$AjcClosure27(objectArray);
        ActionProcessor.aspectOf().jdiAround(windowsManager$AjcClosure27.linkClosureAndJoinPoint(0));
    }

    static final /* synthetic */ void switchToWindow_aroundBody30(String string, JoinPoint joinPoint) {
        WindowsManager.switchToWindow(string);
    }

    static final /* synthetic */ void closeWindow_aroundBody32(JoinPoint joinPoint) {
        WindowsManager.closeWindow();
    }

    static final /* synthetic */ void closeWindow_aroundBody34(String value, JoinPoint joinPoint) {
        String string = value;
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, null, null, (Object)string);
        Object[] objectArray = new Object[]{string, joinPoint2};
        WindowsManager$AjcClosure31 windowsManager$AjcClosure31 = new WindowsManager$AjcClosure31(objectArray);
        ActionProcessor.aspectOf().jdiAround(windowsManager$AjcClosure31.linkClosureAndJoinPoint(0));
        JoinPoint joinPoint3 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, null, null);
        Object[] objectArray2 = new Object[]{joinPoint3};
        WindowsManager$AjcClosure33 windowsManager$AjcClosure33 = new WindowsManager$AjcClosure33(objectArray2);
        ActionProcessor.aspectOf().jdiAround(windowsManager$AjcClosure33.linkClosureAndJoinPoint(0));
    }

    static final /* synthetic */ void resizeWindow_aroundBody36(int width, int height, JoinPoint joinPoint) {
        WebDriverFactory.getDriver().manage().window().setSize(new Dimension(width, height));
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WindowsManager.java", WindowsManager.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "switchToWindow", "com.epam.jdi.light.elements.common.WindowsManager", "java.lang.String", "value", "", "void"), 51);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "openNewTab", "com.epam.jdi.light.elements.common.WindowsManager", "java.lang.String", "name", "", "void"), 53);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "originalWindow", "com.epam.jdi.light.elements.common.WindowsManager", "", "", "", "void"), 131);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "switchToWindow", "com.epam.jdi.light.elements.common.WindowsManager", "int", "index", "", "void"), 140);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "switchToWindow", "com.epam.jdi.light.elements.common.WindowsManager", "java.lang.String", "value", "", "void"), 162);
        ajc$tjp_13 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "originalWindow", "com.epam.jdi.light.elements.common.WindowsManager", "", "", "", "void"), 175);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "closeWindow", "com.epam.jdi.light.elements.common.WindowsManager", "", "", "", "void"), 173);
        ajc$tjp_15 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "switchToWindow", "com.epam.jdi.light.elements.common.WindowsManager", "java.lang.String", "value", "", "void"), 184);
        ajc$tjp_16 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "closeWindow", "com.epam.jdi.light.elements.common.WindowsManager", "", "", "", "void"), 185);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "closeWindow", "com.epam.jdi.light.elements.common.WindowsManager", "java.lang.String", "value", "", "void"), 183);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "resizeWindow", "com.epam.jdi.light.elements.common.WindowsManager", "int:int", "width:height", "", "void"), 193);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "switchToNewWindow", "com.epam.jdi.light.elements.common.WindowsManager", "", "", "", "void"), 75);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "checkNewWindowIsOpened", "com.epam.jdi.light.elements.common.WindowsManager", "", "", "", "void"), 70);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "windowsCount", "com.epam.jdi.light.elements.common.WindowsManager", "", "", "", "int"), 89);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "switchToNewWindow", "com.epam.jdi.light.elements.common.WindowsManager", "", "", "", "void"), 97);
        ajc$tjp_6 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "switchToNewWindow", "com.epam.jdi.light.elements.common.WindowsManager", "", "", "", "void"), 114);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "openNewTab", "com.epam.jdi.light.elements.common.WindowsManager", "", "", "", "void"), 112);
        ajc$tjp_8 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "switchToNewWindow", "com.epam.jdi.light.elements.common.WindowsManager", "", "", "", "void"), 123);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "openNewTab", "com.epam.jdi.light.elements.common.WindowsManager", "java.lang.String", "name", "", "void"), 121);
    }
}

