/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.complex.table;

import com.epam.jdi.light.asserts.generic.table.IDataGridAssert;
import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.elements.base.UIBaseElement;
import com.epam.jdi.light.elements.common.UIElement;
import com.epam.jdi.light.elements.complex.ISetup;
import com.epam.jdi.light.elements.complex.WebList;
import com.epam.jdi.light.elements.complex.table.Grid;
import com.epam.jdi.light.elements.complex.table.IDataGrid;
import com.epam.jdi.light.elements.complex.table.IGrid;
import com.epam.jdi.light.elements.complex.table.Line;
import com.epam.jdi.light.elements.interfaces.base.HasInit;
import com.epam.jdi.light.elements.interfaces.base.HasValue;
import com.epam.jdi.light.elements.interfaces.composite.PageObject;
import com.epam.jdi.light.elements.pageobjects.annotations.WebAnnotationsUtil;
import com.epam.jdi.light.settings.JDISettings;
import com.jdiai.tools.LinqUtils;
import com.jdiai.tools.ReflectionUtils;
import com.jdiai.tools.Safe;
import com.jdiai.tools.StringUtils;
import com.jdiai.tools.func.JFunc1;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.WebElement;

public class DataGrid<L extends PageObject, D>
extends UIBaseElement<IDataGridAssert<D, IDataGrid<L, D>, ?>>
implements ISetup,
IGrid<D>,
IDataGrid<L, D>,
HasInit {
    protected Class<D> dataClass = null;
    protected Class<L> lineClass = null;
    protected Safe<Grid> grid = new Safe(Grid::new);
    public JFunc1<String, String> SIMPLIFY;
    protected int startIndex;

    public DataGrid() {
        this.SIMPLIFY = JDISettings.ELEMENT.simplifyString;
        this.startIndex = JDISettings.ELEMENT.startIndex;
    }

    @Override
    public Grid grid() {
        return (Grid)this.grid.get();
    }

    @Override
    public void init() {
        Grid element = (Grid)this.grid.get();
        element.init();
        this.grid = new Safe(() -> element);
    }

    @Override
    public UIElement core() {
        return this.grid().core();
    }

    @Override
    public boolean isEmpty() {
        return IDataGrid.super.isEmpty();
    }

    @Override
    public int size() {
        return IDataGrid.super.size();
    }

    @Override
    public int count() {
        return IDataGrid.super.count();
    }

    @Override
    public WebList webRow(int rowNum) {
        return IDataGrid.super.webRow(rowNum);
    }

    @Override
    public WebList webColumn(int colNum) {
        return IDataGrid.super.webColumn(colNum);
    }

    @Override
    public WebList webColumn(String colName) {
        return IDataGrid.super.webColumn(colName);
    }

    @Override
    public UIElement webCell(int colNum, int rowNum) {
        return IDataGrid.super.webCell(colNum, rowNum);
    }

    @Override
    public List<String> header() {
        return IDataGrid.super.header();
    }

    @Override
    public WebList footerUI() {
        return IDataGrid.super.footerUI();
    }

    @Override
    public D rowAsData(WebList row) {
        return this.lineClass != null ? this.lineToData(this.rowAsLine(row)) : new Line(this.header(), row, row.getName()).asData(this.dataClass);
    }

    @Override
    public L rowAsLine(WebList row) {
        return (L)((PageObject)new Line(this.header(), row, row.getName()).asLine(this.lineClass));
    }

    @Override
    public List<D> elements(int minAmount) {
        return this.allData();
    }

    public List<D> dataEqualsTo(D data) {
        return this.dataMatches(d -> d == data);
    }

    public List<D> dataMatches(JFunc1<D, Boolean> matcher) {
        return this.filter(matcher);
    }

    @Override
    public D get(String value) {
        return (D)this.data(value);
    }

    @Override
    public WebList webCells() {
        return this.grid().webCells();
    }

    @Override
    public void clear() {
        this.grid().clear();
    }

    @Override
    public WebList headerUI() {
        WebList headerUI = this.grid().headerUI();
        return headerUI.size() == this.grid().size ? headerUI : this.tryFilterHeader(headerUI);
    }

    @Override
    public IDataGridAssert<D, IDataGrid<L, D>, ?> is() {
        return new IDataGridAssert(this);
    }

    @Override
    public void setup(Field field) {
        this.grid().setup(field);
        try {
            this.setupGenericFields(field);
        }
        catch (Exception exception) {}
        ArrayList<Field> entityFields = new ArrayList<Field>();
        if (this.lineClass != null) {
            entityFields.addAll(ReflectionUtils.getFieldsExact(this.lineClass, f -> ReflectionUtils.isInterface((Field)f, HasValue.class)));
        }
        if (this.dataClass != null) {
            entityFields.addAll(Arrays.asList(this.dataClass.getDeclaredFields()));
        }
        if (entityFields.size() > 0) {
            this.grid().header = LinqUtils.map(entityFields, field1 -> (String)JDISettings.ELEMENT.name.execute(field1)).stream().distinct().collect(Collectors.toList());
            this.grid().size = this.grid().header.size();
        }
    }

    protected void setupGenericFields(Field field) {
        Type[] types = ReflectionUtils.getGenericTypes((Field)field);
        if (types.length != 2) {
            return;
        }
        try {
            this.lineClass = types[0].toString().equals("?") ? null : (Class)types[0];
            this.dataClass = types[1].toString().equals("?") ? null : (Class)types[1];
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't get DataTable %s data or entity class", this.getName());
        }
    }

    protected WebList tryFilterHeader(WebList headerUI) {
        if (headerUI.size() < this.grid().size) {
            throw Exceptions.runtimeException("Header has size less than expected - %s. Please verify header locator or override headerUI() method", this.grid().size);
        }
        int i = 1;
        int j = 0;
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        this.grid().columnsMapping = new ArrayList<Integer>();
        for (WebElement element : headerUI) {
            if (((String)this.SIMPLIFY.execute((Object)element.getText())).equalsIgnoreCase((String)this.SIMPLIFY.execute((Object)this.grid().header.get(j)))) {
                this.grid().columnsMapping.add(i);
                elements.add(element);
                ++j;
            }
            ++i;
        }
        if (elements.size() != this.grid().size) {
            throw Exceptions.runtimeException("Header has size more than expected - %s. Please verify header locator or override headerUI() method", this.grid().size);
        }
        return new WebList(elements);
    }

    protected D lineToData(L line) {
        Field[] lineFields;
        Object instance;
        try {
            instance = ReflectionUtils.create(this.dataClass);
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't create %s instance in lineToData(line)", this.dataClass.getSimpleName());
        }
        Field[] dataFields = instance.getClass().getDeclaredFields();
        Field[] fieldArray = lineFields = line.getClass().getDeclaredFields();
        int n = lineFields.length;
        int n2 = 0;
        while (n2 < n) {
            Field lineField = fieldArray[n2];
            Field[] fieldArray2 = dataFields;
            int n3 = dataFields.length;
            int n4 = 0;
            while (n4 < n3) {
                Field dataField = fieldArray2[n4];
                if (((Boolean)JDISettings.ELEMENT.namesEqual.execute((Object)WebAnnotationsUtil.getElementName(lineField), (Object)WebAnnotationsUtil.getElementName(dataField))).booleanValue()) {
                    Object lineFieldValue;
                    try {
                        lineFieldValue = lineField.get(line);
                    }
                    catch (Exception ex) {
                        throw Exceptions.exception(ex, "Can't get lineField '%s' value", lineField.getName());
                    }
                    String value = ReflectionUtils.isInterface(lineField.getType(), HasValue.class) ? ((HasValue)lineFieldValue).getValue() : lineFieldValue.toString();
                    try {
                        StringUtils.setPrimitiveField((Field)dataField, (Object)instance, (String)value);
                    }
                    catch (Exception ex) {
                        throw Exceptions.exception(ex, "Can't set table value '%s' to field '%s'", value, dataField.getName());
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return (D)instance;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int index) {
        this.startIndex = index;
    }
}

