/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.complex.table;

import com.epam.jdi.light.asserts.generic.table.IGridAssert;
import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.driver.WebDriverByUtils;
import com.epam.jdi.light.driver.WebDriverFactory;
import com.epam.jdi.light.elements.base.UIBaseElement;
import com.epam.jdi.light.elements.common.UIElement;
import com.epam.jdi.light.elements.complex.ISetup;
import com.epam.jdi.light.elements.complex.WebList;
import com.epam.jdi.light.elements.complex.table.IGrid;
import com.epam.jdi.light.elements.complex.table.Line;
import com.epam.jdi.light.elements.pageobjects.annotations.locators.JTable;
import com.epam.jdi.light.elements.pageobjects.annotations.objects.FillFromAnnotationRules;
import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.light.settings.WebSettings;
import com.jdiai.tools.LinqUtils;
import com.jdiai.tools.Timer;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class Grid
extends UIBaseElement<IGridAssert<Line, IGrid<Line>, ?>>
implements IGrid<Line>,
ISetup {
    protected String allCellsLocator = "tbody td";
    protected String cellTemplate = "//tbody//tr[{1}]/td[{0}]";
    protected String columnTemplate = "//tbody//tr/td[%s]";
    protected String rowTemplate = "//tbody//tr[%s]/td";
    protected String headerLocator = "th";
    protected String footerLocator = "tfoot td";
    protected List<String> header = new ArrayList<String>();
    protected int size = -1;
    protected int count = -1;
    protected List<Integer> columnsMapping;
    protected boolean columnsValidated = false;
    protected boolean locatorsValidated = false;
    protected int startIndex;

    public Grid() {
        this.startIndex = JDISettings.ELEMENT.startIndex;
    }

    @Override
    public WebList webCells() {
        return this.core().finds(this.allCellsLocator).setName(String.valueOf(this.getName()) + " webCells");
    }

    @Override
    public UIElement core() {
        UIElement core = super.core();
        if (WebDriverFactory.hasRunDrivers() && !this.locatorsValidated) {
            try {
                this.locatorsValidated = true;
                this.validateLocators(core);
                WebSettings.logger.debug(String.valueOf(this.getName()) + ": Validation success", new Object[0]);
            }
            catch (Throwable throwable) {
                this.locatorsValidated = false;
            }
        }
        return core;
    }

    protected void validateLocators(UIElement core) {
        if (this.headerLocator.equals("th") && core.finds("th").isEmpty()) {
            if (core.finds("thead td").isNotEmpty()) {
                this.headerLocator = "thead td";
            } else if (core.finds("//tr[1]//td").isNotEmpty()) {
                this.headerLocator = "//tr[1]//td";
            }
        }
    }

    @Override
    public List<String> header() {
        return ObjectUtils.isNotEmpty(this.header) ? this.header : IGrid.super.header();
    }

    protected int getColumnIndex(int index) {
        if (!this.columnsValidated) {
            this.validateColumns();
        }
        return ObjectUtils.isEmpty(this.columnsMapping) ? index : this.columnsMapping.get(index - 1);
    }

    @Override
    public int count() {
        return this.count > -1 ? this.count : this.webColumn(1).size();
    }

    @Override
    public List<Line> elements(int minAmount) {
        return (List)Timer.getByCondition(this::rows, r -> r.size() >= minAmount);
    }

    @Override
    public Line get(String value) {
        return this.row(value);
    }

    @Override
    public int size() {
        return this.size > -1 ? this.size : IGrid.super.size();
    }

    @Override
    public void clear() {
        this.size = -1;
        this.count = -1;
    }

    @Override
    public UIElement webCell(int colNum, int rowNum) {
        return this.core().find(MessageFormat.format(this.cellTemplate, colNum, rowNum)).setName(com.jdiai.tools.StringUtils.format((String)"%s cell(%s,%s)", (Object[])new Object[]{this.getName(), colNum, rowNum}));
    }

    @Override
    public WebList webColumn(int colNum) {
        int index = this.getColumnIndex(colNum);
        this.validateColumnIndex(index);
        return this.core().finds(this.columnTemplate, new Object[]{index}).setName(com.jdiai.tools.StringUtils.format((String)"%s column:%s", (Object[])new Object[]{this.getName(), index}));
    }

    @Override
    public WebList webRow(int rowNum) {
        this.validateRowIndex(rowNum);
        return this.core().finds(this.rowTemplate, new Object[]{rowNum}).setName(com.jdiai.tools.StringUtils.format((String)"%s row:%s", (Object[])new Object[]{this.getName(), rowNum}));
    }

    @Override
    public WebList headerUI() {
        return this.core().finds(this.headerLocator).setName(String.valueOf(this.getName()) + " headerUI");
    }

    @Override
    public WebList footerUI() {
        return this.core().finds(this.footerLocator).setName(String.valueOf(this.getName()) + " footerUI");
    }

    @Override
    public void setup(Field field) {
        if (!FillFromAnnotationRules.fieldHasAnnotation(field, JTable.class, Grid.class)) {
            return;
        }
        JTable j = field.getAnnotation(JTable.class);
        List<String> header = Arrays.asList(j.header());
        if (StringUtils.isNotBlank((CharSequence)j.root())) {
            this.core().setLocator((By)WebDriverByUtils.NAME_TO_LOCATOR.execute((Object)j.root()));
        }
        if (!j.row().equals("//tr[%s]/td") || !this.rowTemplate.equals("//tr[%s]/td")) {
            this.rowTemplate = j.row();
        }
        if (!j.column().equals("//tr/td[%s]") || !this.columnTemplate.equals("//tr/td[%s]")) {
            this.columnTemplate = j.column();
        }
        if (!j.cell().equals("//tr[{1}]/td[{0}]") || !this.cellTemplate.equals("//tr[{1}]/td[{0}]")) {
            this.cellTemplate = j.cell();
        }
        if (!j.allCells().equals("td") || !this.allCellsLocator.equals("td")) {
            this.allCellsLocator = j.allCells();
        }
        if (!j.headers().equals("th") || !this.headerLocator.equals("th")) {
            this.headerLocator = j.headers();
        }
        if (!j.footer().equals("tfoot") || !this.footerLocator.equals("tfoot")) {
            this.footerLocator = j.footer();
        }
        if (header.size() > 0) {
            this.header = header;
            this.size = header.size();
        }
        if (j.columnsMapping().length > 0) {
            this.columnsMapping = LinqUtils.toList((int[])j.columnsMapping());
            this.size = j.columnsMapping().length;
            this.columnsValidated = true;
        }
        if (j.size() != -1) {
            this.size = j.size();
        }
        if (j.count() != -1) {
            this.count = j.count();
        }
    }

    @Override
    public IGridAssert<Line, IGrid<Line>, ?> is() {
        return new IGridAssert(this);
    }

    protected void validateColumnIndex(int colNum) {
        if (colNum < 1) {
            throw Exceptions.runtimeException("Columns numeration starts from 1 (but requested index is %s)", colNum);
        }
    }

    protected void validateRowIndex(int rowNum) {
        if (rowNum < 1) {
            throw Exceptions.runtimeException("Rows numeration starts from 1 (but requested index is %s)", rowNum);
        }
    }

    protected synchronized void validateColumns() {
        if (this.columnsValidated) {
            return;
        }
        try {
            WebList header = this.headerUI();
            WebSettings.logger.debug("Start column validation", new Object[0]);
            List<WebElement> visibleHeader = header.getAll(new Object[0]);
            List<WebElement> fullHeader = header.getWebElements(new Object[0]);
            if (visibleHeader.size() < fullHeader.size()) {
                this.columnsMapping = new ArrayList<Integer>();
                int j = 0;
                String visibleValue = visibleHeader.get(j++).getText();
                int i = 0;
                while (i < fullHeader.size()) {
                    String fullValue = fullHeader.get(i).getText();
                    if (fullValue.equals(visibleValue)) {
                        WebSettings.logger.debug("Column '%s' is %d (text is '%s')", visibleValue, i + 1, fullValue);
                        this.columnsMapping.add(i + 1);
                        if (j < visibleHeader.size()) {
                            visibleValue = visibleHeader.get(j++).getText();
                        }
                    }
                    ++i;
                }
                WebSettings.logger.debug("Columns mapping is %s", this.columnsMapping.toString());
            } else {
                WebSettings.logger.debug("Columns mapping is not required", new Object[0]);
            }
            this.columnsValidated = true;
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Column validation failed. Please correct header locator or just setup correct 'columnsMapping' in @JTable", new Object[0]);
        }
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int index) {
        this.startIndex = index;
    }
}

