/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.complex.table.matchers;

import com.epam.jdi.light.elements.complex.table.Column;
import com.epam.jdi.light.elements.complex.table.matchers.ColumnMatcher;
import com.epam.jdi.light.elements.complex.table.matchers.TableMatcherSettings;
import java.text.MessageFormat;

public class ValueMatcher {
    protected String locator;
    protected String name;

    public static ValueMatcher hasValue(String value) {
        return new ValueMatcher(MessageFormat.format(TableMatcherSettings.SINGLE_HAS_VALUE_TEMPLATE, TableMatcherSettings.quotesEscape(value)), "has '" + value + "'");
    }

    public static ValueMatcher containsValue(String value) {
        return new ValueMatcher(MessageFormat.format(TableMatcherSettings.SINGLE_CONTAINS_VALUE_TEMPLATE, TableMatcherSettings.quotesEscape(value)), "contains '" + value + "'");
    }

    public ValueMatcher(String locator, String name) {
        this.locator = locator;
        this.name = name;
    }

    public ColumnMatcher toTableMatcher(Column column) {
        return new ColumnMatcher(this.locator, column, this.name);
    }

    public String toString() {
        return this.name;
    }
}

