/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.init.entities.collection;

import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.elements.base.UIListBase;
import com.epam.jdi.light.elements.common.UIElement;
import com.epam.jdi.light.elements.complex.WebList;
import com.epam.jdi.light.elements.composite.WebPage;
import com.epam.jdi.light.elements.init.UIFactory;
import com.epam.jdi.light.elements.interfaces.base.IBaseElement;
import com.epam.jdi.light.elements.interfaces.base.ICoreElement;
import com.epam.jdi.light.settings.WebSettings;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jdiai.tools.JsonUtils;
import com.jdiai.tools.LinqUtils;
import com.jdiai.tools.PrintUtils;
import com.jdiai.tools.PropertyReader;
import com.jdiai.tools.ReflectionUtils;
import com.jdiai.tools.Safe;
import com.jdiai.tools.map.MapArray;
import com.jdiai.tools.pairs.Pair;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntitiesCollection {
    public static Safe<MapArray<String, WebPage>> PAGES = new Safe(MapArray::new);
    public static Safe<MapArray<String, List<Object>>> ELEMENTS = new Safe(MapArray::new);
    static MapArray<String, String> jsonPages;
    static MapArray<String, String> jsonElements;

    private EntitiesCollection() {
    }

    public static void addPage(WebPage page) {
        ((MapArray)PAGES.get()).update((Object)page.getName(), (Object)page);
    }

    public static void updatePage(WebPage page) {
        String className = page.getClass().getSimpleName();
        if (((MapArray)PAGES.get()).keys().contains(className)) {
            ((MapArray)PAGES.get()).removeByKey((Object)className);
        }
        ((MapArray)PAGES.get()).update((Object)page.getName(), (Object)page);
    }

    static void readPagesFromJson() {
        jsonPages = JsonUtils.getMapFromJson((String)"pages", (String)"json.page.objects");
    }

    public static WebPage getPage(String pageName) {
        WebSettings.init();
        WebPage page = (WebPage)((MapArray)PAGES.get()).get((Object)pageName);
        if (page == null) {
            page = (WebPage)((MapArray)PAGES.get()).get((Object)(String.valueOf(pageName) + " Page"));
        }
        if (page == null) {
            if (jsonPages == null) {
                EntitiesCollection.readPagesFromJson();
            }
            if (jsonPages == null) {
                throw Exceptions.runtimeException("Can't find page with name %s. Available pages: %s", pageName, PrintUtils.print((Collection)((MapArray)PAGES.get()).keys()));
            }
            page = new WebPage((String)jsonPages.get((Object)pageName));
        }
        return page;
    }

    public static WebPage getPageByUrl(String url) {
        Pair result = ((MapArray)PAGES.get()).first((k, v) -> v.isOnPage(url));
        return result != null ? (WebPage)result.value : null;
    }

    public static void addElement(Object jdi) {
        if (ReflectionUtils.isInterface(jdi.getClass(), ICoreElement.class)) {
            ICoreElement element = (ICoreElement)jdi;
            String name = element.getName();
            if (((MapArray)ELEMENTS.get()).has((Object)name)) {
                ((List)((MapArray)ELEMENTS.get()).get((Object)name)).add(jdi);
            } else {
                ArrayList<ICoreElement> newList = new ArrayList<ICoreElement>();
                newList.add(element);
                ((MapArray)ELEMENTS.get()).add((Object)name, newList);
            }
        }
    }

    public static <T extends UIListBase<?>> WebList getList(String name, Class<T> type) {
        Object element = EntitiesCollection.getElement(name);
        if (element != null) {
            if (ReflectionUtils.isClass(element.getClass(), type)) {
                return ((UIListBase)element).list();
            }
            if (ReflectionUtils.isClass(element.getClass(), WebList.class)) {
                return (WebList)element;
            }
        }
        throw Exceptions.runtimeException("Can't cast element '%s' to '%s'", name, type.getSimpleName());
    }

    public static <T> T getUI(String name, Class<T> type) {
        Object element = EntitiesCollection.getElement(name);
        if (element != null && ReflectionUtils.isClass(element.getClass(), type)) {
            return (T)element;
        }
        throw Exceptions.runtimeException("Can't cast element '%s' to '%s'", name, type.getSimpleName());
    }

    public static <T> T getByType(ICoreElement element, Class<T> type) {
        try {
            ICoreElement core = ReflectionUtils.isClass(element.getClass(), type) ? element : element.core();
            return (T)core;
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Can't get element '%s' of type '%s'", element.getName(), type.getSimpleName());
        }
    }

    public static ICoreElement getUI(String name) {
        Object element = EntitiesCollection.getElement(name);
        if (element != null && ReflectionUtils.isInterface(element.getClass(), ICoreElement.class)) {
            return (ICoreElement)element;
        }
        throw Exceptions.runtimeException("Can't find '%s' element", name);
    }

    static void readElementsFromJson() {
        List filePaths = JsonUtils.scanFolder((String)("src/test/resources" + PropertyReader.getProperty((String)"json.page.objects")));
        jsonElements = new MapArray();
        for (String filePath : filePaths) {
            try {
                jsonElements.addAll((Map)new ObjectMapper().readValue(new File(filePath), HashMap.class));
            }
            catch (IOException iOException) {
                throw new RuntimeException("Can't read elements from json");
            }
        }
    }

    static Object getElement(String name) {
        if (!name.matches("[A-Z].*")) {
            return UIFactory.$(name);
        }
        String[] split = name.split("\\.");
        if (split.length == 2) {
            return EntitiesCollection.getElementInSection(split[1], split[0]);
        }
        if (((MapArray)ELEMENTS.get()).has((Object)name)) {
            Object element;
            List elements = (List)((MapArray)ELEMENTS.get()).get((Object)name);
            if (((MapArray)ELEMENTS.get()).size() > 1 && (element = LinqUtils.first((Collection)elements, el -> {
                WebPage page = ((ICoreElement)el).base().getPage();
                if (page != null && page.getName().equals(WebPage.getCurrentPage())) {
                    return true;
                }
                return false;
            })) != null) {
                return element;
            }
            return ((List)((MapArray)ELEMENTS.get()).get((Object)name)).get(0);
        }
        if (jsonElements == null) {
            EntitiesCollection.readElementsFromJson();
        }
        return jsonElements.keys().contains(name) ? UIFactory.$((String)jsonElements.get((Object)name)) : new UIElement().setName(name);
    }

    static Object getElementInSection(String name, String section) {
        if (((MapArray)ELEMENTS.get()).has((Object)name)) {
            List els = (List)((MapArray)ELEMENTS.get()).get((Object)name);
            Object result = LinqUtils.first((Collection)els, el -> ReflectionUtils.isInterface(el.getClass(), IBaseElement.class) && ((IBaseElement)el).base().hasParent(section));
            if (result == null) {
                throw Exceptions.runtimeException("Can't find '%s' element at '%s'", name, section);
            }
            return result;
        }
        throw Exceptions.runtimeException("Can't find '%s' element", name);
    }
}

