/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.elements.pageobjects.annotations;

import com.epam.jdi.light.driver.WebDriverByUtils;
import com.epam.jdi.light.elements.pageobjects.annotations.FindBy;
import com.epam.jdi.light.elements.pageobjects.annotations.Frame;
import com.epam.jdi.light.elements.pageobjects.annotations.JSite;
import com.epam.jdi.light.elements.pageobjects.annotations.Name;
import com.epam.jdi.light.elements.pageobjects.annotations.locators.ByText;
import com.epam.jdi.light.elements.pageobjects.annotations.locators.Css;
import com.epam.jdi.light.elements.pageobjects.annotations.locators.UI;
import com.epam.jdi.light.elements.pageobjects.annotations.locators.WithText;
import com.epam.jdi.light.elements.pageobjects.annotations.locators.XPath;
import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.light.settings.WebSettings;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.support.How;

public class WebAnnotationsUtil {
    public static boolean hasAnnotation(Field field, Class<? extends Annotation> annotation) {
        return field.isAnnotationPresent(annotation) || field.getType().isAnnotationPresent(annotation);
    }

    public static <T extends Annotation> T getAnnotation(Field field, Class<T> annotation) {
        T result = field.getAnnotation(annotation);
        return result == null ? field.getType().getAnnotation(annotation) : result;
    }

    public static String getElementName(Field field) {
        if (WebAnnotationsUtil.hasAnnotation(field, Name.class)) {
            return field.getAnnotation(Name.class).value();
        }
        if (field.getType().isAnnotationPresent(Name.class)) {
            return field.getType().getAnnotation(Name.class).value();
        }
        return (String)JDISettings.ELEMENT.name.execute((Object)field);
    }

    public static void setDomain(Class<?> siteClass) {
        if (siteClass != null) {
            String siteDomain;
            JDISettings.COMMON.applicationName = siteClass.getSimpleName();
            if (siteClass.isAnnotationPresent(JSite.class) && !StringUtils.isBlank((CharSequence)(siteDomain = siteClass.getAnnotation(JSite.class).value()))) {
                WebSettings.setDomain(siteDomain);
            }
        }
    }

    public static String getUrlFromUri(String uri) {
        if (StringUtils.isBlank((CharSequence)uri)) {
            return WebSettings.getDomain();
        }
        return String.valueOf(WebSettings.getDomain().replaceAll("/*$", "")) + "/" + uri.replaceAll("^/*", "");
    }

    public static List<By> getFrames(Frame frames) {
        if (frames == null) {
            return null;
        }
        ArrayList<By> result = new ArrayList<By>();
        String[] stringArray = frames.value();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String frame = stringArray[n2];
            result.add((By)WebDriverByUtils.NAME_TO_LOCATOR.execute((Object)frame));
            ++n2;
        }
        return result;
    }

    public static By findByToBy(org.openqa.selenium.support.FindBy locator) {
        if (locator == null) {
            return null;
        }
        if (!locator.id().isEmpty()) {
            return By.id((String)locator.id());
        }
        if (!locator.className().isEmpty()) {
            return By.className((String)locator.className());
        }
        if (!locator.xpath().isEmpty()) {
            return By.xpath((String)locator.xpath());
        }
        if (!locator.css().isEmpty()) {
            return By.cssSelector((String)locator.css());
        }
        if (!locator.linkText().isEmpty()) {
            return By.linkText((String)locator.linkText());
        }
        if (!locator.name().isEmpty()) {
            return By.name((String)locator.name());
        }
        if (!locator.partialLinkText().isEmpty()) {
            return By.partialLinkText((String)locator.partialLinkText());
        }
        if (!locator.tagName().isEmpty()) {
            return By.tagName((String)locator.tagName());
        }
        if (locator.how() != How.UNSET) {
            return WebAnnotationsUtil.getHowLocator(locator);
        }
        return null;
    }

    private static By getHowLocator(org.openqa.selenium.support.FindBy locator) {
        if (locator.how() == How.ID) {
            return By.id((String)locator.using());
        }
        if (locator.how() == How.CLASS_NAME) {
            return By.className((String)locator.using());
        }
        if (locator.how() == How.XPATH) {
            return By.xpath((String)locator.using());
        }
        if (locator.how() == How.CSS) {
            return By.cssSelector((String)locator.using());
        }
        if (locator.how() == How.LINK_TEXT) {
            return By.linkText((String)locator.using());
        }
        if (locator.how() == How.NAME) {
            return By.name((String)locator.using());
        }
        if (locator.how() == How.PARTIAL_LINK_TEXT) {
            return By.partialLinkText((String)locator.using());
        }
        if (locator.how() == How.TAG_NAME) {
            return By.tagName((String)locator.using());
        }
        return null;
    }

    public static By findByToBy(FindBy locator) {
        if (locator == null) {
            return null;
        }
        if (!"".equals(locator.xpath())) {
            return By.xpath((String)locator.xpath());
        }
        if (!"".equals(locator.css())) {
            return By.cssSelector((String)locator.css());
        }
        if (!"".equals(locator.linkText())) {
            return By.linkText((String)locator.linkText());
        }
        if (!"".equals(locator.partialLinkText())) {
            return By.partialLinkText((String)locator.partialLinkText());
        }
        if (!"".equals(locator.tagName())) {
            return By.tagName((String)locator.tagName());
        }
        if (!"".equals(locator.text())) {
            return WebDriverByUtils.byText(locator.text());
        }
        if (!"".equals(locator.containsText())) {
            return WebDriverByUtils.withText(locator.containsText());
        }
        if (!"".equals(locator.id())) {
            return By.id((String)locator.id());
        }
        if (!"".equals(locator.className())) {
            return By.className((String)locator.className());
        }
        if (!"".equals(locator.name())) {
            return By.name((String)locator.name());
        }
        return null;
    }

    public static By findByToBy(Css locator) {
        if (locator == null) {
            return null;
        }
        return By.cssSelector((String)locator.value());
    }

    public static By findByToBy(XPath locator) {
        if (locator == null) {
            return null;
        }
        return By.xpath((String)locator.value());
    }

    public static By findByToBy(UI locator) {
        if (locator == null) {
            return null;
        }
        return (By)WebDriverByUtils.NAME_TO_LOCATOR.execute((Object)locator.value());
    }

    public static By findByToBy(ByText locator) {
        if (locator == null) {
            return null;
        }
        return WebDriverByUtils.byText(locator.value());
    }

    public static By findByToBy(WithText locator) {
        if (locator == null) {
            return null;
        }
        return WebDriverByUtils.withText(locator.value());
    }
}

