/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.logger;

import com.epam.jdi.light.actions.ActionObject;
import com.epam.jdi.light.actions.ActionProcessor;
import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.driver.ScreenshotMaker;
import com.epam.jdi.light.driver.WebDriverFactory;
import com.epam.jdi.light.elements.common.Alerts;
import com.epam.jdi.light.elements.common.UIElement;
import com.epam.jdi.light.elements.init.UIFactory;
import com.epam.jdi.light.elements.interfaces.base.ICoreElement;
import com.epam.jdi.light.logger.AllureLogData;
import com.epam.jdi.light.logger.AllureLogger$AjcClosure1;
import com.epam.jdi.light.logger.AttachmentStrategy;
import com.epam.jdi.light.logger.Strategy;
import com.epam.jdi.light.settings.JDISettings;
import com.jdiai.tools.JsonUtils;
import com.jdiai.tools.LinqUtils;
import com.jdiai.tools.PrintUtils;
import com.jdiai.tools.ReflectionUtils;
import com.jdiai.tools.Timer;
import com.jdiai.tools.func.JFunc1;
import io.qameta.allure.Allure;
import io.qameta.allure.aspects.StepsAspects;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StepResult;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.logging.LogEntry;

public class AllureLogger {
    public static AttachmentStrategy HTML_CODE_LOGGING;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        AllureLogger.ajc$preClinit();
        HTML_CODE_LOGGING = AttachmentStrategy.ON_FAIL;
    }

    public static void screenshotStep(String screenName) {
        String detailsUUID = AllureLogger.startStep(screenName);
        AllureLogger.createScreenAttachment(screenName);
        StepsAspects.getLifecycle().stopStep(detailsUUID);
    }

    public static void infoStep() {
        AllureLogger.infoStep("Step info");
    }

    public static void infoStep(String stepName) {
        AllureLogger.infoStep(stepName, true, false, true, false);
    }

    public static void infoStep(String stepName, boolean screenshot, boolean pageSource, boolean htmlErrors, boolean video) {
        String detailsUUID = AllureLogger.startStep(stepName);
        try {
            if (screenshot) {
                AllureLogger.attachScreenshot();
            }
            if (pageSource) {
                AllureLogger.attachPageSource();
            }
            if (htmlErrors) {
                AllureLogger.attachHttpErrors();
            }
            if (video) {
                AllureLogger.attachVideo(JDISettings.DRIVER.videoUrl);
            }
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Failed to add attachments to Allure step", new Object[0]);
        }
        StepsAspects.getLifecycle().stopStep(detailsUUID);
    }

    public static void attachScreenshotStep(ICoreElement element) {
        AllureLogger.attachScreenshotStep(element.getName(), element.core());
    }

    public static void attachScreenshotStep(String stepName, WebElement element) {
        String detailsUUID = AllureLogger.startStep(stepName);
        try {
            UIElement uiElement = ReflectionUtils.isInterface(element.getClass(), ICoreElement.class) ? ((ICoreElement)element).core() : UIFactory.$(element);
            File elementScreen = uiElement.makePhoto();
            AllureLogger.attachScreenshot("Screenshot", elementScreen.getAbsolutePath());
        }
        catch (Exception ex) {
            AllureLogger.attachText("Screenshot failed", "text/plain", ex.getMessage());
        }
        StepsAspects.getLifecycle().stopStep(detailsUUID);
    }

    public static void attachScreenshotStep(String stepName) {
        String detailsUUID = AllureLogger.startStep(stepName);
        try {
            String screenPath = AllureLogger.makeScreenshot("After test");
            AllureLogger.attachScreenshot("Screenshot", screenPath);
        }
        catch (Exception ex) {
            AllureLogger.attachText("Screenshot failed", "text/plain", ex.getMessage());
        }
        StepsAspects.getLifecycle().stopStep(detailsUUID);
    }

    private static void attachScreenshot() {
        try {
            String screenPath = AllureLogger.makeScreenshot("After test");
            AllureLogger.attachScreenshot("Screenshot", screenPath);
        }
        catch (Exception ex) {
            AllureLogger.attachText("Screenshot failed", "text/plain", ex.getMessage());
        }
    }

    public static void attachPageSourceStep(String stepName) {
        String detailsUUID = AllureLogger.startStep(stepName);
        AllureLogger.attachPageSource();
        StepsAspects.getLifecycle().stopStep(detailsUUID);
    }

    private static void attachPageSource() {
        try {
            String htmlCode = WebDriverFactory.getDriver().getPageSource();
            AllureLogger.attachText("HTML Code", "text/html", htmlCode);
        }
        catch (Exception ex) {
            AllureLogger.attachText("HTML Code failed", "text/plain", ex.getMessage());
        }
    }

    public static void attachElementHtmlStep(ICoreElement element) {
        AllureLogger.attachElementHtmlStep(element.getName(), element.core());
    }

    public static void attachElementHtmlStep(String stepName, WebElement element) {
        String detailsUUID = AllureLogger.startStep(stepName);
        try {
            UIElement uiElement;
            UIElement uIElement = uiElement = ReflectionUtils.isInterface(element.getClass(), ICoreElement.class) ? ((ICoreElement)element).core() : UIFactory.$(element);
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, (Object)uIElement);
            Object[] objectArray = new Object[]{uIElement, joinPoint};
            AllureLogger$AjcClosure1 allureLogger$AjcClosure1 = new AllureLogger$AjcClosure1(objectArray);
            String html = (String)ActionProcessor.aspectOf().jdiAround(allureLogger$AjcClosure1.linkClosureAndJoinPoint(16));
            AllureLogger.attachText("HTML Code", "text/html", html);
        }
        catch (Exception ex) {
            AllureLogger.attachText("Screenshot failed", "text/plain", ex.getMessage());
        }
        StepsAspects.getLifecycle().stopStep(detailsUUID);
    }

    public static void attachHttpErrorsStep(String stepName) {
        String detailsUUID = AllureLogger.startStep(stepName);
        AllureLogger.attachHttpErrors();
        StepsAspects.getLifecycle().stopStep(detailsUUID);
    }

    private static void attachHttpErrors() {
        try {
            String httpErrors = AllureLogger.getHtmlErrors();
            AllureLogger.attachText("HTTP Errors", "text/plain", httpErrors);
        }
        catch (Exception ex) {
            AllureLogger.attachText("HTTP Errors failed", "text/plain", ex.getMessage());
        }
    }

    public static void attachVideoStep(String stepName) {
        AllureLogger.attachVideoStep(stepName, JDISettings.DRIVER.videoUrl);
    }

    public static void attachVideoStep(String stepName, String videoUrl) {
        String detailsUUID = AllureLogger.startStep(stepName);
        AllureLogger.attachVideo(videoUrl);
        StepsAspects.getLifecycle().stopStep(detailsUUID);
    }

    private static void attachVideo(String videoUrl) {
        Allure.addAttachment((String)"Video", (String)"text/html", (String)AllureLogger.htmlVideo(videoUrl), (String)".html");
    }

    private static String htmlVideo(String url) {
        return "<html><body><video width='100%' height='100%' controls autoplay><source src='" + url + "' type='video/mp4'></video></body></html>";
    }

    public static void createScreenAttachment(String screenName) {
        String screenPath = AllureLogger.makeScreenshot(screenName);
        if (StringUtils.isNotBlank((CharSequence)screenPath)) {
            try {
                AllureLogger.attachScreenshot("Page screenshot", screenPath);
            }
            catch (IOException ex) {
                throw Exceptions.exception(ex, "", new Object[0]);
            }
        }
    }

    public static String startStep(String message) {
        if (!JDISettings.LOGS.writeToAllure) {
            return "";
        }
        try {
            StepResult step = new StepResult().setName(message);
            if (StepsAspects.getLifecycle().getCurrentTestCase().isPresent()) {
                String uuid = UUID.randomUUID().toString();
                StepsAspects.getLifecycle().startStep(uuid, step);
                return uuid;
            }
        }
        catch (Exception exception) {
        }
        return "";
    }

    public static AllureLogData logDataToAllure(Strategy expectedStrategy, String screenName, boolean isAssert) {
        String screenPath = "";
        String htmlSnapshot = "";
        String errors = "";
        if (JDISettings.LOGS.screenStrategy.contains((Object)expectedStrategy)) {
            screenPath = AllureLogger.makeScreenshot(screenName, isAssert);
        }
        if (JDISettings.LOGS.htmlCodeStrategy.contains((Object)expectedStrategy)) {
            htmlSnapshot = AllureLogger.getHtmlCode();
        }
        if (JDISettings.LOGS.requestsStrategy.contains((Object)expectedStrategy)) {
            errors = AllureLogger.getHtmlErrors();
        }
        return new AllureLogData(screenPath, htmlSnapshot, errors);
    }

    public static void attachDataToStep(String screenPath, String htmlSnapshot, String requests) {
        AllureLogger.attachDataToStep(new AllureLogData(screenPath, htmlSnapshot, requests));
    }

    public static void attachDataStep(String stepName, String screenPath, String htmlSnapshot, String requests) {
        AllureLogger.attachDataStep(stepName, new AllureLogData(screenPath, htmlSnapshot, requests));
    }

    public static void attachDataStep(String stepName, AllureLogData ld) {
        String detailsUUID = AllureLogger.startStep(stepName);
        AllureLogger.attachDataToStep(ld);
        StepsAspects.getLifecycle().stopStep(detailsUUID);
    }

    public static void attachDataToStep(AllureLogData ld) {
        try {
            if (StringUtils.isNotBlank((CharSequence)ld.screenPath)) {
                AllureLogger.attachScreenshot("Screenshot", ld.screenPath);
            }
            if (StringUtils.isNotBlank((CharSequence)ld.htmlSnapshot)) {
                AllureLogger.attachText("HTML Code Snapshot", "text/html", ld.htmlSnapshot);
            }
            if (StringUtils.isNotBlank((CharSequence)ld.requests)) {
                AllureLogger.attachText("HTTP Requests", "text/plain", ld.requests);
            }
        }
        catch (Exception ex) {
            throw Exceptions.exception(ex, "Failed to add attachments to Allure step", new Object[0]);
        }
    }

    public static void failStep(String uuid, AllureLogData ld) {
        if (!JDISettings.LOGS.writeToAllure || StringUtils.isBlank((CharSequence)uuid)) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)ld.screenPath) || StringUtils.isNotBlank((CharSequence)ld.htmlSnapshot) || StringUtils.isNotBlank((CharSequence)ld.requests)) {
            String detailsUUID = AllureLogger.startStep("Failure details");
            try {
                AllureLogger.attachDataToStep(ld);
            }
            finally {
                StepsAspects.getLifecycle().stopStep(detailsUUID);
            }
        }
    }

    public static void passStep(String uuid) {
        if (!JDISettings.LOGS.writeToAllure || StringUtils.isBlank((CharSequence)uuid)) {
            return;
        }
        StepsAspects.getLifecycle().updateStep(uuid, s -> {
            StepResult stepResult = s.setStatus(Status.PASSED);
        });
        StepsAspects.getLifecycle().stopStep(uuid);
    }

    public static void attachText(String name, String type, String htmlSnapshot) {
        Allure.addAttachment((String)name, (String)type, (String)htmlSnapshot, (String)"html");
    }

    public static void attachScreenshot(String attachName, String screenName) throws IOException {
        Allure.addAttachment((String)attachName, (InputStream)new ByteArrayInputStream(Files.readAllBytes(Paths.get(screenName, new String[0]))));
    }

    public static String getHtmlCode() {
        if (HTML_CODE_LOGGING == AttachmentStrategy.OFF) {
            return null;
        }
        return WebDriverFactory.getDriver().getPageSource();
    }

    public static String makeScreenshot(String screenName) {
        return AllureLogger.makeScreenshot(screenName, false);
    }

    public static String makeScreenshot(String screenName, ActionObject jInfo) {
        return AllureLogger.makeScreenshot(screenName, ReflectionUtils.isClass(jInfo.jpClass(), Alerts.class));
    }

    public static String makeScreenshot(String screenName, boolean isAssert) {
        try {
            Timer.sleep((long)200L);
            return JDISettings.SCREEN.tool.equalsIgnoreCase("robot") || isAssert ? ScreenshotMaker.takeRobotScreenshot(screenName) : ScreenshotMaker.takeScreen(screenName);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getHtmlErrors() {
        return AllureLogger.getHtmlErrors(JDISettings.LOGS.filterHttpRequests);
    }

    public static String getHtmlErrors(JFunc1<LogEntry, Boolean> filterHttpRequests) {
        List requests = WebDriverFactory.getDriver().manage().logs().get("performance").getAll();
        List errorEntries = LinqUtils.map((Collection)LinqUtils.filter((Collection)requests, filterHttpRequests), logEntry -> JsonUtils.beautifyJson((String)logEntry.getMessage()));
        return PrintUtils.print((Collection)errorEntries);
    }

    static final /* synthetic */ String printHtml_aroundBody0(UIElement uIElement, JoinPoint joinPoint) {
        return uIElement.printHtml();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AllureLogger.java", AllureLogger.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "printHtml", "com.epam.jdi.light.elements.common.UIElement", "", "", "", "java.lang.String"), 136);
    }
}

