/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.logger;

import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.driver.WebDriverFactory;
import com.epam.jdi.light.logger.ILogger;
import com.epam.jdi.light.logger.LogLevels;
import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.light.settings.WebSettings;
import com.jdiai.tools.FixedQueue;
import com.jdiai.tools.PrintUtils;
import com.jdiai.tools.Safe;
import com.jdiai.tools.func.JAction;
import com.jdiai.tools.func.JFunc;
import com.jdiai.tools.func.JFunc1;
import com.jdiai.tools.map.MapArray;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.config.Configurator;

public class JDILogger
implements ILogger {
    private static MapArray<String, JDILogger> loggers = new MapArray();
    private static Marker jdiMarker = MarkerManager.getMarker((String)"JDI");
    public static int debugBufferSize = 0;
    public Safe<FixedQueue<String>> debugLog = new Safe(() -> new FixedQueue(debugBufferSize));
    private String name;
    public static JFunc1<String, Logger> GET_LOGGER = LogManager::getLogger;
    private Logger logger;
    private Safe<LogLevels> logLevel = new Safe((Object)LogLevels.INFO);
    private Safe<Integer> logOffDeepness = new Safe((Object)0);

    public static JDILogger instance(String name) {
        if (!loggers.has((Object)name)) {
            loggers.add((Object)name, (Object)new JDILogger(name));
        }
        return (JDILogger)loggers.get((Object)name);
    }

    public JDILogger() {
        this("JDI");
    }

    public JDILogger(String name) {
        this.logger = (Logger)GET_LOGGER.execute((Object)name);
        this.name = name;
        this.setLogLevel(this.initialLogLevel());
    }

    public JDILogger(Class<?> clazz) {
        this(clazz.getSimpleName());
    }

    @Override
    public LogLevels getLogLevel() {
        return (LogLevels)((Object)this.logLevel.get());
    }

    private LogLevels initialLogLevel() {
        Properties properties = WebSettings.getProperties(JDISettings.COMMON.testPropertiesPath);
        String logLevelProp = properties.getProperty("log.level");
        return StringUtils.isNotBlank((CharSequence)logLevelProp) ? LogLevels.parseLogLevel(logLevelProp) : LogLevels.INFO;
    }

    @Override
    public void setLogLevel(LogLevels level) {
        this.logLevel = new Safe((Object)level);
        Configurator.setRootLevel((Level)LogLevels.getLog4j2Level(level));
        Configurator.setLevel((String)this.name, (Level)LogLevels.getLog4j2Level(level));
    }

    public void logOff() {
        this.logLevel.set((Object)LogLevels.OFF);
        this.logOffDeepness.update(v -> v + 1);
    }

    public void logOn() {
        this.logOffDeepness.update(v -> v - 1);
        if ((Integer)this.logOffDeepness.get() > 0) {
            return;
        }
        if ((Integer)this.logOffDeepness.get() == 0) {
            this.logLevel.reset();
        }
        if ((Integer)this.logOffDeepness.get() < 0) {
            throw new RuntimeException("Log Off Deepness to high. Please check that each logOff has appropriate logOn");
        }
    }

    public void dropLogOff() {
        this.logOffDeepness.set((Object)0);
        this.logLevel.reset();
    }

    public void logOff(JAction action) {
        this.logOff(() -> {
            action.invoke();
            return null;
        });
    }

    @Override
    public <T> T logOff(JFunc<T> func) {
        LogLevels tempLevel = (LogLevels)((Object)this.logLevel.get());
        if (this.logLevel.get() == LogLevels.TRACE) {
            try {
                return (T)func.invoke();
            }
            catch (Throwable ex) {
                throw Exceptions.exception(ex, "", new Object[0]);
            }
        }
        this.logLevel.set((Object)LogLevels.TRACE);
        try {
            Object object = func.invoke();
            return (T)object;
        }
        catch (Throwable ex) {
            throw Exceptions.exception(ex, "", new Object[0]);
        }
        finally {
            this.logLevel.set((Object)tempLevel);
        }
    }

    private String getRecord(String record, Object ... args) {
        String prefix = WebDriverFactory.MULTI_THREAD ? "[" + Thread.currentThread().getId() + "] " : "";
        return com.jdiai.tools.StringUtils.format((String)(String.valueOf(prefix) + record), (Object[])args);
    }

    public void throwDebugInfo() {
        if (debugBufferSize == 0) {
            return;
        }
        String prefix = WebDriverFactory.MULTI_THREAD ? "[" + Thread.currentThread().getId() + "] " : "";
        this.logger.error(jdiMarker, String.valueOf(prefix) + "DEBUG INFO: " + com.jdiai.tools.StringUtils.LINE_BREAK + PrintUtils.print((Collection)((FixedQueue)this.debugLog.get()).values(), (String)com.jdiai.tools.StringUtils.LINE_BREAK));
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void step(String s, Object ... args) {
        ((FixedQueue)this.debugLog.get()).push((Object)com.jdiai.tools.StringUtils.format((String)s, (Object[])args));
        if (((LogLevels)((Object)this.logLevel.get())).equalOrLessThan(LogLevels.STEP)) {
            this.logger.log(Level.forName((String)"STEP", (int)350), jdiMarker, this.getRecord(s, args));
        }
    }

    @Override
    public void trace(String s, Object ... args) {
        ((FixedQueue)this.debugLog.get()).push((Object)com.jdiai.tools.StringUtils.format((String)s, (Object[])args));
        if (((LogLevels)((Object)this.logLevel.get())).equalOrLessThan(LogLevels.TRACE)) {
            this.logger.trace(jdiMarker, this.getRecord(s, args));
        }
    }

    @Override
    public void debug(String s, Object ... args) {
        ((FixedQueue)this.debugLog.get()).push((Object)com.jdiai.tools.StringUtils.format((String)s, (Object[])args));
        if (((LogLevels)((Object)this.logLevel.get())).equalOrLessThan(LogLevels.DEBUG)) {
            this.logger.debug(jdiMarker, this.getRecord(s, args));
        }
    }

    @Override
    public void info(String s, Object ... args) {
        ((FixedQueue)this.debugLog.get()).push((Object)com.jdiai.tools.StringUtils.format((String)s, (Object[])args));
        if (((LogLevels)((Object)this.logLevel.get())).equalOrLessThan(LogLevels.INFO)) {
            this.logger.info(jdiMarker, this.getRecord(s, args));
        }
    }

    @Override
    public void error(String s, Object ... args) {
        ((FixedQueue)this.debugLog.get()).push((Object)com.jdiai.tools.StringUtils.format((String)s, (Object[])args));
        this.logger.error(jdiMarker, this.getRecord(s, args));
    }

    @Override
    public void toLog(String msg) {
        this.toLog(msg, (LogLevels)((Object)this.logLevel.getDefault()));
    }

    @Override
    public void toLog(String msg, LogLevels level) {
        block9: {
            block8: {
                if (!((LogLevels)((Object)this.logLevel.get())).equalOrLessThan(level)) break block8;
                switch (level) {
                    case ERROR: {
                        this.error(msg, new Object[0]);
                        break block9;
                    }
                    case STEP: {
                        this.step(msg, new Object[0]);
                        break block9;
                    }
                    case INFO: {
                        this.info(msg, new Object[0]);
                        break block9;
                    }
                    case DEBUG: {
                        this.debug(msg, new Object[0]);
                        break block9;
                    }
                    case TRACE: {
                        this.trace(msg, new Object[0]);
                        break block9;
                    }
                    case OFF: {
                        break block9;
                    }
                    default: {
                        throw new RuntimeException("Unknown log level: " + (Object)((Object)level));
                    }
                }
            }
            ((FixedQueue)this.debugLog.get()).push((Object)msg);
        }
    }
}

