/*
 * Decompiled with CFR 0.152.
 */
package com.epam.jdi.light.settings;

import com.epam.jdi.light.actions.ActionHelper;
import com.epam.jdi.light.asserts.core.SoftAssert;
import com.epam.jdi.light.common.ElementArea;
import com.epam.jdi.light.common.Exceptions;
import com.epam.jdi.light.common.NameToLocator;
import com.epam.jdi.light.common.PageChecks;
import com.epam.jdi.light.common.SearchStrategies;
import com.epam.jdi.light.common.SearchTypes;
import com.epam.jdi.light.common.SetTextTypes;
import com.epam.jdi.light.common.TextTypes;
import com.epam.jdi.light.common.Timeout;
import com.epam.jdi.light.common.UseSmartSearch;
import com.epam.jdi.light.common.VisualCheckAction;
import com.epam.jdi.light.common.VisualCheckPage;
import com.epam.jdi.light.driver.WebDriverByUtils;
import com.epam.jdi.light.driver.WebDriverFactory;
import com.epam.jdi.light.driver.get.DriverTypes;
import com.epam.jdi.light.driver.get.RemoteDriverInfo;
import com.epam.jdi.light.driver.sauce.SauceSettings;
import com.epam.jdi.light.elements.base.JdiSettings;
import com.epam.jdi.light.elements.interfaces.base.IBaseElement;
import com.epam.jdi.light.elements.interfaces.composite.PageObject;
import com.epam.jdi.light.logger.HighlightStrategy;
import com.epam.jdi.light.logger.ILogger;
import com.epam.jdi.light.logger.JDILogger;
import com.epam.jdi.light.logger.LogLevels;
import com.epam.jdi.light.logger.Strategy;
import com.epam.jdi.light.settings.JDISettings;
import com.epam.jdi.light.settings.LogInfoDetails;
import com.epam.jdi.light.settings.Strategies;
import com.jdiai.tools.EnumUtils;
import com.jdiai.tools.LinqUtils;
import com.jdiai.tools.PathUtils;
import com.jdiai.tools.PrintUtils;
import com.jdiai.tools.PropReader;
import com.jdiai.tools.PropertyReader;
import com.jdiai.tools.ReflectionUtils;
import com.jdiai.tools.Safe;
import com.jdiai.tools.StringUtils;
import com.jdiai.tools.func.JAction;
import com.jdiai.tools.func.JAction1;
import com.jdiai.tools.func.JFunc;
import com.jdiai.tools.func.JFunc1;
import com.jdiai.tools.pairs.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import org.openqa.selenium.By;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class WebSettings {
    public static ILogger logger = JDILogger.instance("JDI");
    public static VisualCheckAction VISUAL_ACTION_STRATEGY = VisualCheckAction.NONE;
    public static VisualCheckPage VISUAL_PAGE_STRATEGY = VisualCheckPage.NONE;
    public static String TEST_GROUP = "";
    public static Safe<String> TEST_NAME = new Safe(null);
    public static JFunc1<IBaseElement, List<WebElement>> SMART_SEARCH = WebSettings::defaultSmartSearch;
    public static boolean initialized = false;
    public static JAction INIT_FUNC = WebSettings::jdiSetup;

    public static String getDomain() {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)JDISettings.DRIVER.domain)) {
            WebSettings.init();
        }
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)JDISettings.DRIVER.domain) ? JDISettings.DRIVER.domain : "";
    }

    public static void setDomain(String domain) {
        JDISettings.DRIVER.domain = domain;
    }

    public static boolean hasDomain() {
        WebSettings.init();
        return JDISettings.DRIVER.domain != null && JDISettings.DRIVER.domain.contains("://");
    }

    public static String useDriver(JFunc<WebDriver> driver) {
        return WebDriverFactory.useDriver(driver);
    }

    public static String useDriver(String driverName) {
        return WebDriverFactory.useDriver(driverName);
    }

    public static String useDriver(DriverTypes driverType) {
        return WebDriverFactory.useDriver(driverType);
    }

    public static String printSmartLocators(IBaseElement el) {
        try {
            return "smart: " + WebDriverByUtils.getByLocator((By)JDISettings.ELEMENT.smartLocator.execute((Object)el, (Object)((String)JDISettings.ELEMENT.smartLocatorName.execute((Object)el))));
        }
        catch (Exception exception) {
            return StringUtils.format((String)"Can't define smart locator(%s, %s)", (Object[])new Object[]{JDISettings.ELEMENT.smartTemplate, JDISettings.ELEMENT.smartName.key});
        }
    }

    public static List<WebElement> defaultSmartSearch(IBaseElement el) {
        switch (JDISettings.ELEMENT.useSmartSearch) {
            case FALSE: {
                return null;
            }
            case ONLY_UI: {
                if (!el.base().locator.isNull()) break;
                return null;
            }
            case UI_AND_ELEMENTS: {
                if (!el.base().locator.isNull() || !ReflectionUtils.isInterface(el.getClass(), PageObject.class)) break;
                return null;
            }
        }
        String locatorName = (String)JDISettings.ELEMENT.smartLocatorName.execute((Object)el);
        By locator = (By)JDISettings.ELEMENT.smartLocator.execute((Object)el, (Object)locatorName);
        SearchContext ctx = (SearchContext)JdiSettings.DEFAULT_CONTEXT.execute((Object)el.base().driver());
        try {
            return JDISettings.ELEMENT.smartTemplate.equals("#%s") ? ctx.findElements(locator) : JdiSettings.getWebElementsFromContext(el.base(), locator);
        }
        catch (Exception exception) {
            throw Exceptions.runtimeException("Element '%s' has no locator and Smart Search failed (%s). Please add locator to element or be sure that element can be found using Smart Search", el.getName(), WebSettings.printSmartLocators(el));
        }
    }

    private static void fillAction(JAction1<String> action, String name) {
        String prop = null;
        try {
            prop = PropertyReader.getProperty((String)name);
        }
        catch (Exception exception) {}
        logger.trace("fillAction(%s=%s)", name, prop == null ? "null" : prop);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)prop)) {
            return;
        }
        action.execute((Object)prop);
    }

    public static void jdiSetup() {
        Properties properties = WebSettings.getProperties(JDISettings.COMMON.testPropertiesPath);
        if (properties.isEmpty()) {
            JDISettings.LOGS.writeToAllure = !WebSettings.getProperties("allure.properties").isEmpty();
            JDISettings.COMMON.strategy.action.execute();
            return;
        }
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            Strategies strategies = JDISettings.COMMON.strategy = WebSettings.getStrategy(p);
        }), "strategy");
        JDISettings.COMMON.strategy.action.execute();
        if (JDISettings.DRIVER.name.equalsIgnoreCase("chrome")) {
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                String string = JDISettings.DRIVER.name = p;
            }), org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)PropertyReader.getProperty((String)"driver")) ? "driver" : "browser");
        }
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            String string = JDISettings.DRIVER.version = p;
        }), "driver.version");
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            String string = JDISettings.DRIVER.path = p;
        }), "drivers.folder");
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            String string = JDISettings.DRIVER.path = p;
        }), "drivers.path");
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            if (Boolean.parseBoolean(p)) {
                JDISettings.DRIVER.getFunc = name -> WebDriverFactory.getDriverFromName(name, WebDriverFactory.RUN_DRIVERS);
            }
        }), "single.thread");
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            Timeout timeout = JDISettings.TIMEOUTS.element = new Timeout(Integer.parseInt(p));
        }), "timeout.wait.element");
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            Timeout timeout = JDISettings.TIMEOUTS.page = new Timeout(Integer.parseInt(p));
        }), "timeout.wait.page");
        WebSettings.fillAction((JAction1<String>)((JAction1)WebSettings::setDomain), org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)PropertyReader.getProperty((String)"site.url")) ? "site.url" : "domain");
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            String string = JDISettings.SCREEN.path = p;
        }), "screens.folder");
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            String string = JDISettings.SCREEN.tool = p;
        }), "screenshot.tool");
        if (JDISettings.SCREEN.tool.equals("robot")) {
            JDISettings.SCREEN.allowRobot = true;
        }
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            boolean bl = JDISettings.SCREEN.allowRobot = Boolean.parseBoolean(p);
        }), "allow.robot");
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            int n = JDISettings.ELEMENT.startIndex = Integer.parseInt(p);
        }), "list.start.index");
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            LogInfoDetails logInfoDetails = JDISettings.LOGS.logInfoDetails = WebSettings.getInfoDetailsLevel(p);
        }), "log.info.details");
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            JDISettings.LOGS.screenStrategy = WebSettings.getActionStrategy(p);
            List<Strategy> list = JDISettings.LOGS.screenStrategy;
        }), "screenshot.strategy");
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            JDISettings.LOGS.htmlCodeStrategy = WebSettings.getActionStrategy(p);
            List<Strategy> list = JDISettings.LOGS.htmlCodeStrategy;
        }), "html.code.strategy");
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            JDISettings.LOGS.requestsStrategy = WebSettings.getActionStrategy(p);
            List<Strategy> list = JDISettings.LOGS.requestsStrategy;
        }), "requests.strategy");
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            String string = JDISettings.COMMON.killBrowser = p;
        }), "browser.kill");
        WebSettings.fillAction((JAction1<String>)((JAction1)WebSettings::setSearchStrategy), "element.search.strategy");
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> JDISettings.DRIVER.screenSize.read((String)p)), "browser.size");
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            PageLoadStrategy pageLoadStrategy = JDISettings.DRIVER.pageLoadStrategy = WebSettings.getPageLoadStrategy(p);
        }), "page.load.strategy");
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            String string = JDISettings.DRIVER.gitHubToken = p;
        }), "gitHubToken");
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            PageChecks pageChecks = JDISettings.PAGE.checkPageOpen = PageChecks.parse(p);
        }), "page.check.after.open");
        WebSettings.fillAction((JAction1<String>)((JAction1)SoftAssert::setAssertType), "assert.type");
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            ElementArea elementArea = JDISettings.ELEMENT.clickType = (ElementArea)EnumUtils.getEnumValueByName(ElementArea.class, (String)p, (Enum)ElementArea.CENTER);
        }), "click.type");
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            TextTypes textTypes = JDISettings.ELEMENT.getTextType = (TextTypes)EnumUtils.getEnumValueByName(TextTypes.class, (String)p, (Enum)TextTypes.SMART_TEXT);
        }), "text.type");
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            SetTextTypes setTextTypes = JDISettings.ELEMENT.setTextType = (SetTextTypes)EnumUtils.getEnumValueByName(SetTextTypes.class, (String)p, (Enum)SetTextTypes.CLEAR_SEND_KEYS);
        }), "set.text.type");
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            String string = JDISettings.DRIVER.remoteUrl = WebSettings.getRemoteUrl(p);
        }), "remote.type");
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            String string = JDISettings.DRIVER.remoteUrl = p;
        }), "driver.remote.url");
        if (PropertyReader.hasProperty((String)"driver.remote.run")) {
            WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
                Boolean bl = JDISettings.DRIVER.remoteRun = Boolean.valueOf(Boolean.parseBoolean(p));
            }), "driver.remote.run");
        } else {
            JDISettings.DRIVER.remoteRun = PropertyReader.hasProperty((String)"driver.remote.url") && JDISettings.DRIVER.remoteRun == null;
        }
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            LogLevels logLevels = JDISettings.LOGS.logLevel = LogLevels.parseLogLevel(p);
        }), "log.level");
        logger.setLogLevel(JDISettings.LOGS.logLevel);
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            boolean bl = JDISettings.LOGS.writeToAllure = WebSettings.onOff(p);
        }), PropertyReader.hasProperty((String)"allure") ? "allure" : "allure.steps");
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            String string = JDISettings.ELEMENT.smartTemplate = p.split(";")[0];
        }), "smart.locator");
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            JDISettings.ELEMENT.smartName = WebSettings.getSmartSearchFunc(p);
            Pair<String, JFunc1<String, String>> pair = JDISettings.ELEMENT.smartName;
        }), "smart.locator.to.name");
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            UseSmartSearch useSmartSearch = JDISettings.ELEMENT.useSmartSearch = WebSettings.getSmartSearchUse(p);
        }), "smart.search");
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            JDISettings.ELEMENT.highlight = WebSettings.getHighlightStrategy(p);
            List<HighlightStrategy> list = JDISettings.ELEMENT.highlight;
        }), "element.highlight");
        WebSettings.fillAction((JAction1<String>)((JAction1)p -> {
            if (Boolean.parseBoolean(p)) {
                JDISettings.DRIVER.capabilities.common.put("arguments", "--headless");
            }
        }), "headless");
        WebSettings.loadCapabilities("chrome.capabilities.path", "chrome.properties", (JAction1<Properties>)((JAction1)p -> p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String string = JDISettings.DRIVER.capabilities.chrome.put(key.toString(), value.toString());
        }))));
        WebSettings.loadCapabilities("ff.capabilities.path", "ff.properties", (JAction1<Properties>)((JAction1)p -> p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String string = JDISettings.DRIVER.capabilities.firefox.put(key.toString(), value.toString());
        }))));
        WebSettings.loadCapabilities("ie.capabilities.path", "ie.properties", (JAction1<Properties>)((JAction1)p -> p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String string = JDISettings.DRIVER.capabilities.ie.put(key.toString(), value.toString());
        }))));
        WebSettings.loadCapabilities("edge.capabilities.path", "edge.properties", (JAction1<Properties>)((JAction1)p -> p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String string = JDISettings.DRIVER.capabilities.ieEdge.put(key.toString(), value.toString());
        }))));
        WebSettings.loadCapabilities("opera.capabilities.path", "opera.properties", (JAction1<Properties>)((JAction1)p -> p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String string = JDISettings.DRIVER.capabilities.opera.put(key.toString(), value.toString());
        }))));
        WebSettings.loadCapabilities("safari.capabilities.path", "safari.properties", (JAction1<Properties>)((JAction1)p -> p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String string = JDISettings.DRIVER.capabilities.safari.put(key.toString(), value.toString());
        }))));
        WebSettings.loadCapabilities("common.capabilities.path", "common.properties", (JAction1<Properties>)((JAction1)p -> p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String string = JDISettings.DRIVER.capabilities.common.put(key.toString(), value.toString());
        }))));
        initialized = true;
    }

    public static synchronized void init() {
        ActionHelper.CHECK_MULTI_THREAD.execute();
        if (initialized) {
            return;
        }
        ReentrantLock locker = new ReentrantLock();
        locker.lock();
        logger.trace("init()", new Object[0]);
        try {
            try {
                INIT_FUNC.execute();
            }
            catch (Throwable ex) {
                throw Exceptions.exception(ex, "Failed to init test.properties", new Object[0]);
            }
        }
        finally {
            logger.trace("init() DONE", new Object[0]);
            locker.unlock();
        }
    }

    private static boolean onOff(String onOff) {
        return onOff.equals("true") || onOff.equals("on");
    }

    private static String getRemoteUrl(String prop) {
        String value;
        switch (value = prop.toLowerCase().trim().replaceAll("[^a-z]", "")) {
            case "saucelabs": 
            case "sauce": {
                JDISettings.DRIVER.capabilities.common = SauceSettings.sauceCapabilities();
                return RemoteDriverInfo.SAUCE_LABS;
            }
            case "browserstack": {
                return RemoteDriverInfo.browserstack();
            }
            case "selenoid": {
                return "http://localhost:4444/wd/hub";
            }
        }
        return "http://localhost:4444/wd/hub";
    }

    private static Pair<String, JFunc1<String, String>> getSmartSearchFunc(String name) {
        if (!NameToLocator.SMART_MAP_NAME_TO_LOCATOR.keys().contains(name)) {
            throw Exceptions.runtimeException("Unknown JDISettings.ELEMENT.smartName: '%s'. Please correct value 'smart.locator.to.name' in test.properties.Available names: [%s]", name, PrintUtils.print((Collection)NameToLocator.SMART_MAP_NAME_TO_LOCATOR.keys()));
        }
        return Pair.$((Object)name, (Object)((JFunc1)NameToLocator.SMART_MAP_NAME_TO_LOCATOR.get((Object)name)));
    }

    private static UseSmartSearch getSmartSearchUse(String prop) {
        String value;
        switch (value = prop.toLowerCase().trim().replaceAll("[^a-z]", "")) {
            case "off": 
            case "false": {
                return UseSmartSearch.FALSE;
            }
            case "onlyui": {
                return UseSmartSearch.ONLY_UI;
            }
            case "uiandelements": {
                return UseSmartSearch.UI_AND_ELEMENTS;
            }
            case "always": {
                return UseSmartSearch.ALWAYS;
            }
        }
        return UseSmartSearch.UI_AND_ELEMENTS;
    }

    public static void loadCapabilities(String property, String defaultPath, JAction1<Properties> setCapabilities) {
        Properties properties;
        String path = "";
        try {
            path = System.getProperty(property, PropertyReader.getProperty((String)property));
        }
        catch (Exception ignore) {
            logger.trace("Error on read property %s. %s", property, ignore);
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)path)) {
            path = defaultPath;
        }
        if ((properties = new PropReader(path).getProperties()).isEmpty()) {
            logger.trace("There is no properties in %s", property);
            File p = new File("." + path);
            logger.trace("Abs prop path %s, Properties file exists? = %s", p.getAbsolutePath(), p.exists());
            return;
        }
        try {
            setCapabilities.execute((Object)properties);
        }
        catch (Exception ignore) {
            logger.trace("Error set properties %s. %s", property, ignore);
        }
    }

    private static void setSearchStrategy(String p) {
        if ((p = p.toLowerCase()).equals("soft")) {
            p = "any, multiple";
        }
        if (p.equals("strict")) {
            p = "visible, smart";
        }
        if (p.split(",").length != 2) {
            return;
        }
        List params = LinqUtils.map(Arrays.asList(p.split(",")), a -> (String)JDISettings.ELEMENT.simplifyString.execute(a));
        if (params.contains("visible") || params.contains("displayed")) {
            SearchStrategies.onlyVisible();
        }
        if (params.contains("any") || params.contains("all")) {
            SearchStrategies.noValidation();
        }
        if (params.contains("enabled")) {
            SearchStrategies.visibleEnabled();
        }
        if (params.contains("inview")) {
            SearchStrategies.inView();
        }
        if (params.contains("single")) {
            JDISettings.ELEMENT.searchType = SearchTypes.Single;
        } else if (params.contains("first") || params.contains("multiple")) {
            JDISettings.ELEMENT.searchType = SearchTypes.First;
        } else if (params.contains("smart")) {
            JDISettings.ELEMENT.searchType = SearchTypes.Smart;
        }
    }

    /*
     * Exception decompiling
     */
    private static PageLoadStrategy getPageLoadStrategy(String strategy) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[5] lbl27 : CaseStatement: default:\u000a, @NONE, blocks:[5] lbl27 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Properties getProperties(String path) {
        Properties properties;
        File propertyFile = new File(path);
        if (propertyFile.exists()) {
            properties = WebSettings.getCiProperties(path, propertyFile);
        } else {
            Properties pTest = PropertyReader.getProperties((String)PathUtils.mergePath((String)path, (String[])new String[0]));
            Properties pTarget = PropertyReader.getProperties((String)PathUtils.mergePath((String)("/../../target/classes/" + path), (String[])new String[0]));
            if (pTarget.size() > 0) {
                return pTarget;
            }
            String propertiesPath = pTest.size() > 0 ? path : PathUtils.mergePath((String)("/../../target/classes/" + path), (String[])new String[0]);
            properties = PropertyReader.getProperties((String)propertiesPath);
        }
        return properties;
    }

    private static Properties getCiProperties(String path, File propertyFile) {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(propertyFile));
            logger.info("Property file found: %s", propertyFile.getAbsolutePath());
        }
        catch (IOException iOException) {
            throw Exceptions.runtimeException("Couldn't load properties for CI Server" + path, new Object[0]);
        }
        return properties;
    }

    private static LogInfoDetails getInfoDetailsLevel(String option) {
        switch (option.toLowerCase()) {
            case "none": {
                return LogInfoDetails.NONE;
            }
            case "name": {
                return LogInfoDetails.NAME;
            }
            case "locator": {
                return LogInfoDetails.LOCATOR;
            }
            case "context": {
                return LogInfoDetails.CONTEXT;
            }
            case "element": {
                return LogInfoDetails.ELEMENT;
            }
        }
        return LogInfoDetails.ELEMENT;
    }

    private static List<Strategy> getActionStrategy(String strategy) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)strategy)) {
            return Arrays.asList(Strategy.FAIL);
        }
        if (strategy.trim().equalsIgnoreCase("off")) {
            return new ArrayList<Strategy>();
        }
        if (strategy.trim().equalsIgnoreCase("flow")) {
            return LinqUtils.list((Object[])new Strategy[]{Strategy.NEW_PAGE, Strategy.FAIL, Strategy.ASSERT});
        }
        List<Strategy> strategies = new ArrayList<Strategy>();
        try {
            Object[] split = strategy.split("\\|");
            strategies = LinqUtils.map((Object[])split, s -> Strategy.parseStrategy(s.trim()));
        }
        catch (Exception exception) {}
        return strategies;
    }

    private static List<HighlightStrategy> getHighlightStrategy(String strategy) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)strategy) || strategy.trim().equalsIgnoreCase("off")) {
            return new ArrayList<HighlightStrategy>();
        }
        if (strategy.trim().equalsIgnoreCase("flow")) {
            return LinqUtils.list((Object[])new HighlightStrategy[]{HighlightStrategy.FAIL, HighlightStrategy.ACTION, HighlightStrategy.ASSERT});
        }
        List<HighlightStrategy> strategies = new ArrayList<HighlightStrategy>();
        try {
            Object[] split = strategy.split("\\|");
            strategies = LinqUtils.map((Object[])split, s -> HighlightStrategy.parseStrategy(s.trim()));
        }
        catch (Exception exception) {}
        return strategies;
    }

    private static Strategies getStrategy(String prop) {
        String strategy;
        switch (strategy = prop.trim().toLowerCase().replaceAll("[^a-z]", "")) {
            case "jdi": {
                return Strategies.JDI;
            }
            case "jdismart": {
                return Strategies.JDI_SMART;
            }
            case "selenium": {
                return Strategies.SELENIUM;
            }
        }
        return Strategies.JDI;
    }

    public static void waitAction(int timeout, JAction action) {
        int oldTimeout = JDISettings.TIMEOUTS.element.get();
        JDISettings.TIMEOUTS.element.set(timeout);
        try {
            action.execute();
        }
        finally {
            JDISettings.TIMEOUTS.element.set(oldTimeout);
        }
    }
}

