/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import com.epam.reportportal.annotations.TestCaseId;
import com.epam.reportportal.annotations.attribute.Attributes;
import com.epam.reportportal.cucumber.RunningContext;
import com.epam.reportportal.cucumber.Utils;
import com.epam.reportportal.cucumber.util.ItemTreeUtils;
import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.message.ReportPortalMessage;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.ReportPortal;
import com.epam.reportportal.service.item.TestCaseIdEntry;
import com.epam.reportportal.service.tree.TestItemTree;
import com.epam.reportportal.utils.AttributeParser;
import com.epam.reportportal.utils.ParameterUtils;
import com.epam.reportportal.utils.TestCaseIdUtils;
import com.epam.reportportal.utils.properties.SystemAttributesExtractor;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.ParameterResource;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import gherkin.formatter.Argument;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.DocString;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Row;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import gherkin.formatter.model.Tag;
import io.reactivex.Maybe;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.tika.Tika;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rp.com.google.common.base.Strings;
import rp.com.google.common.base.Supplier;
import rp.com.google.common.base.Suppliers;
import rp.com.google.common.base.Throwables;
import rp.com.google.common.io.ByteSource;

public abstract class AbstractReporter
implements Formatter,
Reporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractReporter.class);
    private static final String AGENT_PROPERTIES_FILE = "agent.properties";
    private static final String STEP_DEFINITION_FIELD_NAME = "stepDefinition";
    private static final String GET_LOCATION_METHOD_NAME = "getLocation";
    private static final String METHOD_OPENING_BRACKET = "(";
    private static final String TABLE_SEPARATOR = "|";
    private static final String DOCSTRING_DECORATOR = "\n\"\"\"\n";
    public static final TestItemTree ITEM_TREE = new TestItemTree();
    private static volatile ReportPortal REPORT_PORTAL = ReportPortal.builder().build();
    protected static final String COLON_INFIX = ": ";
    protected static final String SKIPPED_ISSUE_KEY = "skippedIssue";
    protected final ThreadLocal<RunningContext.FeatureContext> currentFeatureContext = new ThreadLocal();
    protected final ThreadLocal<RunningContext.ScenarioContext> currentScenarioContext = new ThreadLocal();
    private AtomicBoolean finished = new AtomicBoolean(false);
    protected final Supplier<Launch> launch = Suppliers.memoize((Supplier)new Supplier<Launch>(){
        private final Date startTime = Calendar.getInstance().getTime();

        public Launch get() {
            ReportPortal reportPortal = AbstractReporter.this.buildReportPortal();
            ListenerParameters parameters = reportPortal.getParameters();
            StartLaunchRQ rq = new StartLaunchRQ();
            rq.setName(parameters.getLaunchName());
            rq.setStartTime(this.startTime);
            rq.setMode(parameters.getLaunchRunningMode());
            rq.setAttributes(parameters.getAttributes() == null ? new HashSet() : parameters.getAttributes());
            rq.getAttributes().addAll(SystemAttributesExtractor.extract((String)AbstractReporter.AGENT_PROPERTIES_FILE, (ClassLoader)AbstractReporter.class.getClassLoader()));
            rq.setDescription(parameters.getDescription());
            rq.setRerun(parameters.isRerun());
            if (!Strings.isNullOrEmpty((String)parameters.getRerunOf())) {
                rq.setRerunOf(parameters.getRerunOf());
            }
            Boolean skippedAnIssue = parameters.getSkippedAnIssue();
            ItemAttributesRQ skippedIssueAttr = new ItemAttributesRQ();
            skippedIssueAttr.setKey(AbstractReporter.SKIPPED_ISSUE_KEY);
            skippedIssueAttr.setValue(skippedAnIssue == null ? "true" : skippedAnIssue.toString());
            skippedIssueAttr.setSystem(true);
            rq.getAttributes().add(skippedIssueAttr);
            Launch launch = reportPortal.newLaunch(rq);
            AbstractReporter.this.finished = new AtomicBoolean(false);
            return launch;
        }
    });
    private static final ThreadLocal<Tika> TIKA_THREAD_LOCAL = ThreadLocal.withInitial(Tika::new);
    private volatile MimeTypes mimeTypes = null;

    public static ReportPortal getReportPortal() {
        return REPORT_PORTAL;
    }

    protected static void setReportPortal(ReportPortal reportPortal) {
        REPORT_PORTAL = reportPortal;
    }

    protected ReportPortal buildReportPortal() {
        return ReportPortal.builder().build();
    }

    protected void afterLaunch() {
        FinishExecutionRQ finishLaunchRq = new FinishExecutionRQ();
        finishLaunchRq.setEndTime(Calendar.getInstance().getTime());
        ((Launch)this.launch.get()).finish(finishLaunchRq);
    }

    private void addToTree(RunningContext.FeatureContext featureContext, RunningContext.ScenarioContext scenarioContext) {
        ItemTreeUtils.retrieveLeaf(featureContext.getUri(), ITEM_TREE).ifPresent(suiteLeaf -> suiteLeaf.getChildItems().put(ItemTreeUtils.createKey(scenarioContext.getLine()), TestItemTree.createTestItemLeaf(scenarioContext.getId())));
    }

    private void addToTree(RunningContext.FeatureContext context) {
        ITEM_TREE.getTestItems().put(ItemTreeUtils.createKey(context.getUri()), TestItemTree.createTestItemLeaf(context.getId()));
    }

    protected String buildScenarioName(Scenario scenario) {
        return Utils.buildName(scenario.getKeyword(), COLON_INFIX, scenario.getName());
    }

    protected StartTestItemRQ buildStartScenarioRequest(Scenario scenario, String uri) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(this.buildScenarioName(scenario));
        String description = this.getDescription(scenario, uri);
        String codeRef = this.getCodeRef(uri, scenario.getLine());
        rq.setDescription(description);
        rq.setCodeRef(codeRef);
        rq.setAttributes(this.extractAttributes(scenario.getTags()));
        rq.setStartTime(Calendar.getInstance().getTime());
        String type = this.getScenarioTestItemType();
        rq.setType(type);
        if ("STEP".equals(type)) {
            rq.setTestCaseId((String)Optional.ofNullable(this.getTestCaseId(codeRef, null)).map(TestCaseIdEntry::getId).orElse(null));
        }
        return rq;
    }

    protected void beforeScenario(Scenario scenario, String outlineIteration) {
        RunningContext.FeatureContext featureContext = this.currentFeatureContext.get();
        Launch myLaunch = (Launch)this.launch.get();
        if (null == featureContext.getId()) {
            StartTestItemRQ startFeatureRq = featureContext.getItemRq();
            Optional<Maybe<String>> root = this.getRootItemId();
            startFeatureRq.setStartTime(Calendar.getInstance().getTime());
            Maybe currentFeatureId = root.map(i -> myLaunch.startTestItem(i, startFeatureRq)).orElseGet(() -> myLaunch.startTestItem(startFeatureRq));
            featureContext.setId((Maybe<String>)currentFeatureId);
            this.addToTree(featureContext);
        }
        String uri = featureContext.getUri();
        StartTestItemRQ rq = this.buildStartScenarioRequest(scenario, uri);
        Maybe id = myLaunch.startTestItem(featureContext.getId(), rq);
        RunningContext.ScenarioContext scenarioContext = this.getCurrentScenarioContext();
        scenarioContext.setId((Maybe<String>)id);
        scenarioContext.setLine(scenario.getLine());
        scenarioContext.setFeatureUri(uri);
        if (myLaunch.getParameters().isCallbackReportingEnabled()) {
            this.addToTree(featureContext, scenarioContext);
        }
    }

    private void removeFromTree(RunningContext.FeatureContext featureContext, RunningContext.ScenarioContext scenarioContext) {
        ItemTreeUtils.retrieveLeaf(featureContext.getUri(), ITEM_TREE).ifPresent(suiteLeaf -> {
            TestItemTree.TestItemLeaf cfr_ignored_0 = (TestItemTree.TestItemLeaf)suiteLeaf.getChildItems().remove(ItemTreeUtils.createKey(scenarioContext.getLine()));
        });
    }

    protected void afterScenario() {
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        this.finishTestItem(context.getId(), context.getStatus());
        this.currentScenarioContext.set(null);
        this.removeFromTree(this.currentFeatureContext.get(), context);
    }

    protected StartTestItemRQ buildStartFeatureRequest(Feature feature, String uri) {
        String featureKeyword = feature.getKeyword();
        String featureName = feature.getName();
        StartTestItemRQ startFeatureRq = new StartTestItemRQ();
        startFeatureRq.setDescription(this.getDescription(feature, uri));
        startFeatureRq.setCodeRef(this.getCodeRef(uri, 0));
        startFeatureRq.setName(Utils.buildName(featureKeyword, COLON_INFIX, featureName));
        startFeatureRq.setAttributes(this.extractAttributes(feature.getTags()));
        startFeatureRq.setType(this.getFeatureTestItemType());
        return startFeatureRq;
    }

    protected void beforeFeature(Feature feature) {
        RunningContext.FeatureContext featureContext = this.currentFeatureContext.get();
        featureContext.setItemRq(this.buildStartFeatureRequest(feature, featureContext.getUri()));
    }

    protected void afterFeature() {
        RunningContext.FeatureContext currentFeature = this.currentFeatureContext.get();
        if (null != currentFeature && null != currentFeature.getId()) {
            this.finishTestItem(currentFeature.getId());
        }
    }

    private RunningContext.ScenarioContext getCurrentScenarioContext() {
        RunningContext.ScenarioContext context = this.currentScenarioContext.get();
        if (context == null) {
            context = new RunningContext.ScenarioContext();
            this.currentScenarioContext.set(context);
        }
        return context;
    }

    protected StartTestItemRQ buildStartStepRequest(Step step, String stepPrefix, Match match) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(Utils.buildName(stepPrefix, step.getKeyword(), step.getName()));
        rq.setDescription(this.buildMultilineArgument(step));
        rq.setStartTime(Calendar.getInstance().getTime());
        rq.setType("STEP");
        String codeRef = this.getCodeRef(match);
        rq.setParameters(this.getParameters(step, codeRef, match));
        rq.setCodeRef(codeRef);
        rq.setTestCaseId((String)Optional.ofNullable(this.getTestCaseId(match, codeRef)).map(TestCaseIdEntry::getId).orElse(null));
        rq.setAttributes(this.getAttributes(match));
        return rq;
    }

    private void addToTree(RunningContext.ScenarioContext scenarioContext, String text, Maybe<String> stepId) {
        ItemTreeUtils.retrieveLeaf(scenarioContext.getFeatureUri(), scenarioContext.getLine(), ITEM_TREE).ifPresent(scenarioLeaf -> scenarioLeaf.getChildItems().put(ItemTreeUtils.createKey(text), TestItemTree.createTestItemLeaf((Maybe)stepId)));
    }

    protected void beforeStep(Step step, Match match) {
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        StartTestItemRQ rq = this.buildStartStepRequest(step, context.getStepPrefix(), match);
        Launch myLaunch = (Launch)this.launch.get();
        Maybe stepId = myLaunch.startTestItem(context.getId(), rq);
        context.setCurrentStepId((Maybe<String>)stepId);
        String stepText = step.getName();
        if (myLaunch.getParameters().isCallbackReportingEnabled()) {
            this.addToTree(context, stepText, (Maybe<String>)stepId);
        }
    }

    protected void afterStep(Result result) {
        this.reportResult(result, null);
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        ((Launch)this.launch.get()).getStepReporter().finishPreviousStep();
        this.finishTestItem(context.getCurrentStepId(), this.mapStatus(result.getStatus()));
        context.setCurrentStepId(null);
    }

    protected StartTestItemRQ buildStartHookRequest(boolean isBefore) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setType(isBefore ? "BEFORE_TEST" : "AFTER_TEST");
        rq.setName(isBefore ? "Before hooks" : "After hooks");
        rq.setStartTime(Calendar.getInstance().getTime());
        return rq;
    }

    protected void beforeHooks(boolean isBefore) {
        StartTestItemRQ rq = this.buildStartHookRequest(isBefore);
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        context.setHookStepId((Maybe<String>)((Launch)this.launch.get()).startTestItem(context.getId(), rq));
        context.setHookStatus(ItemStatus.PASSED);
    }

    protected void afterHooks(Boolean isBefore) {
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        ((Launch)this.launch.get()).getStepReporter().finishPreviousStep();
        this.finishTestItem(context.getHookStepId(), context.getHookStatus());
        context.setHookStepId(null);
    }

    protected void hookFinished(Match match, Result result, Boolean isBefore) {
        this.reportResult(result, (isBefore != false ? "Before" : "After") + " hook: " + match.getLocation());
        this.getCurrentScenarioContext().setHookStatus(this.mapStatus(result.getStatus()));
    }

    protected void reportResult(Result result, String message) {
        String errorMessage;
        String cukesStatus = result.getStatus();
        String level = this.mapLevel(cukesStatus);
        if (message != null) {
            this.sendLog(message, level);
        }
        if ((errorMessage = result.getErrorMessage()) != null) {
            this.sendLog(errorMessage, level);
        } else if (result.getError() != null) {
            this.sendLog(Throwables.getStackTraceAsString((Throwable)result.getError()), level);
        }
        RunningContext.ScenarioContext currentScenario = this.getCurrentScenarioContext();
        currentScenario.updateStatus(this.mapStatus(result.getStatus()));
    }

    @Nonnull
    protected abstract String getFeatureTestItemType();

    @Nonnull
    protected abstract String getScenarioTestItemType();

    public void before(Match match, Result result) {
        this.hookFinished(match, result, true);
    }

    public void result(Result result) {
        this.afterStep(result);
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        if (!context.isInBackground() && context.noMoreSteps()) {
            this.beforeHooks(false);
        }
    }

    public void after(Match match, Result result) {
        this.hookFinished(match, result, false);
    }

    public void match(Match match) {
        this.beforeStep(this.getCurrentScenarioContext().getNextStep(), match);
    }

    private MimeTypes getMimeTypes() {
        if (this.mimeTypes == null) {
            this.mimeTypes = MimeTypes.getDefaultMimeTypes();
        }
        return this.mimeTypes;
    }

    public void embedding(String mimeType, byte[] data) {
        String type = mimeType;
        try {
            type = TIKA_THREAD_LOCAL.get().detect((InputStream)new ByteArrayInputStream(data));
        }
        catch (IOException e) {
            LOGGER.warn("Mime-type not found", (Throwable)e);
        }
        String prefix = "";
        try {
            MediaType mt = this.getMimeTypes().forName(type).getType();
            prefix = mt.getType();
        }
        catch (MimeTypeException e) {
            LOGGER.warn("Mime-type not found", (Throwable)e);
        }
        ReportPortal.emitLog((ReportPortalMessage)new ReportPortalMessage(ByteSource.wrap((byte[])data), type, prefix), (String)"UNKNOWN", (Date)Calendar.getInstance().getTime());
    }

    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
    }

    public void uri(String uri) {
        this.currentFeatureContext.set(new RunningContext.FeatureContext(uri));
        Maybe launchId = ((Launch)this.launch.get()).start();
        ITEM_TREE.setLaunchId(launchId);
    }

    public void feature(Feature feature) {
        this.beforeFeature(feature);
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
    }

    public void examples(Examples examples) {
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        Queue<String> iterations = context.getOutlineIterations();
        IntStream.range(1, examples.getRows().size()).forEach(it -> iterations.add(String.format("[%d]", it)));
    }

    public void startOfScenarioLifeCycle(Scenario scenario) {
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        String iteration = context.getOutlineIterations().poll();
        context.setInBackground(false);
        this.beforeScenario(scenario, iteration);
        this.beforeHooks(true);
    }

    public void background(Background background) {
        this.afterHooks(true);
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        context.setInBackground(true);
        context.setStepPrefix(background.getKeyword().toUpperCase() + COLON_INFIX);
    }

    public void scenario(Scenario scenario) {
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        if (!context.isInBackground()) {
            this.afterHooks(true);
        } else {
            context.setInBackground(false);
        }
        context.setStepPrefix("");
    }

    public void step(Step step) {
        RunningContext.ScenarioContext context = this.currentScenarioContext.get();
        if (context != null) {
            context.addStep(step);
        }
    }

    public void endOfScenarioLifeCycle(Scenario scenario) {
        this.afterHooks(false);
        this.afterScenario();
    }

    public void done() {
    }

    public void close() {
        if (this.finished.compareAndSet(false, true)) {
            this.afterLaunch();
        }
    }

    public void eof() {
        this.afterFeature();
    }

    protected abstract Optional<Maybe<String>> getRootItemId();

    @Nullable
    private TestCaseIdEntry getTestCaseId(@Nullable String codeRef, @Nullable List<Argument> arguments) {
        return TestCaseIdUtils.getTestCaseId((String)codeRef, Utils.ARGUMENTS_TRANSFORM.apply(arguments));
    }

    @Nullable
    protected TestCaseIdEntry getTestCaseId(@Nonnull Match match, @Nullable String codeRef) {
        try {
            Method method = Utils.retrieveMethod(match);
            if (method == null) {
                return this.getTestCaseId(codeRef, match.getArguments());
            }
            return TestCaseIdUtils.getTestCaseId((TestCaseId)method.getAnnotation(TestCaseId.class), (Executable)method, (String)codeRef, Utils.ARGUMENTS_TRANSFORM.apply(match.getArguments()));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return this.getTestCaseId(codeRef, match.getArguments());
        }
    }

    @Nonnull
    protected String getDescription(@Nonnull Scenario scenario, @Nonnull String uri) {
        return uri;
    }

    @Nonnull
    protected String getDescription(@Nonnull Feature feature, @Nonnull String uri) {
        return uri;
    }

    protected void finishTestItem(Maybe<String> itemId) {
        this.finishTestItem(itemId, null);
    }

    protected void finishTestItem(Maybe<String> itemId, ItemStatus status) {
        if (itemId == null) {
            LOGGER.error("BUG: Trying to finish unspecified test item.");
            return;
        }
        FinishTestItemRQ rq = new FinishTestItemRQ();
        Optional.ofNullable(status).ifPresent(s -> rq.setStatus(s.name()));
        rq.setEndTime(Calendar.getInstance().getTime());
        ((Launch)this.launch.get()).finishTestItem(itemId, rq);
    }

    @Nullable
    protected String getCodeRef(Match match) {
        try {
            Field stepDefinitionField = match.getClass().getDeclaredField(STEP_DEFINITION_FIELD_NAME);
            stepDefinitionField.setAccessible(true);
            Object javaStepDefinition = stepDefinitionField.get(match);
            Method getLocationMethod = javaStepDefinition.getClass().getDeclaredMethod(GET_LOCATION_METHOD_NAME, Boolean.TYPE);
            getLocationMethod.setAccessible(true);
            String fullCodeRef = String.valueOf(getLocationMethod.invoke(javaStepDefinition, true));
            return fullCodeRef != null ? fullCodeRef.substring(0, fullCodeRef.indexOf(METHOD_OPENING_BRACKET)) : null;
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    @Nonnull
    protected String getCodeRef(@Nonnull String uri, int line) {
        return uri + ":" + line;
    }

    @Nonnull
    protected ItemStatus mapStatus(@Nullable String cukesStatus) {
        if (Strings.isNullOrEmpty((String)cukesStatus)) {
            return ItemStatus.FAILED;
        }
        ItemStatus status = Utils.STATUS_MAPPING.get(cukesStatus.toLowerCase());
        return null == status ? ItemStatus.FAILED : status;
    }

    @Nonnull
    protected String mapLevel(@Nullable String cukesStatus) {
        if (Strings.isNullOrEmpty((String)cukesStatus)) {
            return "ERROR";
        }
        String level = Utils.LOG_LEVEL_MAPPING.get(cukesStatus.toLowerCase());
        return null == level ? "ERROR" : level;
    }

    public void write(String text) {
        this.sendLog(text);
    }

    protected void sendLog(String message) {
        this.sendLog(message, "INFO");
    }

    protected void sendLog(String message, String level) {
        ReportPortal.emitLog((String)message, (String)level, (Date)Calendar.getInstance().getTime());
    }

    @Nonnull
    protected List<ParameterResource> getParameters(@Nonnull Step step, @Nullable String codeRef, @Nonnull Match match) {
        List params = Optional.ofNullable(match.getArguments()).map(a -> IntStream.range(0, a.size()).mapToObj(i -> Pair.of((Object)("arg" + i), (Object)((Argument)a.get(i)).getVal())).collect(Collectors.toList())).orElse(null);
        if (params == null || params.isEmpty()) {
            DocString docstring = step.getDocString();
            if (docstring != null) {
                return ParameterUtils.getParameters((String)codeRef, Collections.singletonList(Pair.of((Object)"docstring", (Object)StringEscapeUtils.escapeHtml4((String)docstring.getValue()))));
            }
            return Collections.emptyList();
        }
        return ParameterUtils.getParameters((String)codeRef, (List)params);
    }

    @Nonnull
    protected Set<ItemAttributesRQ> extractAttributes(@Nonnull List<Tag> tags) {
        HashSet<ItemAttributesRQ> result = new HashSet<ItemAttributesRQ>();
        for (Tag tag : tags) {
            result.add(new ItemAttributesRQ(null, tag.getName()));
        }
        return result;
    }

    @Nullable
    protected Set<ItemAttributesRQ> getAttributes(Match match) {
        try {
            Method method = Utils.retrieveMethod(match);
            if (method == null) {
                return null;
            }
            Attributes attributesAnnotation = method.getAnnotation(Attributes.class);
            if (attributesAnnotation != null) {
                return AttributeParser.retrieveAttributes((Attributes)attributesAnnotation);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return null;
        }
        return null;
    }

    protected String buildMultilineArgument(Step step) {
        List table = step.getRows();
        DocString ds = step.getDocString();
        StringBuilder marg = new StringBuilder();
        StringBuilder markDownSeparator = new StringBuilder();
        if (table != null) {
            marg.append("\r\n\r\n");
            for (Row row : table) {
                marg.append(TABLE_SEPARATOR);
                for (String cell : row.getCells()) {
                    marg.append(" ").append(cell).append(" ").append(TABLE_SEPARATOR);
                }
                marg.append("\r\n");
                if (markDownSeparator.length() != 0) continue;
                markDownSeparator.append(TABLE_SEPARATOR).append("-").append(TABLE_SEPARATOR);
                marg.append((CharSequence)markDownSeparator);
                marg.append("\r\n");
            }
        }
        if (ds != null) {
            marg.append(DOCSTRING_DECORATOR).append(ds.getValue()).append(DOCSTRING_DECORATOR);
        }
        return marg.toString();
    }
}

