/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import com.epam.reportportal.annotations.TestCaseId;
import com.epam.reportportal.annotations.attribute.Attributes;
import com.epam.reportportal.cucumber.RunningContext;
import com.epam.reportportal.cucumber.Utils;
import com.epam.reportportal.cucumber.util.ItemTreeUtils;
import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.message.ReportPortalMessage;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.ReportPortal;
import com.epam.reportportal.service.item.TestCaseIdEntry;
import com.epam.reportportal.service.tree.TestItemTree;
import com.epam.reportportal.utils.AttributeParser;
import com.epam.reportportal.utils.MemoizingSupplier;
import com.epam.reportportal.utils.MimeTypeDetector;
import com.epam.reportportal.utils.ParameterUtils;
import com.epam.reportportal.utils.TestCaseIdUtils;
import com.epam.reportportal.utils.files.ByteSource;
import com.epam.reportportal.utils.formatting.ExceptionUtils;
import com.epam.reportportal.utils.formatting.MarkdownUtils;
import com.epam.reportportal.utils.http.ContentType;
import com.epam.reportportal.utils.properties.SystemAttributesExtractor;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.ParameterResource;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import gherkin.formatter.Argument;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.DocString;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Row;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import gherkin.formatter.model.Tag;
import io.reactivex.Maybe;
import java.io.IOException;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReporter
implements Formatter,
Reporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractReporter.class);
    private static final String AGENT_PROPERTIES_FILE = "agent.properties";
    private static final String STEP_DEFINITION_FIELD_NAME = "stepDefinition";
    private static final String GET_LOCATION_METHOD_NAME = "getLocation";
    private static final String METHOD_OPENING_BRACKET = "(";
    private static final String DOCSTRING_DECORATOR = "\n\"\"\"\n";
    private static final String ERROR_FORMAT = "Error:\n%s";
    public static final TestItemTree ITEM_TREE = new TestItemTree();
    private static volatile ReportPortal REPORT_PORTAL = ReportPortal.builder().build();
    protected static final String COLON_INFIX = ": ";
    protected static final String SKIPPED_ISSUE_KEY = "skippedIssue";
    protected final ThreadLocal<RunningContext.FeatureContext> currentFeatureContext = new ThreadLocal();
    protected final ThreadLocal<RunningContext.ScenarioContext> currentScenarioContext = new ThreadLocal();
    private final Map<Maybe<String>, String> descriptionsMap = new ConcurrentHashMap<Maybe<String>, String>();
    private final Map<Maybe<String>, Throwable> errorMap = new ConcurrentHashMap<Maybe<String>, Throwable>();
    private AtomicBoolean finished = new AtomicBoolean(false);
    protected final Supplier<Launch> launch = new MemoizingSupplier((Supplier)new Supplier<Launch>(){
        private final Date startTime = Calendar.getInstance().getTime();

        @Override
        public Launch get() {
            ReportPortal reportPortal = AbstractReporter.this.buildReportPortal();
            ListenerParameters parameters = reportPortal.getParameters();
            StartLaunchRQ rq = new StartLaunchRQ();
            rq.setName(parameters.getLaunchName());
            rq.setStartTime(this.startTime);
            rq.setMode(parameters.getLaunchRunningMode());
            HashSet<ItemAttributesRQ> attributes = new HashSet<ItemAttributesRQ>(parameters.getAttributes());
            rq.setAttributes(attributes);
            attributes.addAll(SystemAttributesExtractor.extract((String)AbstractReporter.AGENT_PROPERTIES_FILE, (ClassLoader)AbstractReporter.class.getClassLoader()));
            rq.setDescription(parameters.getDescription());
            rq.setRerun(parameters.isRerun());
            if (StringUtils.isNotBlank((CharSequence)parameters.getRerunOf())) {
                rq.setRerunOf(parameters.getRerunOf());
            }
            Boolean skippedAnIssue = parameters.getSkippedAnIssue();
            ItemAttributesRQ skippedIssueAttr = new ItemAttributesRQ();
            skippedIssueAttr.setKey(AbstractReporter.SKIPPED_ISSUE_KEY);
            skippedIssueAttr.setValue(skippedAnIssue == null ? "true" : skippedAnIssue.toString());
            skippedIssueAttr.setSystem(true);
            attributes.add(skippedIssueAttr);
            Launch launch = reportPortal.newLaunch(rq);
            AbstractReporter.this.finished = new AtomicBoolean(false);
            return launch;
        }
    });

    @Nonnull
    public static ReportPortal getReportPortal() {
        return REPORT_PORTAL;
    }

    protected static void setReportPortal(ReportPortal reportPortal) {
        REPORT_PORTAL = reportPortal;
    }

    protected ReportPortal buildReportPortal() {
        return ReportPortal.builder().build();
    }

    protected void afterLaunch() {
        FinishExecutionRQ finishLaunchRq = new FinishExecutionRQ();
        finishLaunchRq.setEndTime(Calendar.getInstance().getTime());
        this.launch.get().finish(finishLaunchRq);
    }

    private void addToTree(RunningContext.FeatureContext featureContext, RunningContext.ScenarioContext scenarioContext) {
        ItemTreeUtils.retrieveLeaf(featureContext.getUri(), ITEM_TREE).ifPresent(suiteLeaf -> suiteLeaf.getChildItems().put(ItemTreeUtils.createKey(scenarioContext.getLine()), TestItemTree.createTestItemLeaf(scenarioContext.getId())));
    }

    private void addToTree(RunningContext.FeatureContext context) {
        ITEM_TREE.getTestItems().put(ItemTreeUtils.createKey(context.getUri()), TestItemTree.createTestItemLeaf(context.getId()));
    }

    @Nonnull
    protected String buildScenarioName(@Nonnull Scenario scenario) {
        return Utils.buildName(scenario.getKeyword(), COLON_INFIX, scenario.getName());
    }

    @Nonnull
    protected StartTestItemRQ buildStartScenarioRequest(@Nonnull Scenario scenario, @Nonnull String uri) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(this.buildScenarioName(scenario));
        String description = this.getDescription(scenario, uri);
        String codeRef = this.getCodeRef(uri, scenario.getLine());
        rq.setDescription(description);
        rq.setCodeRef(codeRef);
        rq.setAttributes(this.extractAttributes(scenario.getTags()));
        rq.setStartTime(Calendar.getInstance().getTime());
        String type = this.getScenarioTestItemType();
        rq.setType(type);
        if ("STEP".equals(type)) {
            rq.setTestCaseId((String)Optional.ofNullable(this.getTestCaseId(codeRef, null)).map(TestCaseIdEntry::getId).orElse(null));
        }
        return rq;
    }

    private RunningContext.ScenarioContext getCurrentScenarioContext() {
        RunningContext.ScenarioContext context = this.currentScenarioContext.get();
        if (context == null) {
            context = new RunningContext.ScenarioContext();
            this.currentScenarioContext.set(context);
        }
        return context;
    }

    @Nonnull
    protected Maybe<String> startFeature(@Nonnull StartTestItemRQ startFeatureRq) {
        Optional<Maybe<String>> root = this.getRootItemId();
        startFeatureRq.setStartTime(Calendar.getInstance().getTime());
        Launch myLaunch = this.launch.get();
        return root.map(i -> myLaunch.startTestItem(i, startFeatureRq)).orElseGet(() -> myLaunch.startTestItem(startFeatureRq));
    }

    @Nonnull
    protected Maybe<String> startScenario(@Nonnull Maybe<String> featureId, @Nonnull StartTestItemRQ startScenarioRq) {
        return this.launch.get().startTestItem(featureId, startScenarioRq);
    }

    protected void beforeScenario(Scenario scenario, String outlineIteration) {
        RunningContext.FeatureContext featureContext = this.currentFeatureContext.get();
        Launch myLaunch = this.launch.get();
        if (null == featureContext.getId()) {
            featureContext.setId(this.startFeature(featureContext.getItemRq()));
            this.addToTree(featureContext);
        }
        String uri = featureContext.getUri();
        StartTestItemRQ rq = this.buildStartScenarioRequest(scenario, uri);
        RunningContext.ScenarioContext scenarioContext = this.getCurrentScenarioContext();
        scenarioContext.setId(this.startScenario(featureContext.getId(), rq));
        scenarioContext.setLine(scenario.getLine());
        scenarioContext.setFeatureUri(uri);
        this.descriptionsMap.put(scenarioContext.getId(), Optional.ofNullable(rq.getDescription()).orElse(""));
        if (myLaunch.getParameters().isCallbackReportingEnabled()) {
            this.addToTree(featureContext, scenarioContext);
        }
    }

    private void removeFromTree(RunningContext.FeatureContext featureContext, RunningContext.ScenarioContext scenarioContext) {
        ItemTreeUtils.retrieveLeaf(featureContext.getUri(), ITEM_TREE).ifPresent(suiteLeaf -> {
            TestItemTree.TestItemLeaf cfr_ignored_0 = (TestItemTree.TestItemLeaf)suiteLeaf.getChildItems().remove(ItemTreeUtils.createKey(scenarioContext.getLine()));
        });
    }

    @Nonnull
    protected FinishTestItemRQ buildFinishTestItemRequest(@Nonnull Maybe<String> itemId, @Nullable ItemStatus status) {
        FinishTestItemRQ rq = new FinishTestItemRQ();
        if (status == ItemStatus.FAILED) {
            Optional<String> currentDescription = Optional.ofNullable(this.descriptionsMap.get(itemId));
            Optional<Throwable> currentError = Optional.ofNullable(this.errorMap.get(itemId));
            currentDescription.flatMap(description -> currentError.map(errorMessage -> this.resolveDescriptionErrorMessage((String)description, (Throwable)errorMessage))).ifPresent(arg_0 -> ((FinishTestItemRQ)rq).setDescription(arg_0));
        }
        Optional.ofNullable(status).ifPresent(s -> rq.setStatus(s.name()));
        rq.setEndTime(Calendar.getInstance().getTime());
        return rq;
    }

    private String resolveDescriptionErrorMessage(String currentDescription, Throwable error) {
        String errorStr = String.format(ERROR_FORMAT, ExceptionUtils.getStackTrace((Throwable)error, (Throwable)new Throwable()));
        return Optional.ofNullable(currentDescription).filter(StringUtils::isNotBlank).map(description -> MarkdownUtils.asTwoParts((String)currentDescription, (String)errorStr)).orElse(errorStr);
    }

    protected void finishTestItem(@Nullable Maybe<String> itemId, @Nullable ItemStatus status) {
        if (itemId == null) {
            LOGGER.error("BUG: Trying to finish unspecified test item.");
            return;
        }
        FinishTestItemRQ finishTestItemRQ = this.buildFinishTestItemRequest(itemId, status);
        this.launch.get().finishTestItem(itemId, finishTestItemRQ);
    }

    protected void afterScenario() {
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        this.finishTestItem(context.getId(), context.getStatus());
        this.currentScenarioContext.remove();
        this.removeFromTree(this.currentFeatureContext.get(), context);
    }

    @Nonnull
    protected StartTestItemRQ buildStartFeatureRequest(@Nonnull Feature feature, @Nonnull String uri) {
        String featureKeyword = feature.getKeyword();
        String featureName = feature.getName();
        StartTestItemRQ startFeatureRq = new StartTestItemRQ();
        startFeatureRq.setDescription(this.getDescription(feature, uri));
        startFeatureRq.setCodeRef(this.getCodeRef(uri, 0));
        startFeatureRq.setName(Utils.buildName(featureKeyword, COLON_INFIX, featureName));
        startFeatureRq.setAttributes(this.extractAttributes(feature.getTags()));
        startFeatureRq.setType(this.getFeatureTestItemType());
        return startFeatureRq;
    }

    protected void beforeFeature(Feature feature) {
        RunningContext.FeatureContext featureContext = this.currentFeatureContext.get();
        featureContext.setItemRq(this.buildStartFeatureRequest(feature, featureContext.getUri()));
    }

    protected void afterFeature() {
        RunningContext.FeatureContext currentFeature = this.currentFeatureContext.get();
        if (null != currentFeature && null != currentFeature.getId()) {
            this.finishTestItem(currentFeature.getId());
        }
    }

    @Nonnull
    protected StartTestItemRQ buildStartStepRequest(@Nonnull Step step, @Nullable String stepPrefix, @Nonnull Match match) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(Utils.buildName(stepPrefix, step.getKeyword(), step.getName()));
        rq.setDescription(this.buildMultilineArgument(step));
        rq.setStartTime(Calendar.getInstance().getTime());
        rq.setType("STEP");
        String codeRef = this.getCodeRef(match);
        rq.setParameters(this.getParameters(step, codeRef, match));
        rq.setCodeRef(codeRef);
        rq.setTestCaseId((String)Optional.ofNullable(this.getTestCaseId(match, codeRef)).map(TestCaseIdEntry::getId).orElse(null));
        rq.setAttributes(this.getAttributes(match));
        return rq;
    }

    @Nonnull
    protected Maybe<String> startStep(@Nonnull Maybe<String> scenarioId, @Nonnull StartTestItemRQ startStepRq) {
        return this.launch.get().startTestItem(scenarioId, startStepRq);
    }

    private void addToTree(@Nonnull RunningContext.ScenarioContext scenarioContext, @Nullable String text, @Nullable Maybe<String> stepId) {
        ItemTreeUtils.retrieveLeaf(scenarioContext.getFeatureUri(), scenarioContext.getLine(), ITEM_TREE).ifPresent(scenarioLeaf -> scenarioLeaf.getChildItems().put(ItemTreeUtils.createKey(text), TestItemTree.createTestItemLeaf((Maybe)stepId)));
    }

    protected void beforeStep(Step step, Match match) {
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        StartTestItemRQ rq = this.buildStartStepRequest(step, context.getStepPrefix(), match);
        Maybe<String> stepId = this.startStep(context.getId(), rq);
        context.setCurrentStepId(stepId);
        String stepText = step.getName();
        if (rq.isHasStats()) {
            this.descriptionsMap.put(stepId, Optional.ofNullable(rq.getDescription()).orElse(""));
        }
        if (this.launch.get().getParameters().isCallbackReportingEnabled()) {
            this.addToTree(context, stepText, stepId);
        }
    }

    protected void afterStep(@Nonnull Result result) {
        this.reportResult(result, null);
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        this.finishTestItem(context.getCurrentStepId(), this.mapStatus(result.getStatus()));
        context.setCurrentStepId(null);
    }

    protected StartTestItemRQ buildStartHookRequest(boolean isBefore) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setType(isBefore ? "BEFORE_TEST" : "AFTER_TEST");
        rq.setName(isBefore ? "Before hooks" : "After hooks");
        rq.setStartTime(Calendar.getInstance().getTime());
        return rq;
    }

    @Nonnull
    protected Maybe<String> startHook(@Nonnull Maybe<String> parentId, @Nonnull StartTestItemRQ rq) {
        return this.launch.get().startTestItem(parentId, rq);
    }

    protected void beforeHooks(boolean isBefore) {
        StartTestItemRQ rq = this.buildStartHookRequest(isBefore);
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        context.setHookStepId(this.startHook(context.getId(), rq));
        context.setHookStatus(ItemStatus.PASSED);
    }

    protected void afterHooks(Boolean isBefore) {
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        this.finishTestItem(context.getHookStepId(), context.getHookStatus());
        context.setHookStepId(null);
    }

    protected void hookFinished(Match match, Result result, Boolean isBefore) {
        this.reportResult(result, (isBefore != false ? "Before" : "After") + " hook: " + match.getLocation());
        this.getCurrentScenarioContext().setHookStatus(this.mapStatus(result.getStatus()));
    }

    protected void reportResult(@Nonnull Result result, @Nullable String message) {
        String errorMessage;
        String cukesStatus = result.getStatus();
        String level = this.mapLevel(cukesStatus);
        if (message != null) {
            this.sendLog(message, level);
        }
        if ((errorMessage = result.getErrorMessage()) != null) {
            this.sendLog(errorMessage, level);
        } else if (result.getError() != null) {
            this.sendLog(ExceptionUtils.getStackTrace((Throwable)result.getError(), (Throwable)new Throwable()), level);
        }
        RunningContext.ScenarioContext currentScenario = this.getCurrentScenarioContext();
        ItemStatus itemStatus = this.mapStatus(result.getStatus());
        currentScenario.updateStatus(itemStatus);
        if (itemStatus == ItemStatus.FAILED) {
            this.errorMap.put(currentScenario.getId(), result.getError());
            this.errorMap.put(currentScenario.getCurrentStepId(), result.getError());
        }
    }

    @Nonnull
    protected abstract String getFeatureTestItemType();

    @Nonnull
    protected abstract String getScenarioTestItemType();

    public void before(Match match, Result result) {
        this.hookFinished(match, result, true);
    }

    public void result(Result result) {
        this.afterStep(result);
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        if (!context.isInBackground() && context.noMoreSteps()) {
            this.beforeHooks(false);
        }
    }

    public void after(Match match, Result result) {
        this.hookFinished(match, result, false);
    }

    public void match(Match match) {
        this.beforeStep(this.getCurrentScenarioContext().getNextStep(), match);
    }

    @Nullable
    private static String getDataType(@Nonnull byte[] data) {
        try {
            return MimeTypeDetector.detect((ByteSource)ByteSource.wrap((byte[])data), null);
        }
        catch (IOException e) {
            LOGGER.warn("Unable to detect MIME type", (Throwable)e);
            return null;
        }
    }

    public void embedding(String mimeType, byte[] data) {
        String type = Optional.ofNullable(mimeType).filter(ContentType::isValidType).orElseGet(() -> AbstractReporter.getDataType(data));
        String attachmentName = Optional.ofNullable(type).map(t -> t.substring(0, t.indexOf("/"))).orElse("");
        ReportPortal.emitLog((ReportPortalMessage)new ReportPortalMessage(ByteSource.wrap((byte[])data), type, attachmentName), (String)"UNKNOWN", (Date)Calendar.getInstance().getTime());
    }

    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
    }

    public void uri(String uri) {
        this.currentFeatureContext.set(new RunningContext.FeatureContext(uri));
        Maybe launchId = this.launch.get().start();
        ITEM_TREE.setLaunchId(launchId);
    }

    public void feature(Feature feature) {
        this.beforeFeature(feature);
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
    }

    public void examples(Examples examples) {
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        Queue<String> iterations = context.getOutlineIterations();
        IntStream.range(1, examples.getRows().size()).forEach(it -> iterations.add(String.format("[%d]", it)));
    }

    public void startOfScenarioLifeCycle(Scenario scenario) {
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        String iteration = context.getOutlineIterations().poll();
        context.setInBackground(false);
        this.beforeScenario(scenario, iteration);
        this.beforeHooks(true);
    }

    public void background(Background background) {
        this.afterHooks(true);
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        context.setInBackground(true);
        context.setStepPrefix(background.getKeyword().toUpperCase() + COLON_INFIX);
    }

    public void scenario(Scenario scenario) {
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        if (!context.isInBackground()) {
            this.afterHooks(true);
        } else {
            context.setInBackground(false);
        }
        context.setStepPrefix("");
    }

    public void step(Step step) {
        RunningContext.ScenarioContext context = this.currentScenarioContext.get();
        if (context != null) {
            context.addStep(step);
        }
    }

    public void endOfScenarioLifeCycle(Scenario scenario) {
        this.afterHooks(false);
        this.afterScenario();
    }

    public void done() {
    }

    public void close() {
        if (this.finished.compareAndSet(false, true)) {
            this.afterLaunch();
        }
    }

    public void eof() {
        this.afterFeature();
    }

    protected abstract Optional<Maybe<String>> getRootItemId();

    @Nullable
    private TestCaseIdEntry getTestCaseId(@Nullable String codeRef, @Nullable List<Argument> arguments) {
        return TestCaseIdUtils.getTestCaseId((String)codeRef, Utils.ARGUMENTS_TRANSFORM.apply(arguments));
    }

    @Nullable
    protected TestCaseIdEntry getTestCaseId(@Nonnull Match match, @Nullable String codeRef) {
        try {
            Method method = Utils.retrieveMethod(match);
            if (method == null) {
                return this.getTestCaseId(codeRef, match.getArguments());
            }
            return TestCaseIdUtils.getTestCaseId((TestCaseId)method.getAnnotation(TestCaseId.class), (Executable)method, (String)codeRef, Utils.ARGUMENTS_TRANSFORM.apply(match.getArguments()));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return this.getTestCaseId(codeRef, match.getArguments());
        }
    }

    @Nonnull
    protected String getDescription(@Nonnull Scenario scenario, @Nonnull String uri) {
        return uri;
    }

    @Nonnull
    protected String getDescription(@Nonnull Feature feature, @Nonnull String uri) {
        return uri;
    }

    protected void finishTestItem(Maybe<String> itemId) {
        this.finishTestItem(itemId, null);
    }

    @Nullable
    protected String getCodeRef(@Nonnull Match match) {
        try {
            Field stepDefinitionField = match.getClass().getDeclaredField(STEP_DEFINITION_FIELD_NAME);
            stepDefinitionField.setAccessible(true);
            Object javaStepDefinition = stepDefinitionField.get(match);
            Method getLocationMethod = javaStepDefinition.getClass().getDeclaredMethod(GET_LOCATION_METHOD_NAME, Boolean.TYPE);
            getLocationMethod.setAccessible(true);
            String fullCodeRef = String.valueOf(getLocationMethod.invoke(javaStepDefinition, true));
            if (!fullCodeRef.isEmpty()) {
                int openingBracketIndex = fullCodeRef.indexOf(METHOD_OPENING_BRACKET);
                if (openingBracketIndex > 0) {
                    return fullCodeRef.substring(0, fullCodeRef.indexOf(METHOD_OPENING_BRACKET));
                }
                return fullCodeRef;
            }
            return match.getLocation();
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            return match.getLocation();
        }
    }

    @Nonnull
    protected String getCodeRef(@Nonnull String uri, int line) {
        return uri + ":" + line;
    }

    @Nonnull
    protected ItemStatus mapStatus(@Nullable String cukesStatus) {
        if (StringUtils.isBlank((CharSequence)cukesStatus)) {
            return ItemStatus.FAILED;
        }
        ItemStatus status = Utils.STATUS_MAPPING.get(cukesStatus.toLowerCase());
        return null == status ? ItemStatus.FAILED : status;
    }

    @Nonnull
    protected String mapLevel(@Nullable String cukesStatus) {
        if (StringUtils.isBlank((CharSequence)cukesStatus)) {
            return "ERROR";
        }
        String level = Utils.LOG_LEVEL_MAPPING.get(cukesStatus.toLowerCase());
        return null == level ? "ERROR" : level;
    }

    public void write(String text) {
        this.sendLog(text);
    }

    protected void sendLog(String message) {
        this.sendLog(message, "INFO");
    }

    protected void sendLog(String message, String level) {
        ReportPortal.emitLog((String)message, (String)level, (Date)Calendar.getInstance().getTime());
    }

    @Nonnull
    protected List<ParameterResource> getParameters(@Nonnull Step step, @Nullable String codeRef, @Nonnull Match match) {
        List params = Optional.ofNullable(match.getArguments()).map(a -> IntStream.range(0, a.size()).mapToObj(i -> Pair.of((Object)("arg" + i), (Object)((Argument)a.get(i)).getVal())).collect(Collectors.toList())).orElse(new ArrayList());
        Optional.ofNullable(step.getDocString()).map(DocString::getValue).filter(ds -> !ds.isEmpty()).ifPresent(ds -> params.add(Pair.of((Object)"docstring", (Object)StringEscapeUtils.escapeHtml4((String)ds))));
        Optional.ofNullable(step.getRows()).filter(rows -> !rows.isEmpty()).ifPresent(rows -> params.add(Pair.of((Object)"datatable", (Object)MarkdownUtils.formatDataTable(rows.stream().map(Row::getCells).collect(Collectors.toList())))));
        return params.isEmpty() ? Collections.emptyList() : ParameterUtils.getParameters((String)codeRef, (List)params);
    }

    @Nonnull
    protected Set<ItemAttributesRQ> extractAttributes(@Nonnull List<Tag> tags) {
        HashSet<ItemAttributesRQ> result = new HashSet<ItemAttributesRQ>();
        for (Tag tag : tags) {
            result.add(new ItemAttributesRQ(null, tag.getName()));
        }
        return result;
    }

    @Nullable
    protected Set<ItemAttributesRQ> getAttributes(Match match) {
        try {
            Method method = Utils.retrieveMethod(match);
            if (method == null) {
                return null;
            }
            Attributes attributesAnnotation = method.getAnnotation(Attributes.class);
            if (attributesAnnotation != null) {
                return AttributeParser.retrieveAttributes((Attributes)attributesAnnotation);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return null;
        }
        return null;
    }

    protected String buildMultilineArgument(Step step) {
        StringBuilder marg = new StringBuilder();
        Optional.ofNullable(step.getRows()).map(rows -> rows.stream().map(Row::getCells).collect(Collectors.toList())).filter(t -> !t.isEmpty()).ifPresent(t -> marg.append(MarkdownUtils.formatDataTable((List)t)));
        Optional.ofNullable(step.getDocString()).map(DocString::getValue).filter(ds -> !ds.isEmpty()).ifPresent(ds -> marg.append(DOCSTRING_DECORATOR).append((String)ds).append(DOCSTRING_DECORATOR));
        return marg.toString();
    }
}

