/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import com.epam.reportportal.listeners.ItemStatus;
import gherkin.formatter.Argument;
import gherkin.formatter.model.Match;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Utils {
    private static final String STEP_DEFINITION_FIELD_NAME = "stepDefinition";
    private static final String METHOD_FIELD_NAME = "method";
    public static final Map<String, ItemStatus> STATUS_MAPPING = Collections.unmodifiableMap(new HashMap<String, ItemStatus>(){
        {
            this.put("passed", ItemStatus.PASSED);
            this.put("failed", ItemStatus.FAILED);
            this.put("skipped", ItemStatus.SKIPPED);
            this.put("pending", ItemStatus.SKIPPED);
            this.put("undefined", ItemStatus.SKIPPED);
        }
    });
    public static final Map<String, String> LOG_LEVEL_MAPPING = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("passed", "INFO");
            this.put("failed", "ERROR");
            this.put("skipped", "WARN");
            this.put("pending", "WARN");
            this.put("undefined", "WARN");
        }
    });
    public static final Function<List<Argument>, List<?>> ARGUMENTS_TRANSFORM = arguments -> Optional.ofNullable(arguments).map(args -> args.stream().map(Argument::getVal).collect(Collectors.toList())).orElse(null);

    private Utils() {
    }

    @Nonnull
    public static String buildName(@Nullable String prefix, @Nullable String infix, @Nullable String argument) {
        return (prefix == null ? "" : prefix) + infix + argument;
    }

    @Nullable
    public static Method retrieveMethod(@Nonnull Match match) throws NoSuchFieldException, IllegalAccessException {
        Field stepDefinitionField = match.getClass().getDeclaredField(STEP_DEFINITION_FIELD_NAME);
        stepDefinitionField.setAccessible(true);
        Object javaStepDefinition = stepDefinitionField.get(match);
        Field methodField = javaStepDefinition.getClass().getDeclaredField(METHOD_FIELD_NAME);
        methodField.setAccessible(true);
        return (Method)methodField.get(javaStepDefinition);
    }
}

