/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.listeners.LogLevel;
import com.epam.reportportal.utils.reflect.Accessible;
import cucumber.api.Argument;
import cucumber.api.Result;
import cucumber.api.TestStep;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Utils {
    private static final String EMPTY = "";
    private static final String DEFINITION_MATCH_FIELD_NAME = "definitionMatch";
    private static final String STEP_DEFINITION_FIELD_NAME = "stepDefinition";
    private static final String METHOD_FIELD_NAME = "method";
    private static final Map<Result.Type, ItemStatus> COMMON_STATUS_MAPPING = new HashMap<Result.Type, ItemStatus>(){
        {
            this.put(Result.Type.PASSED, ItemStatus.PASSED);
            this.put(Result.Type.FAILED, ItemStatus.FAILED);
            this.put(Result.Type.SKIPPED, ItemStatus.SKIPPED);
            this.put(Result.Type.PENDING, ItemStatus.SKIPPED);
            this.put(Result.Type.AMBIGUOUS, ItemStatus.SKIPPED);
            this.put(Result.Type.UNDEFINED, ItemStatus.SKIPPED);
        }
    };
    private static final Map<Result.Type, String> COMMON_LOG_LEVEL_MAPPING = new HashMap<Result.Type, String>(){
        {
            this.put(Result.Type.PASSED, LogLevel.INFO.name());
            this.put(Result.Type.FAILED, LogLevel.ERROR.name());
            this.put(Result.Type.SKIPPED, LogLevel.WARN.name());
            this.put(Result.Type.PENDING, LogLevel.WARN.name());
            this.put(Result.Type.AMBIGUOUS, LogLevel.WARN.name());
            this.put(Result.Type.UNDEFINED, LogLevel.WARN.name());
        }
    };
    public static final Map<Result.Type, ItemStatus> STATUS_MAPPING;
    public static final Map<Result.Type, String> LOG_LEVEL_MAPPING;
    public static final Function<List<Argument>, List<?>> ARGUMENTS_TRANSFORM;

    private Utils() {
        throw new AssertionError((Object)"No instances should exist for the class!");
    }

    public static String buildName(String prefix, String infix, String argument) {
        return (prefix == null ? EMPTY : prefix) + infix + argument;
    }

    public static Method retrieveMethod(Object stepDefinitionMatch) throws IllegalAccessException, NoSuchFieldException {
        Object javaStepDefinition = Accessible.on((Object)stepDefinitionMatch).field(STEP_DEFINITION_FIELD_NAME).getValue();
        Method method = null;
        if (javaStepDefinition != null) {
            method = (Method)Accessible.on((Object)javaStepDefinition).field(METHOD_FIELD_NAME).getValue();
        }
        return method;
    }

    public static Object getDefinitionMatch(TestStep testStep) {
        try {
            return Accessible.on((Object)testStep).field(DEFINITION_MATCH_FIELD_NAME).getValue();
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    static {
        Optional<Result.Type> unused = Arrays.stream(Result.Type.values()).filter(e -> "UNUSED".equals(e.name())).findAny();
        if (unused.isPresent()) {
            COMMON_STATUS_MAPPING.put(unused.get(), ItemStatus.SKIPPED);
            COMMON_LOG_LEVEL_MAPPING.put(unused.get(), LogLevel.WARN.name());
        }
        STATUS_MAPPING = Collections.unmodifiableMap(COMMON_STATUS_MAPPING);
        LOG_LEVEL_MAPPING = Collections.unmodifiableMap(COMMON_LOG_LEVEL_MAPPING);
        ARGUMENTS_TRANSFORM = arguments -> Optional.ofNullable(arguments).map(args -> args.stream().map(Argument::getValue).collect(Collectors.toList())).orElse(null);
    }
}

