/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import com.epam.reportportal.annotations.TestCaseId;
import com.epam.reportportal.annotations.attribute.Attributes;
import com.epam.reportportal.cucumber.RunningContext;
import com.epam.reportportal.cucumber.Utils;
import com.epam.reportportal.cucumber.util.ItemTreeUtils;
import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.message.ReportPortalMessage;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.ReportPortal;
import com.epam.reportportal.service.item.TestCaseIdEntry;
import com.epam.reportportal.service.tree.TestItemTree;
import com.epam.reportportal.utils.AttributeParser;
import com.epam.reportportal.utils.ParameterUtils;
import com.epam.reportportal.utils.TestCaseIdUtils;
import com.epam.reportportal.utils.properties.SystemAttributesExtractor;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.ParameterResource;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import io.cucumber.core.internal.gherkin.ast.Feature;
import io.cucumber.core.internal.gherkin.ast.Step;
import io.cucumber.core.internal.gherkin.ast.Tag;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.Argument;
import io.cucumber.plugin.event.DataTableArgument;
import io.cucumber.plugin.event.DocStringArgument;
import io.cucumber.plugin.event.EmbedEvent;
import io.cucumber.plugin.event.EventHandler;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.HookTestStep;
import io.cucumber.plugin.event.HookType;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.StepArgument;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestRunStarted;
import io.cucumber.plugin.event.TestSourceRead;
import io.cucumber.plugin.event.TestStep;
import io.cucumber.plugin.event.TestStepFinished;
import io.cucumber.plugin.event.TestStepStarted;
import io.cucumber.plugin.event.WriteEvent;
import io.reactivex.Maybe;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tika.Tika;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rp.com.google.common.base.Strings;
import rp.com.google.common.base.Supplier;
import rp.com.google.common.base.Suppliers;
import rp.com.google.common.base.Throwables;
import rp.com.google.common.io.ByteSource;

public abstract class AbstractReporter
implements ConcurrentEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractReporter.class);
    private static final URI WORKING_DIRECTORY = new File(System.getProperty("user.dir")).toURI();
    private static final String AGENT_PROPERTIES_FILE = "agent.properties";
    private static final String HOOK_ = "Hook: ";
    private static final String GET_LOCATION_METHOD_NAME = "getLocation";
    private static final String METHOD_OPENING_BRACKET = "(";
    private static final String STEP_DEFINITION_FIELD_NAME = "stepDefinition";
    private static final String TABLE_INDENT = "          ";
    private static final String TABLE_SEPARATOR = "|";
    private static final String DOCSTRING_DECORATOR = "\n\"\"\"\n";
    private static final String ONE_SPACE = " ";
    private static final String NEW_LINE = "\r\n";
    private static final String EMPTY = "";
    public static final TestItemTree ITEM_TREE = new TestItemTree();
    private static volatile ReportPortal REPORT_PORTAL = ReportPortal.builder().build();
    protected Supplier<Launch> launch;
    static final String COLON_INFIX = ": ";
    private static final String SKIPPED_ISSUE_KEY = "skippedIssue";
    private final Map<URI, RunningContext.FeatureContext> currentFeatureContextMap = new ConcurrentHashMap<URI, RunningContext.FeatureContext>();
    private final Map<Pair<Integer, URI>, RunningContext.ScenarioContext> currentScenarioContextMap = new ConcurrentHashMap<Pair<Integer, URI>, RunningContext.ScenarioContext>();
    private final Map<URI, Date> featureEndTime = new ConcurrentHashMap<URI, Date>();
    private final ThreadLocal<RunningContext.ScenarioContext> currentScenarioContext = new ThreadLocal();
    private static final ThreadLocal<Tika> TIKA_THREAD_LOCAL = ThreadLocal.withInitial(Tika::new);
    private volatile MimeTypes mimeTypes = null;

    public static ReportPortal getReportPortal() {
        return REPORT_PORTAL;
    }

    protected static void setReportPortal(ReportPortal reportPortal) {
        REPORT_PORTAL = reportPortal;
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestRunStarted.class, this.getTestRunStartedHandler());
        publisher.registerHandlerFor(TestSourceRead.class, this.getTestSourceReadHandler());
        publisher.registerHandlerFor(TestCaseStarted.class, this.getTestCaseStartedHandler());
        publisher.registerHandlerFor(TestStepStarted.class, this.getTestStepStartedHandler());
        publisher.registerHandlerFor(TestStepFinished.class, this.getTestStepFinishedHandler());
        publisher.registerHandlerFor(TestCaseFinished.class, this.getTestCaseFinishedHandler());
        publisher.registerHandlerFor(TestRunFinished.class, this.getTestRunFinishedHandler());
        publisher.registerHandlerFor(EmbedEvent.class, this.getEmbedEventHandler());
        publisher.registerHandlerFor(WriteEvent.class, this.getWriteEventHandler());
    }

    protected RunningContext.ScenarioContext getCurrentScenarioContext() {
        return this.currentScenarioContext.get();
    }

    protected void beforeLaunch() {
        this.startLaunch();
        Maybe launchId = ((Launch)this.launch.get()).start();
        ITEM_TREE.setLaunchId(launchId);
    }

    protected ReportPortal buildReportPortal() {
        return ReportPortal.builder().build();
    }

    protected void afterLaunch() {
        FinishExecutionRQ finishLaunchRq = new FinishExecutionRQ();
        finishLaunchRq.setEndTime(Calendar.getInstance().getTime());
        ((Launch)this.launch.get()).finish(finishLaunchRq);
    }

    private void addToTree(RunningContext.FeatureContext featureContext, RunningContext.ScenarioContext scenarioContext) {
        ItemTreeUtils.retrieveLeaf(featureContext.getUri(), ITEM_TREE).ifPresent(suiteLeaf -> suiteLeaf.getChildItems().put(ItemTreeUtils.createKey(scenarioContext.getLine()), TestItemTree.createTestItemLeaf(scenarioContext.getId())));
    }

    protected StartTestItemRQ buildStartScenarioRequest(TestCase testCase, String name, URI uri, int line) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(name);
        rq.setDescription(this.getDescription(testCase, uri));
        String codeRef = this.getCodeRef(uri, line);
        rq.setCodeRef(codeRef);
        rq.setAttributes(this.extractAttributes(testCase.getTags()));
        rq.setStartTime(Calendar.getInstance().getTime());
        String type = this.getScenarioTestItemType();
        rq.setType(type);
        if ("STEP".equals(type)) {
            rq.setTestCaseId((String)Optional.ofNullable(this.getTestCaseId(codeRef, null)).map(TestCaseIdEntry::getId).orElse(null));
        }
        return rq;
    }

    protected void beforeScenario(RunningContext.FeatureContext featureContext, RunningContext.ScenarioContext scenarioContext) {
        String scenarioName = Utils.buildName(scenarioContext.getKeyword(), COLON_INFIX, scenarioContext.getName());
        Launch myLaunch = (Launch)this.launch.get();
        Maybe id = myLaunch.startTestItem(featureContext.getFeatureId(), this.buildStartScenarioRequest(scenarioContext.getTestCase(), scenarioName, featureContext.getUri(), scenarioContext.getLine()));
        scenarioContext.setId((Maybe<String>)id);
        if (myLaunch.getParameters().isCallbackReportingEnabled()) {
            this.addToTree(featureContext, scenarioContext);
        }
    }

    private void removeFromTree(RunningContext.FeatureContext featureContext, RunningContext.ScenarioContext scenarioContext) {
        ItemTreeUtils.retrieveLeaf(featureContext.getUri(), ITEM_TREE).ifPresent(suiteLeaf -> {
            TestItemTree.TestItemLeaf cfr_ignored_0 = (TestItemTree.TestItemLeaf)suiteLeaf.getChildItems().remove(ItemTreeUtils.createKey(scenarioContext.getLine()));
        });
    }

    protected void afterScenario(TestCaseFinished event) {
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        URI featureUri = context.getFeatureUri();
        this.currentScenarioContextMap.remove(Pair.of((Object)context.getLine(), (Object)featureUri));
        Date endTime = this.finishTestItem(context.getId(), event.getResult().getStatus());
        this.featureEndTime.put(featureUri, endTime);
        this.currentScenarioContext.set(null);
        this.removeFromTree(this.currentFeatureContextMap.get(context.getFeatureUri()), context);
    }

    protected void startLaunch() {
        this.launch = Suppliers.memoize((Supplier)new Supplier<Launch>(){
            private final Date startTime = Calendar.getInstance().getTime();

            public Launch get() {
                ReportPortal reportPortal = AbstractReporter.this.buildReportPortal();
                ListenerParameters parameters = reportPortal.getParameters();
                StartLaunchRQ rq = new StartLaunchRQ();
                rq.setName(parameters.getLaunchName());
                rq.setStartTime(this.startTime);
                rq.setMode(parameters.getLaunchRunningMode());
                rq.setAttributes(parameters.getAttributes());
                rq.getAttributes().addAll(SystemAttributesExtractor.extract((String)AbstractReporter.AGENT_PROPERTIES_FILE, (ClassLoader)AbstractReporter.class.getClassLoader()));
                rq.setDescription(parameters.getDescription());
                rq.setRerun(parameters.isRerun());
                if (!Strings.isNullOrEmpty((String)parameters.getRerunOf())) {
                    rq.setRerunOf(parameters.getRerunOf());
                }
                if (null != parameters.getSkippedAnIssue()) {
                    ItemAttributesRQ skippedIssueAttribute = new ItemAttributesRQ();
                    skippedIssueAttribute.setKey(AbstractReporter.SKIPPED_ISSUE_KEY);
                    skippedIssueAttribute.setValue(parameters.getSkippedAnIssue().toString());
                    skippedIssueAttribute.setSystem(true);
                    rq.getAttributes().add(skippedIssueAttribute);
                }
                return reportPortal.newLaunch(rq);
            }
        });
    }

    @Nullable
    protected String getStepName(@Nonnull TestStep testStep) {
        return testStep instanceof HookTestStep ? HOOK_ + ((HookTestStep)testStep).getHookType().toString() : ((PickleStepTestStep)testStep).getStep().getText();
    }

    protected StartTestItemRQ buildStartStepRequest(TestStep testStep, String stepPrefix, String keyword) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(Utils.buildName(stepPrefix, keyword, this.getStepName(testStep)));
        rq.setDescription(this.buildMultilineArgument(testStep));
        rq.setStartTime(Calendar.getInstance().getTime());
        rq.setType("STEP");
        String codeRef = this.getCodeRef(testStep);
        rq.setParameters(this.getParameters(codeRef, testStep));
        rq.setCodeRef(codeRef);
        rq.setTestCaseId((String)Optional.ofNullable(this.getTestCaseId(testStep, codeRef)).map(TestCaseIdEntry::getId).orElse(null));
        rq.setAttributes(this.getAttributes(testStep));
        return rq;
    }

    protected void beforeStep(TestStep testStep) {
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        Step step = context.getStep(testStep);
        StartTestItemRQ rq = this.buildStartStepRequest(testStep, context.getStepPrefix(), step.getKeyword());
        Launch myLaunch = (Launch)this.launch.get();
        Maybe stepId = myLaunch.startTestItem(context.getId(), rq);
        context.setCurrentStepId((Maybe<String>)stepId);
        String stepText = step.getText();
        context.setCurrentText(stepText);
        if (myLaunch.getParameters().isCallbackReportingEnabled()) {
            this.addToTree(context, stepText, (Maybe<String>)stepId);
        }
    }

    protected void afterStep(Result result) {
        this.reportResult(result, null);
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        ((Launch)this.launch.get()).getStepReporter().finishPreviousStep();
        this.finishTestItem(context.getCurrentStepId(), result.getStatus());
        context.setCurrentStepId(null);
    }

    protected StartTestItemRQ buildStartHookRequest(HookType hookType) {
        StartTestItemRQ rq = new StartTestItemRQ();
        Pair<String, String> typeName = this.getHookTypeAndName(hookType);
        rq.setType((String)typeName.getKey());
        rq.setName((String)typeName.getValue());
        rq.setStartTime(Calendar.getInstance().getTime());
        return rq;
    }

    protected void beforeHooks(HookType hookType) {
        StartTestItemRQ rq = this.buildStartHookRequest(hookType);
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        context.setHookStepId((Maybe<String>)((Launch)this.launch.get()).startTestItem(context.getId(), rq));
        context.setHookStatus(Status.PASSED);
    }

    protected void afterHooks(HookType hookType) {
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        ((Launch)this.launch.get()).getStepReporter().finishPreviousStep();
        this.finishTestItem(context.getHookStepId(), context.getHookStatus());
        context.setHookStepId(null);
        if (hookType == HookType.AFTER_STEP) {
            this.removeFromTree(context, context.getCurrentText());
            context.setCurrentText(null);
        }
    }

    protected void hookFinished(HookTestStep step, Result result, Boolean isBefore) {
        this.reportResult(result, (isBefore != false ? "Before" : "After") + " hook: " + step.getCodeLocation());
        this.getCurrentScenarioContext().setHookStatus(result.getStatus());
    }

    @Nonnull
    protected abstract String getFeatureTestItemType();

    @Nonnull
    protected abstract String getScenarioTestItemType();

    protected void reportResult(Result result, String message) {
        String level = this.mapLevel(result.getStatus());
        if (message != null) {
            this.sendLog(message, level);
        }
        if (result.getError() != null) {
            this.sendLog(Throwables.getStackTraceAsString((Throwable)result.getError()), level);
        }
    }

    private MimeTypes getMimeTypes() {
        if (this.mimeTypes == null) {
            this.mimeTypes = MimeTypes.getDefaultMimeTypes();
        }
        return this.mimeTypes;
    }

    protected void embedding(String mimeType, byte[] data) {
        String type = mimeType;
        try {
            type = TIKA_THREAD_LOCAL.get().detect((InputStream)new ByteArrayInputStream(data));
        }
        catch (IOException e) {
            LOGGER.warn("Mime-type not found", (Throwable)e);
        }
        String prefix = EMPTY;
        try {
            MediaType mt = this.getMimeTypes().forName(type).getType();
            prefix = mt.getType();
        }
        catch (MimeTypeException e) {
            LOGGER.warn("Mime-type not found", (Throwable)e);
        }
        ReportPortal.emitLog((ReportPortalMessage)new ReportPortalMessage(ByteSource.wrap((byte[])data), type, prefix), (String)"UNKNOWN", (Date)Calendar.getInstance().getTime());
    }

    @Deprecated
    protected void write(String text) {
        this.sendLog(text, "INFO");
    }

    protected void sendLog(String message) {
        this.sendLog(message, "INFO");
    }

    protected void sendLog(String message, String level) {
        ReportPortal.emitLog((String)message, (String)level, (Date)Calendar.getInstance().getTime());
    }

    private boolean isBefore(TestStep step) {
        return HookType.BEFORE == ((HookTestStep)step).getHookType();
    }

    @Nonnull
    protected abstract Optional<Maybe<String>> getRootItemId();

    protected StartTestItemRQ buildStartFeatureRequest(Feature feature, URI uri) {
        String featureKeyword = feature.getKeyword();
        String featureName = feature.getName();
        StartTestItemRQ startFeatureRq = new StartTestItemRQ();
        startFeatureRq.setDescription(this.getDescription(feature, uri));
        startFeatureRq.setCodeRef(this.getCodeRef(uri, 0));
        startFeatureRq.setName(Utils.buildName(featureKeyword, COLON_INFIX, featureName));
        startFeatureRq.setAttributes(this.extractAttributes(feature.getTags()));
        startFeatureRq.setStartTime(Calendar.getInstance().getTime());
        startFeatureRq.setType(this.getFeatureTestItemType());
        return startFeatureRq;
    }

    private RunningContext.FeatureContext startFeatureContext(RunningContext.FeatureContext context) {
        Optional<Maybe<String>> root = this.getRootItemId();
        StartTestItemRQ rq = this.buildStartFeatureRequest(context.getFeature(), context.getUri());
        context.setFeatureId((Maybe<String>)root.map(r -> ((Launch)this.launch.get()).startTestItem(r, rq)).orElseGet(() -> ((Launch)this.launch.get()).startTestItem(rq)));
        return context;
    }

    protected EventHandler<TestRunStarted> getTestRunStartedHandler() {
        return event -> this.beforeLaunch();
    }

    protected EventHandler<TestSourceRead> getTestSourceReadHandler() {
        return event -> RunningContext.FeatureContext.addTestSourceReadEvent(event.getUri(), event);
    }

    protected EventHandler<TestCaseStarted> getTestCaseStartedHandler() {
        return this::handleStartOfTestCase;
    }

    protected EventHandler<TestStepStarted> getTestStepStartedHandler() {
        return this::handleTestStepStarted;
    }

    protected EventHandler<TestStepFinished> getTestStepFinishedHandler() {
        return this::handleTestStepFinished;
    }

    protected EventHandler<TestCaseFinished> getTestCaseFinishedHandler() {
        return this::afterScenario;
    }

    protected EventHandler<TestRunFinished> getTestRunFinishedHandler() {
        return event -> {
            this.handleEndOfFeature();
            this.afterLaunch();
        };
    }

    protected EventHandler<EmbedEvent> getEmbedEventHandler() {
        return event -> this.embedding(event.getMediaType(), event.getData());
    }

    protected EventHandler<WriteEvent> getWriteEventHandler() {
        return event -> this.sendLog(event.getText());
    }

    private void removeFromTree(RunningContext.FeatureContext featureContext) {
        ITEM_TREE.getTestItems().remove(ItemTreeUtils.createKey(featureContext.getUri()));
    }

    protected void handleEndOfFeature() {
        this.currentFeatureContextMap.values().forEach(f -> {
            Date featureCompletionDateTime = this.featureEndTime.get(f.getUri());
            this.finishFeature(f.getFeatureId(), featureCompletionDateTime);
            this.removeFromTree((RunningContext.FeatureContext)f);
        });
        this.currentFeatureContextMap.clear();
    }

    private void addToTree(RunningContext.FeatureContext context) {
        ITEM_TREE.getTestItems().put(ItemTreeUtils.createKey(context.getUri()), TestItemTree.createTestItemLeaf(context.getFeatureId()));
    }

    protected void handleStartOfTestCase(TestCaseStarted event) {
        TestCase testCase = event.getTestCase();
        RunningContext.FeatureContext newFeatureContext = new RunningContext.FeatureContext(testCase);
        URI featureUri = newFeatureContext.getUri();
        RunningContext.FeatureContext featureContext = this.currentFeatureContextMap.computeIfAbsent(featureUri, u -> {
            RunningContext.FeatureContext c = this.startFeatureContext(newFeatureContext);
            if (((Launch)this.launch.get()).getParameters().isCallbackReportingEnabled()) {
                this.addToTree(c);
            }
            return c;
        });
        if (!featureContext.getUri().equals(testCase.getUri())) {
            throw new IllegalStateException("Scenario URI does not match Feature URI.");
        }
        RunningContext.ScenarioContext newScenarioContext = featureContext.getScenarioContext(testCase);
        Pair scenarioLineFeatureURI = Pair.of((Object)newScenarioContext.getLine(), (Object)featureContext.getUri());
        RunningContext.ScenarioContext scenarioContext = this.currentScenarioContextMap.computeIfAbsent((Pair<Integer, URI>)scenarioLineFeatureURI, k -> {
            this.currentScenarioContext.set(newScenarioContext);
            return newScenarioContext;
        });
        this.beforeScenario(featureContext, scenarioContext);
    }

    protected void handleTestStepStarted(TestStepStarted event) {
        TestStep testStep = event.getTestStep();
        if (testStep instanceof HookTestStep) {
            this.beforeHooks(((HookTestStep)testStep).getHookType());
        } else {
            if (this.getCurrentScenarioContext().withBackground()) {
                this.getCurrentScenarioContext().nextBackgroundStep();
            }
            this.beforeStep(testStep);
        }
    }

    protected void handleTestStepFinished(TestStepFinished event) {
        if (event.getTestStep() instanceof HookTestStep) {
            HookTestStep hookTestStep = (HookTestStep)event.getTestStep();
            this.hookFinished(hookTestStep, event.getResult(), this.isBefore(event.getTestStep()));
            this.afterHooks(hookTestStep.getHookType());
        } else {
            this.afterStep(event.getResult());
        }
    }

    protected void addToTree(RunningContext.ScenarioContext scenarioContext, String text, Maybe<String> stepId) {
        ItemTreeUtils.retrieveLeaf(scenarioContext.getFeatureUri(), scenarioContext.getLine(), ITEM_TREE).ifPresent(scenarioLeaf -> scenarioLeaf.getChildItems().put(ItemTreeUtils.createKey(text), TestItemTree.createTestItemLeaf((Maybe)stepId)));
    }

    protected void removeFromTree(RunningContext.ScenarioContext scenarioContext, String text) {
        ItemTreeUtils.retrieveLeaf(scenarioContext.getFeatureUri(), scenarioContext.getLine(), ITEM_TREE).ifPresent(scenarioLeaf -> {
            TestItemTree.TestItemLeaf cfr_ignored_0 = (TestItemTree.TestItemLeaf)scenarioLeaf.getChildItems().remove(ItemTreeUtils.createKey(text));
        });
    }

    protected void finishFeature(Maybe<String> itemId, Date dateTime) {
        if (itemId == null) {
            LOGGER.error("BUG: Trying to finish unspecified test item.");
            return;
        }
        FinishTestItemRQ rq = new FinishTestItemRQ();
        rq.setEndTime(dateTime);
        ((Launch)this.launch.get()).finishTestItem(itemId, rq);
    }

    protected void finishTestItem(Maybe<String> itemId) {
        this.finishTestItem(itemId, null);
    }

    protected Date finishTestItem(Maybe<String> itemId, Status status) {
        if (itemId == null) {
            LOGGER.error("BUG: Trying to finish unspecified test item.");
            return null;
        }
        FinishTestItemRQ rq = new FinishTestItemRQ();
        Date endTime = Calendar.getInstance().getTime();
        rq.setEndTime(endTime);
        rq.setStatus(this.mapItemStatus(status));
        ((Launch)this.launch.get()).finishTestItem(itemId, rq);
        return endTime;
    }

    @Nullable
    protected String mapItemStatus(@Nullable Status status) {
        if (status == null) {
            return null;
        }
        if (Utils.STATUS_MAPPING.get(status) == null) {
            LOGGER.error(String.format("Unable to find direct mapping between Cucumber and ReportPortal for TestItem with status: '%s'.", status));
            return ItemStatus.SKIPPED.name();
        }
        return Utils.STATUS_MAPPING.get(status).name();
    }

    @Nonnull
    protected String mapLevel(@Nullable Status cukesStatus) {
        if (cukesStatus == null) {
            return "ERROR";
        }
        String level = Utils.LOG_LEVEL_MAPPING.get(cukesStatus);
        return null == level ? "ERROR" : level;
    }

    @Nonnull
    protected String buildMultilineArgument(@Nonnull TestStep step) {
        List table = null;
        String dockString = EMPTY;
        PickleStepTestStep pickleStep = (PickleStepTestStep)step;
        if (pickleStep.getStep().getArgument() != null) {
            StepArgument argument = pickleStep.getStep().getArgument();
            if (argument instanceof DocStringArgument) {
                dockString = ((DocStringArgument)argument).getContent();
            } else if (argument instanceof DataTableArgument) {
                table = ((DataTableArgument)argument).cells();
            }
        }
        StringBuilder marg = new StringBuilder();
        if (table != null) {
            marg.append(NEW_LINE);
            for (List row : table) {
                marg.append(TABLE_INDENT).append(TABLE_SEPARATOR);
                for (String cell : row) {
                    marg.append(ONE_SPACE).append(cell).append(ONE_SPACE).append(TABLE_SEPARATOR);
                }
                marg.append(NEW_LINE);
            }
        }
        if (!dockString.isEmpty()) {
            marg.append(DOCSTRING_DECORATOR).append(dockString).append(DOCSTRING_DECORATOR);
        }
        return marg.toString();
    }

    @Nonnull
    protected Set<ItemAttributesRQ> extractAttributes(@Nonnull List<?> tags) {
        return tags.stream().map(s -> {
            String tagValue = s instanceof Tag ? ((Tag)s).getName() : s.toString();
            return new ItemAttributesRQ(null, tagValue);
        }).collect(Collectors.toSet());
    }

    @Nullable
    protected Set<ItemAttributesRQ> getAttributes(@Nonnull TestStep testStep) {
        Field definitionMatchField = Utils.getDefinitionMatchField(testStep);
        if (definitionMatchField != null) {
            try {
                Method method = Utils.retrieveMethod(definitionMatchField, testStep);
                Attributes attributesAnnotation = method.getAnnotation(Attributes.class);
                if (attributesAnnotation != null) {
                    return AttributeParser.retrieveAttributes((Attributes)attributesAnnotation);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    protected String getCodeRef(@Nonnull TestStep testStep) {
        Field definitionMatchField = Utils.getDefinitionMatchField(testStep);
        if (definitionMatchField != null) {
            try {
                Object stepDefinitionMatch = definitionMatchField.get(testStep);
                Field stepDefinitionField = stepDefinitionMatch.getClass().getDeclaredField(STEP_DEFINITION_FIELD_NAME);
                stepDefinitionField.setAccessible(true);
                Object javaStepDefinition = stepDefinitionField.get(stepDefinitionMatch);
                Method getLocationMethod = javaStepDefinition.getClass().getMethod(GET_LOCATION_METHOD_NAME, new Class[0]);
                getLocationMethod.setAccessible(true);
                String fullCodeRef = String.valueOf(getLocationMethod.invoke(javaStepDefinition, new Object[0]));
                return fullCodeRef != null ? fullCodeRef.substring(0, fullCodeRef.indexOf(METHOD_OPENING_BRACKET)) : null;
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                return null;
            }
        }
        return null;
    }

    @Nonnull
    protected String getCodeRef(@Nonnull URI uri, int line) {
        return WORKING_DIRECTORY.relativize(uri) + ":" + line;
    }

    @Nonnull
    protected List<ParameterResource> getParameters(@Nullable String codeRef, @Nonnull TestStep testStep) {
        if (!(testStep instanceof PickleStepTestStep)) {
            return Collections.emptyList();
        }
        PickleStepTestStep pickleStepTestStep = (PickleStepTestStep)testStep;
        List arguments = pickleStepTestStep.getDefinitionArgument();
        List params = Optional.ofNullable(arguments).map(a -> IntStream.range(0, a.size()).mapToObj(i -> Pair.of((Object)("arg" + i), (Object)((Argument)a.get(i)).getValue())).collect(Collectors.toList())).orElse(Collections.emptyList());
        Optional.ofNullable(pickleStepTestStep.getStep().getArgument()).ifPresent(a -> {
            String value = a instanceof DocStringArgument ? ((DocStringArgument)a).getContent() : a.toString();
            params.add(Pair.of((Object)"arg", (Object)value));
        });
        return ParameterUtils.getParameters((String)codeRef, params);
    }

    @Nullable
    protected TestCaseIdEntry getTestCaseId(@Nonnull TestStep testStep, @Nullable String codeRef) {
        Field definitionMatchField = Utils.getDefinitionMatchField(testStep);
        List arguments = ((PickleStepTestStep)testStep).getDefinitionArgument();
        if (definitionMatchField != null) {
            try {
                Method method = Utils.retrieveMethod(definitionMatchField, testStep);
                return TestCaseIdUtils.getTestCaseId((TestCaseId)method.getAnnotation(TestCaseId.class), (Executable)method, (String)codeRef, Utils.ARGUMENTS_TRANSFORM.apply(arguments));
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
        return this.getTestCaseId(codeRef, arguments);
    }

    @Nullable
    protected TestCaseIdEntry getTestCaseId(@Nullable String codeRef, @Nullable List<Argument> arguments) {
        return TestCaseIdUtils.getTestCaseId((String)codeRef, Utils.ARGUMENTS_TRANSFORM.apply(arguments));
    }

    @Nonnull
    protected String getDescription(@Nonnull Feature feature, @Nonnull URI uri) {
        return uri.toString();
    }

    @Nonnull
    protected String getDescription(@Nonnull TestCase testCase, @Nonnull URI uri) {
        return uri.toString();
    }

    @Nonnull
    protected Pair<String, String> getHookTypeAndName(@Nonnull HookType hookType) {
        String name = null;
        String type = null;
        switch (hookType) {
            case BEFORE: {
                name = "Before hooks";
                type = "BEFORE_TEST";
                break;
            }
            case AFTER: {
                name = "After hooks";
                type = "AFTER_TEST";
                break;
            }
            case AFTER_STEP: {
                name = "After step";
                type = "AFTER_METHOD";
                break;
            }
            case BEFORE_STEP: {
                name = "Before step";
                type = "BEFORE_METHOD";
            }
        }
        return Pair.of(type, (Object)name);
    }
}

