/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import com.epam.reportportal.listeners.ItemStatus;
import io.cucumber.plugin.event.Argument;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestStep;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import rp.com.google.common.collect.ImmutableMap;

public class Utils {
    private static final String EMPTY = "";
    private static final String DEFINITION_MATCH_FIELD_NAME = "definitionMatch";
    private static final String STEP_DEFINITION_FIELD_NAME = "stepDefinition";
    private static final String METHOD_FIELD_NAME = "method";
    public static final Map<Status, ItemStatus> STATUS_MAPPING = ImmutableMap.builder().put((Object)Status.PASSED, (Object)ItemStatus.PASSED).put((Object)Status.FAILED, (Object)ItemStatus.FAILED).put((Object)Status.SKIPPED, (Object)ItemStatus.SKIPPED).put((Object)Status.PENDING, (Object)ItemStatus.SKIPPED).put((Object)Status.AMBIGUOUS, (Object)ItemStatus.SKIPPED).put((Object)Status.UNDEFINED, (Object)ItemStatus.SKIPPED).put((Object)Status.UNUSED, (Object)ItemStatus.SKIPPED).build();
    public static final Map<Status, String> LOG_LEVEL_MAPPING = ImmutableMap.builder().put((Object)Status.PASSED, (Object)"INFO").put((Object)Status.FAILED, (Object)"ERROR").put((Object)Status.SKIPPED, (Object)"WARN").put((Object)Status.PENDING, (Object)"WARN").put((Object)Status.AMBIGUOUS, (Object)"WARN").put((Object)Status.UNDEFINED, (Object)"WARN").put((Object)Status.UNUSED, (Object)"WARN").build();
    public static final Function<List<Argument>, List<?>> ARGUMENTS_TRANSFORM = arguments -> Optional.ofNullable(arguments).map(args -> args.stream().map(Argument::getValue).collect(Collectors.toList())).orElse(null);

    private Utils() {
        throw new AssertionError((Object)"No instances should exist for the class!");
    }

    public static String buildName(String prefix, String infix, String argument) {
        return (prefix == null ? EMPTY : prefix) + infix + argument;
    }

    public static Method retrieveMethod(Field definitionMatchField, TestStep testStep) throws IllegalAccessException, NoSuchFieldException {
        Object stepDefinitionMatch = definitionMatchField.get(testStep);
        Field stepDefinitionField = stepDefinitionMatch.getClass().getDeclaredField(STEP_DEFINITION_FIELD_NAME);
        stepDefinitionField.setAccessible(true);
        Object javaStepDefinition = stepDefinitionField.get(stepDefinitionMatch);
        Field methodField = javaStepDefinition.getClass().getSuperclass().getDeclaredField(METHOD_FIELD_NAME);
        methodField.setAccessible(true);
        return (Method)methodField.get(javaStepDefinition);
    }

    public static Field getDefinitionMatchField(TestStep testStep) {
        Class<?> clazz = testStep.getClass();
        try {
            return clazz.getField(DEFINITION_MATCH_FIELD_NAME);
        }
        catch (NoSuchFieldException e) {
            while (true) {
                try {
                    Field definitionMatchField = clazz.getDeclaredField(DEFINITION_MATCH_FIELD_NAME);
                    definitionMatchField.setAccessible(true);
                    return definitionMatchField;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    if ((clazz = clazz.getSuperclass()) != null) continue;
                    return null;
                }
                break;
            }
        }
    }
}

