/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import com.epam.reportportal.cucumber.AbstractReporter;
import com.epam.reportportal.listeners.ItemType;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.utils.MemoizingSupplier;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import io.cucumber.plugin.event.HookType;
import io.cucumber.plugin.event.TestStep;
import io.reactivex.Maybe;
import java.util.Calendar;
import java.util.Optional;
import javax.annotation.Nonnull;

public class ScenarioReporter
extends AbstractReporter {
    private static final String RP_STORY_TYPE = ItemType.SUITE.name();
    private static final String RP_TEST_TYPE = ItemType.STORY.name();
    private static final String RP_STEP_TYPE = ItemType.STEP.name();
    private static final String DUMMY_ROOT_SUITE_NAME = "Root User Story";
    protected MemoizingSupplier<Maybe<String>> rootSuiteId;

    @Override
    protected void beforeLaunch() {
        super.beforeLaunch();
        this.startRootItem();
    }

    @Override
    protected StartTestItemRQ buildStartStepRequest(TestStep testStep, String stepPrefix, String keyword) {
        StartTestItemRQ rq = super.buildStartStepRequest(testStep, stepPrefix, keyword);
        rq.setHasStats(false);
        return rq;
    }

    @Override
    protected void beforeStep(TestStep testStep) {
        super.beforeStep(testStep);
        String description = this.buildMultilineArgument(testStep).trim();
        if (!description.isEmpty()) {
            this.sendLog(description);
        }
    }

    @Override
    protected StartTestItemRQ buildStartHookRequest(HookType hookType) {
        StartTestItemRQ rq = super.buildStartHookRequest(hookType);
        rq.setHasStats(false);
        return rq;
    }

    @Override
    @Nonnull
    protected String getFeatureTestItemType() {
        return RP_TEST_TYPE;
    }

    @Override
    @Nonnull
    protected String getScenarioTestItemType() {
        return RP_STEP_TYPE;
    }

    @Override
    @Nonnull
    protected Optional<Maybe<String>> getRootItemId() {
        return Optional.of(this.rootSuiteId.get());
    }

    @Override
    protected void afterLaunch() {
        this.finishRootItem();
        super.afterLaunch();
    }

    protected void finishRootItem() {
        if (this.rootSuiteId.isInitialized()) {
            this.finishTestItem((Maybe<String>)((Maybe)this.rootSuiteId.get()));
            this.rootSuiteId = null;
        }
    }

    protected void startRootItem() {
        this.rootSuiteId = new MemoizingSupplier(() -> {
            StartTestItemRQ rq = new StartTestItemRQ();
            rq.setName(DUMMY_ROOT_SUITE_NAME);
            rq.setStartTime(Calendar.getInstance().getTime());
            rq.setType(RP_STORY_TYPE);
            return ((Launch)this.launch.get()).startTestItem(rq);
        });
    }
}

