/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.utils.reflect.Accessible;
import io.cucumber.plugin.event.Argument;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestStep;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Utils {
    private static final String EMPTY = "";
    private static final String DEFINITION_MATCH_FIELD_NAME = "definitionMatch";
    private static final String STEP_DEFINITION_FIELD_NAME = "stepDefinition";
    private static final String METHOD_FIELD_NAME = "method";
    public static final Map<Status, ItemStatus> STATUS_MAPPING = Collections.unmodifiableMap(new HashMap<Status, ItemStatus>(){
        {
            this.put(Status.PASSED, ItemStatus.PASSED);
            this.put(Status.FAILED, ItemStatus.FAILED);
            this.put(Status.SKIPPED, ItemStatus.SKIPPED);
            this.put(Status.PENDING, ItemStatus.SKIPPED);
            this.put(Status.AMBIGUOUS, ItemStatus.SKIPPED);
            this.put(Status.UNDEFINED, ItemStatus.SKIPPED);
            this.put(Status.UNUSED, ItemStatus.SKIPPED);
        }
    });
    public static final Map<Status, String> LOG_LEVEL_MAPPING = Collections.unmodifiableMap(new HashMap<Status, String>(){
        {
            this.put(Status.PASSED, "INFO");
            this.put(Status.FAILED, "ERROR");
            this.put(Status.SKIPPED, "WARN");
            this.put(Status.PENDING, "WARN");
            this.put(Status.AMBIGUOUS, "WARN");
            this.put(Status.UNDEFINED, "WARN");
            this.put(Status.UNUSED, "WARN");
        }
    });
    public static final Function<List<Argument>, List<?>> ARGUMENTS_TRANSFORM = arguments -> Optional.ofNullable(arguments).map(args -> args.stream().map(Argument::getValue).collect(Collectors.toList())).orElse(null);

    private Utils() {
        throw new AssertionError((Object)"No instances should exist for the class!");
    }

    public static String buildName(String prefix, String infix, String argument) {
        return (prefix == null ? EMPTY : prefix) + infix + argument;
    }

    public static Method retrieveMethod(Object stepDefinitionMatch) throws IllegalAccessException, NoSuchFieldException {
        Field stepDefinitionField = stepDefinitionMatch.getClass().getDeclaredField(STEP_DEFINITION_FIELD_NAME);
        stepDefinitionField.setAccessible(true);
        Object javaStepDefinition = stepDefinitionField.get(stepDefinitionMatch);
        Field methodField = javaStepDefinition.getClass().getSuperclass().getDeclaredField(METHOD_FIELD_NAME);
        methodField.setAccessible(true);
        return (Method)methodField.get(javaStepDefinition);
    }

    public static Object getDefinitionMatch(TestStep testStep) {
        try {
            return Accessible.on((Object)testStep).field(DEFINITION_MATCH_FIELD_NAME).getValue();
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }
}

