/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import com.epam.reportportal.cucumber.RuleContext;
import io.cucumber.plugin.event.Node;
import io.cucumber.plugin.event.TestCase;
import io.reactivex.Maybe;
import java.net.URI;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ScenarioContext {
    private final int line;
    private final URI uri;
    private final RuleContext rule;
    private final Node.Scenario scenario;
    private final Node.ScenarioOutline scenarioOutline;
    private final Node.Example example;
    private TestCase testCase;
    private Maybe<String> id = Maybe.empty();
    private Maybe<String> hookId = Maybe.empty();
    private Maybe<String> stepId = Maybe.empty();

    public ScenarioContext(@Nonnull URI scenarioFilePath, @Nullable RuleContext ruleNode, @Nonnull Node.Scenario scenarioNode) {
        this.uri = scenarioFilePath;
        this.rule = ruleNode;
        this.scenario = scenarioNode;
        this.scenarioOutline = null;
        this.example = null;
        this.line = this.scenario.getLocation().getLine();
    }

    public ScenarioContext(@Nonnull URI scenarioFilePath, @Nullable RuleContext ruleNode, @Nonnull Node.ScenarioOutline scenarioOutlineNode, @Nonnull Node.Example exampleNode) {
        this.uri = scenarioFilePath;
        this.rule = ruleNode;
        this.scenario = null;
        this.scenarioOutline = scenarioOutlineNode;
        this.example = exampleNode;
        this.line = this.scenarioOutline.getLocation().getLine();
    }

    public int getLine() {
        return this.line;
    }

    @Nonnull
    public Optional<TestCase> getTestCase() {
        return Optional.ofNullable(this.testCase);
    }

    public void setTestCase(@Nullable TestCase testCase) {
        this.testCase = testCase;
    }

    @Nonnull
    public Optional<RuleContext> getRule() {
        return Optional.ofNullable(this.rule);
    }

    @Nonnull
    public URI getUri() {
        return this.uri;
    }

    @Nonnull
    public Maybe<String> getId() {
        return this.id;
    }

    public void setId(@Nonnull Maybe<String> id) {
        this.id = id;
    }

    public void setHookId(@Nonnull Maybe<String> hookStepId) {
        this.hookId = hookStepId;
    }

    @Nonnull
    public Maybe<String> getHookId() {
        return this.hookId;
    }

    public void setStepId(@Nonnull Maybe<String> currentStepId) {
        this.stepId = currentStepId;
    }

    @Nonnull
    public Maybe<String> getStepId() {
        return this.stepId;
    }

    @Nonnull
    public Optional<Node.Example> getExample() {
        return Optional.ofNullable(this.example);
    }
}

