/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import com.epam.reportportal.cucumber.RuleContext;
import com.epam.reportportal.cucumber.Step;
import com.epam.reportportal.cucumber.util.HookSuite;
import io.cucumber.plugin.event.Node;
import io.cucumber.plugin.event.TestCase;
import io.reactivex.Maybe;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ScenarioContext {
    private final int line;
    private final RuleContext rule;
    private final Node.Scenario scenario;
    private final Node.ScenarioOutline scenarioOutline;
    private TestCase testCase;
    private Maybe<String> id = Maybe.empty();
    private Maybe<String> hookId = Maybe.empty();
    private Step step;
    private Step previousStep;
    private HookSuite hookSuite;

    public ScenarioContext(@Nullable RuleContext ruleNode, @Nonnull Node.Scenario scenarioNode) {
        this.rule = ruleNode;
        this.scenario = scenarioNode;
        this.scenarioOutline = null;
        this.line = this.scenario.getLocation().getLine();
    }

    public ScenarioContext(@Nullable RuleContext ruleNode, @Nonnull Node.ScenarioOutline scenarioOutlineNode) {
        this.rule = ruleNode;
        this.scenario = null;
        this.scenarioOutline = scenarioOutlineNode;
        this.line = this.scenarioOutline.getLocation().getLine();
    }

    public int getLine() {
        return this.line;
    }

    @Nonnull
    public Optional<TestCase> getTestCase() {
        return Optional.ofNullable(this.testCase);
    }

    public void setTestCase(@Nullable TestCase testCase) {
        this.testCase = testCase;
    }

    @Nonnull
    public Optional<RuleContext> getRule() {
        return Optional.ofNullable(this.rule);
    }

    @Nonnull
    public Maybe<String> getId() {
        return this.id;
    }

    public void setId(@Nonnull Maybe<String> id) {
        this.id = id;
    }

    @Nonnull
    public Optional<HookSuite> getHookSuite() {
        return Optional.ofNullable(this.hookSuite);
    }

    public void setHookSuite(@Nullable HookSuite hookSuite) {
        this.hookSuite = hookSuite;
    }

    public void setHookId(@Nonnull Maybe<String> hookStepId) {
        this.hookId = hookStepId;
    }

    @Nonnull
    public Maybe<String> getHookId() {
        return this.hookId;
    }

    public void setStep(@Nullable Step step) {
        this.step = step;
    }

    @Nonnull
    public Optional<Step> getStep() {
        return Optional.ofNullable(this.step);
    }

    public void setPreviousStep(@Nullable Step previousStep) {
        this.previousStep = previousStep;
    }

    @Nonnull
    public Optional<Step> getPreviousStep() {
        return Optional.ofNullable(this.previousStep);
    }
}

