/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import com.epam.reportportal.cucumber.FeatureContext;
import com.epam.reportportal.cucumber.RuleContext;
import com.epam.reportportal.cucumber.ScenarioContext;
import com.epam.reportportal.cucumber.Step;
import com.epam.reportportal.cucumber.Utils;
import com.epam.reportportal.cucumber.util.HookSuite;
import com.epam.reportportal.cucumber.util.ItemTreeUtils;
import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.listeners.ItemType;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.message.ReportPortalMessage;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.ReportPortal;
import com.epam.reportportal.service.tree.TestItemTree;
import com.epam.reportportal.utils.MemoizingSupplier;
import com.epam.reportportal.utils.ParameterUtils;
import com.epam.reportportal.utils.files.ByteSource;
import com.epam.reportportal.utils.formatting.MarkdownUtils;
import com.epam.reportportal.utils.http.ContentType;
import com.epam.reportportal.utils.properties.SystemAttributesExtractor;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.ParameterResource;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.DataTableArgument;
import io.cucumber.plugin.event.DocStringArgument;
import io.cucumber.plugin.event.EmbedEvent;
import io.cucumber.plugin.event.EventHandler;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.HookTestStep;
import io.cucumber.plugin.event.HookType;
import io.cucumber.plugin.event.Node;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.StepArgument;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestRunStarted;
import io.cucumber.plugin.event.TestSourceParsed;
import io.cucumber.plugin.event.TestStep;
import io.cucumber.plugin.event.TestStepFinished;
import io.cucumber.plugin.event.TestStepStarted;
import io.cucumber.plugin.event.WriteEvent;
import io.reactivex.Maybe;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScenarioReporter
implements ConcurrentEventListener {
    public static final String BACKGROUND_PREFIX = "BACKGROUND: ";
    protected static final URI WORKING_DIRECTORY = new File(System.getProperty("user.dir")).toURI();
    protected static final String DOCSTRING_DECORATOR = "\n\"\"\"\n";
    private static final Logger LOGGER = LoggerFactory.getLogger(ScenarioReporter.class);
    private static final ThreadLocal<ScenarioReporter> INSTANCES = new InheritableThreadLocal<ScenarioReporter>();
    private static final String AGENT_PROPERTIES_FILE = "agent.properties";
    private static final String COLON_INFIX = ": ";
    private static final String SKIPPED_ISSUE_KEY = "skippedIssue";
    private static final String DOC_STRING_PARAM = "DocString";
    private static final String DATA_TABLE_PARAM = "DataTable";
    private static final String UNKNOWN_PARAM = "arg";
    private static final String TEST_CASE_ID_PREFIX = "@tc_id:";
    private static final String ERROR_FORMAT = "Error:\n%s";
    private final Map<URI, FeatureContext> featureContextMap = new ConcurrentHashMap<URI, FeatureContext>();
    private final TestItemTree itemTree = new TestItemTree();
    private final ReportPortal rp = this.buildReportPortal();
    private final Map<URI, Date> featureEndTime = new ConcurrentHashMap<URI, Date>();
    private final Map<Maybe<String>, String> descriptionsMap = new ConcurrentHashMap<Maybe<String>, String>();
    private final Map<Maybe<String>, Throwable> errorMap = new ConcurrentHashMap<Maybe<String>, Throwable>();
    private final Supplier<Launch> launch = new MemoizingSupplier((Supplier)new Supplier<Launch>(){
        private final Date startTime = Calendar.getInstance().getTime();

        @Override
        public Launch get() {
            StartLaunchRQ rq = ScenarioReporter.this.buildStartLaunchRq(this.startTime, ScenarioReporter.this.getReportPortal().getParameters());
            Launch myLaunch = ScenarioReporter.this.getReportPortal().newLaunch(rq);
            ScenarioReporter.this.itemTree.setLaunchId(myLaunch.start());
            return myLaunch;
        }
    });

    public ScenarioReporter() {
        INSTANCES.set(this);
    }

    @Nonnull
    public static ScenarioReporter getCurrent() {
        return INSTANCES.get();
    }

    protected StartLaunchRQ buildStartLaunchRq(Date startTime, ListenerParameters parameters) {
        StartLaunchRQ rq = new StartLaunchRQ();
        rq.setName(parameters.getLaunchName());
        rq.setStartTime(startTime);
        rq.setMode(parameters.getLaunchRunningMode());
        HashSet<ItemAttributesRQ> attributes = new HashSet<ItemAttributesRQ>(parameters.getAttributes());
        rq.setAttributes(attributes);
        attributes.addAll(SystemAttributesExtractor.extract((String)AGENT_PROPERTIES_FILE, (ClassLoader)ScenarioReporter.class.getClassLoader()));
        rq.setDescription(parameters.getDescription());
        rq.setRerun(parameters.isRerun());
        if (StringUtils.isNotBlank((CharSequence)parameters.getRerunOf())) {
            rq.setRerunOf(parameters.getRerunOf());
        }
        if (null != parameters.getSkippedAnIssue()) {
            ItemAttributesRQ skippedIssueAttribute = new ItemAttributesRQ();
            skippedIssueAttribute.setKey(SKIPPED_ISSUE_KEY);
            skippedIssueAttribute.setValue(parameters.getSkippedAnIssue().toString());
            skippedIssueAttribute.setSystem(true);
            attributes.add(skippedIssueAttribute);
        }
        return rq;
    }

    @Nonnull
    public TestItemTree getItemTree() {
        return this.itemTree;
    }

    @Nonnull
    public ReportPortal getReportPortal() {
        return this.rp;
    }

    @Nonnull
    public Launch getLaunch() {
        return this.launch.get();
    }

    protected void beforeLaunch() {
        this.getLaunch();
    }

    protected ReportPortal buildReportPortal() {
        return ReportPortal.builder().build();
    }

    protected void afterLaunch() {
        FinishExecutionRQ finishLaunchRq = new FinishExecutionRQ();
        finishLaunchRq.setEndTime(Calendar.getInstance().getTime());
        this.getLaunch().finish(finishLaunchRq);
    }

    private void addToTree(Feature feature, TestCase testCase, Maybe<String> scenarioId) {
        ItemTreeUtils.retrieveLeaf(feature.getUri(), this.itemTree).ifPresent(suiteLeaf -> suiteLeaf.getChildItems().put(ItemTreeUtils.createKey(testCase.getLocation().getLine()), TestItemTree.createTestItemLeaf((Maybe)scenarioId)));
    }

    @Nonnull
    protected Set<ItemAttributesRQ> extractAttributes(@Nonnull Collection<?> tags) {
        return tags.stream().map(Object::toString).map(Utils::toAttribute).collect(Collectors.toSet());
    }

    private void execute(@Nonnull URI uri, @Nonnull FeatureContextAware context) {
        Optional<FeatureContext> feature = Optional.ofNullable(this.featureContextMap.get(uri));
        if (feature.isPresent()) {
            context.executeWithContext(feature.get());
        } else {
            LOGGER.warn("Unable to locate corresponding Feature for URI: {}", (Object)uri);
        }
    }

    private boolean isLineInExamplesTable(String line) {
        return line.startsWith("|") && line.endsWith("|");
    }

    private boolean isLineInExamplesTable(List<String> fileLines, int lineNumber) {
        if (lineNumber <= 0 || lineNumber > fileLines.size()) {
            return false;
        }
        String line = fileLines.get(lineNumber - 1).trim();
        return this.isLineInExamplesTable(line);
    }

    private int findHeaderRowIndex(List<String> fileLines, int lineNumber) {
        int previousLine;
        for (int i = previousLine = lineNumber - 2; i >= 0; --i) {
            String line = fileLines.get(i).trim();
            if (StringUtils.isNotBlank((CharSequence)line) && !this.isLineInExamplesTable(line)) {
                return previousLine;
            }
            if (!StringUtils.isNotBlank((CharSequence)line)) continue;
            previousLine = i;
        }
        return -1;
    }

    private List<String> extractTableCells(String tableRow) {
        return Arrays.stream(tableRow.split("\\|")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    @Nullable
    protected List<Pair<String, String>> getParameters(@Nonnull TestCase testCase) {
        List<String> fileLines;
        URI uri = testCase.getUri();
        int lineNumber = testCase.getLocation().getLine();
        try {
            fileLines = Files.readAllLines(Paths.get(uri));
        }
        catch (IOException e) {
            LOGGER.error("Failed to read feature file: {}", (Object)uri, (Object)e);
            return null;
        }
        if (!this.isLineInExamplesTable(fileLines, lineNumber)) {
            return null;
        }
        int headerRowIndex = this.findHeaderRowIndex(fileLines, lineNumber);
        if (headerRowIndex < 0) {
            return null;
        }
        String headerRow = fileLines.get(headerRowIndex).trim();
        List<String> paramNames = this.extractTableCells(headerRow);
        String valueRow = fileLines.get(lineNumber - 1).trim();
        List<String> paramValues = this.extractTableCells(valueRow);
        if (paramValues.isEmpty() || paramNames.size() != paramValues.size()) {
            return null;
        }
        return IntStream.range(0, paramNames.size()).mapToObj(i -> Pair.of((Object)((String)paramNames.get(i)), (Object)((String)paramValues.get(i)))).collect(Collectors.toList());
    }

    @Nonnull
    protected String getCodeRef(@Nonnull TestCase testCase, @Nullable List<Pair<String, String>> parameters) {
        URI uri = testCase.getUri();
        String relativePath = WORKING_DIRECTORY.relativize(uri).toString();
        String baseCodeRef = relativePath + "/[SCENARIO:" + testCase.getName() + "]";
        if (parameters == null) {
            return baseCodeRef;
        }
        return relativePath + "/[EXAMPLE:" + testCase.getName() + Utils.formatParameters(parameters) + "]";
    }

    protected Set<ItemAttributesRQ> getAttributes(TestCase testCase) {
        Set tags = testCase.getTags().stream().filter(t -> !t.startsWith(TEST_CASE_ID_PREFIX)).collect(Collectors.toSet());
        this.execute(testCase.getUri(), (FeatureContext f) -> tags.removeAll(f.getTags()));
        return this.extractAttributes(tags);
    }

    @Nonnull
    protected String getTestCaseId(@Nonnull TestCase testCase, @Nullable List<Pair<String, String>> parameters) {
        List tags = testCase.getTags().stream().filter(t -> t.startsWith(TEST_CASE_ID_PREFIX)).collect(Collectors.toList());
        return tags.isEmpty() ? this.getCodeRef(testCase, parameters) : ((String)tags.get(0)).substring(TEST_CASE_ID_PREFIX.length()) + (parameters == null || parameters.isEmpty() ? "" : Utils.formatParameters(parameters));
    }

    @Nonnull
    protected StartTestItemRQ buildStartScenarioRequest(@Nonnull TestCase testCase) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(Utils.buildName(testCase.getKeyword(), COLON_INFIX, testCase.getName()));
        List<Pair<String, String>> parameters = this.getParameters(testCase);
        rq.setParameters(ParameterUtils.getParameters((String)null, parameters));
        String codeRef = this.getCodeRef(testCase, parameters);
        rq.setCodeRef(codeRef);
        rq.setAttributes(this.getAttributes(testCase));
        rq.setStartTime(Calendar.getInstance().getTime());
        String type = ItemType.STEP.name();
        rq.setType(type);
        rq.setTestCaseId(this.getTestCaseId(testCase, parameters));
        return rq;
    }

    @Nonnull
    protected Maybe<String> startScenario(@Nonnull Maybe<String> featureId, @Nonnull StartTestItemRQ startScenarioRq) {
        return this.getLaunch().startTestItem(featureId, startScenarioRq);
    }

    private void execute(@Nonnull TestCase testCase, @Nonnull ScenarioContextAware context) {
        URI uri = testCase.getUri();
        int line = testCase.getLocation().getLine();
        this.execute(uri, (FeatureContext f) -> {
            Optional<ScenarioContext> scenario = f.getScenario(line);
            if (scenario.isPresent()) {
                context.executeWithContext(f, scenario.get());
            } else {
                LOGGER.warn("Unable to locate corresponding Feature or Scenario context for URI: {}; line: {}", (Object)uri, (Object)line);
            }
        });
    }

    protected Date finishTestItem(@Nullable Maybe<String> itemId, @Nullable ItemStatus status, @Nullable Date dateTime) {
        if (itemId == null) {
            LOGGER.error("BUG: Trying to finish unspecified test item.");
            return null;
        }
        Date endTime = Optional.ofNullable(dateTime).orElse(Calendar.getInstance().getTime());
        FinishTestItemRQ rq = this.buildFinishTestItemRequest(itemId, endTime, status);
        this.getLaunch().finishTestItem(itemId, rq);
        return endTime;
    }

    protected void finishTestItem(@Nullable Maybe<String> itemId, @Nullable ItemStatus status) {
        this.finishTestItem(itemId, status, null);
    }

    protected void finishTestItem(@Nullable Maybe<String> itemId) {
        this.finishTestItem(itemId, null);
    }

    private void removeFromTree(Feature featureContext, TestCase scenarioContext) {
        ItemTreeUtils.retrieveLeaf(featureContext.getUri(), this.itemTree).ifPresent(suiteLeaf -> suiteLeaf.getChildItems().remove(ItemTreeUtils.createKey(scenarioContext.getLocation().getLine())));
    }

    @Nonnull
    protected Maybe<String> startHook(@Nonnull Maybe<String> parentId, @Nonnull StartTestItemRQ rq) {
        return this.getLaunch().startTestItem(parentId, rq);
    }

    protected void beforeHooksSuite(@Nonnull TestCase testCase, @Nonnull HookTestStep testStep) {
        this.execute(testCase, (FeatureContext f, ScenarioContext s) -> {
            Maybe parentId;
            Optional<HookSuite> hookSuiteOptional;
            HookType hookType = testStep.getHookType();
            if (hookType == (hookSuiteOptional = s.getHookSuite()).map(HookSuite::getType).orElse(null)) {
                return;
            }
            if (hookType == HookType.BEFORE_STEP) {
                Maybe virtualStepId = this.getLaunch().createVirtualItem();
                s.setStep(new Step((Maybe<String>)virtualStepId, Step.Type.VIRTUAL));
                parentId = virtualStepId;
            } else {
                parentId = hookType == HookType.AFTER_STEP ? s.getPreviousStep().map(Step::getId).orElseGet(() -> {
                    LOGGER.warn("Unable to locate step ID for AFTER_STEP hook. Using scenario ID as parent.");
                    return s.getId();
                }) : s.getId();
            }
            hookSuiteOptional.map(hookSuite -> {
                this.finishTestItem(hookSuite.getId(), hookSuite.getStatus());
                StartTestItemRQ hookSuiteRq = this.buildStartHookSuiteRequest(testStep);
                Maybe<String> hookSuiteId = this.startHook((Maybe<String>)parentId, hookSuiteRq);
                s.setHookSuite(new HookSuite(hookSuiteId, hookType, ItemStatus.PASSED));
                return true;
            }).orElseGet(() -> {
                StartTestItemRQ hookSuiteRq = this.buildStartHookSuiteRequest(testStep);
                Maybe<String> hookSuiteId = this.startHook((Maybe<String>)parentId, hookSuiteRq);
                s.setHookSuite(new HookSuite(hookSuiteId, hookType, ItemStatus.PASSED));
                return false;
            });
        });
    }

    protected void afterHooksSuite(@Nonnull TestCase testCase) {
        this.execute(testCase, (FeatureContext f, ScenarioContext s) -> {
            Optional<HookSuite> hookSuite = s.getHookSuite();
            hookSuite.ifPresent(suite -> {
                this.finishTestItem(suite.getId(), suite.getStatus());
                s.setHookSuite(null);
            });
        });
    }

    protected void afterScenario(TestCaseFinished event) {
        TestCase testCase = event.getTestCase();
        this.afterHooksSuite(testCase);
        this.execute(testCase, (FeatureContext f, ScenarioContext s) -> {
            URI featureUri = f.getUri();
            if (this.mapItemStatus(event.getResult().getStatus()) == ItemStatus.FAILED) {
                Optional.ofNullable(event.getResult().getError()).ifPresent(error -> this.errorMap.put(s.getId(), (Throwable)error));
            }
            Date endTime = this.finishTestItem(s.getId(), this.mapItemStatus(event.getResult().getStatus()), null);
            this.featureEndTime.put(featureUri, endTime);
            this.removeFromTree(f.getFeature(), testCase);
        });
    }

    @Nullable
    protected String getStepName(@Nonnull PickleStepTestStep testStep) {
        return testStep.getStep().getText();
    }

    @Nonnull
    protected List<ParameterResource> getParameters(@Nonnull TestStep testStep) {
        if (!(testStep instanceof PickleStepTestStep)) {
            return Collections.emptyList();
        }
        PickleStepTestStep pickleStepTestStep = (PickleStepTestStep)testStep;
        List arguments = pickleStepTestStep.getDefinitionArgument();
        List params = Optional.ofNullable(arguments).map(a -> a.stream().map(arg -> Pair.of((Object)arg.getParameterTypeName(), (Object)arg.getValue())).collect(Collectors.toList())).orElse(new ArrayList());
        Optional.ofNullable(pickleStepTestStep.getStep().getArgument()).ifPresent(a -> {
            if (a instanceof DocStringArgument) {
                String value = ((DocStringArgument)a).getContent();
                params.add(Pair.of((Object)DOC_STRING_PARAM, (Object)value));
            } else if (a instanceof DataTableArgument) {
                params.add(Pair.of((Object)DATA_TABLE_PARAM, (Object)this.formatDataTable(((DataTableArgument)a).cells())));
            } else {
                params.add(Pair.of((Object)UNKNOWN_PARAM, (Object)a.toString()));
            }
        });
        return ParameterUtils.getParameters((String)null, (List)params);
    }

    @Nonnull
    protected StartTestItemRQ buildStartStepRequest(@Nonnull PickleStepTestStep testStep, @Nullable String stepPrefix, @Nullable String keyword) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(Utils.buildName(stepPrefix, keyword, this.getStepName(testStep)));
        rq.setDescription(this.buildMultilineArgument((TestStep)testStep));
        rq.setStartTime(Calendar.getInstance().getTime());
        rq.setType("STEP");
        rq.setParameters(this.getParameters((TestStep)testStep));
        rq.setHasStats(false);
        return rq;
    }

    @Nonnull
    protected Maybe<String> startVirtualStep(@Nonnull Maybe<String> scenarioId, @Nonnull Maybe<String> virtualStepId, @Nonnull StartTestItemRQ startStepRq) {
        return this.getLaunch().startVirtualTestItem(scenarioId, virtualStepId, startStepRq);
    }

    @Nonnull
    protected Maybe<String> startStep(@Nonnull Maybe<String> scenarioId, @Nonnull StartTestItemRQ startStepRq) {
        return this.getLaunch().startTestItem(scenarioId, startStepRq);
    }

    private void addToTree(@Nonnull TestCase scenario, @Nullable String text, @Nullable Maybe<String> stepId) {
        ItemTreeUtils.retrieveLeaf(scenario.getUri(), scenario.getLocation().getLine(), this.itemTree).ifPresent(scenarioLeaf -> scenarioLeaf.getChildItems().put(ItemTreeUtils.createKey(text), TestItemTree.createTestItemLeaf((Maybe)stepId)));
    }

    protected void beforeStep(@Nonnull TestCase testCase, @Nonnull PickleStepTestStep step) {
        this.execute(testCase, (FeatureContext f, ScenarioContext s) -> {
            this.afterHooksSuite(testCase);
            String stepPrefix = step.getStep().getLocation().getLine() < s.getLine() ? BACKGROUND_PREFIX : null;
            StartTestItemRQ rq = this.buildStartStepRequest(step, stepPrefix, step.getStep().getKeyword());
            Optional<Step> currentStepOptional = s.getStep();
            Maybe stepId = currentStepOptional.map(currentStep -> {
                Maybe<String> sId;
                if (currentStep.getType() == Step.Type.VIRTUAL) {
                    rq.setStartTime(currentStep.getTimestamp());
                    sId = this.startVirtualStep(s.getId(), currentStep.getId(), rq);
                } else {
                    LOGGER.warn("Unexpected state: starting a step when another step of type NORMAL is active. This might indicate an unfinished step. Step: {}: {}", (Object)step.getStep().getKeyword(), (Object)step.getStep().getText());
                    sId = this.startStep(s.getId(), rq);
                }
                s.setStep(new Step(sId, Step.Type.NORMAL));
                return sId;
            }).orElseGet(() -> {
                Maybe<String> sId = this.startStep(s.getId(), rq);
                s.setStep(new Step(sId, Step.Type.NORMAL));
                return sId;
            });
            String stepText = step.getStep().getText();
            if (this.getLaunch().getParameters().isCallbackReportingEnabled()) {
                this.addToTree(testCase, stepText, (Maybe<String>)stepId);
            }
        });
        String description = this.buildMultilineArgument((TestStep)step).trim();
        if (!description.isEmpty()) {
            this.sendLog(description);
        }
    }

    protected void afterStep(@Nonnull TestCase testCase, @Nonnull PickleStepTestStep testStep, @Nonnull Result result) {
        this.execute(testCase, (FeatureContext f, ScenarioContext s) -> {
            this.reportResult(result, null);
            Optional<Step> optionalStep = s.getStep();
            if (optionalStep.isPresent()) {
                Step step = optionalStep.get();
                if (step.getType() == Step.Type.NORMAL) {
                    if (this.mapItemStatus(result.getStatus()) == ItemStatus.FAILED) {
                        Optional.ofNullable(result.getError()).ifPresent(error -> this.errorMap.put(step.getId(), (Throwable)error));
                    }
                    this.finishTestItem(step.getId(), this.mapItemStatus(result.getStatus()), null);
                    s.setPreviousStep(step);
                } else {
                    LOGGER.error("BUG: Trying to finish virtual step item: {}: {}", (Object)testStep.getStep().getKeyword(), (Object)testStep.getStep().getText());
                }
                s.setStep(null);
            } else {
                LOGGER.error("BUG: Trying to finish unspecified step item: {}: {}", (Object)testStep.getStep().getKeyword(), (Object)testStep.getStep().getText());
            }
        });
    }

    @Nonnull
    protected String getHookName(@Nonnull HookType hookType) {
        switch (hookType) {
            case BEFORE: {
                return "Before hooks";
            }
            case AFTER: {
                return "After hooks";
            }
            case AFTER_STEP: {
                return "After step";
            }
            case BEFORE_STEP: {
                return "Before step";
            }
        }
        return "Hook";
    }

    protected StartTestItemRQ buildStartHookSuiteRequest(@Nonnull HookTestStep testStep) {
        StartTestItemRQ rq = new StartTestItemRQ();
        String name = this.getHookName(testStep.getHookType());
        rq.setName(name);
        rq.setType(ItemType.STEP.name());
        rq.setStartTime(Calendar.getInstance().getTime());
        rq.setHasStats(false);
        return rq;
    }

    @Nonnull
    protected StartTestItemRQ buildStartHookRequest(@Nonnull TestCase testCase, @Nonnull HookTestStep testStep) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(testStep.getCodeLocation());
        rq.setType(ItemType.STEP.name());
        rq.setStartTime(Calendar.getInstance().getTime());
        rq.setHasStats(false);
        return rq;
    }

    protected void beforeHooks(@Nonnull TestCase testCase, @Nonnull HookTestStep testStep) {
        this.execute(testCase, (FeatureContext f, ScenarioContext s) -> {
            this.beforeHooksSuite(testCase, testStep);
            StartTestItemRQ rq = this.buildStartHookRequest(testCase, testStep);
            Optional<HookSuite> hookSuite = s.getHookSuite();
            s.setHookId(this.startHook((Maybe<String>)hookSuite.map(HookSuite::getId).orElseGet(s::getId), rq));
        });
    }

    protected void afterHooks(@Nonnull TestCase testCase, @Nonnull HookTestStep step, Result result) {
        this.execute(testCase, (FeatureContext f, ScenarioContext s) -> {
            this.reportResult(result, (this.isBefore(step) ? "Before" : "After") + " hook: " + step.getCodeLocation());
            ItemStatus hookStatus = this.mapItemStatus(result.getStatus());
            this.finishTestItem(s.getHookId(), hookStatus);
            s.setHookId((Maybe<String>)Maybe.empty());
            Optional<HookSuite> hookSuite = s.getHookSuite();
            if (hookSuite.isEmpty() || hookStatus == null) {
                return;
            }
            hookSuite.get().updateStatus(hookStatus);
        });
    }

    protected void reportResult(@Nonnull Result result, @Nullable String message) {
        Throwable error;
        String level = this.mapLevel(result.getStatus());
        if (message != null) {
            this.sendLog(message, level);
        }
        if ((error = result.getError()) != null) {
            this.sendLog(this.getReportPortal().getParameters().isExceptionTruncate() ? com.epam.reportportal.utils.formatting.ExceptionUtils.getStackTrace((Throwable)error, (Throwable)new Throwable()) : ExceptionUtils.getStackTrace((Throwable)error), level);
        }
    }

    protected void embedding(@Nullable String name, @Nullable String mimeType, @Nonnull byte[] data) {
        String type = Optional.ofNullable(mimeType).filter(ContentType::isValidType).orElseGet(() -> Utils.getDataType(data, name));
        String attachmentName = Optional.ofNullable(name).filter(m -> !m.isEmpty()).orElseGet(() -> Optional.ofNullable(type).map(t -> t.substring(0, t.indexOf("/"))).orElse(""));
        ReportPortal.emitLog((ReportPortalMessage)new ReportPortalMessage(ByteSource.wrap((byte[])data), type, attachmentName), (String)"UNKNOWN", (Date)Calendar.getInstance().getTime());
    }

    protected void sendLog(@Nullable String message) {
        this.sendLog(message, "INFO");
    }

    protected void sendLog(@Nullable String message, @Nullable String level) {
        ReportPortal.emitLog((String)message, (String)level, (Date)Calendar.getInstance().getTime());
    }

    private boolean isBefore(@Nonnull HookTestStep step) {
        return HookType.BEFORE == step.getHookType();
    }

    @Nonnull
    protected StartTestItemRQ buildStartRuleRequest(@Nonnull Node.Rule rule) {
        String ruleKeyword = rule.getKeyword().orElse("Rule");
        String ruleName = rule.getName().orElse(null);
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(ruleName != null ? Utils.buildName(ruleKeyword, COLON_INFIX, ruleName) : ruleKeyword);
        rq.setStartTime(Calendar.getInstance().getTime());
        rq.setAttributes(this.extractAttributes(Utils.getTags(rule)));
        rq.setType("SUITE");
        return rq;
    }

    @Nonnull
    protected Maybe<String> startRule(@Nonnull Maybe<String> featureId, @Nonnull StartTestItemRQ ruleRq) {
        return this.getLaunch().startTestItem(featureId, ruleRq);
    }

    protected void beforeScenario(@Nonnull Feature feature, @Nonnull TestCase scenario) {
        this.execute(scenario, (FeatureContext f, ScenarioContext s) -> {
            Optional<RuleContext> rule = s.getRule();
            Optional<RuleContext> currentRule = f.getCurrentRule();
            if (!currentRule.equals(rule)) {
                if (currentRule.isEmpty()) {
                    rule.ifPresent(r -> {
                        r.setId(this.startRule(f.getId(), this.buildStartRuleRequest(r.getRule())));
                        f.setCurrentRule((RuleContext)r);
                    });
                } else {
                    this.finishTestItem(currentRule.get().getId());
                    rule.ifPresent(r -> {
                        r.setId(this.startRule(f.getId(), this.buildStartRuleRequest(r.getRule())));
                        f.setCurrentRule((RuleContext)r);
                    });
                }
            }
            Maybe rootId = rule.map(RuleContext::getId).orElseGet(f::getId);
            StartTestItemRQ startTestItemRQ = this.buildStartScenarioRequest(scenario);
            s.setId(this.startScenario((Maybe<String>)rootId, startTestItemRQ));
            this.descriptionsMap.put(s.getId(), Optional.ofNullable(startTestItemRQ.getDescription()).orElse(""));
            if (this.getLaunch().getParameters().isCallbackReportingEnabled()) {
                this.addToTree(feature, scenario, s.getId());
            }
        });
    }

    @Nonnull
    protected String getCodeRef(@Nonnull Feature feature) {
        return WORKING_DIRECTORY.relativize(feature.getUri()).toString();
    }

    @Nonnull
    protected StartTestItemRQ buildStartFeatureRequest(@Nonnull Feature feature, @Nonnull URI uri) {
        String featureKeyword = feature.getKeyword().orElse("");
        String featureName = feature.getName().orElse(this.getCodeRef(feature));
        StartTestItemRQ startFeatureRq = new StartTestItemRQ();
        startFeatureRq.setDescription(this.getDescription(feature, uri));
        startFeatureRq.setName(Utils.buildName(featureKeyword, COLON_INFIX, featureName));
        this.execute(feature.getUri(), (FeatureContext f) -> startFeatureRq.setAttributes(this.extractAttributes(f.getTags())));
        startFeatureRq.setStartTime(Calendar.getInstance().getTime());
        startFeatureRq.setType(ItemType.STORY.name());
        return startFeatureRq;
    }

    @Nonnull
    protected Maybe<String> startFeature(@Nonnull StartTestItemRQ startFeatureRq) {
        return this.getLaunch().startTestItem(startFeatureRq);
    }

    private void addToTree(Feature feature, Maybe<String> featureId) {
        this.getItemTree().getTestItems().put(ItemTreeUtils.createKey(feature.getUri()), TestItemTree.createTestItemLeaf(featureId));
    }

    protected void handleStartOfTestCase(@Nonnull TestCaseStarted event) {
        TestCase testCase = event.getTestCase();
        URI uri = testCase.getUri();
        this.execute(uri, (FeatureContext f) -> {
            if (f.getId().equals((Object)Maybe.empty())) {
                StartTestItemRQ featureRq = this.buildStartFeatureRequest(f.getFeature(), uri);
                f.setId(this.startFeature(featureRq));
                if (this.getLaunch().getParameters().isCallbackReportingEnabled()) {
                    this.addToTree(f.getFeature(), f.getId());
                }
            }
        });
        this.execute(testCase, (FeatureContext f, ScenarioContext s) -> {
            s.setTestCase(testCase);
            this.beforeScenario(f.getFeature(), testCase);
        });
    }

    protected void handleSourceEvents(TestSourceParsed parseEvent) {
        parseEvent.getNodes().forEach(n -> {
            if (n instanceof Feature) {
                Feature feature = (Feature)n;
                this.featureContextMap.put(feature.getUri(), new FeatureContext(feature));
            } else {
                LOGGER.warn("Unknown node type: {}", (Object)n.getClass().getSimpleName());
            }
        });
    }

    protected void handleTestStepStarted(@Nonnull TestStepStarted event) {
        TestStep testStep = event.getTestStep();
        TestCase testCase = event.getTestCase();
        if (testStep instanceof HookTestStep) {
            this.beforeHooks(testCase, (HookTestStep)testStep);
        } else if (testStep instanceof PickleStepTestStep) {
            this.afterHooksSuite(testCase);
            this.beforeStep(testCase, (PickleStepTestStep)testStep);
        } else {
            LOGGER.warn("Unable to start unknown step type: {}", (Object)testStep.getClass().getSimpleName());
        }
    }

    protected void handleTestStepFinished(@Nonnull TestStepFinished event) {
        TestStep testStep = event.getTestStep();
        TestCase testCase = event.getTestCase();
        if (testStep instanceof HookTestStep) {
            this.afterHooks(testCase, (HookTestStep)testStep, event.getResult());
        } else if (testStep instanceof PickleStepTestStep) {
            this.afterStep(testCase, (PickleStepTestStep)testStep, event.getResult());
        } else {
            LOGGER.warn("Unable to finish unknown step type: {}", (Object)testStep.getClass().getSimpleName());
        }
    }

    private void removeFromTree(Feature feature) {
        this.itemTree.getTestItems().remove(ItemTreeUtils.createKey(feature.getUri()));
    }

    protected void handleEndOfFeature() {
        this.featureContextMap.values().forEach(f -> {
            Date featureCompletionDateTime = this.featureEndTime.get(f.getUri());
            f.getCurrentRule().ifPresent(r -> this.finishTestItem(r.getId(), null, featureCompletionDateTime));
            this.finishTestItem(f.getId(), null, featureCompletionDateTime);
            this.removeFromTree(f.getFeature());
        });
        this.featureContextMap.clear();
    }

    protected EventHandler<TestRunStarted> getTestRunStartedHandler() {
        return event -> this.beforeLaunch();
    }

    protected EventHandler<TestSourceParsed> getTestSourceParsedHandler() {
        return this::handleSourceEvents;
    }

    protected EventHandler<TestCaseStarted> getTestCaseStartedHandler() {
        return this::handleStartOfTestCase;
    }

    protected EventHandler<TestStepStarted> getTestStepStartedHandler() {
        return this::handleTestStepStarted;
    }

    protected EventHandler<TestStepFinished> getTestStepFinishedHandler() {
        return this::handleTestStepFinished;
    }

    protected EventHandler<TestCaseFinished> getTestCaseFinishedHandler() {
        return this::afterScenario;
    }

    protected EventHandler<TestRunFinished> getTestRunFinishedHandler() {
        return event -> {
            this.handleEndOfFeature();
            this.afterLaunch();
        };
    }

    protected EventHandler<EmbedEvent> getEmbedEventHandler() {
        return event -> this.embedding(event.getName(), event.getMediaType(), event.getData());
    }

    protected EventHandler<WriteEvent> getWriteEventHandler() {
        return event -> this.sendLog(event.getText());
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestRunStarted.class, this.getTestRunStartedHandler());
        publisher.registerHandlerFor(TestRunFinished.class, this.getTestRunFinishedHandler());
        publisher.registerHandlerFor(TestSourceParsed.class, this.getTestSourceParsedHandler());
        publisher.registerHandlerFor(TestCaseStarted.class, this.getTestCaseStartedHandler());
        publisher.registerHandlerFor(TestCaseFinished.class, this.getTestCaseFinishedHandler());
        publisher.registerHandlerFor(TestStepStarted.class, this.getTestStepStartedHandler());
        publisher.registerHandlerFor(TestStepFinished.class, this.getTestStepFinishedHandler());
        publisher.registerHandlerFor(EmbedEvent.class, this.getEmbedEventHandler());
        publisher.registerHandlerFor(WriteEvent.class, this.getWriteEventHandler());
    }

    @Nonnull
    protected FinishTestItemRQ buildFinishTestItemRequest(@Nonnull Maybe<String> itemId, @Nullable Date finishTime, @Nullable ItemStatus status) {
        FinishTestItemRQ rq = new FinishTestItemRQ();
        if (status == ItemStatus.FAILED) {
            Optional<String> currentDescription = Optional.ofNullable(this.descriptionsMap.remove(itemId));
            Optional<Throwable> currentError = Optional.ofNullable(this.errorMap.remove(itemId));
            currentDescription.flatMap(description -> currentError.map(errorMessage -> this.resolveDescriptionErrorMessage((String)description, (Throwable)errorMessage))).ifPresent(arg_0 -> ((FinishTestItemRQ)rq).setDescription(arg_0));
        }
        Optional.ofNullable(status).ifPresent(s -> rq.setStatus(s.name()));
        rq.setEndTime(finishTime);
        return rq;
    }

    private String resolveDescriptionErrorMessage(String currentDescription, Throwable error) {
        String errorStr = this.getReportPortal().getParameters().isExceptionTruncate() ? String.format(ERROR_FORMAT, com.epam.reportportal.utils.formatting.ExceptionUtils.getStackTrace((Throwable)error, (Throwable)new Throwable())) : String.format(ERROR_FORMAT, ExceptionUtils.getStackTrace((Throwable)error));
        return Optional.ofNullable(currentDescription).filter(StringUtils::isNotBlank).map(description -> MarkdownUtils.asTwoParts((String)currentDescription, (String)errorStr)).orElse(errorStr);
    }

    @Nullable
    protected ItemStatus mapItemStatus(@Nullable Status status) {
        if (status == null) {
            return null;
        }
        if (Utils.STATUS_MAPPING.get(status) == null) {
            LOGGER.error("Unable to find direct mapping between Cucumber and ReportPortal for TestItem with status: '{}'.", (Object)status);
            return ItemStatus.SKIPPED;
        }
        return Utils.STATUS_MAPPING.get(status);
    }

    @Nonnull
    protected String mapLevel(@Nullable Status cukesStatus) {
        if (cukesStatus == null) {
            return "ERROR";
        }
        String level = Utils.LOG_LEVEL_MAPPING.get(cukesStatus);
        return null == level ? "ERROR" : level;
    }

    @Nonnull
    protected String formatDataTable(@Nonnull List<List<String>> table) {
        return MarkdownUtils.formatDataTable(table);
    }

    @Nonnull
    protected String buildMultilineArgument(@Nonnull TestStep step) {
        List table = null;
        String docString = null;
        PickleStepTestStep pickleStep = (PickleStepTestStep)step;
        if (pickleStep.getStep().getArgument() != null) {
            StepArgument argument = pickleStep.getStep().getArgument();
            if (argument instanceof DocStringArgument) {
                docString = ((DocStringArgument)argument).getContent();
            } else if (argument instanceof DataTableArgument) {
                table = ((DataTableArgument)argument).cells();
            }
        }
        StringBuilder marg = new StringBuilder();
        if (table != null) {
            marg.append(this.formatDataTable(table));
        }
        if (docString != null) {
            marg.append(DOCSTRING_DECORATOR).append(docString).append(DOCSTRING_DECORATOR);
        }
        return marg.toString();
    }

    @Nonnull
    protected String getDescription(Feature feature, @Nonnull URI uri) {
        return uri.toString();
    }

    @Nonnull
    protected String getDescription(@Nonnull TestCase testCase, @Nonnull URI uri) {
        return uri.toString();
    }

    @FunctionalInterface
    private static interface ScenarioContextAware {
        public void executeWithContext(@Nonnull FeatureContext var1, @Nonnull ScenarioContext var2);
    }

    @FunctionalInterface
    private static interface FeatureContextAware {
        public void executeWithContext(@Nonnull FeatureContext var1);
    }
}

