/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.utils.MimeTypeDetector;
import com.epam.reportportal.utils.files.ByteSource;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.plugin.event.Node;
import io.cucumber.plugin.event.Status;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);
    private static final String EMPTY = "";
    public static final String TAG_KEY = "@";
    private static final String KEY_VALUE_SEPARATOR = ":";
    public static final Map<Status, ItemStatus> STATUS_MAPPING = Map.of(Status.PASSED, ItemStatus.PASSED, Status.FAILED, ItemStatus.FAILED, Status.SKIPPED, ItemStatus.SKIPPED, Status.PENDING, ItemStatus.SKIPPED, Status.AMBIGUOUS, ItemStatus.SKIPPED, Status.UNDEFINED, ItemStatus.SKIPPED, Status.UNUSED, ItemStatus.SKIPPED);
    public static final Map<Status, String> LOG_LEVEL_MAPPING = Map.of(Status.PASSED, "INFO", Status.FAILED, "ERROR", Status.SKIPPED, "WARN", Status.PENDING, "WARN", Status.AMBIGUOUS, "WARN", Status.UNDEFINED, "WARN", Status.UNUSED, "WARN");

    private Utils() {
        throw new AssertionError((Object)"No instances should exist for the class!");
    }

    public static String buildName(@Nullable String prefix, @Nullable String infix, @Nullable String argument) {
        return (prefix == null ? EMPTY : prefix) + infix + argument;
    }

    @Nonnull
    public static Set<String> getTags(@Nonnull Feature feature) {
        return feature.getKeyword().map(k -> {
            HashSet<String> tags = new HashSet<String>();
            for (String line : feature.getSource().split("\\r?\\n")) {
                String bareLine = line.trim();
                if (bareLine.startsWith((String)k)) {
                    return tags;
                }
                if (!line.startsWith(TAG_KEY)) continue;
                tags.addAll(Arrays.asList(line.split("\\s+")));
            }
            return tags;
        }).orElse(Collections.emptySet());
    }

    @Nonnull
    public static Set<String> getTags(@Nonnull Node.Rule rule) {
        return rule.getParent().map(p -> {
            if (!(p instanceof Feature)) {
                return Collections.emptySet();
            }
            Feature feature = (Feature)p;
            List featureChildren = feature.elements().stream().sorted(Comparator.comparing(n -> n.getLocation().getLine())).collect(Collectors.toList());
            int ruleIndex = IntStream.range(0, featureChildren.size()).filter(i -> ((Node)featureChildren.get(i)).equals(rule)).findFirst().orElse(-1);
            if (ruleIndex < 0) {
                return Collections.emptySet();
            }
            int lastLine = ruleIndex > 0 ? ((Node)featureChildren.get(ruleIndex - 1)).getLocation().getLine() : feature.getLocation().getLine();
            String[] lines = feature.getSource().split("\\r?\\n");
            HashSet<String> tags = new HashSet<String>();
            for (int i2 = rule.getLocation().getLine() - 1; i2 > lastLine; --i2) {
                String line = lines[i2].trim();
                if (!line.startsWith(TAG_KEY)) continue;
                tags.addAll(Arrays.asList(line.split("\\s+")));
            }
            return tags;
        }).orElse(Collections.emptySet());
    }

    public static ItemAttributesRQ toAttribute(String tag) {
        String tagStr = tag.trim();
        String string = tagStr = tagStr.startsWith(TAG_KEY) ? tagStr.substring(TAG_KEY.length()) : tagStr;
        if (tagStr.contains(KEY_VALUE_SEPARATOR)) {
            String[] parts = tagStr.split(KEY_VALUE_SEPARATOR, 2);
            return new ItemAttributesRQ(parts[0], parts[1]);
        }
        return new ItemAttributesRQ(null, tagStr);
    }

    @Nonnull
    public static String formatParameters(@Nonnull List<Pair<String, String>> parameters) {
        String paramString = parameters.stream().sorted().map(entry -> (String)entry.getKey() + KEY_VALUE_SEPARATOR + (String)entry.getValue()).collect(Collectors.joining(";"));
        return "[" + paramString + "]";
    }

    @Nullable
    public static String getDataType(@Nonnull byte[] data, @Nullable String name) {
        try {
            return MimeTypeDetector.detect((ByteSource)ByteSource.wrap((byte[])data), (String)name);
        }
        catch (IOException e) {
            LOGGER.warn("Unable to detect MIME type", (Throwable)e);
            return null;
        }
    }
}

