/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.junit;

import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.service.tree.TestItemTree;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;

public class ParallelRunningContext {
    private static final ThreadLocal<ParallelRunningContext> CONTEXT_THREAD_LOCAL = new ThreadLocal();
    private final TestItemTree itemTree = new TestItemTree();
    private final Map<FrameworkMethod, Description> testMethodDescription = new ConcurrentHashMap<FrameworkMethod, Description>();
    private final Map<TestItemTree.ItemTreeKey, ItemStatus> testStatus = new ConcurrentHashMap<TestItemTree.ItemTreeKey, ItemStatus>();
    private final Map<TestItemTree.ItemTreeKey, Throwable> testThrowable = new ConcurrentHashMap<TestItemTree.ItemTreeKey, Throwable>();

    public ParallelRunningContext() {
        CONTEXT_THREAD_LOCAL.set(this);
    }

    public ItemStatus getTestStatus(TestItemTree.ItemTreeKey test) {
        return this.testStatus.get(test);
    }

    public ItemStatus setTestStatus(TestItemTree.ItemTreeKey test, ItemStatus status) {
        return this.testStatus.put(test, status);
    }

    public ItemStatus computeTestStatusIfNo(TestItemTree.ItemTreeKey test, Function<TestItemTree.ItemTreeKey, ItemStatus> mappingFunction) {
        return this.testStatus.computeIfAbsent(test, mappingFunction);
    }

    public Throwable getTestThrowable(TestItemTree.ItemTreeKey test) {
        return this.testThrowable.get(test);
    }

    public void setTestThrowable(TestItemTree.ItemTreeKey test, Throwable throwable) {
        this.testThrowable.put(test, throwable);
    }

    public Description getTestMethodDescription(FrameworkMethod method) {
        return this.testMethodDescription.get(method);
    }

    public Description setTestMethodDescription(FrameworkMethod method, Description description) {
        CONTEXT_THREAD_LOCAL.set(this);
        return this.testMethodDescription.put(method, description);
    }

    public static ParallelRunningContext getCurrent() {
        return CONTEXT_THREAD_LOCAL.get();
    }

    public TestItemTree getItemTree() {
        return this.itemTree;
    }
}

