/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.junit;

import com.epam.reportportal.annotations.TestCaseId;
import com.epam.reportportal.annotations.attribute.Attributes;
import com.epam.reportportal.junit.ParallelRunningContext;
import com.epam.reportportal.junit.utils.ItemTreeUtils;
import com.epam.reportportal.junit.utils.SystemAttributesFetcher;
import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.listeners.ItemType;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.listeners.LogLevel;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.ReportPortal;
import com.epam.reportportal.service.item.TestCaseIdEntry;
import com.epam.reportportal.service.tree.TestItemTree;
import com.epam.reportportal.utils.AttributeParser;
import com.epam.reportportal.utils.MemoizingSupplier;
import com.epam.reportportal.utils.ParameterUtils;
import com.epam.reportportal.utils.StatusEvaluation;
import com.epam.reportportal.utils.TestCaseIdUtils;
import com.epam.reportportal.utils.reflect.Accessible;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.ParameterResource;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import com.nordstrom.automation.junit.ArtifactParams;
import com.nordstrom.automation.junit.AtomicTest;
import com.nordstrom.automation.junit.DisplayName;
import com.nordstrom.automation.junit.LifecycleHooks;
import com.nordstrom.automation.junit.MethodWatcher;
import com.nordstrom.automation.junit.RetriedTest;
import com.nordstrom.automation.junit.RunWatcher;
import com.nordstrom.automation.junit.RunnerWatcher;
import com.nordstrom.automation.junit.ShutdownListener;
import io.reactivex.Maybe;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.runner.Description;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;
import org.junit.runners.parameterized.BlockJUnit4ClassRunnerWithParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportPortalListener
implements ShutdownListener,
RunnerWatcher,
RunWatcher,
MethodWatcher<FrameworkMethod> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportPortalListener.class);
    private static final String FINISH_REQUEST = "FINISH_REQUEST";
    private static final String START_TIME = "START_TIME";
    private static final String IS_RETRY = "IS_RETRY";
    private static final String IS_THEORY = "IS_THEORY";
    public static final String DESCRIPTION_TEST_ERROR_FORMAT = "%s\nError: \n%s";
    private Throwable testThrowable;
    private static final Map<Class<? extends Annotation>, ItemType> TYPE_MAP = Collections.unmodifiableMap(new HashMap<Class<? extends Annotation>, ItemType>(){
        private static final long serialVersionUID = 5292344734560662610L;
        {
            this.put(Test.class, ItemType.STEP);
            this.put(Before.class, ItemType.BEFORE_METHOD);
            this.put(After.class, ItemType.AFTER_METHOD);
            this.put(BeforeClass.class, ItemType.BEFORE_CLASS);
            this.put(AfterClass.class, ItemType.AFTER_CLASS);
            this.put(Theory.class, ItemType.STEP);
        }
    });
    private static final Predicate<StackTraceElement> EXPECTED_EXCEPTION_ELEMENT = e -> "org.junit.rules.ExpectedException".equals(e.getClassName());
    private static final Predicate<StackTraceElement[]> IS_EXPECTED_EXCEPTION_RULE = eList -> Arrays.stream(eList).anyMatch(EXPECTED_EXCEPTION_ELEMENT);
    private static volatile ReportPortal REPORT_PORTAL = ReportPortal.builder().build();
    private final ParallelRunningContext context = new ParallelRunningContext();
    private final MemoizingSupplier<Launch> launch = this.createLaunch();
    private final ConcurrentLinkedDeque<Object> runners = new ConcurrentLinkedDeque();

    protected MemoizingSupplier<Launch> createLaunch() {
        return new MemoizingSupplier(() -> {
            ReportPortal reportPortal = ReportPortalListener.getReportPortal();
            StartLaunchRQ rq = this.buildStartLaunchRq(reportPortal.getParameters());
            Launch l = reportPortal.newLaunch(rq);
            this.context.getItemTree().setLaunchId(l.start());
            return l;
        });
    }

    public static ReportPortal getReportPortal() {
        return REPORT_PORTAL;
    }

    public static void setReportPortal(ReportPortal reportPortal) {
        REPORT_PORTAL = reportPortal;
    }

    protected void stopLaunch() {
        if (this.launch.isInitialized()) {
            FinishExecutionRQ finishExecutionRQ = new FinishExecutionRQ();
            finishExecutionRQ.setEndTime((Comparable)Instant.now());
            ((Launch)this.launch.get()).finish(finishExecutionRQ);
            this.launch.reset();
        }
    }

    @Nonnull
    private List<Object> getRunnerChain(@Nonnull Object runner) {
        ArrayList<Object> chain = new ArrayList<Object>();
        chain.add(runner);
        Object current = runner;
        for (Object parent : this.runners) {
            if (!ReportPortalListener.getRunnerName(current).equals(ReportPortalListener.getRunnerName(parent))) {
                chain.add(parent);
            }
            current = parent;
        }
        Collections.reverse(chain);
        return chain;
    }

    @Nonnull
    private TestItemTree.TestItemLeaf retrieveLeaf(@Nonnull Map<TestItemTree.ItemTreeKey, TestItemTree.TestItemLeaf> children, @Nonnull Object runner, @Nonnull Instant previousDate, @Nonnull ItemType itemType, @Nullable Maybe<String> parentId) {
        return children.computeIfAbsent(TestItemTree.ItemTreeKey.of((String)ReportPortalListener.getRunnerName(runner)), k -> {
            Launch myLaunch = (Launch)this.launch.get();
            Instant currentDate = Instant.now();
            Instant itemDate = previousDate.compareTo(currentDate) <= 0 ? currentDate : previousDate;
            StartTestItemRQ rq = itemType == ItemType.TEST ? this.buildStartTestItemRq(runner, itemDate) : this.buildStartSuiteRq(runner, itemDate);
            TestItemTree.TestItemLeaf l = Optional.ofNullable(parentId).map(p -> TestItemTree.createTestItemLeaf((Maybe)p, (Maybe)myLaunch.startTestItem(p, rq))).orElseGet(() -> TestItemTree.createTestItemLeaf((Maybe)myLaunch.startTestItem(rq)));
            l.setType(ItemType.SUITE);
            l.setAttribute(START_TIME, (Object)rq.getStartTime());
            return l;
        });
    }

    @Nonnull
    protected TestItemTree.TestItemLeaf retrieveLeaf(@Nonnull Object testRunner) {
        List<Object> runnerChain = this.getRunnerChain(testRunner);
        int chainSize = runnerChain.size();
        ArrayList<TestItemTree.TestItemLeaf> leafChain = new ArrayList<TestItemTree.TestItemLeaf>(chainSize);
        for (int i = 0; i < chainSize; ++i) {
            ItemType type;
            Object runner = runnerChain.get(i);
            ItemType itemType = type = i + 1 < chainSize ? ItemType.SUITE : ItemType.TEST;
            if (i <= 0) {
                leafChain.add(this.retrieveLeaf(this.context.getItemTree().getTestItems(), runner, Instant.now(), type, null));
                continue;
            }
            TestItemTree.TestItemLeaf parentLeaf = (TestItemTree.TestItemLeaf)leafChain.get(i - 1);
            leafChain.add(this.retrieveLeaf(parentLeaf.getChildItems(), runner, Objects.requireNonNull((Instant)parentLeaf.getAttribute(START_TIME)), type, (Maybe<String>)parentLeaf.getItemId()));
        }
        return (TestItemTree.TestItemLeaf)leafChain.get(chainSize - 1);
    }

    @Nullable
    protected TestItemTree.TestItemLeaf getLeaf(@Nonnull Object runner) {
        List<Object> chain = this.getRunnerChain(runner);
        TestItemTree.TestItemLeaf leaf = null;
        Map children = this.context.getItemTree().getTestItems();
        for (Object r : chain) {
            leaf = (TestItemTree.TestItemLeaf)children.get(TestItemTree.ItemTreeKey.of((String)ReportPortalListener.getRunnerName(r)));
            if (leaf == null) continue;
            children = leaf.getChildItems();
        }
        return leaf;
    }

    @Nullable
    protected TestItemTree.TestItemLeaf getLeaf(@Nonnull Object runner, @Nonnull FrameworkMethod method, @Nonnull ReflectiveCallable callable) {
        TestItemTree.ItemTreeKey myKey = Optional.ofNullable((Theory)method.getAnnotation(Theory.class)).map(T -> ItemTreeUtils.createItemTreeKey(method)).orElseGet(() -> ItemTreeUtils.createItemTreeKey(method, this.getStepParameters(method, runner, callable)));
        TestItemTree.ItemTreeKey myParentKey = ItemTreeUtils.createItemTreeKey(ReportPortalListener.getRunnerName(runner));
        TestItemTree.TestItemLeaf testLeaf = Optional.ofNullable(this.getLeaf(runner)).orElseGet(() -> (TestItemTree.TestItemLeaf)this.context.getItemTree().getTestItems().get(myParentKey));
        return Optional.ofNullable(testLeaf).map(l -> (TestItemTree.TestItemLeaf)l.getChildItems().get(myKey)).orElse(null);
    }

    @Nullable
    protected ItemStatus evaluateStatus(@Nullable ItemStatus currentStatus, @Nullable ItemStatus childStatus) {
        return StatusEvaluation.evaluateStatus((ItemStatus)currentStatus, (ItemStatus)childStatus);
    }

    protected void startRunner(@Nonnull Object runner) {
        this.runners.addFirst(runner);
    }

    protected void stopRunner(@Nonnull Object runner) {
        FinishTestItemRQ rq = this.buildFinishSuiteRq(LifecycleHooks.getTestClassOf((Object)runner));
        Optional.ofNullable(this.getLeaf(runner)).ifPresent(l -> {
            l.setAttribute(FINISH_REQUEST, (Object)rq);
            ItemStatus status = l.getStatus();
            for (Map.Entry entry : l.getChildItems().entrySet()) {
                TestItemTree.TestItemLeaf value = (TestItemTree.TestItemLeaf)entry.getValue();
                if (value.getType() != ItemType.SUITE) continue;
                Optional.ofNullable(value.getAttribute(FINISH_REQUEST)).ifPresent(r -> ((Launch)this.launch.get()).finishTestItem(value.getItemId(), (FinishTestItemRQ)value.clearAttribute(FINISH_REQUEST)));
                status = this.evaluateStatus(status, value.getStatus());
            }
            l.setStatus(status);
            if (l.getParentId() == null) {
                rq.setStatus((String)Optional.ofNullable(status).map(Enum::name).orElse(null));
                ((Launch)this.launch.get()).finishTestItem(l.getItemId(), rq);
            }
        });
        this.runners.removeFirstOccurrence(runner);
    }

    @Nonnull
    protected Instant getDateForChild(@Nullable TestItemTree.TestItemLeaf parentLeaf) {
        Instant currentDate = Instant.now();
        return Optional.ofNullable(parentLeaf).map(l -> (Instant)l.getAttribute(START_TIME)).map(d -> {
            if (currentDate.compareTo((Instant)d) >= 0) {
                return currentDate;
            }
            return d;
        }).orElse(currentDate);
    }

    protected void startTest(@Nonnull AtomicTest testContext) {
        FrameworkMethod method = testContext.getIdentity();
        if (Optional.ofNullable((Theory)method.getAnnotation(Theory.class)).isEmpty()) {
            this.context.setTestStatus(ItemTreeUtils.createItemTreeKey(method, this.getStepParameters(testContext)), ItemStatus.PASSED);
        }
        this.context.setTestMethodDescription(method, testContext.getDescription());
    }

    protected void finishTest(@Nonnull AtomicTest testContext) {
        FrameworkMethod method = testContext.getIdentity();
        TestItemTree.ItemTreeKey key = Optional.ofNullable((Theory)method.getAnnotation(Theory.class)).map(T -> ItemTreeUtils.createItemTreeKey(method)).orElseGet(() -> ItemTreeUtils.createItemTreeKey(method, this.getStepParameters(testContext)));
        ItemStatus status = this.context.getTestStatus(key);
        Throwable throwable = this.context.getTestThrowable(key);
        Object runner = testContext.getRunner();
        ReflectiveCallable callable = LifecycleHooks.getCallableOf((Description)testContext.getDescription());
        TestItemTree.TestItemLeaf testLeaf = this.getLeaf(runner);
        if (testLeaf != null) {
            Optional.ofNullable((TestItemTree.TestItemLeaf)testLeaf.getChildItems().get(key)).ifPresent(l -> {
                ItemStatus itemStatus = l.getStatus();
                boolean isTheory = Optional.ofNullable((Boolean)l.getAttribute(IS_THEORY)).orElse(Boolean.FALSE);
                if (itemStatus != status && !isTheory) {
                    Boolean isRetry = (Boolean)l.getAttribute(IS_RETRY);
                    if (ItemStatus.SKIPPED != status || isRetry == null || !isRetry.booleanValue()) {
                        Optional.ofNullable(throwable).ifPresent(t -> {
                            if (status == ItemStatus.SKIPPED) {
                                this.sendReportPortalMsg((Maybe<String>)l.getItemId(), LogLevel.WARN, throwable);
                            } else {
                                this.sendReportPortalMsg((Maybe<String>)l.getItemId(), LogLevel.ERROR, throwable);
                            }
                        });
                        if (status == ItemStatus.PASSED || throwable != null && IS_EXPECTED_EXCEPTION_RULE.test(throwable.getStackTrace())) {
                            this.stopTestMethod((TestItemTree.TestItemLeaf)l, method, this.buildFinishStepRq(runner, method, callable, status));
                        }
                    }
                } else if (isTheory && runner.getClass() == Theories.class) {
                    ItemStatus theoryStatus = this.context.getTestStatus(key);
                    if (ItemStatus.FAILED == theoryStatus) {
                        this.sendReportPortalMsg((Maybe<String>)l.getItemId(), LogLevel.ERROR, this.context.getTestThrowable(key));
                    }
                    this.stopTestMethod((TestItemTree.TestItemLeaf)l, method, this.buildFinishStepRq(runner, method, callable, theoryStatus == null ? ItemStatus.PASSED : theoryStatus));
                }
            });
            testLeaf.setStatus(status);
        }
    }

    protected void startTestItem(@Nonnull FrameworkMethod method, @Nonnull TestItemTree.TestItemLeaf parentLeaf, @Nonnull StartTestItemRQ rq) {
        TestItemTree.ItemTreeKey myKey = Optional.ofNullable((Theory)method.getAnnotation(Theory.class)).map(a -> ItemTreeUtils.createItemTreeKey(method)).orElseGet(() -> ItemTreeUtils.createItemTreeKey(method, rq.getParameters()));
        Map children = parentLeaf.getChildItems();
        TestItemTree.TestItemLeaf child = (TestItemTree.TestItemLeaf)children.get(myKey);
        if (child != null) {
            Boolean t = (Boolean)child.getAttribute(IS_THEORY);
            if (t != null && t.booleanValue()) {
                return;
            }
            Boolean r = (Boolean)child.getAttribute(IS_RETRY);
            if (r != null && r.booleanValue()) {
                parentLeaf.getChildItems().remove(myKey);
                rq.setRetry(Boolean.valueOf(true));
            }
        }
        Maybe itemId = ((Launch)this.launch.get()).startTestItem(parentLeaf.getItemId(), rq);
        TestItemTree.TestItemLeaf myLeaf = TestItemTree.createTestItemLeaf((Maybe)parentLeaf.getItemId(), (Maybe)itemId);
        myLeaf.setType(ItemType.STEP);
        Optional.ofNullable((Theory)method.getAnnotation(Theory.class)).ifPresent(a -> myLeaf.setAttribute(IS_THEORY, (Object)Boolean.TRUE));
        parentLeaf.getChildItems().put(myKey, myLeaf);
        if (ReportPortalListener.getReportPortal().getParameters().isCallbackReportingEnabled()) {
            this.context.getItemTree().getTestItems().put(ItemTreeUtils.createItemTreeKey(method), myLeaf);
        }
    }

    protected void startTestMethod(@Nonnull Object runner, @Nonnull FrameworkMethod method, @Nonnull ReflectiveCallable callable) {
        TestItemTree.TestItemLeaf testLeaf = this.retrieveLeaf(runner);
        StartTestItemRQ rq = this.buildStartStepRq(runner, this.context.getTestMethodDescription(method), method, callable, this.getDateForChild(testLeaf));
        this.startTestItem(method, testLeaf, rq);
    }

    @Nullable
    protected ItemType detectMethodType(@Nonnull FrameworkMethod method) {
        return Arrays.stream(method.getAnnotations()).map(a -> TYPE_MAP.get(a.annotationType())).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private void updateTestItemTree(@Nonnull FrameworkMethod method, @Nullable Maybe<OperationCompletionRS> finishResponse) {
        TestItemTree.TestItemLeaf testItemLeaf = ItemTreeUtils.retrieveLeaf(method, this.context.getItemTree());
        if (testItemLeaf != null) {
            testItemLeaf.setFinishResponse(finishResponse);
        }
    }

    protected void reportSkippedStep(@Nonnull Object runner, @Nonnull FrameworkMethod failedMethod, @Nonnull ReflectiveCallable callable, @Nonnull Instant eventTime, @Nullable Throwable throwable) {
        Instant currentTime = Instant.now();
        Instant skipStartTime = currentTime.isAfter(eventTime) ? currentTime.minusMillis(1L) : currentTime;
        TestItemTree.ItemTreeKey myParentKey = ItemTreeUtils.createItemTreeKey(ReportPortalListener.getRunnerName(runner));
        TestItemTree.TestItemLeaf testLeaf = Optional.ofNullable(this.getLeaf(runner)).orElseGet(() -> (TestItemTree.TestItemLeaf)this.context.getItemTree().getTestItems().get(myParentKey));
        try {
            Object target = LifecycleHooks.getFieldValue((Object)callable, (String)"val$target");
            AtomicTest testContext = LifecycleHooks.getAtomicTestOf((Object)target);
            Description description = testContext.getDescription();
            FrameworkMethod method = testContext.getIdentity();
            Optional.ofNullable(testLeaf).ifPresent(l -> {
                StartTestItemRQ startRq = this.buildStartStepRq(runner, description, method, callable, skipStartTime);
                Maybe id = ((Launch)this.launch.get()).startTestItem(l.getItemId(), startRq);
                Optional.ofNullable(throwable).ifPresent(t -> this.sendReportPortalMsg((Maybe<String>)id, LogLevel.WARN, throwable));
                FinishTestItemRQ finishRq = this.buildFinishStepRq(runner, method, callable, ItemStatus.SKIPPED);
                finishRq.setIssue(Launch.NOT_ISSUE);
                ((Launch)this.launch.get()).finishTestItem(id, finishRq);
            });
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
    }

    protected void reportSkippedClassTests(@Nonnull Object runner, @Nonnull FrameworkMethod failedMethod, @Nonnull ReflectiveCallable callable, @Nonnull Instant eventTime, @Nullable Throwable throwable) {
    }

    private void stopTestMethod(@Nonnull TestItemTree.TestItemLeaf myLeaf, @Nonnull FrameworkMethod method, @Nonnull FinishTestItemRQ rq) {
        Maybe itemId = myLeaf.getItemId();
        Maybe finishResponse = Optional.ofNullable(myLeaf.getFinishResponse()).map(rs -> {
            rs.blockingGet();
            return ((Launch)this.launch.get()).finishTestItem(itemId, rq);
        }).orElseGet(() -> ((Launch)this.launch.get()).finishTestItem(itemId, rq));
        myLeaf.setFinishResponse(finishResponse);
        if (ReportPortalListener.getReportPortal().getParameters().isCallbackReportingEnabled()) {
            this.updateTestItemTree(method, (Maybe<OperationCompletionRS>)finishResponse);
        }
    }

    protected void stopTestMethod(@Nonnull Object runner, @Nonnull FrameworkMethod method, @Nonnull ReflectiveCallable callable, @Nonnull FinishTestItemRQ rq) {
        Optional.ofNullable(this.getLeaf(runner, method, callable)).ifPresent(l -> {
            ItemStatus status = ItemStatus.valueOf((String)rq.getStatus());
            if (Optional.ofNullable((Theory)method.getAnnotation(Theory.class)).isEmpty()) {
                l.setStatus(status);
                this.stopTestMethod((TestItemTree.TestItemLeaf)l, method, rq);
            }
        });
    }

    protected void stopTestMethod(@Nonnull Object runner, @Nonnull FrameworkMethod method, @Nonnull ReflectiveCallable callable, @Nonnull ItemStatus status, @Nullable Throwable throwable) {
        boolean reportSkippedClass;
        boolean reportSkippedMethod;
        this.testThrowable = throwable;
        FinishTestItemRQ rq = this.buildFinishStepRq(runner, method, callable, status);
        this.stopTestMethod(runner, method, callable, rq);
        ItemType methodType = this.detectMethodType(method);
        boolean bl = reportSkippedMethod = ItemType.BEFORE_METHOD == methodType && ItemStatus.FAILED == status || ItemType.BEFORE_METHOD == methodType && ItemStatus.SKIPPED == status && throwable instanceof AssumptionViolatedException;
        if (reportSkippedMethod) {
            this.reportSkippedStep(runner, method, callable, (Instant)rq.getEndTime(), throwable);
        }
        boolean bl2 = reportSkippedClass = ItemType.BEFORE_CLASS == methodType && ItemStatus.FAILED == status || ItemType.BEFORE_CLASS == methodType && ItemStatus.SKIPPED == status && throwable instanceof AssumptionViolatedException;
        if (reportSkippedClass) {
            this.reportSkippedClassTests(runner, method, callable, (Instant)rq.getEndTime(), throwable);
        }
    }

    protected void setTestFailure(@Nonnull AtomicTest testContext, @Nullable Throwable thrown) {
        FrameworkMethod method = testContext.getIdentity();
        TestItemTree.ItemTreeKey key = Optional.ofNullable((Theory)method.getAnnotation(Theory.class)).map(a -> ItemTreeUtils.createItemTreeKey(testContext.getIdentity())).orElseGet(() -> ItemTreeUtils.createItemTreeKey(testContext.getIdentity(), this.getStepParameters(testContext)));
        this.context.setTestStatus(key, ItemStatus.FAILED);
        this.context.setTestThrowable(key, thrown);
    }

    protected void handleTestSkip(@Nonnull AtomicTest testContext) {
        List<ParameterResource> parameters = this.getStepParameters(testContext);
        TestItemTree.ItemTreeKey key = ItemTreeUtils.createItemTreeKey(testContext.getIdentity(), parameters);
        this.context.setTestStatus(key, ItemStatus.SKIPPED);
        Object runner = testContext.getRunner();
        FrameworkMethod method = testContext.getIdentity();
        TestItemTree.ItemTreeKey myKey = ItemTreeUtils.createItemTreeKey(method, parameters);
        TestItemTree.TestItemLeaf myLeaf = (TestItemTree.TestItemLeaf)this.retrieveLeaf(runner).getChildItems().get(myKey);
        if (myLeaf == null) {
            ReflectiveCallable callable = LifecycleHooks.encloseCallable((Method)method.getMethod(), null, (Object[])new Object[0]);
            this.startTest(testContext);
            this.startTestMethod(runner, method, callable);
            this.stopTestMethod(runner, method, callable, ItemStatus.SKIPPED, null);
        } else {
            FinishTestItemRQ rq;
            ReflectiveCallable callable = LifecycleHooks.getCallableOf((Description)testContext.getDescription());
            if (RetriedTest.isRetriedTest((Description)testContext.getDescription())) {
                rq = this.buildFinishStepRq(runner, method, callable, myLeaf.getStatus());
                rq.setRetry(Boolean.valueOf(true));
                myLeaf.setAttribute(IS_RETRY, (Object)true);
            } else {
                rq = this.buildFinishStepRq(runner, method, callable, ItemStatus.SKIPPED);
                myLeaf.setStatus(ItemStatus.SKIPPED);
            }
            this.stopTestMethod(runner, method, callable, rq);
        }
    }

    protected void setTestSkip(@Nonnull AtomicTest testContext, @Nullable Throwable thrown) {
        TestItemTree.ItemTreeKey key = ItemTreeUtils.createItemTreeKey(testContext.getIdentity(), this.getStepParameters(testContext));
        this.context.setTestStatus(key, ItemStatus.SKIPPED);
        this.context.setTestThrowable(key, thrown);
    }

    @Nonnull
    protected Function<String, SaveLogRQ> getLogSupplier(@Nonnull LogLevel level, @Nullable Throwable thrown) {
        return itemUuid -> {
            SaveLogRQ rq = new SaveLogRQ();
            rq.setItemUuid(itemUuid);
            rq.setLevel(level.name());
            rq.setLogTime((Comparable)Instant.now());
            if (thrown != null) {
                rq.setMessage(ExceptionUtils.getStackTrace((Throwable)thrown));
            } else {
                rq.setMessage("Test has failed without exception");
            }
            return rq;
        };
    }

    protected void sendReportPortalMsg(@Nonnull Maybe<String> itemUud, @Nonnull LogLevel level, @Nullable Throwable thrown) {
        ReportPortal.emitLog(itemUud, this.getLogSupplier(level, thrown));
    }

    protected void sendReportPortalMsg(@Nonnull LogLevel level, @Nullable Throwable thrown) {
        ReportPortal.emitLog(this.getLogSupplier(level, thrown));
    }

    protected boolean isReportable(@Nonnull FrameworkMethod method) {
        return this.detectMethodType(method) != null;
    }

    @Nonnull
    protected StartLaunchRQ buildStartLaunchRq(@Nonnull ListenerParameters parameters) {
        StartLaunchRQ rq = new StartLaunchRQ();
        rq.setName(parameters.getLaunchName());
        rq.setStartTime((Comparable)Instant.now());
        HashSet<ItemAttributesRQ> attributes = new HashSet<ItemAttributesRQ>();
        attributes.addAll(parameters.getAttributes());
        attributes.addAll(SystemAttributesFetcher.collectSystemAttributes(parameters.getSkippedAnIssue()));
        rq.setAttributes(attributes);
        rq.setMode(parameters.getLaunchRunningMode());
        rq.setRerun(parameters.isRerun());
        if (StringUtils.isNotBlank((CharSequence)parameters.getRerunOf())) {
            rq.setRerunOf(parameters.getRerunOf());
        }
        if (StringUtils.isNotBlank((CharSequence)parameters.getDescription())) {
            rq.setDescription(parameters.getDescription());
        }
        return rq;
    }

    @Nonnull
    protected StartTestItemRQ buildStartSuiteRq(@Nonnull Object runner, @Nullable Instant startTime) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(ReportPortalListener.getRunnerName(runner));
        rq.setCodeRef(this.getCodeRef(runner));
        rq.setStartTime((Comparable)startTime);
        rq.setType(ItemType.SUITE.name());
        rq.setAttributes(this.getAttributes(LifecycleHooks.getTestClassOf((Object)runner)));
        return rq;
    }

    @Nonnull
    protected StartTestItemRQ buildStartTestItemRq(@Nonnull Object runner, @Nullable Instant startTime) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(ReportPortalListener.getRunnerName(runner));
        rq.setCodeRef(this.getCodeRef(runner));
        rq.setStartTime((Comparable)startTime);
        rq.setType(ItemType.TEST.name());
        rq.setAttributes(this.getAttributes(LifecycleHooks.getTestClassOf((Object)runner)));
        return rq;
    }

    @Nonnull
    protected StartTestItemRQ buildStartStepRq(@Nonnull Object runner, @Nullable Description description, @Nonnull FrameworkMethod method, @Nonnull ReflectiveCallable callable, @Nullable Instant startTime) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(method.getName());
        rq.setCodeRef(this.getCodeRef(method));
        rq.setAttributes(this.getAttributes(method));
        rq.setDescription(this.createStepDescription(description, method));
        rq.setParameters(this.getStepParameters(method, runner, callable));
        rq.setTestCaseId((String)Optional.ofNullable(this.getTestCaseId(runner, method, rq.getCodeRef(), Optional.ofNullable(rq.getParameters()).map(p -> p.stream().map(ParameterResource::getValue).collect(Collectors.toList())).orElse(null), this.getTargetFor(runner, method))).map(TestCaseIdEntry::getId).orElse(null));
        rq.setStartTime((Comparable)startTime);
        rq.setType(Optional.ofNullable(this.detectMethodType(method)).map(Enum::name).orElse(""));
        return rq;
    }

    @Nonnull
    protected FinishTestItemRQ buildFinishSuiteRq(@Nullable TestClass testClass) {
        FinishTestItemRQ rq = new FinishTestItemRQ();
        rq.setEndTime((Comparable)Instant.now());
        return rq;
    }

    @Nonnull
    protected FinishTestItemRQ buildFinishStepRq(@Nullable FrameworkMethod method, @Nonnull ItemStatus status) {
        FinishTestItemRQ rq = new FinishTestItemRQ();
        rq.setEndTime((Comparable)Instant.now());
        rq.setStatus(status.name());
        if (status != ItemStatus.PASSED && this.testThrowable != null && method != null) {
            rq.setDescription(String.format(DESCRIPTION_TEST_ERROR_FORMAT, this.createStepDescription(this.context.getTestMethodDescription(method), method), ExceptionUtils.getStackTrace((Throwable)this.testThrowable)));
        }
        return rq;
    }

    @Nonnull
    protected FinishTestItemRQ buildFinishStepRq(@Nonnull Object runner, @Nullable FrameworkMethod method, @Nonnull ReflectiveCallable callable, @Nonnull ItemStatus status) {
        return this.buildFinishStepRq(method, status);
    }

    @Deprecated
    @Nullable
    protected <T> TestCaseIdEntry getTestCaseId(@Nullable Object runner, @Nonnull FrameworkMethod frameworkMethod, @Nullable String codeRef, @Nullable List<T> params) {
        return this.getTestCaseId(runner, frameworkMethod, codeRef, params, null);
    }

    @Nullable
    protected <T> TestCaseIdEntry getTestCaseId(@Nullable Object runner, @Nonnull FrameworkMethod frameworkMethod, @Nullable String codeRef, @Nullable List<T> params, @Nullable Object testInstance) {
        Method method = frameworkMethod.getMethod();
        Method executable = runner instanceof BlockJUnit4ClassRunnerWithParameters ? Arrays.stream(frameworkMethod.getDeclaringClass().getConstructors()).findAny().map(c -> c).orElse(method) : method;
        return TestCaseIdUtils.getTestCaseId((TestCaseId)method.getAnnotation(TestCaseId.class), (Executable)executable, (String)codeRef, params, (Object)testInstance);
    }

    @Nullable
    protected List<ParameterResource> getStepParameters(@Nonnull AtomicTest test) {
        Object runner = test.getRunner();
        FrameworkMethod identity = test.getIdentity();
        return this.getStepParameters(identity, runner, LifecycleHooks.getCallableOf((Description)test.getDescription()));
    }

    @Nullable
    protected List<ParameterResource> getStepParameters(@Nonnull FrameworkMethod method, @Nonnull Object runner, @Nullable ReflectiveCallable callable) {
        List<ParameterResource> parameters = this.getMethodParameters(method, runner, callable);
        return parameters.isEmpty() ? null : parameters;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    protected List<ParameterResource> getMethodParameters(@Nonnull FrameworkMethod method, @Nonnull Object runner, @Nullable ReflectiveCallable callable) {
        ArrayList<ParameterResource> result = new ArrayList<ParameterResource>();
        if (method.isStatic()) return result;
        Object target = this.getTargetFor(runner, method);
        if (target instanceof ArtifactParams) {
            Optional params = ((ArtifactParams)target).getParameters();
            if (!params.isPresent()) return result;
            for (Map.Entry param : ((Map)params.get()).entrySet()) {
                ParameterResource parameter = new ParameterResource();
                parameter.setKey((String)param.getKey());
                parameter.setValue(Objects.toString(param.getValue(), null));
                result.add(parameter);
            }
            return result;
        } else if (runner instanceof BlockJUnit4ClassRunnerWithParameters) {
            try {
                Object[] params;
                Optional<Constructor<?>> constructor = Arrays.stream(method.getDeclaringClass().getConstructors()).findFirst();
                if (!constructor.isPresent() || (params = (Object[])Accessible.on((Object)runner).field("parameters").getValue()) == null) return result;
                result.addAll(ParameterUtils.getParameters((Executable)constructor.get(), Arrays.asList(params)));
                return result;
            }
            catch (NoSuchFieldException e) {
                LOGGER.warn("Unable to get parameters for parameterized runner", (Throwable)e);
            }
            return result;
        } else {
            if (callable == null) return result;
            try {
                Object[] params = (Object[])Accessible.on((Object)callable).field("val$params").getValue();
                if (params == null) return result;
                result.addAll(ParameterUtils.getParameters((Executable)method.getMethod(), Arrays.asList(params)));
                return result;
            }
            catch (NoSuchFieldException e) {
                LOGGER.warn("Unable to get parameters for parameterized runner", (Throwable)e);
            }
        }
        return result;
    }

    @Nullable
    protected Object getTargetFor(@Nonnull Object runner, @Nonnull FrameworkMethod method) {
        Description description = LifecycleHooks.describeChild((Object)runner, (Object)method);
        return Optional.ofNullable(description).map(LifecycleHooks::getTargetOf).orElse(null);
    }

    @Nullable
    protected String createStepDescription(@Nullable Description description, @Nonnull FrameworkMethod method) {
        DisplayName itemDisplayName = (DisplayName)method.getAnnotation(DisplayName.class);
        return itemDisplayName != null ? itemDisplayName.value() : (String)Optional.ofNullable(description).map(Description::getDisplayName).orElse(null);
    }

    @Nonnull
    protected static String getRunnerName(@Nonnull Object runner) {
        Object name;
        TestClass testClass = LifecycleHooks.getTestClassOf((Object)runner);
        Class javaClass = testClass.getJavaClass();
        if (javaClass != null) {
            name = javaClass.getName();
        } else {
            String role = null == LifecycleHooks.getParentOf((Object)runner) ? "Root " : "Context ";
            String type = runner instanceof Suite ? "Suite" : "Class";
            name = role + type + " Runner";
        }
        return name;
    }

    @Nullable
    protected String getCodeRef(@Nonnull Object runner) {
        return Optional.ofNullable(LifecycleHooks.getTestClassOf((Object)runner)).flatMap(tc -> Optional.ofNullable(tc.getJavaClass())).map(Class::getCanonicalName).orElse(null);
    }

    @Nonnull
    protected String getCodeRef(@Nonnull FrameworkMethod frameworkMethod) {
        return TestCaseIdUtils.getCodeRef((Executable)frameworkMethod.getMethod());
    }

    @Nonnull
    private Set<ItemAttributesRQ> getAttributes(@Nonnull AnnotatedElement annotatedElement) {
        return Optional.ofNullable(annotatedElement.getAnnotation(Attributes.class)).map(AttributeParser::retrieveAttributes).orElse(Collections.emptySet());
    }

    @Nonnull
    protected Set<ItemAttributesRQ> getAttributes(@Nonnull TestClass testClass) {
        Stream categories = Optional.ofNullable((Category)testClass.getAnnotation(Category.class)).stream().flatMap(a -> Arrays.stream(a.value()).map(c -> new ItemAttributesRQ(null, c.getSimpleName())));
        Stream attributes = Optional.ofNullable(testClass.getJavaClass()).map(this::getAttributes).stream().flatMap(Collection::stream);
        return Stream.concat(categories, attributes).collect(Collectors.toSet());
    }

    @Nonnull
    protected Set<ItemAttributesRQ> getAttributes(@Nonnull FrameworkMethod frameworkMethod) {
        Stream categories = Optional.ofNullable((Category)frameworkMethod.getAnnotation(Category.class)).stream().flatMap(a -> Arrays.stream(a.value()).map(c -> new ItemAttributesRQ(null, c.getSimpleName())));
        Stream attributes = Optional.ofNullable(frameworkMethod.getMethod()).map(this::getAttributes).orElse(Collections.emptySet()).stream();
        return Stream.concat(categories, attributes).collect(Collectors.toSet());
    }

    public void onShutdown() {
        this.stopLaunch();
    }

    public void runStarted(Object runner) {
        this.startRunner(runner);
    }

    public void runFinished(Object runner) {
        this.stopRunner(runner);
    }

    public void testStarted(AtomicTest atomicTest) {
        this.startTest(atomicTest);
    }

    public void testFinished(AtomicTest atomicTest) {
        this.finishTest(atomicTest);
    }

    public void testFailure(AtomicTest atomicTest, Throwable thrown) {
        this.setTestFailure(atomicTest, thrown);
    }

    public void testAssumptionFailure(AtomicTest atomicTest, AssumptionViolatedException thrown) {
        this.setTestSkip(atomicTest, (Throwable)thrown);
    }

    public void testIgnored(AtomicTest atomicTest) {
        this.handleTestSkip(atomicTest);
    }

    public void beforeInvocation(Object runner, FrameworkMethod method, ReflectiveCallable callable) {
        if (this.isReportable(method)) {
            this.startTestMethod(runner, method, callable);
        }
    }

    public void afterInvocation(Object runner, FrameworkMethod method, ReflectiveCallable callable, Throwable thrown) {
        if (this.isReportable(method)) {
            ItemStatus status = Optional.ofNullable(thrown).map(t -> {
                boolean isAssumption = t instanceof AssumptionViolatedException;
                ItemStatus myStatus = Optional.ofNullable((Test)method.getAnnotation(Test.class)).filter(a -> a.expected().isInstance(thrown)).map(a -> ItemStatus.PASSED).orElse(isAssumption ? ItemStatus.SKIPPED : ItemStatus.FAILED);
                LogLevel level = ItemStatus.PASSED == myStatus ? LogLevel.INFO : (isAssumption ? LogLevel.WARN : LogLevel.ERROR);
                this.sendReportPortalMsg(level, thrown);
                return myStatus;
            }).orElse(ItemStatus.PASSED);
            this.stopTestMethod(runner, method, callable, status, thrown);
        }
    }

    public Class<FrameworkMethod> supportedType() {
        return FrameworkMethod.class;
    }
}

