/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.junit.utils;

import com.epam.reportportal.service.tree.TestItemTree;
import com.epam.ta.reportportal.ws.model.ParameterResource;
import com.nordstrom.automation.junit.AtomicTest;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;

public class ItemTreeUtils {
    public static final Function<List<ParameterResource>, String> PARAMETER_FORMAT = list -> Optional.ofNullable(list).map(l -> l.stream().map(ParameterResource::getValue).collect(Collectors.joining(",", "[", "]"))).orElse("");

    private ItemTreeUtils() {
    }

    @Nonnull
    public static TestItemTree.ItemTreeKey createItemTreeKey(@Nullable String name) {
        return TestItemTree.ItemTreeKey.of((String)name);
    }

    @Nonnull
    public static TestItemTree.ItemTreeKey createItemTreeKey(@Nonnull FrameworkMethod method) {
        String strKey = method.getDeclaringClass().getName() + "." + method.getName();
        return TestItemTree.ItemTreeKey.of((String)strKey);
    }

    @Nonnull
    public static TestItemTree.ItemTreeKey createItemTreeKey(@Nonnull FrameworkMethod method, @Nullable List<ParameterResource> parameters) {
        String paramStr = PARAMETER_FORMAT.apply(parameters);
        String strKey = method.getDeclaringClass().getName() + "." + method.getName() + paramStr;
        return TestItemTree.ItemTreeKey.of((String)strKey);
    }

    @Nonnull
    public static TestItemTree.ItemTreeKey createItemTreeKey(@Nonnull AtomicTest test) {
        return TestItemTree.ItemTreeKey.of((String)test.getDescription().getDisplayName());
    }

    @Nonnull
    public static TestItemTree.ItemTreeKey createItemTreeKey(@Nonnull Description description) {
        String fullName = description.getTestClass().getName() + "." + description.getMethodName();
        return TestItemTree.ItemTreeKey.of((String)fullName, (int)fullName.hashCode());
    }

    @Nullable
    public static TestItemTree.TestItemLeaf retrieveLeaf(@Nullable String name, @Nonnull TestItemTree testItemTree) {
        return (TestItemTree.TestItemLeaf)testItemTree.getTestItems().get(ItemTreeUtils.createItemTreeKey(name));
    }

    @Nullable
    public static TestItemTree.TestItemLeaf retrieveLeaf(@Nonnull FrameworkMethod method, @Nonnull TestItemTree testItemTree) {
        return (TestItemTree.TestItemLeaf)testItemTree.getTestItems().get(ItemTreeUtils.createItemTreeKey(method));
    }

    @Nullable
    public static TestItemTree.TestItemLeaf retrieveLeaf(@Nonnull Description description, @Nonnull TestItemTree testItemTree) {
        return (TestItemTree.TestItemLeaf)testItemTree.getTestItems().get(ItemTreeUtils.createItemTreeKey(description));
    }
}

