/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.karate;

import com.epam.reportportal.karate.ReportPortalUtils;
import com.epam.reportportal.karate.utils.BlockingConcurrentHashMap;
import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.listeners.LogLevel;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.ReportPortal;
import com.epam.reportportal.utils.MemoizingSupplier;
import com.epam.reportportal.utils.ParameterUtils;
import com.epam.reportportal.utils.StatusEvaluation;
import com.epam.reportportal.utils.markdown.MarkdownUtils;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.intuit.karate.RuntimeHook;
import com.intuit.karate.Suite;
import com.intuit.karate.core.FeatureRuntime;
import com.intuit.karate.core.Result;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.StepResult;
import com.intuit.karate.http.HttpRequest;
import com.intuit.karate.http.Response;
import io.reactivex.Maybe;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportPortalHook
implements RuntimeHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportPortalHook.class);
    protected final MemoizingSupplier<Launch> launch;
    private final BlockingConcurrentHashMap<String, Supplier<Maybe<String>>> featureIdMap = new BlockingConcurrentHashMap();
    private final Map<String, Maybe<String>> scenarioIdMap = new ConcurrentHashMap<String, Maybe<String>>();
    private final Map<String, Maybe<String>> backgroundIdMap = new ConcurrentHashMap<String, Maybe<String>>();
    private final Map<String, ItemStatus> backgroundStatusMap = new ConcurrentHashMap<String, ItemStatus>();
    private final Map<String, Maybe<String>> stepIdMap = new ConcurrentHashMap<String, Maybe<String>>();
    private final Map<Maybe<String>, Date> stepStartTimeMap = new ConcurrentHashMap<Maybe<String>, Date>();
    private volatile Thread shutDownHook;

    public ReportPortalHook(ReportPortal reportPortal) {
        this.launch = new MemoizingSupplier(() -> {
            ListenerParameters params = reportPortal.getParameters();
            StartLaunchRQ rq = this.buildStartLaunchRq(params);
            Launch newLaunch = reportPortal.newLaunch(rq);
            newLaunch.start();
            this.shutDownHook = ReportPortalUtils.registerShutdownHook(this::finishLaunch);
            return newLaunch;
        });
    }

    public ReportPortalHook() {
        this(ReportPortal.builder().build());
    }

    public ReportPortalHook(Supplier<Launch> launchSupplier) {
        this.launch = new MemoizingSupplier(launchSupplier);
    }

    protected StartLaunchRQ buildStartLaunchRq(ListenerParameters parameters) {
        return ReportPortalUtils.buildStartLaunchRq(parameters);
    }

    @Nonnull
    protected FinishExecutionRQ buildFinishLaunchRq(@Nonnull ListenerParameters parameters) {
        return ReportPortalUtils.buildFinishLaunchRq(parameters);
    }

    public void finishLaunch() {
        Launch launchObject = (Launch)this.launch.get();
        ListenerParameters parameters = launchObject.getParameters();
        FinishExecutionRQ rq = this.buildFinishLaunchRq(parameters);
        LOGGER.info("Launch URL: {}/ui/#{}/launches/all/{}", new Object[]{parameters.getBaseUrl(), parameters.getProjectName(), System.getProperty("rp.launch.id")});
        launchObject.finish(rq);
        if (this.shutDownHook != null && Thread.currentThread() != this.shutDownHook) {
            ReportPortalUtils.unregisterShutdownHook(this.shutDownHook);
        }
    }

    @Nonnull
    protected StartTestItemRQ buildStartFeatureRq(@Nonnull FeatureRuntime fr) {
        StartTestItemRQ rq = ReportPortalUtils.buildStartFeatureRq(fr.featureCall.feature);
        Optional.ofNullable(fr.caller).map(c -> c.arg).map(a -> (Map)a.getValue()).filter(args -> !args.isEmpty()).ifPresent(args -> {
            String parameters = String.format("Parameters:\n\n%s", ParameterUtils.formatParametersAsTable(ReportPortalUtils.getParameters(args)));
            String description = rq.getDescription();
            if (StringUtils.isNotBlank((CharSequence)description)) {
                rq.setDescription(String.format("%s\n\n---\n\n%s", parameters, description));
            } else {
                rq.setDescription(parameters);
            }
        });
        return rq;
    }

    public boolean beforeFeature(FeatureRuntime fr) {
        this.featureIdMap.computeIfAbsent(fr.featureCall.feature.getNameForReport(), f -> new MemoizingSupplier(() -> ((Launch)this.launch.get()).startTestItem(this.buildStartFeatureRq(fr))));
        return true;
    }

    @Nonnull
    protected FinishTestItemRQ buildFinishFeatureRq(@Nonnull FeatureRuntime fr) {
        return ReportPortalUtils.buildFinishTestItemRq(Calendar.getInstance().getTime(), fr.result.isFailed() ? ItemStatus.FAILED : ItemStatus.PASSED);
    }

    public void afterFeature(FeatureRuntime fr) {
        Optional<Maybe> optionalId = Optional.ofNullable(this.featureIdMap.remove(fr.featureCall.feature.getNameForReport())).map(Supplier::get);
        if (optionalId.isEmpty()) {
            LOGGER.error("ERROR: Trying to finish unspecified feature.");
        }
        optionalId.ifPresent(featureId -> ((Launch)this.launch.get()).finishTestItem(featureId, this.buildFinishFeatureRq(fr)));
    }

    @Nonnull
    protected StartTestItemRQ buildStartScenarioRq(@Nonnull ScenarioRuntime sr) {
        return ReportPortalUtils.buildStartScenarioRq(sr.result);
    }

    public boolean beforeScenario(ScenarioRuntime sr) {
        Optional<Maybe> optionalId = Optional.ofNullable(this.featureIdMap.get(sr.featureRuntime.featureCall.feature.getNameForReport())).map(Supplier::get);
        if (optionalId.isEmpty()) {
            LOGGER.error("ERROR: Trying to post unspecified feature.");
        }
        optionalId.ifPresent(featureId -> {
            StartTestItemRQ rq = this.buildStartScenarioRq(sr);
            Maybe scenarioId = ((Launch)this.launch.get()).startTestItem(featureId, rq);
            this.scenarioIdMap.put(sr.scenario.getUniqueId(), (Maybe<String>)scenarioId);
        });
        return true;
    }

    @Nonnull
    protected FinishTestItemRQ buildFinishScenarioRq(@Nonnull ScenarioRuntime sr) {
        return ReportPortalUtils.buildFinishScenarioRq(sr.result);
    }

    @Nonnull
    protected StartTestItemRQ buildStartBackgroundRq(@Nonnull Step step, @Nonnull ScenarioRuntime sr) {
        return ReportPortalUtils.buildStartBackgroundRq(step, sr.scenario);
    }

    public Maybe<String> startBackground(@Nonnull Step step, @Nonnull ScenarioRuntime sr) {
        return this.backgroundIdMap.computeIfAbsent(sr.scenario.getUniqueId(), k -> {
            StartTestItemRQ backgroundRq = this.buildStartBackgroundRq(step, sr);
            return ((Launch)this.launch.get()).startTestItem(this.scenarioIdMap.get(sr.scenario.getUniqueId()), backgroundRq);
        });
    }

    @Nonnull
    protected FinishTestItemRQ buildFinishBackgroundRq(@Nullable StepResult stepResult, @Nonnull ScenarioRuntime sr) {
        return ReportPortalUtils.buildFinishTestItemRq(Calendar.getInstance().getTime(), this.backgroundStatusMap.remove(sr.scenario.getUniqueId()));
    }

    public void finishBackground(@Nullable StepResult stepResult, @Nonnull ScenarioRuntime sr) {
        String uniqueId = sr.scenario.getUniqueId();
        Maybe<String> backgroundId = this.backgroundIdMap.remove(uniqueId);
        if (backgroundId != null) {
            FinishTestItemRQ finishRq = this.buildFinishBackgroundRq(stepResult, sr);
            ((Launch)this.launch.get()).finishTestItem(backgroundId, finishRq);
        }
    }

    public void afterScenario(ScenarioRuntime sr) {
        Maybe<String> scenarioId = this.scenarioIdMap.remove(sr.scenario.getUniqueId());
        if (scenarioId == null) {
            LOGGER.error("ERROR: Trying to finish unspecified scenario.");
        }
        this.finishBackground(null, sr);
        FinishTestItemRQ rq = this.buildFinishScenarioRq(sr);
        ((Launch)this.launch.get()).finishTestItem(scenarioId, rq);
    }

    @Nonnull
    private Date getStepStartTime(@Nullable Maybe<String> stepId) {
        Date currentStepStartTime = Calendar.getInstance().getTime();
        if (stepId == null || this.stepStartTimeMap.isEmpty()) {
            return currentStepStartTime;
        }
        Date lastStepStartTime = this.stepStartTimeMap.get(stepId);
        if (lastStepStartTime.compareTo(currentStepStartTime) >= 0) {
            currentStepStartTime.setTime(lastStepStartTime.getTime() + 1L);
        }
        return currentStepStartTime;
    }

    @Nonnull
    protected StartTestItemRQ buildStartStepRq(@Nonnull Step step, @Nonnull ScenarioRuntime sr) {
        StartTestItemRQ rq = ReportPortalUtils.buildStartStepRq(step, sr.scenario);
        Maybe<String> stepId = this.stepIdMap.get(sr.scenario.getUniqueId());
        Date startTime = this.getStepStartTime(stepId);
        rq.setStartTime(startTime);
        return rq;
    }

    protected void sendLog(Maybe<String> itemId, String message, LogLevel level) {
        ReportPortalUtils.sendLog(itemId, message, level);
    }

    public boolean beforeStep(Step step, ScenarioRuntime sr) {
        boolean background = step.isBackground();
        Maybe<String> backgroundId = null;
        if (background) {
            backgroundId = this.startBackground(step, sr);
        }
        StartTestItemRQ stepRq = this.buildStartStepRq(step, sr);
        String scenarioId = sr.scenario.getUniqueId();
        Maybe stepId = ((Launch)this.launch.get()).startTestItem(background ? backgroundId : this.scenarioIdMap.get(scenarioId), stepRq);
        this.stepStartTimeMap.put((Maybe<String>)stepId, stepRq.getStartTime());
        this.stepIdMap.put(scenarioId, (Maybe<String>)stepId);
        Optional.ofNullable(stepRq.getParameters()).filter(params -> !params.isEmpty()).ifPresent(params -> this.sendLog((Maybe<String>)stepId, String.format("Parameters:\n\n%s", ParameterUtils.formatParametersAsTable((List)params)), LogLevel.INFO));
        Optional.ofNullable(step.getTable()).ifPresent(table -> this.sendLog((Maybe<String>)stepId, "Table:\n\n" + MarkdownUtils.formatDataTable((List)table.getRows()), LogLevel.INFO));
        String docString = step.getDocString();
        if (StringUtils.isNotBlank((CharSequence)docString)) {
            this.sendLog((Maybe<String>)stepId, "Docstring:\n\n" + ReportPortalUtils.asMarkdownCode(step.getDocString()), LogLevel.INFO);
        }
        return true;
    }

    public void sendStepResults(StepResult stepResult, ScenarioRuntime sr) {
        Maybe<String> stepId = this.stepIdMap.get(sr.scenario.getUniqueId());
        Step step = stepResult.getStep();
        Result result = stepResult.getResult();
        if (result.isFailed()) {
            String fullErrorMessage = step.getPrefix() + " " + step.getText();
            String errorMessage = result.getErrorMessage();
            if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
                fullErrorMessage = fullErrorMessage + "\n" + errorMessage;
            }
            this.sendLog(stepId, fullErrorMessage, LogLevel.ERROR);
        }
    }

    @Nonnull
    protected FinishTestItemRQ buildFinishStepRq(@Nonnull StepResult stepResult, @Nonnull ScenarioRuntime sr) {
        return ReportPortalUtils.buildFinishTestItemRq(Calendar.getInstance().getTime(), ReportPortalUtils.getStepStatus(stepResult.getResult().getStatus()));
    }

    private void saveBackgroundStatus(@Nonnull StepResult stepResult, @Nonnull ScenarioRuntime sr) {
        this.backgroundStatusMap.put(sr.scenario.getUniqueId(), StatusEvaluation.evaluateStatus((ItemStatus)this.backgroundStatusMap.get(sr.scenario.getUniqueId()), (ItemStatus)ReportPortalUtils.getStepStatus(stepResult.getResult().getStatus())));
    }

    public void afterStep(StepResult stepResult, ScenarioRuntime sr) {
        boolean background = stepResult.getStep().isBackground();
        if (!background) {
            this.finishBackground(stepResult, sr);
        }
        this.sendStepResults(stepResult, sr);
        Maybe<String> stepId = this.stepIdMap.get(sr.scenario.getUniqueId());
        if (stepId == null) {
            LOGGER.error("ERROR: Trying to finish unspecified step.");
            return;
        }
        FinishTestItemRQ rq = this.buildFinishStepRq(stepResult, sr);
        if (background) {
            this.saveBackgroundStatus(stepResult, sr);
        }
        ((Launch)this.launch.get()).finishTestItem(stepId, rq);
    }

    public void beforeHttpCall(HttpRequest request, ScenarioRuntime sr) {
        super.beforeHttpCall(request, sr);
    }

    public void afterHttpCall(HttpRequest request, Response response, ScenarioRuntime sr) {
        super.afterHttpCall(request, response, sr);
    }

    public void beforeSuite(Suite suite) {
    }

    public void afterSuite(Suite suite) {
    }
}

