/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.karate;

import com.epam.reportportal.karate.ReportPortalUtils;
import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.listeners.LogLevel;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.ReportPortal;
import com.epam.reportportal.utils.MemoizingSupplier;
import com.epam.reportportal.utils.ParameterUtils;
import com.epam.reportportal.utils.StatusEvaluation;
import com.epam.reportportal.utils.markdown.MarkdownUtils;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.Result;
import com.intuit.karate.core.ScenarioResult;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.StepResult;
import io.reactivex.Maybe;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportPortalPublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportPortalPublisher.class);
    protected final MemoizingSupplier<Launch> launch;
    private final Map<String, Maybe<String>> featureIdMap = new HashMap<String, Maybe<String>>();
    private final Map<String, Maybe<String>> scenarioIdMap = new HashMap<String, Maybe<String>>();
    private final Map<Maybe<String>, Long> stepStartTimeMap = new HashMap<Maybe<String>, Long>();
    private Maybe<String> backgroundId;
    private ItemStatus backgroundStatus;
    private Maybe<String> stepId;
    private Thread shutDownHook;

    public ReportPortalPublisher(ReportPortal reportPortal) {
        this.launch = new MemoizingSupplier(() -> {
            ListenerParameters params = reportPortal.getParameters();
            StartLaunchRQ rq = this.buildStartLaunchRq(params);
            Launch newLaunch = reportPortal.newLaunch(rq);
            this.shutDownHook = ReportPortalUtils.registerShutdownHook(this::finishLaunch);
            return newLaunch;
        });
    }

    public ReportPortalPublisher(Supplier<Launch> launchSupplier) {
        this.launch = new MemoizingSupplier(launchSupplier);
    }

    protected StartLaunchRQ buildStartLaunchRq(ListenerParameters parameters) {
        return ReportPortalUtils.buildStartLaunchRq(parameters);
    }

    public void startLaunch() {
        ((Launch)this.launch.get()).start();
    }

    @Nonnull
    protected FinishExecutionRQ buildFinishLaunchRq(@Nonnull ListenerParameters parameters) {
        return ReportPortalUtils.buildFinishLaunchRq(parameters);
    }

    public void finishLaunch() {
        Launch launchObject = (Launch)this.launch.get();
        ListenerParameters parameters = launchObject.getParameters();
        FinishExecutionRQ rq = this.buildFinishLaunchRq(parameters);
        LOGGER.info("Launch URL: {}/ui/#{}/launches/all/{}", new Object[]{parameters.getBaseUrl(), parameters.getProjectName(), System.getProperty("rp.launch.id")});
        launchObject.finish(rq);
        if (this.shutDownHook != null && Thread.currentThread() != this.shutDownHook) {
            ReportPortalUtils.unregisterShutdownHook(this.shutDownHook);
        }
    }

    @Nonnull
    protected StartTestItemRQ buildStartFeatureRq(@Nonnull FeatureResult featureResult) {
        return ReportPortalUtils.buildStartFeatureRq(featureResult.getFeature());
    }

    public void startFeature(@Nonnull FeatureResult featureResult) {
        StartTestItemRQ rq = this.buildStartFeatureRq(featureResult);
        Maybe featureId = ((Launch)this.launch.get()).startTestItem(rq);
        this.featureIdMap.put(featureResult.getCallNameForReport(), (Maybe<String>)featureId);
    }

    @Nonnull
    protected FinishTestItemRQ buildFinishFeatureRq(@Nonnull FeatureResult featureResult) {
        return ReportPortalUtils.buildFinishTestItemRq(Calendar.getInstance().getTime(), featureResult.isFailed() ? ItemStatus.FAILED : ItemStatus.PASSED);
    }

    public void finishFeature(FeatureResult featureResult) {
        if (!this.featureIdMap.containsKey(featureResult.getCallNameForReport())) {
            LOGGER.error("ERROR: Trying to finish unspecified feature.");
        }
        for (ScenarioResult scenarioResult : featureResult.getScenarioResults()) {
            this.startScenario(scenarioResult, featureResult);
            List stepResults = scenarioResult.getStepResults();
            for (StepResult stepResult : stepResults) {
                this.startStep(stepResult, scenarioResult);
                this.sendStepResults(stepResult);
                this.finishStep(stepResult, scenarioResult);
            }
            this.stepStartTimeMap.clear();
            this.finishScenario(scenarioResult);
        }
        FinishTestItemRQ rq = this.buildFinishFeatureRq(featureResult);
        ((Launch)this.launch.get()).finishTestItem(this.featureIdMap.remove(featureResult.getCallNameForReport()), rq);
    }

    @Nonnull
    protected StartTestItemRQ buildStartScenarioRq(@Nonnull ScenarioResult scenarioResult) {
        return ReportPortalUtils.buildStartScenarioRq(scenarioResult);
    }

    public void startScenario(ScenarioResult scenarioResult, FeatureResult featureResult) {
        StartTestItemRQ rq = this.buildStartScenarioRq(scenarioResult);
        Maybe scenarioId = ((Launch)this.launch.get()).startTestItem(this.featureIdMap.get(featureResult.getCallNameForReport()), rq);
        this.scenarioIdMap.put(scenarioResult.getScenario().getName(), (Maybe<String>)scenarioId);
    }

    @Nonnull
    protected FinishTestItemRQ buildFinishScenarioRq(@Nonnull ScenarioResult scenarioResult) {
        return ReportPortalUtils.buildFinishScenarioRq(scenarioResult);
    }

    public void finishScenario(ScenarioResult scenarioResult) {
        if (!this.scenarioIdMap.containsKey(scenarioResult.getScenario().getName())) {
            LOGGER.error("ERROR: Trying to finish unspecified scenario.");
        }
        FinishTestItemRQ rq = this.buildFinishScenarioRq(scenarioResult);
        Maybe<String> removedScenarioId = this.scenarioIdMap.remove(scenarioResult.getScenario().getName());
        ((Launch)this.launch.get()).finishTestItem(removedScenarioId, rq);
        this.finishBackground(null, scenarioResult);
    }

    @Nonnull
    protected StartTestItemRQ buildStartBackgroundRq(@Nonnull StepResult stepResult, @Nonnull ScenarioResult scenarioResult) {
        return ReportPortalUtils.buildStartBackgroundRq(stepResult.getStep(), scenarioResult.getScenario());
    }

    public void startBackground(@Nonnull StepResult stepResult, @Nonnull ScenarioResult scenarioResult) {
        this.backgroundId = Optional.ofNullable(this.backgroundId).orElseGet(() -> {
            StartTestItemRQ backgroundRq = this.buildStartBackgroundRq(stepResult, scenarioResult);
            return ((Launch)this.launch.get()).startTestItem(this.scenarioIdMap.get(scenarioResult.getScenario().getName()), backgroundRq);
        });
    }

    @Nonnull
    protected FinishTestItemRQ buildFinishBackgroundRq(@Nullable StepResult stepResult, @Nonnull ScenarioResult scenarioResult) {
        return ReportPortalUtils.buildFinishTestItemRq(Calendar.getInstance().getTime(), this.backgroundStatus);
    }

    public void finishBackground(@Nullable StepResult stepResult, @Nonnull ScenarioResult scenarioResult) {
        Maybe<String> myBackgroundId = this.backgroundId;
        this.backgroundId = null;
        Optional.ofNullable(myBackgroundId).ifPresent(id -> {
            FinishTestItemRQ finishRq = this.buildFinishBackgroundRq(stepResult, scenarioResult);
            ((Launch)this.launch.get()).finishTestItem(id, finishRq);
        });
    }

    private Date getStepStartTime(@Nonnull Maybe<String> stepId) {
        long lastStepStartTime;
        long currentStepStartTime = Calendar.getInstance().getTime().getTime();
        if (!this.stepStartTimeMap.keySet().isEmpty() && (lastStepStartTime = this.stepStartTimeMap.get(stepId).longValue()) >= currentStepStartTime) {
            currentStepStartTime += lastStepStartTime - currentStepStartTime + 1L;
        }
        return new Date(currentStepStartTime);
    }

    @Nonnull
    protected StartTestItemRQ buildStartStepRq(@Nonnull StepResult stepResult, @Nonnull ScenarioResult scenarioResult) {
        StartTestItemRQ rq = ReportPortalUtils.buildStartStepRq(stepResult.getStep(), scenarioResult.getScenario());
        Date startTime = this.getStepStartTime(this.stepId);
        rq.setStartTime(startTime);
        return rq;
    }

    public void startStep(StepResult stepResult, ScenarioResult scenarioResult) {
        Step step = stepResult.getStep();
        boolean background = step.isBackground();
        if (background) {
            this.startBackground(stepResult, scenarioResult);
        }
        StartTestItemRQ stepRq = this.buildStartStepRq(stepResult, scenarioResult);
        this.stepId = ((Launch)this.launch.get()).startTestItem(background && this.backgroundId != null ? this.backgroundId : this.scenarioIdMap.get(scenarioResult.getScenario().getName()), stepRq);
        this.stepStartTimeMap.put(this.stepId, stepRq.getStartTime().getTime());
        Optional.ofNullable(stepRq.getParameters()).filter(params -> !params.isEmpty()).ifPresent(params -> this.sendLog(this.stepId, String.format("Parameters:\n\n%s", ParameterUtils.formatParametersAsTable((List)params)), LogLevel.INFO));
        Optional.ofNullable(step.getTable()).ifPresent(table -> this.sendLog(this.stepId, "Table:\n\n" + MarkdownUtils.formatDataTable((List)table.getRows()), LogLevel.INFO));
        String docString = step.getDocString();
        if (StringUtils.isNotBlank((CharSequence)docString)) {
            this.sendLog(this.stepId, "Docstring:\n\n" + ReportPortalUtils.asMarkdownCode(step.getDocString()), LogLevel.INFO);
        }
    }

    @Nonnull
    protected FinishTestItemRQ buildFinishStepRq(@Nonnull StepResult stepResult, @Nonnull ScenarioResult scenarioResult) {
        return ReportPortalUtils.buildFinishTestItemRq(Calendar.getInstance().getTime(), ReportPortalUtils.getStepStatus(stepResult.getResult().getStatus()));
    }

    private void saveBackgroundStatus(@Nonnull StepResult stepResult, @Nonnull ScenarioResult scenarioResult) {
        this.backgroundStatus = StatusEvaluation.evaluateStatus((ItemStatus)this.backgroundStatus, (ItemStatus)ReportPortalUtils.getStepStatus(stepResult.getResult().getStatus()));
    }

    public void finishStep(StepResult stepResult, ScenarioResult scenarioResult) {
        Step step = stepResult.getStep();
        boolean background = step.isBackground();
        if (!background) {
            this.finishBackground(stepResult, scenarioResult);
        }
        if (this.stepId == null) {
            LOGGER.error("ERROR: Trying to finish unspecified step.");
            return;
        }
        FinishTestItemRQ rq = this.buildFinishStepRq(stepResult, scenarioResult);
        if (background) {
            this.saveBackgroundStatus(stepResult, scenarioResult);
        }
        ((Launch)this.launch.get()).finishTestItem(this.stepId, rq);
    }

    protected void sendLog(Maybe<String> itemId, String message, LogLevel level) {
        ReportPortalUtils.sendLog(itemId, message, level);
    }

    public void sendStepResults(StepResult stepResult) {
        Step step = stepResult.getStep();
        Result result = stepResult.getResult();
        String stepLog = stepResult.getStepLog();
        if (StringUtils.isNotBlank((CharSequence)stepLog)) {
            this.sendLog(this.stepId, stepLog, LogLevel.DEBUG);
        }
        if (result.isFailed()) {
            String fullErrorMessage = step.getPrefix() + " " + step.getText();
            String errorMessage = result.getErrorMessage();
            if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
                fullErrorMessage = fullErrorMessage + "\n" + errorMessage;
            }
            this.sendLog(this.stepId, fullErrorMessage, LogLevel.ERROR);
        }
    }
}

