/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.karate;

import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.listeners.ItemType;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.listeners.LogLevel;
import com.epam.reportportal.service.ReportPortal;
import com.epam.reportportal.service.item.TestCaseIdEntry;
import com.epam.reportportal.utils.AttributeParser;
import com.epam.reportportal.utils.ParameterUtils;
import com.epam.reportportal.utils.TestCaseIdUtils;
import com.epam.reportportal.utils.formatting.MarkdownUtils;
import com.epam.reportportal.utils.properties.SystemAttributesExtractor;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.ParameterResource;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioResult;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.Tag;
import io.reactivex.Maybe;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportPortalUtils {
    public static final String MARKDOWN_CODE_PATTERN = "```\n%s\n```";
    public static final String PARAMETERS_PATTERN = "Parameters:\n\n%s";
    public static final String VARIABLE_PATTERN = "(?:(?<=#\\()%1$s(?=\\)))|(?:(?<=[\\s=+-/*<>(]|^)%1$s(?=[\\s=+-/*<>)]|(?:\\r?\\n)|$))";
    public static final String AGENT_PROPERTIES_FILE = "agent.properties";
    public static final String SKIPPED_ISSUE_KEY = "skippedIssue";
    public static final String SCENARIO_CODE_REFERENCE_PATTERN = "%s/[SCENARIO:%s]";
    public static final String EXAMPLE_CODE_REFERENCE_PATTERN = "%s/[EXAMPLE:%s%s]";
    public static final String MARKDOWN_DELIMITER = "\n\n---\n\n";
    public static final String MARKDOWN_DELIMITER_PATTERN = "%s\n\n---\n\n%s";
    public static final String FEATURE_TAG = "Feature: ";
    public static final String SCENARIO_TAG = "Scenario: ";
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportPortalUtils.class);
    private static final String PARAMETER_ITEMS_START = "[";
    private static final String PARAMETER_ITEMS_END = "]";
    private static final String PARAMETER_ITEMS_DELIMITER = ";";
    private static final String KEY_VALUE_SEPARATOR = ":";

    private ReportPortalUtils() {
        throw new RuntimeException("No instances should exist for the class!");
    }

    public static String formatExampleKey(@Nonnull Map<String, Object> example) {
        return example.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> (String)e.getKey() + KEY_VALUE_SEPARATOR + e.getValue().toString()).collect(Collectors.joining(PARAMETER_ITEMS_DELIMITER, PARAMETER_ITEMS_START, PARAMETER_ITEMS_END));
    }

    @Nonnull
    public static Thread createShutdownHook(@Nonnull Runnable actions) {
        return new Thread(actions);
    }

    @Nonnull
    public static Thread registerShutdownHook(@Nonnull Runnable actions) {
        Thread shutDownHook = ReportPortalUtils.createShutdownHook(actions);
        Runtime.getRuntime().addShutdownHook(shutDownHook);
        return shutDownHook;
    }

    public static void unregisterShutdownHook(@Nonnull Thread hook) {
        Runtime.getRuntime().removeShutdownHook(hook);
    }

    @Nonnull
    public static StartLaunchRQ buildStartLaunchRq(@Nonnull ListenerParameters parameters) {
        StartLaunchRQ rq = new StartLaunchRQ();
        rq.setName(parameters.getLaunchName());
        rq.setStartTime(Calendar.getInstance().getTime());
        rq.setMode(parameters.getLaunchRunningMode());
        rq.setAttributes(new HashSet(parameters.getAttributes()));
        if (StringUtils.isNotBlank((CharSequence)parameters.getDescription())) {
            rq.setDescription(parameters.getDescription());
        }
        rq.setRerun(parameters.isRerun());
        if (StringUtils.isNotBlank((CharSequence)parameters.getRerunOf())) {
            rq.setRerunOf(parameters.getRerunOf());
        }
        if (null != parameters.getSkippedAnIssue()) {
            ItemAttributesRQ skippedIssueAttribute = new ItemAttributesRQ();
            skippedIssueAttribute.setKey(SKIPPED_ISSUE_KEY);
            skippedIssueAttribute.setValue(parameters.getSkippedAnIssue().toString());
            skippedIssueAttribute.setSystem(true);
            rq.getAttributes().add(skippedIssueAttribute);
        }
        rq.getAttributes().addAll(SystemAttributesExtractor.extract((String)AGENT_PROPERTIES_FILE, (ClassLoader)ReportPortalUtils.class.getClassLoader()));
        return rq;
    }

    @Nonnull
    public static FinishExecutionRQ buildFinishLaunchRq(@Nonnull ListenerParameters parameters) {
        FinishExecutionRQ rq = new FinishExecutionRQ();
        rq.setEndTime(Calendar.getInstance().getTime());
        return rq;
    }

    @Nonnull
    public static String getCodeRef(@Nonnull Scenario scenario) {
        if (scenario.isOutlineExample()) {
            return String.format(EXAMPLE_CODE_REFERENCE_PATTERN, scenario.getFeature().getResource().getRelativePath(), scenario.getName(), ReportPortalUtils.formatExampleKey(scenario.getExampleData()));
        }
        return String.format(SCENARIO_CODE_REFERENCE_PATTERN, scenario.getFeature().getResource().getRelativePath(), scenario.getName());
    }

    @Nonnull
    public static StartTestItemRQ buildStartTestItemRq(@Nonnull String name, @Nonnull Date startTime, @Nonnull ItemType type) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(name);
        rq.setStartTime(startTime);
        rq.setType(type.name());
        return rq;
    }

    @Nonnull
    public static FinishTestItemRQ buildFinishTestItemRq(@Nonnull Date endTime, @Nullable ItemStatus status) {
        FinishTestItemRQ rq = new FinishTestItemRQ();
        rq.setEndTime(endTime);
        rq.setStatus((String)Optional.ofNullable(status).map(Enum::name).orElse(null));
        return rq;
    }

    @Nullable
    public static Set<ItemAttributesRQ> toAttributes(@Nullable List<Tag> tags) {
        Set<ItemAttributesRQ> attributes = Optional.ofNullable(tags).orElse(Collections.emptyList()).stream().flatMap(tag -> {
            if (tag.getValues().isEmpty()) {
                return Stream.of(new ItemAttributesRQ(null, tag.getName()));
            }
            return AttributeParser.createItemAttributes((String)tag.getName(), (String[])tag.getValues().toArray(new String[0])).stream();
        }).collect(Collectors.toSet());
        return attributes.isEmpty() ? null : attributes;
    }

    @Nonnull
    public static StartTestItemRQ buildStartFeatureRq(@Nonnull Feature feature) {
        StartTestItemRQ rq = ReportPortalUtils.buildStartTestItemRq(feature.getName(), Calendar.getInstance().getTime(), ItemType.STORY);
        rq.setAttributes(ReportPortalUtils.toAttributes(feature.getTags()));
        String featurePath = feature.getResource().getUri().toString();
        String description = feature.getDescription();
        if (StringUtils.isNotBlank((CharSequence)description)) {
            rq.setDescription(MarkdownUtils.asTwoParts((String)featurePath, (String)description));
        } else {
            rq.setDescription(featurePath);
        }
        return rq;
    }

    @Nonnull
    public static List<ParameterResource> getParameters(@Nonnull Map<String, Object> args) {
        return args.entrySet().stream().map(e -> {
            ParameterResource parameterResource = new ParameterResource();
            parameterResource.setKey((String)e.getKey());
            parameterResource.setValue(Optional.ofNullable(e.getValue()).map(Object::toString).orElse("NULL"));
            return parameterResource;
        }).collect(Collectors.toList());
    }

    @Nullable
    public static List<ParameterResource> getParameters(@Nonnull Scenario scenario) {
        if (!scenario.isOutlineExample()) {
            return null;
        }
        return ReportPortalUtils.getParameters(scenario.getExampleData());
    }

    @Nullable
    public static TestCaseIdEntry getTestCaseId(@Nonnull Scenario scenario) {
        return TestCaseIdUtils.getTestCaseId((String)ReportPortalUtils.getCodeRef(scenario), null);
    }

    @Nonnull
    public static StartTestItemRQ buildStartScenarioRq(@Nonnull ScenarioResult result) {
        Scenario scenario = result.getScenario();
        StartTestItemRQ rq = ReportPortalUtils.buildStartTestItemRq(scenario.getName(), Calendar.getInstance().getTime(), ItemType.STEP);
        rq.setCodeRef(ReportPortalUtils.getCodeRef(scenario));
        rq.setTestCaseId((String)Optional.ofNullable(ReportPortalUtils.getTestCaseId(scenario)).map(TestCaseIdEntry::getId).orElse(null));
        rq.setAttributes(ReportPortalUtils.toAttributes(scenario.getTags()));
        rq.setParameters(ReportPortalUtils.getParameters(scenario));
        rq.setDescription(ReportPortalUtils.buildDescription(scenario, result.getErrorMessage(), ReportPortalUtils.getParameters(scenario)));
        return rq;
    }

    @Nonnull
    public static FinishTestItemRQ buildFinishScenarioRq(@Nonnull ScenarioResult result) {
        Scenario scenario = result.getScenario();
        FinishTestItemRQ rq = ReportPortalUtils.buildFinishTestItemRq(Calendar.getInstance().getTime(), result.getFailureMessageForDisplay() == null ? ItemStatus.PASSED : ItemStatus.FAILED);
        rq.setDescription(ReportPortalUtils.buildDescription(scenario, result.getErrorMessage(), ReportPortalUtils.getParameters(scenario)));
        return rq;
    }

    @Nonnull
    private static String buildDescription(@Nonnull Scenario scenario, @Nullable String errorMessage, @Nullable List<ParameterResource> parameters) {
        StringBuilder descriptionBuilder = new StringBuilder();
        if (parameters != null && !parameters.isEmpty()) {
            descriptionBuilder.append(String.format(PARAMETERS_PATTERN, ParameterUtils.formatParametersAsTable(parameters)));
        }
        if (StringUtils.isNotBlank((CharSequence)scenario.getDescription())) {
            ReportPortalUtils.appendWithDelimiter(descriptionBuilder, scenario.getDescription());
        }
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            ReportPortalUtils.appendWithDelimiter(descriptionBuilder, String.format("Error:\n%s", errorMessage));
        }
        return descriptionBuilder.toString();
    }

    private static void appendWithDelimiter(StringBuilder builder, String text) {
        if (builder.length() > 0) {
            builder.append(MARKDOWN_DELIMITER);
        }
        builder.append(text);
    }

    @Nonnull
    public static StartTestItemRQ buildStartBackgroundRq(@Nonnull Step step, @Nonnull Scenario scenario) {
        StartTestItemRQ rq = ReportPortalUtils.buildStartTestItemRq("Background", Calendar.getInstance().getTime(), ItemType.STEP);
        rq.setHasStats(false);
        return rq;
    }

    @Nonnull
    public static StartTestItemRQ buildStartStepRq(@Nonnull Step step, @Nonnull Scenario scenario) {
        String stepName = step.getPrefix() + " " + step.getText();
        StartTestItemRQ rq = ReportPortalUtils.buildStartTestItemRq(stepName, Calendar.getInstance().getTime(), ItemType.STEP);
        rq.setHasStats(false);
        if (step.isOutline()) {
            List parameters = scenario.getExampleData().entrySet().stream().filter(e -> Pattern.compile(String.format(VARIABLE_PATTERN, e.getKey())).matcher(step.getText()).find()).map(e -> {
                ParameterResource param = new ParameterResource();
                param.setKey((String)e.getKey());
                String value = Optional.ofNullable(e.getValue()).map(Object::toString).orElse("NULL");
                param.setValue(value);
                return param;
            }).collect(Collectors.toList());
            rq.setParameters(parameters);
        }
        return rq;
    }

    public static ItemStatus getStepStatus(String status) {
        switch (status) {
            case "failed": {
                return ItemStatus.FAILED;
            }
            case "passed": {
                return ItemStatus.PASSED;
            }
            case "skipped": {
                return ItemStatus.SKIPPED;
            }
            case "stopped": {
                return ItemStatus.STOPPED;
            }
            case "interrupted": {
                return ItemStatus.INTERRUPTED;
            }
            case "cancelled": {
                return ItemStatus.CANCELLED;
            }
        }
        LOGGER.warn("Unknown step status received! Set it as SKIPPED");
        return ItemStatus.SKIPPED;
    }

    public static void sendLog(Maybe<String> itemId, String message, LogLevel level, Date logTime) {
        ReportPortal.emitLog(itemId, id -> {
            SaveLogRQ rq = new SaveLogRQ();
            rq.setMessage(message);
            rq.setItemUuid(id);
            rq.setLevel(level.name());
            rq.setLogTime(logTime);
            return rq;
        });
    }

    public static void sendLog(Maybe<String> itemId, String message, LogLevel level) {
        ReportPortalUtils.sendLog(itemId, message, level, Calendar.getInstance().getTime());
    }

    public static String asMarkdownCode(String code) {
        return String.format(MARKDOWN_CODE_PATTERN, code);
    }

    public static String getInnerScenarioName(String name) {
        return SCENARIO_TAG + name;
    }

    public static String getInnerFeatureName(String name) {
        return FEATURE_TAG + name;
    }
}

