/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.karate.utils;

import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingConcurrentHashMap<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockingConcurrentHashMap.class);
    private static final int TIMEOUT = 1;
    private static final TimeUnit TIMEOUT_UNIT = TimeUnit.MINUTES;
    private final Map<K, BlockingReference<V>> map = new ConcurrentHashMap<K, BlockingReference<V>>();

    public void computeIfAbsent(@Nonnull K key, Function<K, V> mappingFunction) {
        this.map.computeIfAbsent(key, (? super K k) -> new BlockingReference()).set(mappingFunction);
    }

    @Nullable
    public V get(@Nonnull K key) {
        try {
            return (V)this.map.computeIfAbsent(key, (? super K k) -> new BlockingReference()).get(1L, TIMEOUT_UNIT);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Wait for value was interrupted", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public V remove(@Nonnull K key) {
        try {
            return this.map.remove(key).get(1L, TIMEOUT_UNIT);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Wait for value was interrupted", (Throwable)e);
            return null;
        }
    }

    private static final class BlockingReference<T> {
        private final BlockingQueue<T> lock = new ArrayBlockingQueue<T>(1);
        private volatile boolean set = false;
        private volatile T value;

        private BlockingReference() {
        }

        public void set(Function<?, T> supplier) {
            this.lock.clear();
            this.set = false;
            try {
                this.value = supplier.apply(null);
                this.set = true;
                try {
                    while (this.lock.offer(this.value)) {
                    }
                }
                catch (IllegalStateException illegalStateException) {
                }
            }
            catch (Exception e) {
                LOGGER.warn("Unable to get result value from passed supplier.", (Throwable)e);
                throw e;
            }
        }

        public T get(long timeout, TimeUnit unit) throws InterruptedException {
            if (!this.set) {
                return this.lock.poll(timeout, unit);
            }
            return this.value;
        }
    }
}

