/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.util.test;

import io.reactivex.Maybe;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;

public class CommonUtils {
    public static final long MINIMAL_TEST_PAUSE = 20L;

    private CommonUtils() {
    }

    public static ExecutorService testExecutor() {
        return Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        });
    }

    public static void shutdownExecutorService(ExecutorService executor) {
        if (executor == null || executor.isShutdown()) {
            return;
        }
        executor.shutdown();
        try {
            if (!executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
            }
        }
        catch (InterruptedException ignore) {
            executor.shutdownNow();
        }
    }

    public static String generateUniqueId() {
        return System.currentTimeMillis() + "-" + Thread.currentThread().getId() + "-" + ThreadLocalRandom.current().nextInt(9999);
    }

    public static String namedId(String name) {
        return name + CommonUtils.generateUniqueId();
    }

    public static Maybe<String> createMaybeUuid() {
        return Maybe.just((Object)UUID.randomUUID().toString());
    }
}

