/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.util.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.hamcrest.Matchers;

public class ProcessUtils {
    private ProcessUtils() {
    }

    private static String getPathToClass(@Nonnull Class<?> mainClass) {
        return mainClass.getCanonicalName();
    }

    public static Process buildProcess(boolean inheritOutput, @Nonnull Class<?> mainClass, @Nullable Map<String, String> additionalEnvironmentVariables, @Nullable Map<String, String> additionSystemVariables, String ... params) throws IOException {
        String javaHome;
        String fileSeparator = FileSystems.getDefault().getSeparator();
        String executablePath = StringUtils.joinWith((String)fileSeparator, (Object[])new Object[]{javaHome = System.getProperty("java.home"), "bin", "java"});
        File executableFile = new File(executablePath);
        if (!executableFile.exists() && !(executableFile = new File(executablePath = executablePath + ".exe")).exists()) {
            throw new ExecutableNotFoundException("Unable to find java executable file.");
        }
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(executablePath);
        paramList.add("-classpath");
        paramList.add(System.getProperty("java.class.path"));
        paramList.addAll(Optional.ofNullable(additionSystemVariables).map(p -> p.entrySet().stream().map(e -> "-D" + (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.toList())).orElse(Collections.emptyList()));
        paramList.add(ProcessUtils.getPathToClass(mainClass));
        paramList.addAll(Arrays.asList(params));
        ProcessBuilder pb = new ProcessBuilder(paramList);
        if (inheritOutput) {
            pb.inheritIO();
        }
        Optional.ofNullable(additionalEnvironmentVariables).ifPresent(v -> pb.environment().putAll((Map<String, String>)v));
        return pb.start();
    }

    public static Process buildProcess(boolean inheritOutput, @Nonnull Class<?> mainClass, @Nullable Map<String, String> additionalEnvironmentVariables, String ... params) throws IOException {
        return ProcessUtils.buildProcess(inheritOutput, mainClass, additionalEnvironmentVariables, null, params);
    }

    public static Process buildProcess(Class<?> mainClass, String ... params) throws IOException {
        return ProcessUtils.buildProcess(false, mainClass, null, null, params);
    }

    public static Process buildProcess(boolean inheritOutput, Class<?> mainClass, String ... params) throws IOException {
        return ProcessUtils.buildProcess(inheritOutput, mainClass, null, null, params);
    }

    public static Triple<OutputStreamWriter, BufferedReader, BufferedReader> getProcessIos(Process process) {
        return ImmutableTriple.of((Object)new OutputStreamWriter(process.getOutputStream(), StandardCharsets.UTF_8), (Object)new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8)), (Object)new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8)));
    }

    public static void closeIos(Triple<OutputStreamWriter, BufferedReader, BufferedReader> io) {
        try {
            ((OutputStreamWriter)io.getLeft()).close();
            ((BufferedReader)io.getMiddle()).close();
            ((BufferedReader)io.getRight()).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String waitForLine(BufferedReader reader, BufferedReader errorReader, Predicate<String> linePredicate) throws IOException {
        try {
            return (String)Awaitility.await((String)"Waiting for a line").timeout(8L, TimeUnit.SECONDS).pollInterval(100L, TimeUnit.MILLISECONDS).until(() -> {
                String line;
                if (!reader.ready()) {
                    return null;
                }
                while ((line = reader.readLine()) != null) {
                    if (!linePredicate.test(line)) continue;
                    return line;
                }
                return null;
            }, Matchers.notNullValue());
        }
        catch (ConditionTimeoutException e) {
            List errorLines = Collections.EMPTY_LIST;
            if (errorReader.ready()) {
                errorLines = IOUtils.readLines((Reader)errorReader);
            }
            String lineSeparator = System.lineSeparator();
            throw new IllegalStateException("Unable to run test class: " + String.join((CharSequence)lineSeparator, errorLines));
        }
    }

    public static class ExecutableNotFoundException
    extends RuntimeException {
        public ExecutableNotFoundException(String message) {
            super(message);
        }
    }
}

