/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.util.test;

import io.reactivex.Maybe;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CommonUtils {
    public static final long MINIMAL_TEST_PAUSE = 20L;

    private CommonUtils() {
    }

    public static ExecutorService testExecutor() {
        return new ExecutorService(Executors.newSingleThreadExecutor(r -> {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        }));
    }

    public static ExecutorService testExecutor(int threadNum) {
        return new ExecutorService(Executors.newFixedThreadPool(threadNum, r -> {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        }));
    }

    public static <T extends java.util.concurrent.ExecutorService> void shutdownExecutorService(T executor) {
        if (executor == null || executor.isShutdown()) {
            return;
        }
        executor.shutdown();
        try {
            if (!executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
            }
        }
        catch (InterruptedException ignore) {
            executor.shutdownNow();
        }
    }

    public static String generateUniqueId() {
        return System.currentTimeMillis() + "-" + Thread.currentThread().getId() + "-" + ThreadLocalRandom.current().nextInt(9999);
    }

    public static String namedId(String name) {
        return name + CommonUtils.generateUniqueId();
    }

    public static Maybe<String> createMaybeUuid() {
        return Maybe.just((Object)UUID.randomUUID().toString());
    }

    public static class ExecutorService
    implements java.util.concurrent.ExecutorService,
    AutoCloseable {
        private final java.util.concurrent.ExecutorService delegate;

        public ExecutorService(java.util.concurrent.ExecutorService delegate) {
            this.delegate = delegate;
        }

        @Override
        public void shutdown() {
            this.delegate.shutdown();
        }

        @Override
        @Nonnull
        public List<Runnable> shutdownNow() {
            return this.delegate.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return this.delegate.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.delegate.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, @Nonnull TimeUnit unit) throws InterruptedException {
            return this.delegate.awaitTermination(timeout, unit);
        }

        @Override
        @Nonnull
        public <T> Future<T> submit(@Nonnull Callable<T> task) {
            return this.delegate.submit(task);
        }

        @Override
        @Nonnull
        public <T> Future<T> submit(@Nonnull Runnable task, T result) {
            return this.delegate.submit(task, result);
        }

        @Override
        @Nonnull
        public Future<?> submit(@Nonnull Runnable task) {
            return this.delegate.submit(task);
        }

        @Override
        @Nonnull
        public <T> List<Future<T>> invokeAll(@Nonnull Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return this.delegate.invokeAll(tasks);
        }

        @Override
        @Nonnull
        public <T> List<Future<T>> invokeAll(@Nonnull Collection<? extends Callable<T>> tasks, long timeout, @Nonnull TimeUnit unit) throws InterruptedException {
            return this.delegate.invokeAll(tasks, timeout, unit);
        }

        @Override
        @Nonnull
        public <T> T invokeAny(@Nonnull Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return this.delegate.invokeAny(tasks);
        }

        @Override
        public <T> T invokeAny(@Nonnull Collection<? extends Callable<T>> tasks, long timeout, @Nonnull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.delegate.invokeAny(tasks, timeout, unit);
        }

        @Override
        public void execute(@Nonnull Runnable command) {
            this.delegate.execute(command);
        }

        @Override
        public void close() {
            CommonUtils.shutdownExecutorService(this.delegate);
        }
    }
}

