/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.util.test;

import com.epam.reportportal.util.test.CommonUtils;
import jakarta.annotation.Nonnull;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketUtils {
    public static final String CONTENT_LENGTH_HEADER = "Content-Length: ";
    public static final String WEB_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final Logger LOGGER = LoggerFactory.getLogger(SocketUtils.class);

    private SocketUtils() {
    }

    public static ServerSocket getServerSocketOnFreePort() throws IOException {
        return new ServerSocket(0);
    }

    public static <T> Pair<List<String>, T> executeServerCallable(ServerCallable srvCall, Callable<T> clientCallable, long timeoutSeconds) throws Exception {
        Pair result;
        ExecutorService clientExecutor = Executors.newSingleThreadExecutor();
        ExecutorService serverExecutor = Executors.newSingleThreadExecutor();
        Future<List<String>> serverFuture = serverExecutor.submit(srvCall);
        Future<T> clientFuture = clientExecutor.submit(clientCallable);
        try {
            result = Pair.of(serverFuture.get(timeoutSeconds, TimeUnit.SECONDS), clientFuture.get(timeoutSeconds, TimeUnit.SECONDS));
        }
        catch (TimeoutException e) {
            CommonUtils.shutdownExecutorService(clientExecutor);
            CommonUtils.shutdownExecutorService(serverExecutor);
            throw e;
        }
        CommonUtils.shutdownExecutorService(clientExecutor);
        CommonUtils.shutdownExecutorService(serverExecutor);
        return result;
    }

    public static <T> Pair<List<String>, T> executeServerCallable(ServerCallable srvCall, Callable<T> clientCallable) throws Exception {
        return SocketUtils.executeServerCallable(srvCall, clientCallable, 5L);
    }

    public static final class ServerCallable
    implements Callable<List<String>> {
        private final ServerSocket ss;
        private final Map<String, Object> model;
        private final List<String> responseFiles;

        public ServerCallable(@Nonnull ServerSocket serverSocket, @Nonnull Map<String, Object> replacementValues, @Nonnull List<String> responseFilePaths) {
            this.ss = serverSocket;
            this.model = replacementValues;
            this.responseFiles = responseFilePaths;
        }

        public ServerCallable(@Nonnull ServerSocket serverSocket, @Nonnull Map<String, Object> replacementValues, @Nonnull String responseFilePath) {
            this(serverSocket, replacementValues, Collections.singletonList(responseFilePath));
        }

        @Override
        public List<String> call() throws Exception {
            ArrayList<String> results = new ArrayList<String>();
            try (Socket s = this.ss.accept();
                 InputStream is = s.getInputStream();
                 OutputStream os = s.getOutputStream();){
                for (String responseFile : this.responseFiles) {
                    String line;
                    BufferedReader in = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                    StringBuilder builder = new StringBuilder();
                    while ((line = in.readLine()) != null && !line.isEmpty()) {
                        builder.append(line);
                        builder.append(System.lineSeparator());
                    }
                    String headers = builder.toString();
                    if (headers.isEmpty()) {
                        throw new IOException("No headers received from client");
                    }
                    int contentLength = 0;
                    int lengthIdx = headers.indexOf(SocketUtils.CONTENT_LENGTH_HEADER);
                    if (lengthIdx > 0) {
                        contentLength = Integer.parseInt(headers.substring(lengthIdx += SocketUtils.CONTENT_LENGTH_HEADER.length(), headers.indexOf(System.lineSeparator(), lengthIdx)).trim());
                    }
                    if (contentLength > 0) {
                        char[] body = new char[contentLength];
                        int actualRead = in.read(body, 0, contentLength);
                        if (actualRead < contentLength) {
                            throw new IOException("Expected " + contentLength + " bytes, but only read " + actualRead + " bytes");
                        }
                        builder.append(System.lineSeparator());
                        builder.append(new String(body));
                    }
                    results.add(builder.toString());
                    String rs = ((String)Optional.ofNullable(this.getClass().getClassLoader().getResourceAsStream(responseFile)).flatMap(stream -> {
                        try {
                            String responseStr = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                            for (String k : this.model.keySet()) {
                                responseStr = responseStr.replace("{" + k + "}", this.model.get(k).toString());
                            }
                            return Optional.of(responseStr);
                        }
                        catch (IOException ignore) {
                            return Optional.empty();
                        }
                    }).orElseThrow(() -> new IOException("Unable to read file: " + responseFile))).replaceAll("\r?\n", "\r\n");
                    IOUtils.write((String)rs, (OutputStream)os, (Charset)StandardCharsets.UTF_8);
                    os.flush();
                }
            }
            return results;
        }
    }
}

