/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.testng;

import com.epam.reportportal.annotations.ParameterKey;
import com.epam.reportportal.annotations.UniqueID;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.ReportPortal;
import com.epam.reportportal.testng.ITestNGService;
import com.epam.reportportal.testng.TestMethodType;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.ParameterResource;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.issue.Issue;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import io.reactivex.Maybe;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.testng.IAttributes;
import org.testng.IRetryAnalyzer;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.testng.collections.Lists;
import org.testng.internal.ConstructorOrMethod;
import rp.com.google.common.annotations.VisibleForTesting;
import rp.com.google.common.base.Function;
import rp.com.google.common.base.Optional;
import rp.com.google.common.base.Strings;
import rp.com.google.common.base.Supplier;
import rp.com.google.common.base.Throwables;

public class TestNGService
implements ITestNGService {
    public static final String NOT_ISSUE = "NOT_ISSUE";
    public static final String RP_ID = "rp_id";
    public static final String ARGUMENT = "arg";
    private final AtomicBoolean isLaunchFailed = new AtomicBoolean();
    private MemoizingSupplier<Launch> launch;

    public TestNGService() {
        this.launch = new MemoizingSupplier<Launch>(new Supplier<Launch>(){

            public Launch get() {
                ReportPortal reportPortal = ReportPortal.builder().build();
                StartLaunchRQ rq = TestNGService.this.buildStartLaunchRq(reportPortal.getParameters());
                rq.setStartTime(Calendar.getInstance().getTime());
                return reportPortal.newLaunch(rq);
            }
        });
    }

    public TestNGService(Supplier<Launch> launch) {
        this.launch = new MemoizingSupplier<Launch>(launch);
    }

    @Override
    public void startLaunch() {
        this.launch.get().start();
    }

    @Override
    public void finishLaunch() {
        FinishExecutionRQ rq = new FinishExecutionRQ();
        rq.setEndTime(Calendar.getInstance().getTime());
        rq.setStatus(this.isLaunchFailed.get() ? "FAILED" : "PASSED");
        this.launch.get().finish(rq);
        this.launch.reset();
    }

    @Override
    public synchronized void startTestSuite(ISuite suite) {
        StartTestItemRQ rq = this.buildStartSuiteRq(suite);
        Maybe item = this.launch.get().startTestItem(rq);
        suite.setAttribute(RP_ID, (Object)item);
    }

    @Override
    public synchronized void finishTestSuite(ISuite suite) {
        if (null != suite.getAttribute(RP_ID)) {
            FinishTestItemRQ rq = this.buildFinishTestSuiteRq(suite);
            this.launch.get().finishTestItem((Maybe)this.getAttribute((IAttributes)suite, RP_ID), rq);
            suite.removeAttribute(RP_ID);
        }
    }

    @Override
    public void startTest(ITestContext testContext) {
        if (this.hasMethodsToRun(testContext)) {
            StartTestItemRQ rq = this.buildStartTestItemRq(testContext);
            Maybe testID = this.launch.get().startTestItem((Maybe)this.getAttribute((IAttributes)testContext.getSuite(), RP_ID), rq);
            testContext.setAttribute(RP_ID, (Object)testID);
        }
    }

    @Override
    public void finishTest(ITestContext testContext) {
        if (this.hasMethodsToRun(testContext)) {
            FinishTestItemRQ rq = this.buildFinishTestRq(testContext);
            this.launch.get().finishTestItem((Maybe)this.getAttribute((IAttributes)testContext, RP_ID), rq);
        }
    }

    @Override
    public void startTestMethod(ITestResult testResult) {
        StartTestItemRQ rq = this.buildStartStepRq(testResult);
        if (rq == null) {
            return;
        }
        Maybe stepMaybe = this.launch.get().startTestItem((Maybe)this.getAttribute((IAttributes)testResult.getTestContext(), RP_ID), rq);
        testResult.setAttribute(RP_ID, (Object)stepMaybe);
    }

    @Override
    public void finishTestMethod(String status, ITestResult testResult) {
        if ("SKIPPED".equals(status) && !this.isRetry(testResult) && null == testResult.getAttribute(RP_ID)) {
            this.startTestMethod(testResult);
        }
        FinishTestItemRQ rq = this.buildFinishTestMethodRq(status, testResult);
        this.launch.get().finishTestItem((Maybe)this.getAttribute((IAttributes)testResult, RP_ID), rq);
    }

    @Override
    public void startConfiguration(ITestResult testResult) {
        TestMethodType type = TestMethodType.getStepType(testResult.getMethod());
        StartTestItemRQ rq = this.buildStartConfigurationRq(testResult, type);
        Maybe<String> parentId = this.getConfigParent(testResult, type);
        Maybe itemID = this.launch.get().startTestItem(parentId, rq);
        testResult.setAttribute(RP_ID, (Object)itemID);
    }

    @Override
    public void sendReportPortalMsg(final ITestResult result) {
        ReportPortal.emitLog((Function)new Function<String, SaveLogRQ>(){

            public SaveLogRQ apply(String itemId) {
                SaveLogRQ rq = new SaveLogRQ();
                rq.setTestItemId(itemId);
                rq.setLevel("ERROR");
                rq.setLogTime(Calendar.getInstance().getTime());
                if (result.getThrowable() != null) {
                    rq.setMessage(Throwables.getStackTraceAsString((Throwable)result.getThrowable()));
                } else {
                    rq.setMessage("Test has failed without exception");
                }
                rq.setLogTime(Calendar.getInstance().getTime());
                return rq;
            }
        });
    }

    protected StartTestItemRQ buildStartSuiteRq(ISuite suite) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(suite.getName());
        rq.setStartTime(Calendar.getInstance().getTime());
        rq.setType("SUITE");
        return rq;
    }

    protected StartTestItemRQ buildStartTestItemRq(ITestContext testContext) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(testContext.getName());
        rq.setStartTime(testContext.getStartDate());
        rq.setType("TEST");
        return rq;
    }

    protected StartLaunchRQ buildStartLaunchRq(ListenerParameters parameters) {
        StartLaunchRQ rq = new StartLaunchRQ();
        rq.setName(parameters.getLaunchName());
        rq.setStartTime(Calendar.getInstance().getTime());
        rq.setTags(parameters.getTags());
        rq.setMode(parameters.getLaunchRunningMode());
        if (!Strings.isNullOrEmpty((String)parameters.getDescription())) {
            rq.setDescription(parameters.getDescription());
        }
        return rq;
    }

    protected StartTestItemRQ buildStartConfigurationRq(ITestResult testResult, TestMethodType type) {
        StartTestItemRQ rq = new StartTestItemRQ();
        String configName = testResult.getMethod().getMethodName();
        rq.setName(configName);
        rq.setDescription(testResult.getMethod().getDescription());
        rq.setStartTime(new Date(testResult.getStartMillis()));
        rq.setType(type == null ? null : type.toString());
        return rq;
    }

    protected StartTestItemRQ buildStartStepRq(ITestResult testResult) {
        StartTestItemRQ rq = new StartTestItemRQ();
        String testStepName = testResult.getTestName() != null ? testResult.getTestName() : testResult.getMethod().getMethodName();
        rq.setName(testStepName);
        rq.setDescription(this.createStepDescription(testResult));
        rq.setParameters(this.createStepParameters(testResult));
        rq.setUniqueId(this.extractUniqueID(testResult));
        rq.setStartTime(new Date(testResult.getStartMillis()));
        rq.setType(TestMethodType.getStepType(testResult.getMethod()).toString());
        rq.setRetry(Boolean.valueOf(this.isRetry(testResult)));
        return rq;
    }

    protected FinishTestItemRQ buildFinishTestSuiteRq(ISuite suite) {
        Date now = Calendar.getInstance().getTime();
        FinishTestItemRQ rq = new FinishTestItemRQ();
        rq.setEndTime(now);
        rq.setStatus(this.getSuiteStatus(suite));
        return rq;
    }

    protected FinishTestItemRQ buildFinishTestRq(ITestContext testContext) {
        FinishTestItemRQ rq = new FinishTestItemRQ();
        rq.setEndTime(testContext.getEndDate());
        String status = this.isTestPassed(testContext) ? "PASSED" : "FAILED";
        rq.setStatus(status);
        return rq;
    }

    protected FinishTestItemRQ buildFinishTestMethodRq(String status, ITestResult testResult) {
        FinishTestItemRQ rq = new FinishTestItemRQ();
        rq.setEndTime(new Date(testResult.getEndMillis()));
        rq.setStatus(status);
        if ("SKIPPED".equals(status) && !((Boolean)Optional.fromNullable((Object)this.launch.get().getParameters().getSkippedAnIssue()).or((Object)false)).booleanValue()) {
            Issue issue = new Issue();
            issue.setIssueType(NOT_ISSUE);
            rq.setIssue(issue);
        }
        return rq;
    }

    protected List<ParameterResource> createStepParameters(ITestResult testResult) {
        List<ParameterResource> parameters = Lists.newArrayList();
        Test testAnnotation = this.getMethodAnnotation(Test.class, testResult);
        Parameters parametersAnnotation = this.getMethodAnnotation(Parameters.class, testResult);
        if (null != testAnnotation && !Strings.isNullOrEmpty((String)testAnnotation.dataProvider())) {
            parameters = this.createDataProviderParameters(testResult);
        } else if (null != parametersAnnotation) {
            parameters = this.createAnnotationParameters(testResult, parametersAnnotation);
        }
        return parameters.isEmpty() ? null : parameters;
    }

    private List<ParameterResource> createAnnotationParameters(ITestResult testResult, Parameters parametersAnnotation) {
        List params = Lists.newArrayList();
        String[] keys = parametersAnnotation.value();
        Object[] parameters = testResult.getParameters();
        if (parameters.length != keys.length) {
            return params;
        }
        for (int i = 0; i < keys.length; ++i) {
            ParameterResource parameter = new ParameterResource();
            parameter.setKey(keys[i]);
            parameter.setValue(parameters[i] != null ? parameters[i].toString() : null);
            params.add(parameter);
        }
        return params;
    }

    private List<ParameterResource> createDataProviderParameters(ITestResult testResult) {
        Object[] values;
        List result = Lists.newArrayList();
        Annotation[][] parameterAnnotations = testResult.getMethod().getConstructorOrMethod().getMethod().getParameterAnnotations();
        int length = parameterAnnotations.length;
        if (length != (values = testResult.getParameters()).length) {
            return result;
        }
        for (int i = 0; i < length; ++i) {
            String value;
            ParameterResource parameter = new ParameterResource();
            String key = ARGUMENT + i;
            String string = value = values[i] != null ? values[i].toString() : null;
            if (parameterAnnotations[i].length > 0) {
                for (int j = 0; j < parameterAnnotations[i].length; ++j) {
                    Annotation annotation = parameterAnnotations[i][j];
                    if (!annotation.annotationType().equals(ParameterKey.class)) continue;
                    key = ((ParameterKey)annotation).value();
                }
            }
            parameter.setKey(key);
            parameter.setValue(value);
            result.add(parameter);
        }
        return result;
    }

    protected String createStepDescription(ITestResult testResult) {
        StringBuilder stringBuffer = new StringBuilder();
        if (testResult.getMethod().getDescription() != null) {
            stringBuffer.append(testResult.getMethod().getDescription());
        }
        return stringBuffer.toString();
    }

    protected String getSuiteStatus(ISuite suite) {
        Collection suiteResults = suite.getResults().values();
        String suiteStatus = "PASSED";
        for (ISuiteResult suiteResult : suiteResults) {
            if (this.isTestPassed(suiteResult.getTestContext())) continue;
            suiteStatus = "FAILED";
            break;
        }
        this.isLaunchFailed.compareAndSet(false, suiteStatus.equals("FAILED"));
        return suiteStatus;
    }

    protected boolean isTestPassed(ITestContext testContext) {
        return testContext.getFailedTests().size() == 0 && testContext.getFailedConfigurations().size() == 0 && testContext.getSkippedConfigurations().size() == 0 && testContext.getSkippedTests().size() == 0;
    }

    protected <T> T getAttribute(IAttributes attributes, String attribute) {
        return (T)attributes.getAttribute(attribute);
    }

    private String extractUniqueID(ITestResult testResult) {
        UniqueID itemUniqueID = this.getMethodAnnotation(UniqueID.class, testResult);
        return itemUniqueID != null ? itemUniqueID.value() : null;
    }

    private <T extends Annotation> T getMethodAnnotation(Class<T> annotation, ITestResult testResult) {
        Method method;
        ConstructorOrMethod constructorOrMethod;
        ITestNGMethod testNGMethod = testResult.getMethod();
        if (null != testNGMethod && null != (constructorOrMethod = testNGMethod.getConstructorOrMethod()) && null != (method = constructorOrMethod.getMethod())) {
            return method.getAnnotation(annotation);
        }
        return null;
    }

    private boolean hasMethodsToRun(ITestContext testContext) {
        return null != testContext && null != testContext.getAllTestMethods() && 0 != testContext.getAllTestMethods().length;
    }

    @VisibleForTesting
    Maybe<String> getConfigParent(ITestResult testResult, TestMethodType type) {
        Maybe parentId = TestMethodType.BEFORE_SUITE.equals((Object)type) || TestMethodType.AFTER_SUITE.equals((Object)type) ? (Maybe)this.getAttribute((IAttributes)testResult.getTestContext().getSuite(), RP_ID) : (Maybe)this.getAttribute((IAttributes)testResult.getTestContext(), RP_ID);
        return parentId;
    }

    private boolean isRetry(ITestResult result) {
        IRetryAnalyzer retryAnalyzer = result.getMethod().getRetryAnalyzer(result);
        return retryAnalyzer != null && retryAnalyzer.retry(result);
    }

    @VisibleForTesting
    static class MemoizingSupplier<T>
    implements Supplier<T>,
    Serializable {
        final Supplier<T> delegate;
        volatile transient boolean initialized;
        transient T value;
        private static final long serialVersionUID = 0L;

        MemoizingSupplier(Supplier<T> delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T get() {
            if (!this.initialized) {
                MemoizingSupplier memoizingSupplier = this;
                synchronized (memoizingSupplier) {
                    if (!this.initialized) {
                        Object t = this.delegate.get();
                        this.value = t;
                        this.initialized = true;
                        return (T)t;
                    }
                }
            }
            return this.value;
        }

        public synchronized void reset() {
            this.initialized = false;
        }

        public String toString() {
            return "Suppliers.memoize(" + this.delegate + ")";
        }
    }
}

