/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.restendpoint.http;

import com.epam.reportportal.restendpoint.http.DefaultErrorHandler;
import com.epam.reportportal.restendpoint.http.ErrorHandler;
import com.epam.reportportal.restendpoint.http.HttpMethod;
import com.epam.reportportal.restendpoint.http.IOUtils;
import com.epam.reportportal.restendpoint.http.MultiPartRequest;
import com.epam.reportportal.restendpoint.http.Response;
import com.epam.reportportal.restendpoint.http.RestCommand;
import com.epam.reportportal.restendpoint.http.RestEndpoint;
import com.epam.reportportal.restendpoint.http.exception.RestEndpointIOException;
import com.epam.reportportal.restendpoint.http.exception.SerializerException;
import com.epam.reportportal.restendpoint.serializer.Serializer;
import com.epam.reportportal.restendpoint.serializer.VoidSerializer;
import io.reactivex.Maybe;
import io.reactivex.MaybeEmitter;
import io.reactivex.MaybeOnSubscribe;
import io.reactivex.Scheduler;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import rp.com.google.common.base.Charsets;
import rp.com.google.common.base.Preconditions;
import rp.com.google.common.base.Strings;
import rp.com.google.common.base.Supplier;
import rp.com.google.common.base.Suppliers;
import rp.com.google.common.collect.ImmutableList;
import rp.com.google.common.collect.ImmutableMultimap;
import rp.com.google.common.io.ByteSource;
import rp.com.google.common.io.Closer;
import rp.com.google.common.net.MediaType;
import rp.com.google.common.util.concurrent.ThreadFactoryBuilder;
import rp.org.apache.http.Header;
import rp.org.apache.http.HttpEntity;
import rp.org.apache.http.HttpResponse;
import rp.org.apache.http.client.HttpClient;
import rp.org.apache.http.client.methods.HttpDelete;
import rp.org.apache.http.client.methods.HttpGet;
import rp.org.apache.http.client.methods.HttpPatch;
import rp.org.apache.http.client.methods.HttpPost;
import rp.org.apache.http.client.methods.HttpPut;
import rp.org.apache.http.client.methods.HttpRequestBase;
import rp.org.apache.http.client.methods.HttpUriRequest;
import rp.org.apache.http.client.utils.URIBuilder;
import rp.org.apache.http.entity.ByteArrayEntity;
import rp.org.apache.http.entity.ContentType;
import rp.org.apache.http.entity.mime.MultipartEntityBuilder;
import rp.org.apache.http.entity.mime.content.InputStreamBody;
import rp.org.apache.http.entity.mime.content.StringBody;
import rp.org.apache.http.impl.client.CloseableHttpClient;
import rp.org.apache.http.util.EntityUtils;

public class HttpClientRestEndpoint
implements RestEndpoint {
    private static final int DEFAULT_POOL_SIZE = 100;
    private final List<Serializer> serializers;
    private final String baseUrl;
    private final ErrorHandler errorHandler;
    private final HttpClient httpClient;
    private final Scheduler scheduler;

    public HttpClientRestEndpoint(HttpClient httpClient, List<Serializer> serializers, ErrorHandler errorHandler) {
        this(httpClient, serializers, errorHandler, null);
    }

    public HttpClientRestEndpoint(HttpClient httpClient, List<Serializer> serializers, ErrorHandler errorHandler, String baseUrl) {
        this(httpClient, serializers, errorHandler, baseUrl, Executors.newFixedThreadPool(100, new ThreadFactoryBuilder().setNameFormat("rp-io-%s").build()));
    }

    public HttpClientRestEndpoint(HttpClient httpClient, List<Serializer> serializers, ErrorHandler errorHandler, String baseUrl, ExecutorService executorService) {
        Preconditions.checkArgument(null != serializers && !serializers.isEmpty(), "There is no any serializer provided");
        this.serializers = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(serializers)).add(new VoidSerializer())).build();
        if (!Strings.isNullOrEmpty(baseUrl)) {
            Preconditions.checkArgument(IOUtils.isValidUrl(baseUrl), "'%s' is not valid URL", (Object)baseUrl);
        }
        this.baseUrl = baseUrl;
        this.scheduler = Schedulers.from((Executor)executorService);
        this.errorHandler = errorHandler == null ? new DefaultErrorHandler() : errorHandler;
        this.httpClient = httpClient;
    }

    @Override
    public final <RQ, RS> Maybe<Response<RS>> post(String resource, RQ rq, Class<RS> clazz) throws RestEndpointIOException {
        HttpPost post = new HttpPost(this.spliceUrl(resource));
        Serializer serializer = this.getSupportedSerializer(rq);
        ByteArrayEntity httpEntity = new ByteArrayEntity(serializer.serialize(rq), this.toContentType(serializer.getMimeType()));
        post.setEntity(httpEntity);
        return this.executeInternal(post, new ClassConverterCallback<RS>(this.serializers, clazz));
    }

    @Override
    public final <RQ, RS> Maybe<RS> postFor(String resource, RQ rq, Class<RS> clazz) throws RestEndpointIOException {
        return this.post(resource, rq, clazz).flatMap(new BodyTransformer());
    }

    @Override
    public final <RQ, RS> Maybe<Response<RS>> post(String resource, RQ rq, Type type) throws RestEndpointIOException {
        HttpPost post = new HttpPost(this.spliceUrl(resource));
        Serializer serializer = this.getSupportedSerializer(rq);
        ByteArrayEntity httpEntity = new ByteArrayEntity(serializer.serialize(rq), this.toContentType(serializer.getMimeType()));
        post.setEntity(httpEntity);
        return this.executeInternal(post, new TypeConverterCallback(this.serializers, type));
    }

    @Override
    public final <RQ, RS> Maybe<RS> postFor(String resource, RQ rq, Type type) throws RestEndpointIOException {
        Maybe<Response<RS>> post = this.post(resource, rq, type);
        return post.flatMap(new BodyTransformer());
    }

    @Override
    public final <RS> Maybe<Response<RS>> post(String resource, MultiPartRequest request, Class<RS> clazz) throws RestEndpointIOException {
        HttpPost post = this.buildMultipartRequest(this.spliceUrl(resource), request);
        return this.executeInternal(post, new ClassConverterCallback<RS>(this.serializers, clazz));
    }

    private HttpPost buildMultipartRequest(URI uri, MultiPartRequest request) throws RestEndpointIOException {
        HttpPost post = new HttpPost(uri);
        try {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            for (MultiPartRequest.MultiPartSerialized<?> serializedPart : request.getSerializedRQs()) {
                Serializer serializer = this.getSupportedSerializer(serializedPart);
                builder.addPart(serializedPart.getPartName(), new StringBody(new String(serializer.serialize(serializedPart.getRequest()), Charsets.UTF_8), ContentType.parse(serializer.getMimeType().toString())));
            }
            for (MultiPartRequest.MultiPartBinary partBinaty : request.getBinaryRQs()) {
                builder.addPart(partBinaty.getPartName(), new InputStreamBody(partBinaty.getData().openBufferedStream(), ContentType.parse(partBinaty.getContentType()), partBinaty.getFilename()));
            }
            post.setEntity(builder.build());
        }
        catch (Exception e) {
            throw new RestEndpointIOException("Unable to build post multipart request", e);
        }
        return post;
    }

    @Override
    public final <RS> Maybe<RS> postFor(String resource, MultiPartRequest request, Class<RS> clazz) throws RestEndpointIOException {
        return this.post(resource, request, clazz).flatMap(new BodyTransformer());
    }

    @Override
    public final <RQ, RS> Maybe<Response<RS>> put(String resource, RQ rq, Class<RS> clazz) throws RestEndpointIOException {
        HttpPut put = new HttpPut(this.spliceUrl(resource));
        Serializer serializer = this.getSupportedSerializer(rq);
        ByteArrayEntity httpEntity = new ByteArrayEntity(serializer.serialize(rq), this.toContentType(serializer.getMimeType()));
        put.setEntity(httpEntity);
        return this.executeInternal(put, new ClassConverterCallback<RS>(this.serializers, clazz));
    }

    @Override
    public final <RQ, RS> Maybe<RS> putFor(String resource, RQ rq, Class<RS> clazz) throws RestEndpointIOException {
        return this.put(resource, rq, clazz).flatMap(new BodyTransformer());
    }

    @Override
    public final <RQ, RS> Maybe<Response<RS>> put(String resource, RQ rq, Type type) throws RestEndpointIOException {
        HttpPut put = new HttpPut(this.spliceUrl(resource));
        Serializer serializer = this.getSupportedSerializer(rq);
        ByteArrayEntity httpEntity = new ByteArrayEntity(serializer.serialize(rq), this.toContentType(serializer.getMimeType()));
        put.setEntity(httpEntity);
        return this.executeInternal(put, new TypeConverterCallback(this.serializers, type));
    }

    @Override
    public final <RQ, RS> Maybe<RS> putFor(String resource, RQ rq, Type type) throws RestEndpointIOException {
        Maybe<Response<RS>> rs = this.put(resource, rq, type);
        return rs.flatMap(new BodyTransformer());
    }

    @Override
    public final <RS> Maybe<Response<RS>> delete(String resource, Class<RS> clazz) throws RestEndpointIOException {
        HttpDelete delete = new HttpDelete(this.spliceUrl(resource));
        return this.executeInternal(delete, new ClassConverterCallback<RS>(this.serializers, clazz));
    }

    @Override
    public final <RS> Maybe<RS> deleteFor(String resource, Class<RS> clazz) throws RestEndpointIOException {
        return this.delete(resource, clazz).flatMap(new BodyTransformer());
    }

    @Override
    public final <RS> Maybe<Response<RS>> get(String resource, Class<RS> clazz) throws RestEndpointIOException {
        HttpGet get = new HttpGet(this.spliceUrl(resource));
        return this.executeInternal(get, new ClassConverterCallback<RS>(this.serializers, clazz));
    }

    @Override
    public final <RS> Maybe<RS> getFor(String resource, Class<RS> clazz) throws RestEndpointIOException {
        return this.get(resource, clazz).flatMap(new BodyTransformer());
    }

    @Override
    public final <RS> Maybe<Response<RS>> get(String resource, Type type) throws RestEndpointIOException {
        HttpGet get = new HttpGet(this.spliceUrl(resource));
        return this.executeInternal(get, new TypeConverterCallback(this.serializers, type));
    }

    @Override
    public final <RS> Maybe<RS> getFor(String resource, Type type) throws RestEndpointIOException {
        Maybe<Response<RS>> rs = this.get(resource, type);
        return rs.flatMap(new BodyTransformer());
    }

    @Override
    public final <RS> Maybe<Response<RS>> get(String resource, Map<String, String> parameters, Class<RS> clazz) throws RestEndpointIOException {
        HttpGet get = new HttpGet(this.spliceUrl(resource, parameters));
        return this.executeInternal(get, new ClassConverterCallback<RS>(this.serializers, clazz));
    }

    @Override
    public final <RS> Maybe<RS> getFor(String resource, Map<String, String> parameters, Class<RS> clazz) throws RestEndpointIOException {
        return this.get(resource, parameters, clazz).flatMap(new BodyTransformer());
    }

    @Override
    public final <RS> Maybe<Response<RS>> get(String resource, Map<String, String> parameters, Type type) throws RestEndpointIOException {
        HttpGet get = new HttpGet(this.spliceUrl(resource, parameters));
        return this.executeInternal(get, new TypeConverterCallback(this.serializers, type));
    }

    @Override
    public final <RS> Maybe<RS> getFor(String resource, Map<String, String> parameters, Type type) throws RestEndpointIOException {
        Maybe<Response<RS>> rs = this.get(resource, parameters, type);
        return rs.flatMap(new BodyTransformer());
    }

    @Override
    public final <RQ, RS> Maybe<Response<RS>> executeRequest(RestCommand<RQ, RS> command) throws RestEndpointIOException {
        HttpRequestBase rq;
        URI uri = this.spliceUrl(command.getUri());
        switch (command.getHttpMethod()) {
            case GET: {
                rq = new HttpGet(uri);
                break;
            }
            case POST: {
                if (command.isMultipart()) {
                    MultiPartRequest rqData = (MultiPartRequest)command.getRequest();
                    rq = this.buildMultipartRequest(uri, rqData);
                    break;
                }
                Serializer serializer = this.getSupportedSerializer(command.getRequest());
                rq = new HttpPost(uri);
                ((HttpPost)rq).setEntity(new ByteArrayEntity(serializer.serialize(command.getRequest()), this.toContentType(serializer.getMimeType())));
                break;
            }
            case PUT: {
                Serializer serializer = this.getSupportedSerializer(command.getRequest());
                rq = new HttpPut(uri);
                ((HttpPut)rq).setEntity(new ByteArrayEntity(serializer.serialize(command.getRequest()), this.toContentType(serializer.getMimeType())));
                break;
            }
            case DELETE: {
                rq = new HttpDelete(uri);
                break;
            }
            case PATCH: {
                Serializer serializer = this.getSupportedSerializer(command.getRequest());
                rq = new HttpPatch(uri);
                ((HttpPatch)rq).setEntity(new ByteArrayEntity(serializer.serialize(command.getRequest()), ContentType.create(serializer.getMimeType().toString())));
                break;
            }
            default: {
                throw new IllegalArgumentException("Method '" + (Object)((Object)command.getHttpMethod()) + "' is unsupported");
            }
        }
        return this.executeInternal(rq, new TypeConverterCallback(this.serializers, command.getResponseType()));
    }

    private URI spliceUrl(String resource) throws RestEndpointIOException {
        try {
            return Strings.isNullOrEmpty(this.baseUrl) ? new URI(resource) : new URI(this.baseUrl.concat(resource));
        }
        catch (URISyntaxException e) {
            throw new RestEndpointIOException("Unable to builder URL with base url '" + this.baseUrl + "' and resouce '" + resource + "'", e);
        }
    }

    private ContentType toContentType(MediaType contentType) {
        return ContentType.create(contentType.withoutParameters().toString(), contentType.charset().or(Charsets.UTF_8));
    }

    final URI spliceUrl(String resource, Map<String, String> parameters) throws RestEndpointIOException {
        try {
            URIBuilder builder;
            if (!Strings.isNullOrEmpty(this.baseUrl)) {
                builder = new URIBuilder(this.baseUrl);
                builder.setPath(builder.getPath() + resource);
            } else {
                builder = new URIBuilder(resource);
            }
            for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                builder.addParameter(parameter.getKey(), parameter.getValue());
            }
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new RestEndpointIOException("Unable to builder URL with base url '" + this.baseUrl + "' and resouce '" + resource + "'", e);
        }
    }

    private Serializer getSupportedSerializer(Object o) throws SerializerException {
        for (Serializer s : this.serializers) {
            if (!s.canWrite(o)) continue;
            return s;
        }
        throw new SerializerException("Unable to find serializer for object with type '" + o.getClass() + "'");
    }

    private <RS> Maybe<Response<RS>> executeInternal(final HttpUriRequest rq, final HttpEntityCallback<RS> callback) {
        final Closer closer = Closer.create();
        return Maybe.create((MaybeOnSubscribe)new MaybeOnSubscribe<Response<RS>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void subscribe(MaybeEmitter<Response<RS>> emitter) throws Exception {
                try {
                    HttpResponse response = HttpClientRestEndpoint.this.httpClient.execute(rq);
                    LazyByteSource bodySupplier = new LazyByteSource(response.getEntity());
                    closer.register(bodySupplier);
                    Header[] allHeaders = response.getAllHeaders();
                    ImmutableMultimap.Builder<String, String> headersBuilder = ImmutableMultimap.builder();
                    for (Header header : allHeaders) {
                        headersBuilder.put(header.getName().toLowerCase(), null == header.getValue() ? "" : header.getValue());
                    }
                    Response<ByteSource> rs1 = new Response<ByteSource>(rq.getURI(), HttpMethod.valueOf(rq.getMethod()), response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), headersBuilder.build(), bodySupplier);
                    if (HttpClientRestEndpoint.this.errorHandler.hasError(rs1)) {
                        HttpClientRestEndpoint.this.errorHandler.handle(rs1);
                    }
                    MediaType contentType = null == response.getEntity().getContentType() ? MediaType.ANY_TYPE : MediaType.parse(response.getEntity().getContentType().getValue());
                    emitter.onSuccess(new Response(rs1.getUri(), rs1.getHttpMethod(), rs1.getStatus(), rs1.getReason(), rs1.getHeaders(), callback.callback(contentType, bodySupplier.read())));
                }
                catch (Throwable error) {
                    emitter.onError(error);
                }
                finally {
                    closer.close();
                }
            }
        }).cache().subscribeOn(this.scheduler);
    }

    @Override
    public void close() throws IOException {
        if (this.httpClient instanceof CloseableHttpClient) {
            IOUtils.closeQuietly((CloseableHttpClient)this.httpClient);
        }
    }

    private static class LazyByteSource
    extends ByteSource
    implements Closeable {
        private final HttpEntity httpEntity;
        private final Supplier<ByteSource> supplier;

        private LazyByteSource(final HttpEntity httpEntity) {
            this.httpEntity = httpEntity;
            this.supplier = Suppliers.memoize(new Supplier<ByteSource>(){

                @Override
                public ByteSource get() {
                    return ByteSource.wrap(LazyByteSource.this.readEntity(httpEntity));
                }
            });
        }

        @Override
        public InputStream openStream() throws IOException {
            return this.supplier.get().openStream();
        }

        private byte[] readEntity(HttpEntity entity) {
            try {
                byte[] byArray = EntityUtils.toByteArray(entity);
                return byArray;
            }
            catch (IOException e) {
                throw new RestEndpointIOException("Unable to read body from error", e);
            }
            finally {
                EntityUtils.consumeQuietly(entity);
            }
        }

        @Override
        public void close() throws IOException {
            EntityUtils.consumeQuietly(this.httpEntity);
        }
    }

    public static final class BodyTransformer<T>
    implements Function<Response<T>, Maybe<T>> {
        public Maybe<T> apply(Response<T> input) {
            T body = input.getBody();
            return null == body ? Maybe.empty() : Maybe.just(body);
        }
    }

    private static class ClassConverterCallback<RS>
    extends HttpEntityCallback<RS> {
        private final Class<RS> clazz;

        ClassConverterCallback(List<Serializer> serializers, Class<RS> clazz) {
            super(serializers);
            this.clazz = clazz;
        }

        @Override
        public RS callback(MediaType contentType, byte[] body) throws IOException {
            return this.getSupported(contentType, this.clazz).deserialize(body, this.clazz);
        }

        private Serializer getSupported(MediaType contentType, Class<?> resultType) throws SerializerException {
            for (Serializer s : this.serializers) {
                if (!s.canRead(contentType, resultType)) continue;
                return s;
            }
            throw new SerializerException("Conversion media type '" + contentType + "' to type '" + resultType + "' is not supported");
        }
    }

    private static class TypeConverterCallback<RS>
    extends HttpEntityCallback<RS> {
        private final Type type;

        TypeConverterCallback(List<Serializer> serializers, Type type) {
            super(serializers);
            this.type = type;
        }

        @Override
        public RS callback(MediaType contentType, byte[] body) throws IOException {
            return (RS)this.getSupported(contentType, this.type).deserialize(body, this.type);
        }

        Serializer getSupported(MediaType contentType, Type resultType) throws SerializerException {
            for (Serializer s : this.serializers) {
                if (!s.canRead(contentType, resultType)) continue;
                return s;
            }
            throw new SerializerException("Conversion media type '" + contentType + "' to type '" + resultType + "' is not supported");
        }
    }

    private static abstract class HttpEntityCallback<RS> {
        final List<Serializer> serializers;

        HttpEntityCallback(List<Serializer> serializers) {
            this.serializers = serializers;
        }

        public abstract RS callback(MediaType var1, byte[] var2) throws IOException;
    }
}

