/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service;

import com.epam.reportportal.exception.ReportPortalException;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.LoggingCallback;
import com.epam.reportportal.service.LoggingContext;
import com.epam.reportportal.service.ReportPortalClient;
import com.epam.reportportal.utils.LaunchFile;
import com.epam.reportportal.utils.RetryWithDelay;
import com.epam.reportportal.utils.SubscriptionUtils;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.issue.Issue;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRS;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.MaybeEmitter;
import io.reactivex.MaybeOnSubscribe;
import io.reactivex.MaybeSource;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.schedulers.Schedulers;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import rp.com.google.common.base.Preconditions;
import rp.com.google.common.cache.CacheBuilder;
import rp.com.google.common.cache.CacheLoader;
import rp.com.google.common.cache.LoadingCache;
import rp.com.google.common.collect.Lists;

public class LaunchImpl
extends Launch {
    private static final Function<EntryCreatedRS, String> TO_ID = new Function<EntryCreatedRS, String>(){

        public String apply(EntryCreatedRS rs) {
            return rs.getId();
        }
    };
    private static final Consumer<StartLaunchRS> LAUNCH_SUCCESS_CONSUMER = new Consumer<StartLaunchRS>(){

        public void accept(StartLaunchRS rs) throws Exception {
            LoggingCallback.logCreated("launch").accept((Object)rs);
            System.setProperty("rp.launch.id", rs.getId());
        }
    };
    private static final int ITEM_FINISH_MAX_RETRIES = 10;
    private static final int ITEM_FINISH_RETRY_TIMEOUT = 10;
    private static final String NOT_ISSUE = "NOT_ISSUE";
    private final ReportPortalClient rpClient;
    private final LoadingCache<Maybe<String>, TreeItem> QUEUE = CacheBuilder.newBuilder().build(new CacheLoader<Maybe<String>, TreeItem>(){

        @Override
        public TreeItem load(Maybe<String> key) {
            return new TreeItem();
        }
    });
    private Maybe<String> launch;
    private boolean rerun;

    LaunchImpl(final ReportPortalClient rpClient, ListenerParameters parameters, final StartLaunchRQ rq) {
        super(parameters);
        this.rpClient = Preconditions.checkNotNull(rpClient, "RestEndpoint shouldn't be NULL");
        Preconditions.checkNotNull(parameters, "Parameters shouldn't be NULL");
        if (!parameters.isRerun()) {
            LOGGER.info("Not rerun!");
            this.launch = Maybe.create((MaybeOnSubscribe)new MaybeOnSubscribe<String>(){

                public void subscribe(final MaybeEmitter<String> emitter) {
                    Maybe launchPromise = Maybe.defer((Callable)new Callable<MaybeSource<? extends StartLaunchRS>>(){

                        @Override
                        public MaybeSource<? extends StartLaunchRS> call() {
                            return rpClient.startLaunch(rq).doOnSuccess(LAUNCH_SUCCESS_CONSUMER).doOnError(LoggingCallback.LOG_ERROR);
                        }
                    }).subscribeOn(Schedulers.computation()).cache();
                    LaunchFile.create(rq.getName(), (Maybe<StartLaunchRS>)launchPromise);
                    launchPromise.subscribe((Consumer)new Consumer<StartLaunchRS>(){

                        public void accept(StartLaunchRS startLaunchRS) {
                            emitter.onSuccess((Object)startLaunchRS.getId());
                        }
                    }, (Consumer)new Consumer<Throwable>(){

                        public void accept(Throwable throwable) throws Exception {
                            LoggingCallback.LOG_ERROR.accept((Object)throwable);
                            emitter.onComplete();
                        }
                    });
                }
            }).cache();
        } else {
            LOGGER.info("rerun!");
            this.launch = LaunchFile.find(rq.getName());
            this.rerun = true;
        }
    }

    LaunchImpl(ReportPortalClient rpClient, ListenerParameters parameters, Maybe<String> launch) {
        super(parameters);
        this.rpClient = Preconditions.checkNotNull(rpClient, "RestEndpoint shouldn't be NULL");
        Preconditions.checkNotNull(parameters, "Parameters shouldn't be NULL");
        this.launch = launch.subscribeOn(Schedulers.computation()).cache();
    }

    @Override
    public synchronized Maybe<String> start() {
        this.launch.subscribe(SubscriptionUtils.logMaybeResults("Launch start"));
        return this.launch;
    }

    @Override
    public synchronized void finish(final FinishExecutionRQ rq) {
        Completable finish = Completable.concat(this.QUEUE.getUnchecked(this.launch).getChildren()).andThen((MaybeSource)this.launch.flatMap((Function)new Function<String, Maybe<OperationCompletionRS>>(){

            public Maybe<OperationCompletionRS> apply(String id) {
                return LaunchImpl.this.rpClient.finishLaunch(id, rq).doOnSuccess(LoggingCallback.LOG_SUCCESS).doOnError(LoggingCallback.LOG_ERROR);
            }
        })).doFinally(new Action(){

            public void run() {
                LaunchImpl.this.rpClient.close();
            }
        }).ignoreElement().cache();
        try {
            finish.timeout((long)this.getParameters().getReportingTimeout().intValue(), TimeUnit.SECONDS).blockingGet();
        }
        catch (Exception e) {
            LOGGER.error("Unable to finish launch in ReportPortal", (Throwable)e);
        }
    }

    @Override
    public Maybe<String> startTestItem(final StartTestItemRQ rq) {
        Maybe testItem = this.launch.flatMap((Function)new Function<String, Maybe<String>>(){

            public Maybe<String> apply(String id) {
                rq.setLaunchId(id);
                return LaunchImpl.this.rpClient.startTestItem(rq).doOnSuccess(LoggingCallback.logCreated("item")).map(TO_ID);
            }
        }).cache();
        testItem.subscribeOn(Schedulers.computation()).subscribe(SubscriptionUtils.logMaybeResults("Start test item"));
        this.QUEUE.getUnchecked((Maybe<String>)testItem).addToQueue(testItem.ignoreElement());
        LoggingContext.init((Maybe<String>)testItem, this.rpClient, this.getParameters().getBatchLogsSize(), this.getParameters().isConvertImage());
        return testItem;
    }

    @Override
    public Maybe<String> startTestItem(final Maybe<String> parentId, Maybe<String> retryOf, final StartTestItemRQ rq) {
        return retryOf.flatMap((Function)new Function<String, Maybe<String>>(){

            public Maybe<String> apply(String s) {
                return LaunchImpl.this.startTestItem((Maybe<String>)parentId, rq);
            }
        }).cache();
    }

    @Override
    public Maybe<String> startTestItem(final Maybe<String> parentId, final StartTestItemRQ rq) {
        if (null == parentId) {
            return this.startTestItem(rq);
        }
        Maybe itemId = this.launch.flatMap((Function)new Function<String, Maybe<String>>(){

            public Maybe<String> apply(final String launchId) {
                return parentId.flatMap((Function)new Function<String, MaybeSource<String>>(){

                    public MaybeSource<String> apply(String parentId) {
                        rq.setLaunchId(launchId);
                        Launch.LOGGER.debug("Starting test item..." + Thread.currentThread().getName());
                        return LaunchImpl.this.rpClient.startTestItem(parentId, rq).doOnSuccess(LoggingCallback.logCreated("item")).map(TO_ID);
                    }
                });
            }
        }).cache();
        itemId.subscribeOn(Schedulers.computation()).subscribe(SubscriptionUtils.logMaybeResults("Start test item"));
        this.QUEUE.getUnchecked((Maybe<String>)itemId).withParent(parentId).addToQueue(itemId.ignoreElement());
        LoggingContext.init((Maybe<String>)itemId, this.rpClient, this.getParameters().getBatchLogsSize(), this.getParameters().isConvertImage());
        return itemId;
    }

    @Override
    public void finishTestItem(final Maybe<String> itemId, final FinishTestItemRQ rq) {
        Preconditions.checkArgument(null != itemId, "ItemID should not be null");
        if ("SKIPPED".equals(rq.getStatus()) && !this.getParameters().getSkippedAnIssue().booleanValue()) {
            Issue issue = new Issue();
            issue.setIssueType(NOT_ISSUE);
            rq.setIssue(issue);
        }
        this.QUEUE.getUnchecked(this.launch).addToQueue(LoggingContext.complete());
        TreeItem treeItem = (TreeItem)this.QUEUE.getIfPresent(itemId);
        if (null == treeItem) {
            treeItem = new TreeItem();
            LOGGER.error("Item {} not found in the cache", itemId);
        }
        Completable finishCompletion = Completable.concat(treeItem.getChildren()).andThen((MaybeSource)itemId.flatMap((Function)new Function<String, Maybe<OperationCompletionRS>>(){

            public Maybe<OperationCompletionRS> apply(String itemId) {
                return LaunchImpl.this.rpClient.finishTestItem(itemId, rq).retry((Predicate)new RetryWithDelay((Predicate<? super Throwable>)new Predicate<Throwable>(){

                    public boolean test(Throwable throwable) {
                        return throwable instanceof ReportPortalException && ErrorType.FINISH_ITEM_NOT_ALLOWED.equals((Object)((ReportPortalException)throwable).getError().getErrorType());
                    }
                }, 10L, TimeUnit.SECONDS.toMillis(10L))).doOnSuccess(LoggingCallback.LOG_SUCCESS).doOnError(LoggingCallback.LOG_ERROR);
            }
        })).doAfterSuccess((Consumer)new Consumer<OperationCompletionRS>(){

            public void accept(OperationCompletionRS operationCompletionRS) {
                LaunchImpl.this.QUEUE.invalidate(itemId);
            }
        }).ignoreElement().cache();
        finishCompletion.subscribeOn(Schedulers.computation()).subscribe(SubscriptionUtils.logCompletableResults("Finish test item"));
        Maybe<String> parent = treeItem.getParent();
        if (null != parent) {
            this.QUEUE.getUnchecked(parent).addToQueue(finishCompletion);
        } else {
            this.QUEUE.getUnchecked(this.launch).addToQueue(finishCompletion);
        }
    }

    public boolean isRerun() {
        return this.rerun;
    }

    static class TreeItem {
        private Maybe<String> parent;
        private List<Completable> children = new CopyOnWriteArrayList<Completable>();

        TreeItem() {
        }

        synchronized TreeItem withParent(Maybe<String> parent) {
            this.parent = parent;
            return this;
        }

        TreeItem addToQueue(Completable completable) {
            this.children.add(completable);
            return this;
        }

        List<Completable> getChildren() {
            return Lists.newArrayList(this.children);
        }

        synchronized Maybe<String> getParent() {
            return this.parent;
        }
    }
}

