/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service;

import com.epam.reportportal.exception.GeneralReportPortalException;
import com.epam.reportportal.exception.InternalReportPortalClientException;
import com.epam.reportportal.exception.ReportPortalException;
import com.epam.reportportal.restendpoint.http.DefaultErrorHandler;
import com.epam.reportportal.restendpoint.http.Response;
import com.epam.reportportal.restendpoint.http.exception.RestEndpointIOException;
import com.epam.reportportal.restendpoint.serializer.Serializer;
import com.epam.ta.reportportal.ws.model.ErrorRS;
import java.io.IOException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rp.com.google.common.base.Charsets;
import rp.com.google.common.io.ByteSource;
import rp.org.apache.http.entity.ContentType;

public class ReportPortalErrorHandler
extends DefaultErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ReportPortalErrorHandler.class);
    private Serializer serializer;

    public ReportPortalErrorHandler(Serializer serializer) {
        this.serializer = serializer;
    }

    @Override
    public void handle(Response<ByteSource> rs) throws RestEndpointIOException {
        if (!this.hasError(rs)) {
            return;
        }
        this.handleError(rs);
    }

    @Override
    public boolean hasError(Response<ByteSource> rs) {
        return super.hasError(rs) || this.isNotJson(rs);
    }

    private void handleError(Response<ByteSource> rs) throws RestEndpointIOException {
        try {
            ByteSource errorBody = rs.getBody();
            int statusCode = rs.getStatus();
            String statusMessage = rs.getReason();
            byte[] body = errorBody.read();
            ErrorRS errorRS = this.deserializeError(body);
            if (null != errorRS) {
                throw new ReportPortalException(statusCode, statusMessage, errorRS);
            }
            if (this.isNotJson(rs)) {
                throw new InternalReportPortalClientException("Report portal is not functioning correctly. Response is not json");
            }
            throw new GeneralReportPortalException(statusCode, statusMessage, new String(body, Charsets.UTF_8));
        }
        catch (IOException e) {
            throw new GeneralReportPortalException(rs.getStatus(), rs.getReason(), "Cannot read the response");
        }
    }

    private ErrorRS deserializeError(byte[] content) {
        try {
            if (null != content) {
                return this.serializer.deserialize(content, ErrorRS.class);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean isNotJson(Response<ByteSource> rs) {
        boolean result = true;
        Collection<String> contentTypes = rs.getHeaders().get("Content-Type".toLowerCase());
        for (String contentType : contentTypes) {
            boolean isJson = contentType.contains(ContentType.APPLICATION_JSON.getMimeType());
            if (!isJson) continue;
            result = false;
            break;
        }
        return result;
    }
}

