/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.aspect;

import com.epam.reportportal.annotations.Step;
import com.epam.reportportal.aspect.StepRequestUtils;
import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.ReportPortal;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import io.reactivex.Maybe;
import java.util.Calendar;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import rp.com.google.common.base.Throwables;
import rp.com.google.common.collect.Queues;

@Aspect
public class StepAspect {
    private static final InheritableThreadLocal<String> currentLaunchId = new InheritableThreadLocal();
    private static final InheritableThreadLocal<Map<String, Launch>> launchMap = new InheritableThreadLocal<Map<String, Launch>>(){

        @Override
        protected Map<String, Launch> initialValue() {
            return new HashMap<String, Launch>();
        }
    };
    private static final InheritableThreadLocal<Deque<Maybe<String>>> stepStack = new InheritableThreadLocal<Deque<Maybe<String>>>(){

        @Override
        protected Deque<Maybe<String>> initialValue() {
            return Queues.newArrayDeque();
        }
    };
    private static final InheritableThreadLocal<Maybe<String>> parentId = new InheritableThreadLocal();

    @Pointcut(value="@annotation(step)")
    public void withStepAnnotation(Step step) {
    }

    @Pointcut(value="execution(* *.*(..))")
    public void anyMethod() {
    }

    @Before(value="anyMethod() && withStepAnnotation(step)", argNames="joinPoint,step")
    public void startNestedStep(JoinPoint joinPoint, Step step) {
        if (!step.isIgnored()) {
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            Maybe parent = (Maybe)((Deque)stepStack.get()).peek();
            if (parent == null) {
                parent = (Maybe)parentId.get();
            }
            StartTestItemRQ startStepRequest = StepRequestUtils.buildStartStepRequest(signature, step, joinPoint);
            Launch launch = (Launch)((Map)launchMap.get()).get(currentLaunchId.get());
            Maybe<String> stepMaybe = launch.startTestItem((Maybe<String>)parent, startStepRequest);
            ((Deque)stepStack.get()).push(stepMaybe);
        }
    }

    @AfterReturning(value="anyMethod() && withStepAnnotation(step)", argNames="step")
    public void finishNestedStep(Step step) {
        if (!step.isIgnored()) {
            Maybe stepId = (Maybe)((Deque)stepStack.get()).poll();
            if (stepId == null) {
                return;
            }
            FinishTestItemRQ finishStepRequest = StepRequestUtils.buildFinishStepRequest(ItemStatus.PASSED, Calendar.getInstance().getTime());
            ((Launch)((Map)launchMap.get()).get(currentLaunchId.get())).finishTestItem((Maybe<String>)stepId, finishStepRequest);
        }
    }

    @AfterThrowing(value="anyMethod() && withStepAnnotation(step)", throwing="throwable", argNames="step,throwable")
    public void failedNestedStep(Step step, Throwable throwable) {
        if (!step.isIgnored()) {
            Maybe stepId = (Maybe)((Deque)stepStack.get()).poll();
            if (stepId == null) {
                return;
            }
            ReportPortal.emitLog(itemUuid -> {
                SaveLogRQ rq = new SaveLogRQ();
                rq.setItemUuid(itemUuid);
                rq.setLevel("ERROR");
                rq.setLogTime(Calendar.getInstance().getTime());
                if (throwable != null) {
                    rq.setMessage(Throwables.getStackTraceAsString(throwable));
                } else {
                    rq.setMessage("Test has failed without exception");
                }
                rq.setLogTime(Calendar.getInstance().getTime());
                return rq;
            });
            FinishTestItemRQ finishStepRequest = StepRequestUtils.buildFinishStepRequest(ItemStatus.FAILED, Calendar.getInstance().getTime());
            while (stepId != null) {
                ((Launch)((Map)launchMap.get()).get(currentLaunchId.get())).finishTestItem((Maybe<String>)stepId, finishStepRequest);
                stepId = (Maybe)((Deque)stepStack.get()).poll();
            }
        }
    }

    public static void addLaunch(String key, Launch launch) {
        ((Map)launchMap.get()).put(key, launch);
        currentLaunchId.set(key);
    }

    public static void setParentId(Maybe<String> parent) {
        parentId.set(parent);
    }
}

