/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.listeners;

import com.epam.reportportal.utils.AttributeParser;
import com.epam.reportportal.utils.properties.ListenerProperty;
import com.epam.reportportal.utils.properties.PropertiesLoader;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import rp.com.google.common.annotations.VisibleForTesting;
import rp.com.google.common.collect.Sets;

public class ListenerParameters
implements Cloneable {
    private static final int DEFAULT_REPORTING_TIMEOUT = 300;
    private static final int DEFAULT_IO_POOL_SIZE = 100;
    private static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 50;
    private static final int DEFAULT_MAX_CONNECTIONS_TOTAL = 100;
    private static final boolean DEFAULT_ENABLE = true;
    private static final boolean DEFAULT_SKIP_ISSUE = true;
    private static final boolean DEFAULT_CONVERT_IMAGE = false;
    private static final boolean DEFAULT_RETURN = false;
    private static final boolean DEFAULT_ASYNC_REPORTING = false;
    private static final boolean DEFAULT_CALLBACK_REPORTING_ENABLED = false;
    private static final int DEFAULT_MAX_CONNECTION_TIME_TO_LIVE_MS = 29900;
    private static final int DEFAULT_MAX_CONNECTION_IDLE_TIME_MS = 5000;
    private static final int DEFAULT_TRANSFER_RETRY_COUNT = 5;
    private static final boolean DEFAULT_CLIENT_JOIN_MODE = true;
    private static final String DEFAULT_LOCK_FILE_NAME = "reportportal.lock";
    private static final String DEFAULT_SYNC_FILE_NAME = "reportportal.sync";
    private static final long DEFAULT_FILE_WAIT_TIMEOUT_MS = TimeUnit.MINUTES.toMillis(1L);
    private String description;
    private String apiKey;
    private String baseUrl;
    private String projectName;
    private String launchName;
    private Mode launchRunningMode;
    private Set<ItemAttributesRQ> attributes;
    private Boolean enable;
    private Boolean isSkippedAnIssue;
    private Integer batchLogsSize;
    private boolean convertImage;
    private Integer reportingTimeout;
    private String keystore;
    private String keystorePassword;
    private boolean rerun;
    private String rerunOf;
    private boolean asyncReporting;
    private boolean callbackReportingEnabled;
    private Integer ioPoolSize;
    private Integer maxConnectionsPerRoute;
    private Integer maxConnectionsTotal;
    private Integer maxConnectionTtlMs;
    private Integer maxConnectionIdleTtlMs;
    private Integer transferRetries;
    private boolean clientJoin;
    private String lockFileName;
    private String syncFileName;
    private long fileWaitTimeout;

    public ListenerParameters() {
        this.isSkippedAnIssue = true;
        this.batchLogsSize = 10;
        this.convertImage = false;
        this.reportingTimeout = 300;
        this.attributes = Sets.newHashSet();
        this.rerun = false;
        this.asyncReporting = false;
        this.callbackReportingEnabled = false;
        this.ioPoolSize = 100;
        this.maxConnectionsPerRoute = 50;
        this.maxConnectionsTotal = 100;
        this.maxConnectionTtlMs = 29900;
        this.maxConnectionIdleTtlMs = 5000;
        this.transferRetries = 5;
        this.clientJoin = true;
        this.lockFileName = DEFAULT_LOCK_FILE_NAME;
        this.syncFileName = DEFAULT_SYNC_FILE_NAME;
        this.fileWaitTimeout = DEFAULT_FILE_WAIT_TIMEOUT_MS;
    }

    public ListenerParameters(PropertiesLoader properties) {
        this.description = properties.getProperty(ListenerProperty.DESCRIPTION);
        this.apiKey = Optional.ofNullable(properties.getProperty(ListenerProperty.API_KEY, properties.getProperty(ListenerProperty.UUID))).map(String::trim).orElse(null);
        this.baseUrl = properties.getProperty(ListenerProperty.BASE_URL) != null ? properties.getProperty(ListenerProperty.BASE_URL).trim() : null;
        this.projectName = properties.getProperty(ListenerProperty.PROJECT_NAME) != null ? properties.getProperty(ListenerProperty.PROJECT_NAME).trim() : null;
        this.launchName = properties.getProperty(ListenerProperty.LAUNCH_NAME);
        this.attributes = AttributeParser.parseAsSet(properties.getProperty(ListenerProperty.LAUNCH_ATTRIBUTES));
        this.launchRunningMode = this.parseLaunchMode(properties.getProperty(ListenerProperty.MODE));
        this.enable = properties.getPropertyAsBoolean(ListenerProperty.ENABLE, true);
        this.isSkippedAnIssue = properties.getPropertyAsBoolean(ListenerProperty.SKIPPED_AS_ISSUE, true);
        this.batchLogsSize = properties.getPropertyAsInt(ListenerProperty.BATCH_SIZE_LOGS, 10);
        this.convertImage = properties.getPropertyAsBoolean(ListenerProperty.IS_CONVERT_IMAGE, false);
        this.reportingTimeout = properties.getPropertyAsInt(ListenerProperty.REPORTING_TIMEOUT, 300);
        this.keystore = properties.getProperty(ListenerProperty.KEYSTORE_RESOURCE);
        this.keystorePassword = properties.getProperty(ListenerProperty.KEYSTORE_PASSWORD);
        this.rerun = properties.getPropertyAsBoolean(ListenerProperty.RERUN, false);
        this.rerunOf = properties.getProperty(ListenerProperty.RERUN_OF);
        this.asyncReporting = properties.getPropertyAsBoolean(ListenerProperty.ASYNC_REPORTING, false);
        this.callbackReportingEnabled = properties.getPropertyAsBoolean(ListenerProperty.CALLBACK_REPORTING_ENABLED, false);
        this.ioPoolSize = properties.getPropertyAsInt(ListenerProperty.IO_POOL_SIZE, 100);
        this.maxConnectionsPerRoute = properties.getPropertyAsInt(ListenerProperty.MAX_CONNECTIONS_PER_ROUTE, 50);
        this.maxConnectionsTotal = properties.getPropertyAsInt(ListenerProperty.MAX_CONNECTIONS_TOTAL, 100);
        this.maxConnectionTtlMs = properties.getPropertyAsInt(ListenerProperty.MAX_CONNECTION_TIME_TO_LIVE, 29900);
        this.maxConnectionIdleTtlMs = properties.getPropertyAsInt(ListenerProperty.MAX_CONNECTION_IDLE_TIME, 5000);
        this.transferRetries = properties.getPropertyAsInt(ListenerProperty.MAX_TRANSFER_RETRY_COUNT, 5);
        this.clientJoin = properties.getPropertyAsBoolean(ListenerProperty.CLIENT_JOIN_MODE, true);
        this.lockFileName = properties.getProperty(ListenerProperty.LOCK_FILE_NAME, DEFAULT_LOCK_FILE_NAME);
        this.syncFileName = properties.getProperty(ListenerProperty.SYNC_FILE_NAME, DEFAULT_SYNC_FILE_NAME);
        this.fileWaitTimeout = properties.getPropertyAsInt(ListenerProperty.FILE_WAIT_TIMEOUT_MS, (int)DEFAULT_FILE_WAIT_TIMEOUT_MS);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getLaunchName() {
        return this.launchName;
    }

    public void setLaunchName(String launchName) {
        this.launchName = launchName;
    }

    public Mode getLaunchRunningMode() {
        return this.launchRunningMode;
    }

    public void setLaunchRunningMode(Mode launchRunningMode) {
        this.launchRunningMode = launchRunningMode;
    }

    public Set<ItemAttributesRQ> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Set<ItemAttributesRQ> attributes) {
        this.attributes = attributes;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public Boolean getSkippedAnIssue() {
        return this.isSkippedAnIssue;
    }

    public void setSkippedAnIssue(Boolean skippedAnIssue) {
        this.isSkippedAnIssue = skippedAnIssue;
    }

    public Integer getBatchLogsSize() {
        return this.batchLogsSize;
    }

    public void setBatchLogsSize(Integer batchLogsSize) {
        this.batchLogsSize = batchLogsSize;
    }

    public boolean isConvertImage() {
        return this.convertImage;
    }

    public void setConvertImage(boolean convertImage) {
        this.convertImage = convertImage;
    }

    public Integer getReportingTimeout() {
        return this.reportingTimeout;
    }

    public String getKeystore() {
        return this.keystore;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public void setReportingTimeout(Integer reportingTimeout) {
        this.reportingTimeout = reportingTimeout;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public boolean isRerun() {
        return this.rerun;
    }

    public boolean isAsyncReporting() {
        return this.asyncReporting;
    }

    public void setAsyncReporting(boolean asyncReporting) {
        this.asyncReporting = asyncReporting;
    }

    public boolean isCallbackReportingEnabled() {
        return this.callbackReportingEnabled;
    }

    public void setCallbackReportingEnabled(boolean callbackReportingEnabled) {
        this.callbackReportingEnabled = callbackReportingEnabled;
    }

    public void setRerun(boolean rerun) {
        this.rerun = rerun;
    }

    public String getRerunOf() {
        return this.rerunOf;
    }

    public void setRerunOf(String rerunOf) {
        this.rerunOf = rerunOf;
    }

    public Integer getIoPoolSize() {
        return this.ioPoolSize;
    }

    public void setIoPoolSize(Integer ioPoolSize) {
        this.ioPoolSize = ioPoolSize;
    }

    public Integer getMaxConnectionsPerRoute() {
        return this.maxConnectionsPerRoute;
    }

    public void setMaxConnectionsPerRoute(Integer maxConnectionsPerRoute) {
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
    }

    public Integer getMaxConnectionsTotal() {
        return this.maxConnectionsTotal;
    }

    public void setMaxConnectionsTotal(Integer maxConnectionsTotal) {
        this.maxConnectionsTotal = maxConnectionsTotal;
    }

    public Integer getMaxConnectionTtlMs() {
        return this.maxConnectionTtlMs;
    }

    public void setMaxConnectionTtlMs(Integer maxConnectionTtlMs) {
        this.maxConnectionTtlMs = maxConnectionTtlMs;
    }

    public Integer getMaxConnectionIdleTtlMs() {
        return this.maxConnectionIdleTtlMs;
    }

    public void setMaxConnectionIdleTtlMs(Integer maxConnectionIdleTtlMs) {
        this.maxConnectionIdleTtlMs = maxConnectionIdleTtlMs;
    }

    public Integer getTransferRetries() {
        return this.transferRetries;
    }

    public void setTransferRetries(Integer transferRetries) {
        this.transferRetries = transferRetries;
    }

    public boolean getClientJoin() {
        return this.clientJoin;
    }

    public void setClientJoin(boolean mode) {
        this.clientJoin = mode;
    }

    public String getLockFileName() {
        return this.lockFileName;
    }

    public void setLockFileName(String fileName) {
        this.lockFileName = fileName;
    }

    public String getSyncFileName() {
        return this.syncFileName;
    }

    public void setSyncFileName(String fileName) {
        this.syncFileName = fileName;
    }

    public long getFileWaitTimeout() {
        return this.fileWaitTimeout;
    }

    public void setFileWaitTimeout(long timeout) {
        this.fileWaitTimeout = timeout;
    }

    @VisibleForTesting
    Mode parseLaunchMode(String mode) {
        return Mode.isExists((String)mode) ? Mode.valueOf((String)mode.toUpperCase()) : Mode.DEFAULT;
    }

    public ListenerParameters clone() {
        ListenerParameters clone = new ListenerParameters();
        Arrays.stream(this.getClass().getDeclaredFields()).forEach(f -> {
            if (Modifier.isFinal(f.getModifiers())) {
                return;
            }
            try {
                f.set(clone, f.get(this));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        });
        return clone;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ListenerParameters{");
        sb.append("description='").append(this.description).append('\'');
        sb.append(", apiKey='").append(this.apiKey).append('\'');
        sb.append(", baseUrl='").append(this.baseUrl).append('\'');
        sb.append(", projectName='").append(this.projectName).append('\'');
        sb.append(", launchName='").append(this.launchName).append('\'');
        sb.append(", launchRunningMode=").append(this.launchRunningMode);
        sb.append(", attributes=").append(this.attributes);
        sb.append(", enable=").append(this.enable);
        sb.append(", isSkippedAnIssue=").append(this.isSkippedAnIssue);
        sb.append(", batchLogsSize=").append(this.batchLogsSize);
        sb.append(", convertImage=").append(this.convertImage);
        sb.append(", reportingTimeout=").append(this.reportingTimeout);
        sb.append(", keystore='").append(this.keystore).append('\'');
        sb.append(", keystorePassword='").append(this.keystorePassword).append('\'');
        sb.append(", rerun=").append(this.rerun);
        sb.append(", rerunOf='").append(this.rerunOf).append('\'');
        sb.append(", asyncReporting=").append(this.asyncReporting);
        sb.append(", ioPoolSize=").append(this.ioPoolSize);
        sb.append(", callbackReportingEnabled=").append(this.callbackReportingEnabled);
        sb.append(", maxConnectionsPerRoute=").append(this.maxConnectionsPerRoute);
        sb.append(", maxConnectionsTotal=").append(this.maxConnectionsTotal);
        sb.append(", maxConnectionTtlMs=").append(this.maxConnectionTtlMs);
        sb.append(", maxConnectionIdleTtlMs=").append(this.maxConnectionIdleTtlMs);
        sb.append(", transferRetries=").append(this.transferRetries);
        sb.append(", clientJoin=").append(this.clientJoin);
        sb.append(", lockFileName=").append(this.lockFileName);
        sb.append(", syncFileName=").append(this.syncFileName);
        sb.append(", fileWaitTimeout=").append(this.fileWaitTimeout);
        sb.append('}');
        return sb.toString();
    }
}

